/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.jdbc;

import java.sql.ResultSet;
import java.util.concurrent.CompletableFuture;
import org.apache.phoenix.jdbc.DelegateResultSet;
import org.apache.phoenix.jdbc.ParallelPhoenixContext;
import org.apache.phoenix.jdbc.ParallelPhoenixNullComparingResultSet;
import org.apache.phoenix.jdbc.ParallelPhoenixResultSet;

public class ParallelPhoenixResultSetFactory {
    public static final ParallelPhoenixResultSetFactory INSTANCE = new ParallelPhoenixResultSetFactory();
    public static final String PHOENIX_PARALLEL_RESULTSET_TYPE = "phoenix.parallel.resultSet.type";

    private ParallelPhoenixResultSetFactory() {
    }

    public ResultSet getParallelResultSet(ParallelPhoenixContext context, CompletableFuture<ResultSet> resultSet1, CompletableFuture<ResultSet> resultSet2) {
        DelegateResultSet rs;
        String resultSetProperty = context.getProperties().getProperty(PHOENIX_PARALLEL_RESULTSET_TYPE);
        ParallelPhoenixResultSetType type = ParallelPhoenixResultSetType.fromName(resultSetProperty);
        switch (type) {
            case PARALLEL_PHOENIX_RESULT_SET: {
                rs = new ParallelPhoenixResultSet(context, resultSet1, resultSet2);
                break;
            }
            case PARALLEL_PHOENIX_NULL_COMPARING_RESULT_SET: {
                rs = new ParallelPhoenixNullComparingResultSet(context, resultSet1, resultSet2);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown ParallelPhoenixResultSetType: " + (Object)((Object)type));
            }
        }
        return rs;
    }

    public static enum ParallelPhoenixResultSetType {
        PARALLEL_PHOENIX_RESULT_SET("ParallelPhoenixResultSet"),
        PARALLEL_PHOENIX_NULL_COMPARING_RESULT_SET("ParallelPhoenixNullComparingResultSet");

        private String name;

        private ParallelPhoenixResultSetType(String name) {
            this.name = name;
        }

        static ParallelPhoenixResultSetType fromName(String name) {
            if (name == null) {
                return PARALLEL_PHOENIX_RESULT_SET;
            }
            for (ParallelPhoenixResultSetType type : ParallelPhoenixResultSetType.values()) {
                if (!name.equals(type.getName())) continue;
                return type;
            }
            throw new IllegalArgumentException("Unknown ParallelPhoenixResultSetType: " + name);
        }

        public String getName() {
            return this.name;
        }
    }
}

