/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.jdbc;

import java.sql.SQLException;
import java.util.Map;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.security.User;
import org.apache.phoenix.jdbc.AbstractRPCConnectionInfo;
import org.apache.phoenix.jdbc.ConnectionInfo;
import org.apache.phoenix.util.ReadOnlyProps;

public class MasterConnectionInfo
extends AbstractRPCConnectionInfo {
    private static final String MASTER_REGISTRY_CLASS_NAME = "org.apache.hadoop.hbase.client.MasterRegistry";

    protected MasterConnectionInfo(boolean isConnectionless, String principal, String keytab, User user, String haGroup, String bootstrapServers, ConnectionInfo.ConnectionType connectionType) {
        super(isConnectionless, principal, keytab, user, haGroup, connectionType);
        this.bootstrapServers = bootstrapServers;
    }

    @Override
    public ReadOnlyProps asProps() {
        if (this.isConnectionless) {
            return ReadOnlyProps.EMPTY_PROPS;
        }
        Map<String, String> connectionProps = this.getCommonProps();
        connectionProps.put("hbase.client.registry.impl", MASTER_REGISTRY_CLASS_NAME);
        if (this.bootstrapServers != null) {
            connectionProps.put("hbase.masters", this.bootstrapServers);
        }
        return connectionProps.isEmpty() ? ReadOnlyProps.EMPTY_PROPS : new ReadOnlyProps(connectionProps.entrySet().iterator());
    }

    @Override
    public String toUrl() {
        return "jdbc:phoenix+master:" + this.toString();
    }

    @Override
    public ConnectionInfo withPrincipal(String principal) {
        return new MasterConnectionInfo(this.isConnectionless, principal, this.keytab, this.user, this.haGroup, this.bootstrapServers, this.connectionType);
    }

    protected static class Builder
    extends AbstractRPCConnectionInfo.Builder {
        public Builder(String url, Configuration config, ReadOnlyProps props, Properties info) throws SQLException {
            super(url, config, props, info);
            if (!ConnectionInfo.HAS_MASTER_REGISTRY) {
                throw ConnectionInfo.getMalFormedUrlException("HBase version does not support Master registry for: " + url);
            }
        }

        @Override
        protected void normalize() throws SQLException {
            this.normalizeMaster();
        }

        @Override
        protected ConnectionInfo build() {
            return new MasterConnectionInfo(this.isConnectionless, this.principal, this.keytab, this.user, this.haGroup, this.hostsList, this.connectionType);
        }

        public static boolean isMaster(Configuration config, ReadOnlyProps props, Properties info) {
            return config != null && MasterConnectionInfo.MASTER_REGISTRY_CLASS_NAME.equals(Builder.get("hbase.client.registry.impl", config, props, info));
        }
    }
}

