/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.jdbc;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import org.apache.phoenix.exception.SQLExceptionCode;
import org.apache.phoenix.exception.SQLExceptionInfo;
import org.apache.phoenix.jdbc.ClusterRoleRecord;
import org.apache.phoenix.jdbc.FailoverPhoenixConnection;
import org.apache.phoenix.jdbc.FailoverPhoenixContext;
import org.apache.phoenix.jdbc.HAURLInfo;
import org.apache.phoenix.jdbc.HighAvailabilityGroup;
import org.apache.phoenix.jdbc.ParallelPhoenixConnection;
import org.apache.phoenix.jdbc.ParallelPhoenixContext;
import org.apache.phoenix.jdbc.PhoenixDriver;
import org.apache.phoenix.jdbc.PhoenixHAExecutorServiceProvider;
import org.apache.phoenix.monitoring.GlobalClientMetrics;
import org.apache.phoenix.query.ConnectionQueryServices;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum HighAvailabilityPolicy {
    FAILOVER{

        @Override
        public Connection provide(HighAvailabilityGroup haGroup, Properties info, HAURLInfo haURLInfo) throws SQLException {
            FailoverPhoenixContext context = new FailoverPhoenixContext(info, haGroup, haURLInfo);
            return new FailoverPhoenixConnection(context);
        }

        @Override
        void transitClusterRole(HighAvailabilityGroup haGroup, ClusterRoleRecord oldRecord, ClusterRoleRecord newRecord) throws SQLException {
            if (newRecord.getRole1() == ClusterRoleRecord.ClusterRole.ACTIVE && newRecord.getRole2() == ClusterRoleRecord.ClusterRole.ACTIVE) {
                LOG.warn("Both cluster roles are ACTIVE which is invalid state for FailoverPolicyDoing nothing for Cluster Role Change");
                return;
            }
            if (oldRecord.getRole1() == ClusterRoleRecord.ClusterRole.ACTIVE && (newRecord.getRole1() == ClusterRoleRecord.ClusterRole.STANDBY || newRecord.getRole1() == ClusterRoleRecord.ClusterRole.ACTIVE_TO_STANDBY)) {
                this.transitStandby(haGroup, oldRecord.getUrl1(), oldRecord.getRegistryType(), newRecord.getRole1());
            }
            if (oldRecord.getRole2() == ClusterRoleRecord.ClusterRole.ACTIVE && (newRecord.getRole2() == ClusterRoleRecord.ClusterRole.STANDBY || newRecord.getRole2() == ClusterRoleRecord.ClusterRole.ACTIVE_TO_STANDBY)) {
                this.transitStandby(haGroup, oldRecord.getUrl2(), oldRecord.getRegistryType(), newRecord.getRole2());
            }
            if (oldRecord.getRole1() != ClusterRoleRecord.ClusterRole.ACTIVE && newRecord.getRole1() == ClusterRoleRecord.ClusterRole.ACTIVE) {
                this.transitActive(haGroup, oldRecord.getUrl1(), oldRecord.getRegistryType());
            }
            if (oldRecord.getRole2() != ClusterRoleRecord.ClusterRole.ACTIVE && newRecord.getRole2() == ClusterRoleRecord.ClusterRole.ACTIVE) {
                this.transitActive(haGroup, oldRecord.getUrl2(), oldRecord.getRegistryType());
            }
        }

        @Override
        void transitRoleRecordRegistry(HighAvailabilityGroup haGroup, ClusterRoleRecord oldRecord, ClusterRoleRecord newRecord) throws SQLException {
            Optional<String> activeUrl = oldRecord.getActiveUrl();
            if (activeUrl.isPresent()) {
                LOG.info("Cluster {} has a change in registryType in HA group {}, now closing all its connections", (Object)activeUrl.get(), (Object)oldRecord.getRegistryType());
                HighAvailabilityPolicy.closeConnections(haGroup, activeUrl.get(), oldRecord.getRegistryType());
                HighAvailabilityPolicy.invalidateCQSIs(haGroup, activeUrl.get(), oldRecord.getRegistryType());
            } else {
                LOG.info("None of the cluster in HA Group {} is active", (Object)haGroup);
            }
        }

        @Override
        void transitClusterUrl(HighAvailabilityGroup haGroup, ClusterRoleRecord oldRecord, ClusterRoleRecord newRecord) throws SQLException {
            Optional<String> activeUrl = oldRecord.getActiveUrl();
            Optional<String> newActiveUrl = newRecord.getActiveUrl();
            if (activeUrl.isPresent()) {
                if (newActiveUrl.isPresent()) {
                    if (activeUrl.get().equals(newActiveUrl.get())) {
                        LOG.info("Active URL is same after cluster role record transitionDoing nothing for FailoverPhoenixConnections");
                    } else {
                        LOG.info("Active url of clusterRoleRecord changed from {} to {}, closing old connections", (Object)activeUrl.get(), (Object)newActiveUrl.get());
                        HighAvailabilityPolicy.closeConnections(haGroup, activeUrl.get(), oldRecord.getRegistryType());
                        HighAvailabilityPolicy.invalidateCQSIs(haGroup, activeUrl.get(), oldRecord.getRegistryType());
                    }
                } else {
                    LOG.info("Couldn't find active url in new ClusterRoleRecord,Closing old connections");
                    HighAvailabilityPolicy.closeConnections(haGroup, activeUrl.get(), oldRecord.getRegistryType());
                    HighAvailabilityPolicy.invalidateCQSIs(haGroup, activeUrl.get(), oldRecord.getRegistryType());
                }
            } else {
                LOG.info("Couldn't find active url in old ClusterRoleRecord, Doing nothing for FailoverPhoenixConnections");
            }
        }

        private void transitStandby(HighAvailabilityGroup haGroup, String url, ClusterRoleRecord.RegistryType registryType, ClusterRoleRecord.ClusterRole newRole) throws SQLException {
            LOG.info("Cluster {} becomes {} in HA group {}, now close all its connections", new Object[]{url, newRole, haGroup.getGroupInfo()});
            HighAvailabilityPolicy.closeConnections(haGroup, url, registryType);
        }

        private void transitActive(HighAvailabilityGroup haGroup, String url, ClusterRoleRecord.RegistryType registryType) throws SQLException {
            HighAvailabilityPolicy.invalidateCQSIs(haGroup, url, registryType);
        }
    }
    ,
    PARALLEL{

        @Override
        public Connection provide(HighAvailabilityGroup haGroup, Properties info, HAURLInfo haURLInfo) throws SQLException {
            List<Boolean> executorCapacities = PhoenixHAExecutorServiceProvider.hasCapacity(info);
            if (executorCapacities.contains(Boolean.TRUE)) {
                ParallelPhoenixContext context = new ParallelPhoenixContext(info, haGroup, PhoenixHAExecutorServiceProvider.get(info), executorCapacities, haURLInfo);
                return new ParallelPhoenixConnection(context);
            }
            LOG.warn("Falling back to single phoenix connection due to resource constraints");
            GlobalClientMetrics.GLOBAL_HA_PARALLEL_CONNECTION_FALLBACK_COUNTER.increment();
            return haGroup.connectActive(info, haURLInfo);
        }

        @Override
        void transitClusterRole(HighAvailabilityGroup haGroup, ClusterRoleRecord oldRecord, ClusterRoleRecord newRecord) {
        }

        @Override
        void transitRoleRecordRegistry(HighAvailabilityGroup haGroup, ClusterRoleRecord oldRecord, ClusterRoleRecord newRecord) throws SQLException {
            LOG.info("Cluster {} and {} has a change in registryType in HA group {}, now closing all its connections", new Object[]{oldRecord.getUrl1(), oldRecord.getUrl2(), oldRecord.getRegistryType()});
            HighAvailabilityPolicy.closeConnections(haGroup, oldRecord.getUrl1(), oldRecord.getRegistryType());
            HighAvailabilityPolicy.invalidateCQSIs(haGroup, oldRecord.getUrl1(), oldRecord.getRegistryType());
            HighAvailabilityPolicy.closeConnections(haGroup, oldRecord.getUrl2(), oldRecord.getRegistryType());
            HighAvailabilityPolicy.invalidateCQSIs(haGroup, oldRecord.getUrl2(), oldRecord.getRegistryType());
        }

        @Override
        void transitClusterUrl(HighAvailabilityGroup haGroup, ClusterRoleRecord oldRecord, ClusterRoleRecord newRecord) throws SQLException {
            if (!Objects.equals(oldRecord.getUrl1(), newRecord.getUrl1()) && !Objects.equals(oldRecord.getUrl1(), newRecord.getUrl2())) {
                LOG.info("Cluster {} is changed to {} in HA group {}, now closing all its connections", new Object[]{oldRecord.getUrl1(), newRecord.getUrl1(), haGroup});
                HighAvailabilityPolicy.closeConnections(haGroup, oldRecord.getUrl1(), oldRecord.getRegistryType());
                HighAvailabilityPolicy.invalidateCQSIs(haGroup, oldRecord.getUrl1(), oldRecord.getRegistryType());
            }
            if (!Objects.equals(oldRecord.getUrl2(), newRecord.getUrl2()) && !Objects.equals(oldRecord.getUrl2(), newRecord.getUrl1())) {
                LOG.info("Cluster {} is changed to {} in HA group {}, now closing all its connections", new Object[]{oldRecord.getUrl2(), newRecord.getUrl2(), haGroup});
                HighAvailabilityPolicy.closeConnections(haGroup, oldRecord.getUrl2(), oldRecord.getRegistryType());
                HighAvailabilityPolicy.invalidateCQSIs(haGroup, oldRecord.getUrl2(), oldRecord.getRegistryType());
            }
        }
    };

    private static final Logger LOG;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void closeConnections(HighAvailabilityGroup haGroup, String url, ClusterRoleRecord.RegistryType registryType) throws SQLException {
        ConnectionQueryServices cqs = null;
        for (HAURLInfo haurlInfo : HighAvailabilityGroup.URLS.get(haGroup.getGroupInfo())) {
            try {
                cqs = PhoenixDriver.INSTANCE.getConnectionQueryServices(HighAvailabilityGroup.getJDBCUrl(url, haurlInfo, registryType), haGroup.getProperties());
                cqs.closeAllConnections(new SQLExceptionInfo.Builder(SQLExceptionCode.HA_CLOSED_AFTER_FAILOVER).setMessage("Phoenix connection got closed due to failover").setHaGroupInfo(haGroup.getGroupInfo().toString()));
                LOG.info("Closed all connections to cluster {} for HA group {}", (Object)url, (Object)haGroup.getGroupInfo());
            }
            finally {
                if (cqs == null) continue;
                LOG.info("Closing CQS after clusterRoleRecord change for '{}'", (Object)url);
                cqs.close();
                LOG.info("Successfully closed CQS after clusterRoleRecord change for '{}'", (Object)url);
            }
        }
    }

    private static void invalidateCQSIs(HighAvailabilityGroup haGroup, String url, ClusterRoleRecord.RegistryType registryType) throws SQLException {
        for (HAURLInfo haurlInfo : HighAvailabilityGroup.URLS.get(haGroup.getGroupInfo())) {
            String jdbcUrl = HighAvailabilityGroup.getJDBCUrl(url, haurlInfo, registryType);
            LOG.info("invalidating cqs cache for url: " + jdbcUrl);
            PhoenixDriver.INSTANCE.invalidateCache(jdbcUrl, haGroup.getProperties());
        }
    }

    abstract Connection provide(HighAvailabilityGroup var1, Properties var2, HAURLInfo var3) throws SQLException;

    public void transitClusterRoleRecord(HighAvailabilityGroup haGroup, ClusterRoleRecord oldRecord, ClusterRoleRecord newRecord) throws SQLException {
        if (oldRecord.getRegistryType() != newRecord.getRegistryType()) {
            this.transitRoleRecordRegistry(haGroup, oldRecord, newRecord);
        } else if (!oldRecord.getUrl1().equals(newRecord.getUrl1()) || !oldRecord.getUrl2().equals(newRecord.getUrl2())) {
            this.transitClusterUrl(haGroup, oldRecord, newRecord);
        } else {
            this.transitClusterRole(haGroup, oldRecord, newRecord);
        }
    }

    abstract void transitClusterRole(HighAvailabilityGroup var1, ClusterRoleRecord var2, ClusterRoleRecord var3) throws SQLException;

    abstract void transitRoleRecordRegistry(HighAvailabilityGroup var1, ClusterRoleRecord var2, ClusterRoleRecord var3) throws SQLException;

    abstract void transitClusterUrl(HighAvailabilityGroup var1, ClusterRoleRecord var2, ClusterRoleRecord var3) throws SQLException;

    static {
        LOG = LoggerFactory.getLogger(HighAvailabilityPolicy.class);
    }
}

