/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.jdbc;

import java.util.Properties;
import net.jcip.annotations.Immutable;
import org.apache.commons.lang3.StringUtils;
import org.apache.phoenix.exception.FailoverSQLException;

@Immutable
@FunctionalInterface
public interface FailoverPolicy {
    public static final String PHOENIX_HA_FAILOVER_POLICY_ATTR = "phoenix.ha.failover.policy";
    public static final String PHOENIX_HA_FAILOVER_COUNT_ATTR = "phoenix.ha.failover.count";

    public boolean shouldFailover(Exception var1, int var2);

    public static FailoverPolicy get(Properties properties) {
        String name = properties.getProperty(PHOENIX_HA_FAILOVER_POLICY_ATTR);
        if (StringUtils.isEmpty((CharSequence)name)) {
            return ExplicitFailoverPolicy.INSTANCE;
        }
        switch (name.toLowerCase()) {
            case "explicit": {
                return ExplicitFailoverPolicy.INSTANCE;
            }
            case "active": {
                String maxFailoverCount = properties.getProperty(PHOENIX_HA_FAILOVER_COUNT_ATTR);
                return StringUtils.isEmpty((CharSequence)maxFailoverCount) ? new FailoverToActivePolicy() : new FailoverToActivePolicy(Integer.parseInt(maxFailoverCount));
            }
        }
        throw new IllegalArgumentException(String.format("Unsupported %s '%s'", PHOENIX_HA_FAILOVER_POLICY_ATTR, name));
    }

    public static class FailoverToActivePolicy
    implements FailoverPolicy {
        public static final String NAME = "active";
        private static final int MAX_FAILOVER_COUNT_DEFAULT = 3;
        private final int maxFailoverCount;

        private FailoverToActivePolicy() {
            this.maxFailoverCount = 3;
        }

        private FailoverToActivePolicy(int maxFailoverCount) {
            this.maxFailoverCount = maxFailoverCount;
        }

        @Override
        public boolean shouldFailover(Exception e, int failoverCount) {
            return failoverCount < this.maxFailoverCount && e instanceof FailoverSQLException;
        }

        public String toString() {
            return "active(maxFailoverCount=" + this.maxFailoverCount + ")";
        }
    }

    public static class ExplicitFailoverPolicy
    implements FailoverPolicy {
        public static final String NAME = "explicit";
        private static final ExplicitFailoverPolicy INSTANCE = new ExplicitFailoverPolicy();

        @Override
        public boolean shouldFailover(Exception e, int failoverCount) {
            return false;
        }

        public String toString() {
            return NAME;
        }
    }
}

