/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.jdbc;

import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;
import org.apache.phoenix.exception.FailoverSQLException;
import org.apache.phoenix.exception.SQLExceptionCode;
import org.apache.phoenix.exception.SQLExceptionInfo;
import org.apache.phoenix.jdbc.FailoverPhoenixContext;
import org.apache.phoenix.jdbc.FailoverPolicy;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.jdbc.PhoenixMonitoredConnection;
import org.apache.phoenix.monitoring.MetricType;
import org.apache.phoenix.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.phoenix.thirdparty.com.google.common.base.Preconditions;
import org.apache.phoenix.util.EnvironmentEdgeManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FailoverPhoenixConnection
implements PhoenixMonitoredConnection {
    public static final String FAILOVER_TIMEOUT_MS_ATTR = "phoenix.ha.failover.timeout.ms";
    public static final long FAILOVER_TIMEOUT_MS_DEFAULT = 10000L;
    private static final Logger LOG = LoggerFactory.getLogger(FailoverPhoenixConnection.class);
    private final FailoverPhoenixContext context;
    private final FailoverPolicy policy;
    private boolean isClosed;
    private PhoenixConnection connection;
    private Map<String, Map<MetricType, Long>> previousMutationMetrics = new HashMap<String, Map<MetricType, Long>>();
    private Map<String, Map<MetricType, Long>> previousReadMetrics = new HashMap<String, Map<MetricType, Long>>();

    public FailoverPhoenixConnection(FailoverPhoenixContext context) throws SQLException {
        this.context = context;
        this.policy = FailoverPolicy.get(context.getProperties());
        this.isClosed = false;
        this.connection = context.getHAGroup().connectActive(context.getProperties(), context.getHAURLInfo());
    }

    public static void failover(Connection conn, long timeoutMs) throws SQLException {
        Preconditions.checkNotNull((Object)conn, (Object)"Connection to failover must not be null!");
        FailoverPhoenixConnection failoverConnection = conn.unwrap(FailoverPhoenixConnection.class);
        if (failoverConnection == null) {
            throw new SQLExceptionInfo.Builder(SQLExceptionCode.CLASS_NOT_UNWRAPPABLE).setMessage("Connection is not a valid FailoverPhoenixConnection object").build().buildException();
        }
        failoverConnection.failover(timeoutMs);
    }

    private static Map<String, Map<MetricType, Long>> mergeMetricMaps(Map<String, Map<MetricType, Long>> shallow, Map<String, Map<MetricType, Long>> deep) {
        if (deep.isEmpty()) {
            return shallow;
        }
        HashMap<String, Map<MetricType, Long>> metrics = new HashMap<String, Map<MetricType, Long>>(shallow);
        deep.forEach((k, v) -> {
            metrics.putIfAbsent((String)k, new HashMap());
            Map map = (Map)metrics.get(k);
            v.forEach((kk, vv) -> {
                Long value = map.getOrDefault(kk, 0L);
                map.put(kk, value + vv);
            });
        });
        return metrics;
    }

    @VisibleForTesting
    void failover(long timeoutMs) throws SQLException {
        this.checkConnection();
        if (this.context.getHAGroup().isActive(this.connection)) {
            LOG.info("Connection {} is against ACTIVE cluster in HA group {}; skip failing over.", (Object)this.connection.getURL(), (Object)this.context.getHAGroup().getGroupInfo().getName());
            return;
        }
        PhoenixConnection newConn = null;
        SQLException cause = null;
        long startTime = EnvironmentEdgeManager.currentTimeMillis();
        while (newConn == null && EnvironmentEdgeManager.currentTimeMillis() < startTime + timeoutMs) {
            try {
                newConn = this.context.getHAGroup().connectActive(this.context.getProperties(), this.context.getHAURLInfo());
            }
            catch (SQLException e) {
                cause = e;
                LOG.info("Got exception when trying to connect to active cluster.", (Throwable)e);
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                    throw new SQLException("Got interrupted waiting for connection failover", e);
                }
            }
        }
        if (newConn == null) {
            throw new FailoverSQLException("Can not failover connection", this.context.getHAGroup().getGroupInfo().toString(), cause);
        }
        PhoenixConnection oldConn = this.connection;
        this.connection = newConn;
        if (oldConn != null) {
            this.previousMutationMetrics = oldConn.getMutationMetrics();
            this.previousReadMetrics = oldConn.getReadMetrics();
            oldConn.clearMetrics();
            if (!oldConn.isClosed()) {
                try {
                    oldConn.close(new SQLExceptionInfo.Builder(SQLExceptionCode.HA_CLOSED_AFTER_FAILOVER).setMessage("Phoenix connection got closed due to failover").setHaGroupInfo(this.context.getHAGroup().getGroupInfo().toString()).build().buildException());
                }
                catch (SQLException e) {
                    LOG.error("Failed to close old connection after failover: {}", (Object)e.getMessage());
                    LOG.info("Full stack when closing old connection after failover", (Throwable)e);
                }
            }
        }
        LOG.info("Connection {} failed over to {}", (Object)this.context.getHAGroup().getGroupInfo(), (Object)this.connection.getURL());
    }

    private void checkConnection() throws SQLException {
        if (this.isClosed) {
            throw new SQLExceptionInfo.Builder(SQLExceptionCode.CONNECTION_CLOSED).setHaGroupInfo(this.context.getHAGroup().getGroupInfo().toString()).build().buildException();
        }
        if (this.connection == null) {
            throw new SQLExceptionInfo.Builder(SQLExceptionCode.CANNOT_ESTABLISH_CONNECTION).setMessage("Connection has not been established to ACTIVE HBase cluster").setHaGroupInfo(this.context.getHAGroup().getGroupInfo().toString()).build().buildException();
        }
    }

    @Override
    public void close() throws SQLException {
        if (this.isClosed()) {
            return;
        }
        try {
            this.connection.close();
            this.connection.clearMetrics();
        }
        finally {
            this.previousMutationMetrics.clear();
            this.previousReadMetrics.clear();
            this.isClosed = true;
        }
    }

    @Override
    public boolean isClosed() {
        return this.isClosed;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (!iface.isInstance(this)) {
            throw new SQLExceptionInfo.Builder(SQLExceptionCode.CLASS_NOT_UNWRAPPABLE).setMessage(this.getClass().getName() + " not unwrappable from " + iface.getName()).build().buildException();
        }
        return (T)this;
    }

    @Override
    public Map<String, Map<MetricType, Long>> getMutationMetrics() {
        return FailoverPhoenixConnection.mergeMetricMaps(this.connection.getMutationMetrics(), this.previousMutationMetrics);
    }

    @Override
    public Map<String, Map<MetricType, Long>> getReadMetrics() {
        return FailoverPhoenixConnection.mergeMetricMaps(this.connection.getReadMetrics(), this.previousReadMetrics);
    }

    @Override
    public boolean isRequestLevelMetricsEnabled() {
        return this.connection != null && this.connection.isRequestLevelMetricsEnabled();
    }

    @Override
    public void clearMetrics() {
        this.previousMutationMetrics.clear();
        this.previousReadMetrics.clear();
        if (this.connection != null) {
            this.connection.clearMetrics();
        }
    }

    @VisibleForTesting
    <T> T wrapActionDuringFailover(SupplierWithSQLException<T> s) throws SQLException {
        this.checkConnection();
        long timeoutMs = Long.parseLong(this.context.getProperties().getProperty(FAILOVER_TIMEOUT_MS_ATTR, String.valueOf(10000L)));
        int failoverCount = 0;
        while (true) {
            try {
                return s.get();
            }
            catch (SQLException e) {
                if (this.policy.shouldFailover(e, ++failoverCount)) {
                    this.failover(timeoutMs);
                    continue;
                }
                throw new SQLException(String.format("Error on operation with failover policy %s", this.policy), e);
            }
            break;
        }
    }

    @VisibleForTesting
    void wrapActionDuringFailover(RunWithSQLException runnable) throws SQLException {
        this.wrapActionDuringFailover(() -> {
            runnable.run();
            return null;
        });
    }

    @Override
    public void commit() throws SQLException {
        this.wrapActionDuringFailover(() -> this.connection.commit());
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return this.wrapActionDuringFailover(() -> this.connection.isWrapperFor(iface));
    }

    @Override
    public Statement createStatement() throws SQLException {
        return this.wrapActionDuringFailover(() -> this.connection.createStatement());
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        return this.wrapActionDuringFailover(() -> this.connection.prepareStatement(sql));
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        return this.wrapActionDuringFailover(() -> this.connection.prepareCall(sql));
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        return this.wrapActionDuringFailover(() -> this.connection.nativeSQL(sql));
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        return this.wrapActionDuringFailover(() -> this.connection.getAutoCommit());
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this.wrapActionDuringFailover(() -> this.connection.setAutoCommit(autoCommit));
    }

    @Override
    public void rollback() throws SQLException {
        this.wrapActionDuringFailover(() -> this.connection.rollback());
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        return this.wrapActionDuringFailover(() -> this.connection.getMetaData());
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        return this.wrapActionDuringFailover(() -> this.connection.isReadOnly());
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        this.wrapActionDuringFailover(() -> this.connection.setReadOnly(readOnly));
    }

    @Override
    public String getCatalog() throws SQLException {
        return this.wrapActionDuringFailover(() -> this.connection.getCatalog());
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        this.wrapActionDuringFailover(() -> this.connection.setCatalog(catalog));
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        return this.wrapActionDuringFailover(() -> this.connection.getTransactionIsolation());
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        this.wrapActionDuringFailover(() -> this.connection.setTransactionIsolation(level));
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return this.wrapActionDuringFailover(() -> this.connection.getWarnings());
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.wrapActionDuringFailover(() -> this.connection.clearWarnings());
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.wrapActionDuringFailover(() -> this.connection.createStatement(resultSetType, resultSetConcurrency));
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.wrapActionDuringFailover(() -> this.connection.prepareStatement(sql, resultSetType, resultSetConcurrency));
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.wrapActionDuringFailover(() -> this.connection.prepareCall(sql, resultSetType, resultSetConcurrency));
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        return this.wrapActionDuringFailover(() -> this.connection.getTypeMap());
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        this.wrapActionDuringFailover(() -> this.connection.setTypeMap(map));
    }

    @Override
    public int getHoldability() throws SQLException {
        return this.wrapActionDuringFailover(() -> this.connection.getHoldability());
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        this.wrapActionDuringFailover(() -> this.connection.setHoldability(holdability));
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        return this.wrapActionDuringFailover(() -> this.connection.setSavepoint());
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        return this.wrapActionDuringFailover(() -> this.connection.setSavepoint(name));
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        this.wrapActionDuringFailover(() -> this.connection.rollback(savepoint));
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        this.wrapActionDuringFailover(() -> this.connection.releaseSavepoint(savepoint));
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return this.wrapActionDuringFailover(() -> this.connection.createStatement(resultSetType, resultSetConcurrency, resultSetHoldability));
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return this.wrapActionDuringFailover(() -> this.connection.prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability));
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return this.wrapActionDuringFailover(() -> this.connection.prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability));
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        return this.wrapActionDuringFailover(() -> this.connection.prepareStatement(sql, autoGeneratedKeys));
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        return this.wrapActionDuringFailover(() -> this.connection.prepareStatement(sql, columnIndexes));
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        return this.wrapActionDuringFailover(() -> this.connection.prepareStatement(sql, columnNames));
    }

    @Override
    public Clob createClob() throws SQLException {
        return this.wrapActionDuringFailover(() -> this.connection.createClob());
    }

    @Override
    public Blob createBlob() throws SQLException {
        return this.wrapActionDuringFailover(() -> this.connection.createBlob());
    }

    @Override
    public NClob createNClob() throws SQLException {
        return this.wrapActionDuringFailover(() -> this.connection.createNClob());
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        this.checkConnection();
        return this.wrapActionDuringFailover(() -> this.connection.createSQLXML());
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        return this.wrapActionDuringFailover(() -> this.connection.isValid(timeout));
    }

    @Override
    public void setClientInfo(String name, String value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        return this.wrapActionDuringFailover(() -> this.connection.getClientInfo(name));
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        return this.wrapActionDuringFailover(() -> this.connection.getClientInfo());
    }

    @Override
    public void setClientInfo(Properties properties) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        return this.wrapActionDuringFailover(() -> this.connection.createArrayOf(typeName, elements));
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        return this.wrapActionDuringFailover(() -> this.connection.createStruct(typeName, attributes));
    }

    @Override
    public String getSchema() throws SQLException {
        return this.wrapActionDuringFailover(() -> this.connection.getSchema());
    }

    @Override
    public void setSchema(String schema) throws SQLException {
        this.wrapActionDuringFailover(() -> this.connection.setSchema(schema));
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        this.wrapActionDuringFailover(() -> this.connection.abort(executor));
    }

    @Override
    public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
        this.wrapActionDuringFailover(() -> this.connection.setNetworkTimeout(executor, milliseconds));
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        return this.wrapActionDuringFailover(() -> this.connection.getNetworkTimeout());
    }

    @VisibleForTesting
    PhoenixConnection getWrappedConnection() {
        return this.connection;
    }

    @VisibleForTesting
    public FailoverPhoenixContext getContext() {
        return this.context;
    }

    @FunctionalInterface
    @VisibleForTesting
    static interface RunWithSQLException {
        public void run() throws SQLException;
    }

    @FunctionalInterface
    @VisibleForTesting
    static interface SupplierWithSQLException<T> {
        public T get() throws SQLException;
    }
}

