/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.jdbc;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.replication.ReplicationPeerConfig;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.phoenix.jdbc.ClusterRoleRecord;
import org.apache.phoenix.jdbc.HighAvailabilityPolicy;
import org.apache.phoenix.jdbc.PhoenixHAAdmin;
import org.apache.phoenix.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.phoenix.util.JacksonUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterRoleRecordGeneratorTool
extends Configured
implements Tool {
    private static final Logger LOG = LoggerFactory.getLogger(ClusterRoleRecordGeneratorTool.class);
    private static final String GENERATOR_ATTR_PREFIX = "phoenix.ha.role.generator.";
    public static final String PHOENIX_HA_GENERATOR_FILE_ATTR = "phoenix.ha.role.generator.file";
    public static final String PHOENIX_HA_GROUPS_ATTR = "phoenix.ha.role.generator.groups";
    public static final String PHOENIX_HA_GROUP_POLICY_ATTR_FORMAT = "phoenix.ha.role.generator.policy.%s";
    public static final String PHOENIX_HA_GROUP_STORE_PEER_ID_ATTR_FORMAT = "phoenix.ha.role.generator.store.peer.id.%s";
    public static final String PHOENIX_HA_GROUP_STORE_PEER_ID_DEFAULT = "1";

    public int run(String[] args) throws Exception {
        try {
            String fileName = this.getConf().get(PHOENIX_HA_GENERATOR_FILE_ATTR);
            File file = StringUtils.isEmpty((CharSequence)fileName) ? File.createTempFile("phoenix.ha.cluster.role.records", ".json") : new File(fileName);
            JacksonUtil.getObjectWriterPretty().writeValue(file, this.listAllRecordsByZk());
            System.out.println("Created JSON file '" + file + "'");
            return 0;
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    List<ClusterRoleRecord> listAllRecordsByZk() throws IOException {
        String localZkUrl = PhoenixHAAdmin.getLocalZkUrl(this.getConf());
        String[] haGroupNames = this.getConf().getStrings(PHOENIX_HA_GROUPS_ATTR);
        if (haGroupNames == null || haGroupNames.length == 0) {
            String msg = "No HA groups configured for this cluster via phoenix.ha.role.generator.groups";
            LOG.error(msg);
            throw new IOException(msg);
        }
        ArrayList<ClusterRoleRecord> records = new ArrayList<ClusterRoleRecord>();
        for (String haGroupName : haGroupNames) {
            String peerZkUrl = ClusterRoleRecordGeneratorTool.getPeerZkUrl(this.getConf(), haGroupName);
            records.add(new ClusterRoleRecord(haGroupName, this.getHaPolicy(haGroupName), localZkUrl, ClusterRoleRecord.ClusterRole.ACTIVE, peerZkUrl, ClusterRoleRecord.ClusterRole.STANDBY, 1L));
        }
        LOG.debug("Returning all cluster role records discovered: {}", records);
        return records;
    }

    private static String getPeerZkUrl(Configuration conf, String haGroupName) throws IOException {
        String key = String.format(PHOENIX_HA_GROUP_STORE_PEER_ID_ATTR_FORMAT, haGroupName);
        String peerId = conf.get(key, PHOENIX_HA_GROUP_STORE_PEER_ID_DEFAULT);
        try (Connection connection = ConnectionFactory.createConnection((Configuration)conf);){
            String string = ClusterRoleRecordGeneratorTool.getPeerClusterKey(connection.getAdmin(), peerId);
            return string;
        }
    }

    @VisibleForTesting
    static String getPeerClusterKey(Admin admin, String id) throws IOException {
        ReplicationPeerConfig replicationConfig;
        try {
            replicationConfig = admin.getReplicationPeerConfig(id);
        }
        catch (IOException io) {
            String msg = "Can not get replication peer (id=" + id + ") config";
            LOG.error(msg, (Throwable)io);
            throw io;
        }
        String peerZk = replicationConfig.getClusterKey();
        if (StringUtils.isEmpty((CharSequence)peerZk)) {
            String msg = "Peer (id=" + id + ") ZK quorum is not set!";
            LOG.error(msg);
            throw new IOException(msg);
        }
        return peerZk;
    }

    @VisibleForTesting
    HighAvailabilityPolicy getHaPolicy(String haGroupName) throws IOException {
        String key = String.format(PHOENIX_HA_GROUP_POLICY_ATTR_FORMAT, haGroupName);
        String value = this.getConf().get(key, HighAvailabilityPolicy.PARALLEL.name());
        try {
            return HighAvailabilityPolicy.valueOf(value);
        }
        catch (IllegalArgumentException e) {
            String msg = "Invalid HA policy name '" + value + "' for HA group " + haGroupName;
            LOG.error(msg, (Throwable)e);
            throw new IOException(msg, e);
        }
    }

    public static void main(String[] args) throws Exception {
        Configuration conf = HBaseConfiguration.create();
        int retCode = ToolRunner.run((Configuration)conf, (Tool)new ClusterRoleRecordGeneratorTool(), (String[])args);
        System.exit(retCode);
    }
}

