/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.jdbc;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Optional;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.phoenix.jdbc.HighAvailabilityPolicy;
import org.apache.phoenix.thirdparty.com.google.common.base.Preconditions;
import org.apache.phoenix.util.JDBCUtil;
import org.apache.phoenix.util.JacksonUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterRoleRecord {
    private static final Logger LOG = LoggerFactory.getLogger(ClusterRoleRecord.class);
    private final String haGroupName;
    private final HighAvailabilityPolicy policy;
    private final RegistryType registryType;
    private final String url1;
    private final ClusterRole role1;
    private final String url2;
    private final ClusterRole role2;
    private final long version;

    @JsonCreator
    public ClusterRoleRecord(@JsonProperty(value="haGroupName") String haGroupName, @JsonProperty(value="policy") HighAvailabilityPolicy policy, @JsonProperty(value="registryType") RegistryType registryType, @JsonProperty(value="url1") String url1, @JsonProperty(value="role1") ClusterRole role1, @JsonProperty(value="url2") String url2, @JsonProperty(value="role2") ClusterRole role2, @JsonProperty(value="version") long version, @JsonProperty(value="zk1") String zk1, @JsonProperty(value="zk2") String zk2) {
        this.haGroupName = haGroupName;
        this.policy = policy;
        this.registryType = registryType != null ? registryType : RegistryType.ZK;
        String resolvedUrl1 = url1 != null ? url1 : zk1;
        String resolvedUrl2 = url2 != null ? url2 : zk2;
        url1 = JDBCUtil.formatUrl(resolvedUrl1, this.registryType);
        url2 = JDBCUtil.formatUrl(resolvedUrl2, this.registryType);
        Preconditions.checkArgument((!url1.equals(url2) ? 1 : 0) != 0, (Object)"Two clusters have the same URLS!");
        Preconditions.checkNotNull((Object)((Object)role1), (Object)"Role of a cluster cannot be null!");
        Preconditions.checkNotNull((Object)((Object)role2), (Object)"Role of a cluster cannot be null!");
        if (url1.compareTo(url2) < 0) {
            this.url1 = url1;
            this.role1 = role1;
            this.url2 = url2;
            this.role2 = role2;
        } else {
            this.url1 = url2;
            this.role1 = role2;
            this.url2 = url1;
            this.role2 = role1;
        }
        this.version = version;
    }

    public ClusterRoleRecord(String haGroupName, HighAvailabilityPolicy policy, String url1, ClusterRole role1, String url2, ClusterRole role2, long version) {
        this(haGroupName, policy, RegistryType.ZK, url1, role1, url2, role2, version, null, null);
    }

    public ClusterRoleRecord(String haGroupName, HighAvailabilityPolicy policy, RegistryType registryType, String url1, ClusterRole role1, String url2, ClusterRole role2, long version) {
        this(haGroupName, policy, registryType, url1, role1, url2, role2, version, null, null);
    }

    public static Optional<ClusterRoleRecord> fromJson(byte[] bytes) {
        if (bytes == null) {
            return Optional.empty();
        }
        try {
            return Optional.of(JacksonUtil.getObjectReader(ClusterRoleRecord.class).readValue(bytes));
        }
        catch (Exception e) {
            LOG.error("Fail to deserialize data to a cluster role store", (Throwable)e);
            return Optional.empty();
        }
    }

    public static byte[] toJson(ClusterRoleRecord record) throws IOException {
        return JacksonUtil.getObjectWriter().writeValueAsBytes((Object)record);
    }

    @JsonIgnore
    public Optional<String> getActiveUrl() {
        if (this.role1 == ClusterRole.ACTIVE) {
            return Optional.of(this.url1);
        }
        if (this.role2 == ClusterRole.ACTIVE) {
            return Optional.of(this.url2);
        }
        return Optional.empty();
    }

    public boolean isNewerThan(ClusterRoleRecord other) {
        if (other == null) {
            return true;
        }
        return this.hasSameInfo(other) && this.version > other.version;
    }

    public boolean hasSameInfo(ClusterRoleRecord other) {
        return this.haGroupName.equals(other.haGroupName) && this.policy.equals((Object)other.policy);
    }

    public ClusterRole getRole(String url) {
        if (this.url1.equals(url)) {
            return this.role1;
        }
        if (this.url2.equals(url)) {
            return this.role2;
        }
        return ClusterRole.UNKNOWN;
    }

    public String getHaGroupName() {
        return this.haGroupName;
    }

    public HighAvailabilityPolicy getPolicy() {
        return this.policy;
    }

    public RegistryType getRegistryType() {
        return this.registryType;
    }

    public String getUrl1() {
        return this.url1;
    }

    public ClusterRole getRole1() {
        return this.role1;
    }

    public String getUrl2() {
        return this.url2;
    }

    public ClusterRole getRole2() {
        return this.role2;
    }

    public long getVersion() {
        return this.version;
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.haGroupName).append((Object)this.policy).append((Object)this.registryType).append((Object)this.url1).append((Object)this.role1).append((Object)this.url2).append((Object)this.role2).append(this.version).hashCode();
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (!(other instanceof ClusterRoleRecord)) {
            return false;
        }
        ClusterRoleRecord otherRecord = (ClusterRoleRecord)other;
        return new EqualsBuilder().append((Object)this.haGroupName, (Object)otherRecord.haGroupName).append((Object)this.policy, (Object)otherRecord.policy).append((Object)this.registryType, (Object)otherRecord.registryType).append((Object)this.url1, (Object)otherRecord.url1).append((Object)this.role1, (Object)otherRecord.role1).append((Object)this.url2, (Object)otherRecord.url2).append((Object)this.role2, (Object)otherRecord.role2).append(this.version, otherRecord.version).isEquals();
    }

    public String toString() {
        return "ClusterRoleRecord{haGroupName='" + this.haGroupName + '\'' + ", policy=" + (Object)((Object)this.policy) + ", registryType=" + (Object)((Object)this.registryType) + ", url1='" + this.url1 + '\'' + ", role1=" + (Object)((Object)this.role1) + ", url2='" + this.url2 + '\'' + ", role2=" + (Object)((Object)this.role2) + ", version=" + this.version + '}';
    }

    public String toPrettyString() {
        try {
            return JacksonUtil.getObjectWriterPretty().writeValueAsString((Object)this);
        }
        catch (Exception e) {
            LOG.error("Fail to wrap this object as JSON, retuning the oneliner using toString", (Throwable)e);
            return this.toString();
        }
    }

    public static enum RegistryType {
        ZK,
        MASTER,
        RPC;

    }

    public static enum ClusterRole {
        ACTIVE,
        STANDBY,
        OFFLINE,
        UNKNOWN,
        ACTIVE_TO_STANDBY;


        public boolean canConnect() {
            return this == ACTIVE || this == STANDBY || this == ACTIVE_TO_STANDBY;
        }

        public static ClusterRole from(byte[] bytes) {
            String value = new String(bytes, StandardCharsets.UTF_8);
            return Arrays.stream(ClusterRole.values()).filter(r -> r.name().equalsIgnoreCase(value)).findFirst().orElse(UNKNOWN);
        }
    }
}

