/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.iterate;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.compile.ExplainPlanAttributes;
import org.apache.phoenix.iterate.BaseResultIterator;
import org.apache.phoenix.query.QueryConstants;
import org.apache.phoenix.schema.tuple.ResultTuple;
import org.apache.phoenix.schema.tuple.Tuple;

public class SegmentResultIterator
extends BaseResultIterator {
    private final Iterator<Segment> segmentIterator;
    private int key;

    public SegmentResultIterator(List<HRegionLocation> regions, int totalSegments) {
        this.segmentIterator = SegmentResultIterator.getSegments(regions, totalSegments).iterator();
        this.key = 0;
    }

    @Override
    public Tuple next() throws SQLException {
        if (!this.segmentIterator.hasNext()) {
            return null;
        }
        Segment segment = this.segmentIterator.next();
        byte[] startKey = segment.getStartKey();
        byte[] endKey = segment.getEndKey();
        byte[] rowKey = Bytes.toBytes((int)this.key);
        ++this.key;
        ArrayList<KeyValue> cells = new ArrayList<KeyValue>();
        cells.add(new KeyValue(rowKey, QueryConstants.DEFAULT_COLUMN_FAMILY_BYTES, Bytes.toBytes((String)"0"), startKey));
        cells.add(new KeyValue(rowKey, QueryConstants.DEFAULT_COLUMN_FAMILY_BYTES, Bytes.toBytes((String)"1"), endKey));
        Result result = Result.create(cells);
        return new ResultTuple(result);
    }

    public static List<Segment> getSegments(List<HRegionLocation> regions, int numBuckets) {
        int size = regions.size();
        ArrayList<Segment> segments = new ArrayList<Segment>();
        if (size <= numBuckets) {
            for (HRegionLocation region : regions) {
                segments.add(new Segment(region.getRegion().getStartKey(), region.getRegion().getEndKey()));
            }
        } else {
            int q = size / numBuckets;
            int r = size % numBuckets;
            int currentIndex = 0;
            for (int i = 0; i < numBuckets; ++i) {
                int bucketSize = q + (i < r ? 1 : 0);
                HRegionLocation first = regions.get(currentIndex);
                HRegionLocation last = regions.get(currentIndex + bucketSize - 1);
                segments.add(new Segment(first.getRegion().getStartKey(), last.getRegion().getEndKey()));
                currentIndex += bucketSize;
            }
        }
        return segments;
    }

    @Override
    public void explain(List<String> planSteps) {
        planSteps.add("CLIENT SEGMENT SCAN");
    }

    @Override
    public void explain(List<String> planSteps, ExplainPlanAttributes.ExplainPlanAttributesBuilder explainPlanAttributesBuilder) {
        planSteps.add("CLIENT SEGMENT SCAN");
    }

    public static class Segment {
        byte[] startKey;
        byte[] endKey;

        public Segment(byte[] startKey, byte[] endKey) {
            this.startKey = startKey;
            this.endKey = endKey;
        }

        public byte[] getStartKey() {
            return this.startKey;
        }

        public byte[] getEndKey() {
            return this.endKey;
        }
    }
}

