/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.iterate;

import java.sql.SQLException;
import java.util.List;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.phoenix.compile.ExplainPlanAttributes;
import org.apache.phoenix.expression.aggregator.Aggregator;
import org.apache.phoenix.expression.aggregator.Aggregators;
import org.apache.phoenix.iterate.AggregatingResultIterator;
import org.apache.phoenix.iterate.LookAheadResultIterator;
import org.apache.phoenix.iterate.PeekingResultIterator;
import org.apache.phoenix.iterate.ResultIterators;
import org.apache.phoenix.query.QueryConstants;
import org.apache.phoenix.schema.tuple.SingleKeyValueTuple;
import org.apache.phoenix.schema.tuple.Tuple;
import org.apache.phoenix.util.ClientUtil;
import org.apache.phoenix.util.PhoenixKeyValueUtil;

public class RowKeyOrderedAggregateResultIterator
extends LookAheadResultIterator
implements AggregatingResultIterator {
    private final ResultIterators resultIterators;
    private List<PeekingResultIterator> iterators;
    private final Aggregators aggregators;
    private final ImmutableBytesWritable currentKey = new ImmutableBytesWritable();
    private final ImmutableBytesWritable previousKey = new ImmutableBytesWritable();
    private boolean traversedIterator = true;
    private boolean nextTraversedIterators;
    private Tuple next;
    private int index;

    public RowKeyOrderedAggregateResultIterator(ResultIterators iterators, Aggregators aggregators) {
        this.resultIterators = iterators;
        this.aggregators = aggregators;
    }

    private List<PeekingResultIterator> getIterators() throws SQLException {
        if (this.iterators == null && this.resultIterators != null) {
            this.iterators = this.resultIterators.getIterators();
        }
        return this.iterators;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws SQLException {
        block23: {
            SQLException toThrow = null;
            try {
                if (this.resultIterators != null) {
                    this.resultIterators.close();
                }
            }
            catch (Exception e) {
                toThrow = ClientUtil.parseServerException(e);
            }
            finally {
                try {
                    if (this.iterators != null) {
                        while (this.index < this.iterators.size()) {
                            PeekingResultIterator iterator = this.iterators.get(this.index);
                            try {
                                iterator.close();
                            }
                            catch (Exception e) {
                                if (toThrow == null) {
                                    toThrow = ClientUtil.parseServerException(e);
                                }
                                toThrow.setNextException(ClientUtil.parseServerException(e));
                            }
                            ++this.index;
                        }
                    }
                }
                finally {
                    if (toThrow == null) break block23;
                    throw toThrow;
                }
            }
        }
    }

    @Override
    public void explain(List<String> planSteps) {
        if (this.resultIterators != null) {
            this.resultIterators.explain(planSteps);
        }
    }

    @Override
    public void explain(List<String> planSteps, ExplainPlanAttributes.ExplainPlanAttributesBuilder explainPlanAttributesBuilder) {
        if (this.resultIterators != null) {
            this.resultIterators.explain(planSteps, explainPlanAttributesBuilder);
        }
    }

    private Tuple nextTuple() throws SQLException {
        List<PeekingResultIterator> iterators = this.getIterators();
        while (this.index < iterators.size()) {
            PeekingResultIterator iterator = iterators.get(this.index);
            Tuple r = iterator.peek();
            if (r != null) {
                return iterator.next();
            }
            this.traversedIterator = true;
            iterator.close();
            ++this.index;
        }
        return null;
    }

    private boolean continueAggregating(Tuple previous, Tuple next) {
        if (next == null) {
            return false;
        }
        next.getKey(this.currentKey);
        previous.getKey(this.previousKey);
        return this.currentKey.compareTo(this.previousKey) == 0;
    }

    @Override
    public Tuple next() throws SQLException {
        Tuple t = super.next();
        if (t == null) {
            return null;
        }
        this.aggregate(t);
        return t;
    }

    @Override
    protected Tuple advance() throws SQLException {
        Tuple current = this.next;
        boolean traversedIterators = this.nextTraversedIterators;
        if (current == null) {
            current = this.nextTuple();
            traversedIterators = this.traversedIterator;
        }
        if (current != null) {
            Tuple previous = current;
            Aggregator[] rowAggregators = null;
            while (true) {
                current = this.nextTuple();
                if (!traversedIterators || !this.continueAggregating(previous, current)) break;
                if (rowAggregators == null) {
                    rowAggregators = this.aggregate(previous);
                }
                this.aggregators.aggregate(rowAggregators, current);
                traversedIterators = this.traversedIterator;
            }
            this.next = current;
            this.nextTraversedIterators = this.traversedIterator;
            if (rowAggregators == null) {
                current = previous;
            } else {
                byte[] value = this.aggregators.toBytes(rowAggregators);
                current = new SingleKeyValueTuple(PhoenixKeyValueUtil.newKeyValue(this.previousKey, QueryConstants.SINGLE_COLUMN_FAMILY, QueryConstants.SINGLE_COLUMN, Long.MAX_VALUE, value, 0, value.length));
            }
        }
        if (current == null) {
            this.close();
        }
        return current;
    }

    public String toString() {
        return "RowKeyOrderedAggregateResultIterator [resultIterators=" + this.resultIterators + ", index=" + this.index + "]";
    }

    @Override
    public Aggregator[] aggregate(Tuple result) {
        Aggregator[] rowAggregators = this.aggregators.getAggregators();
        this.aggregators.reset(rowAggregators);
        this.aggregators.aggregate(rowAggregators, result);
        return rowAggregators;
    }
}

