/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.iterate;

import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.phoenix.compile.QueryPlan;
import org.apache.phoenix.iterate.ParallelScanGrouper;

public class ParallelScansCollector {
    private final ParallelScanGrouper grouper;
    private boolean lastScanCrossedRegionBoundary = false;
    private final List<List<Scan>> parallelScans = new ArrayList<List<Scan>>();
    private List<Scan> lastBatch = new ArrayList<Scan>();
    private Scan lastScan = null;
    private final List<HRegionLocation> regionLocations = new ArrayList<HRegionLocation>();

    public ParallelScansCollector(ParallelScanGrouper grouper) {
        this.grouper = grouper;
        this.parallelScans.add(this.lastBatch);
    }

    public void addNewScan(QueryPlan plan, Scan newScan, boolean crossesRegionBoundary, HRegionLocation regionLocation) {
        if (this.grouper.shouldStartNewScan(plan, this.lastScan, newScan.getStartRow(), this.lastScanCrossedRegionBoundary)) {
            this.lastBatch = new ArrayList<Scan>();
            this.parallelScans.add(this.lastBatch);
        }
        this.lastBatch.add(newScan);
        this.regionLocations.add(regionLocation);
        this.lastScanCrossedRegionBoundary = crossesRegionBoundary;
        this.lastScan = newScan;
    }

    public List<List<Scan>> getParallelScans() {
        return this.parallelScans;
    }

    public List<HRegionLocation> getRegionLocations() {
        return this.regionLocations;
    }
}

