/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.iterate;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.compile.ExplainPlanAttributes;
import org.apache.phoenix.exception.PhoenixIOException;
import org.apache.phoenix.execute.DescVarLengthFastByteComparisons;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.OrderByExpression;
import org.apache.phoenix.iterate.PeekingResultIterator;
import org.apache.phoenix.iterate.PhoenixQueues;
import org.apache.phoenix.iterate.ResultIterator;
import org.apache.phoenix.iterate.SizeAwareQueue;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.tuple.Tuple;
import org.apache.phoenix.thirdparty.com.google.common.base.Function;
import org.apache.phoenix.thirdparty.com.google.common.base.Preconditions;
import org.apache.phoenix.thirdparty.com.google.common.collect.Collections2;
import org.apache.phoenix.thirdparty.com.google.common.collect.Lists;
import org.apache.phoenix.thirdparty.com.google.common.collect.Ordering;
import org.apache.phoenix.util.ByteUtil;
import org.apache.phoenix.util.ClientUtil;
import org.apache.phoenix.util.EnvironmentEdgeManager;
import org.apache.phoenix.util.PhoenixKeyValueUtil;
import org.apache.phoenix.util.ScanUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OrderedResultIterator
implements PeekingResultIterator {
    private static final Logger LOGGER = LoggerFactory.getLogger(OrderedResultIterator.class);
    private static final Function<OrderByExpression, Expression> TO_EXPRESSION = new Function<OrderByExpression, Expression>(){

        public Expression apply(OrderByExpression column) {
            return column.getExpression();
        }
    };
    private final boolean spoolingEnabled;
    private final long thresholdBytes;
    private final Integer limit;
    private final Integer offset;
    private final ResultIterator delegate;
    private final List<OrderByExpression> orderByExpressions;
    private final long estimatedByteSize;
    private PeekingResultIterator resultIterator;
    private boolean resultIteratorReady = false;
    private Tuple dummyTuple = null;
    private long byteSize;
    private long pageSizeMs;
    private Scan scan;
    private byte[] scanStartRowKey;
    private byte[] actualScanStartRowKey;
    private Boolean actualScanIncludeStartRowKey;
    private RegionInfo regionInfo = null;
    private boolean includeStartRowKey;
    private boolean serverSideIterator = false;
    private boolean firstScan = true;
    private boolean skipValidRowsSent = false;

    protected ResultIterator getDelegate() {
        return this.delegate;
    }

    public OrderedResultIterator(ResultIterator delegate, List<OrderByExpression> orderByExpressions, boolean spoolingEnabled, long thresholdBytes, Integer limit, Integer offset) {
        this(delegate, orderByExpressions, spoolingEnabled, thresholdBytes, limit, offset, 0, Long.MAX_VALUE);
    }

    public OrderedResultIterator(ResultIterator delegate, List<OrderByExpression> orderByExpressions, boolean spoolingEnabled, long thresholdBytes) throws SQLException {
        this(delegate, orderByExpressions, spoolingEnabled, thresholdBytes, null, null);
    }

    public OrderedResultIterator(ResultIterator delegate, List<OrderByExpression> orderByExpressions, boolean spoolingEnabled, long thresholdBytes, Integer limit, Integer offset, int estimatedRowSize) {
        this(delegate, orderByExpressions, spoolingEnabled, thresholdBytes, limit, offset, estimatedRowSize, Long.MAX_VALUE);
    }

    public OrderedResultIterator(ResultIterator delegate, List<OrderByExpression> orderByExpressions, boolean spoolingEnabled, long thresholdBytes, Integer limit, Integer offset, int estimatedRowSize, long pageSizeMs, Scan scan, RegionInfo regionInfo) {
        this(delegate, orderByExpressions, spoolingEnabled, thresholdBytes, limit, offset, estimatedRowSize, pageSizeMs);
        this.scan = scan;
        this.scanStartRowKey = scan.getStartRow().length > 0 ? scan.getStartRow() : (scan.isReversed() ? regionInfo.getEndKey() : regionInfo.getStartKey());
        this.actualScanStartRowKey = scan.getAttribute("_ScanActualStartRow");
        this.actualScanIncludeStartRowKey = true;
        this.includeStartRowKey = scan.includeStartRow();
        this.serverSideIterator = true;
        this.regionInfo = regionInfo;
    }

    public OrderedResultIterator(ResultIterator delegate, List<OrderByExpression> orderByExpressions, boolean spoolingEnabled, long thresholdBytes, Integer limit, Integer offset, int estimatedRowSize, long pageSizeMs) {
        Preconditions.checkArgument((!orderByExpressions.isEmpty() ? 1 : 0) != 0);
        this.delegate = delegate;
        this.orderByExpressions = orderByExpressions;
        this.spoolingEnabled = spoolingEnabled;
        this.thresholdBytes = thresholdBytes;
        this.offset = offset == null ? 0 : offset;
        this.limit = limit != null ? Integer.valueOf(limit + this.offset) : null;
        long estimatedEntrySize = 40 + orderByExpressions.size() * 48 + 16 + estimatedRowSize;
        assert (limit == null || Long.MAX_VALUE / estimatedEntrySize >= (long)(limit + this.offset));
        this.estimatedByteSize = limit == null ? 0L : Math.min((long)(limit + this.offset) * estimatedEntrySize, thresholdBytes);
        this.pageSizeMs = pageSizeMs;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public long getEstimatedByteSize() {
        return this.estimatedByteSize;
    }

    public long getByteSize() {
        return this.byteSize;
    }

    private static Comparator<ResultEntry> buildComparator(List<OrderByExpression> orderByExpressions) {
        Ordering ordering = null;
        int pos = 0;
        for (OrderByExpression col : orderByExpressions) {
            Expression e = col.getExpression();
            ImmutableBytesWritable.Comparator comparator = e.getSortOrder() == SortOrder.DESC && !e.getDataType().isFixedWidth() ? OrderedResultIterator.buildDescVarLengthComparator() : new ImmutableBytesWritable.Comparator();
            Ordering o = Ordering.from((Comparator)comparator);
            if (!col.isAscending()) {
                o = o.reverse();
            }
            o = col.isNullsLast() ? o.nullsLast() : o.nullsFirst();
            Ordering entryOrdering = o.onResultOf((Function)new NthKey(pos++));
            ordering = ordering == null ? entryOrdering : ordering.compound((Comparator)entryOrdering);
        }
        return ordering;
    }

    private static Comparator<ImmutableBytesWritable> buildDescVarLengthComparator() {
        return new Comparator<ImmutableBytesWritable>(){

            @Override
            public int compare(ImmutableBytesWritable o1, ImmutableBytesWritable o2) {
                return DescVarLengthFastByteComparisons.compareTo(o1.get(), o1.getOffset(), o1.getLength(), o2.get(), o2.getOffset(), o2.getLength());
            }
        };
    }

    @Override
    public Tuple next() throws SQLException {
        try {
            if (this.firstScan && this.serverSideIterator && this.actualScanStartRowKey != null && this.actualScanIncludeStartRowKey != null && this.scanStartRowKey.length > 0 && !ScanUtil.isLocalIndex(this.scan) && (Bytes.compareTo((byte[])this.actualScanStartRowKey, (byte[])this.scanStartRowKey) != 0 || this.actualScanIncludeStartRowKey != this.includeStartRowKey)) {
                LOGGER.info("Region has moved. Actual scan start rowkey {} is not same as current scan start rowkey  {}", (Object)Bytes.toStringBinary((byte[])this.actualScanStartRowKey), (Object)Bytes.toStringBinary((byte[])this.scanStartRowKey));
                if (Bytes.compareTo((byte[])ByteUtil.concat(this.actualScanStartRowKey, new byte[][]{ByteUtil.ZERO_BYTE}), (byte[])this.scanStartRowKey) == 0) {
                    this.scan.setAttribute("phoenix.paging.start.newscan.startrow", this.actualScanStartRowKey);
                    this.scan.setAttribute("phoenix.paging.start.newscan.startrow.include", Bytes.toBytes((boolean)this.actualScanIncludeStartRowKey));
                } else {
                    this.skipValidRowsSent = true;
                    this.scan.setAttribute("phoenix.paging.start.newscan.startrow", this.actualScanStartRowKey);
                    this.scan.setAttribute("phoenix.paging.start.newscan.startrow.include", Bytes.toBytes((boolean)this.actualScanIncludeStartRowKey));
                }
            }
            if (this.firstScan) {
                this.firstScan = false;
            }
            this.getResultIterator();
            if (!this.resultIteratorReady) {
                return this.dummyTuple;
            }
            Tuple result = this.resultIterator.next();
            if (this.skipValidRowsSent) {
                while (true) {
                    if (result == null) {
                        this.skipValidRowsSent = false;
                        return null;
                    }
                    ImmutableBytesWritable ptr = new ImmutableBytesWritable();
                    result.getKey(ptr);
                    byte[] resultRowKey = new byte[ptr.getLength()];
                    System.arraycopy(ptr.get(), ptr.getOffset(), resultRowKey, 0, resultRowKey.length);
                    if (Bytes.compareTo((byte[])resultRowKey, (byte[])this.scanStartRowKey) == 0) {
                        this.skipValidRowsSent = false;
                        if (this.includeStartRowKey) {
                            return result;
                        }
                        return this.resultIterator.next();
                    }
                    if (Bytes.compareTo((byte[])ByteUtil.concat(resultRowKey, new byte[][]{ByteUtil.ZERO_BYTE}), (byte[])this.scanStartRowKey) == 0) {
                        this.skipValidRowsSent = false;
                        if (this.includeStartRowKey) {
                            return this.resultIterator.next();
                        }
                    }
                    result = this.resultIterator.next();
                }
            }
            return result;
        }
        catch (Exception e) {
            LOGGER.error("Ordered result iterator next encountered error " + (this.regionInfo != null ? " for region: " + this.regionInfo.getRegionNameAsString() : "."), (Throwable)e);
            if (e instanceof SQLException) {
                throw e;
            }
            throw new PhoenixIOException(e);
        }
    }

    private PeekingResultIterator getResultIterator() throws SQLException {
        if (this.resultIteratorReady) {
            return this.resultIterator;
        }
        int numSortKeys = this.orderByExpressions.size();
        ArrayList expressions = Lists.newArrayList((Iterable)Collections2.transform(this.orderByExpressions, TO_EXPRESSION));
        Comparator<ResultEntry> comparator = OrderedResultIterator.buildComparator(this.orderByExpressions);
        try {
            if (this.resultIterator == null) {
                this.resultIterator = new RecordPeekingResultIterator(PhoenixQueues.newResultEntrySortedQueue(comparator, this.limit, this.spoolingEnabled, this.thresholdBytes));
            }
            SizeAwareQueue<ResultEntry> queueEntries = ((RecordPeekingResultIterator)this.resultIterator).getQueueEntries();
            long startTime = EnvironmentEdgeManager.currentTimeMillis();
            Tuple result = this.delegate.next();
            while (result != null) {
                if (result.size() != 0) {
                    if (ScanUtil.isDummy(result)) {
                        this.getDummyResult();
                        PeekingResultIterator peekingResultIterator = this.resultIterator;
                        return peekingResultIterator;
                    }
                    int pos = 0;
                    ImmutableBytesWritable[] sortKeys = new ImmutableBytesWritable[numSortKeys];
                    for (Expression expression : expressions) {
                        ImmutableBytesWritable sortKey = new ImmutableBytesWritable();
                        boolean evaluated = expression.evaluate(result, sortKey);
                        sortKeys[pos++] = evaluated && sortKey.getLength() > 0 ? sortKey : null;
                    }
                    queueEntries.add(new ResultEntry(sortKeys, result));
                    if (EnvironmentEdgeManager.currentTimeMillis() - startTime >= this.pageSizeMs) {
                        this.getDummyResult();
                        PeekingResultIterator peekingResultIterator = this.resultIterator;
                        return peekingResultIterator;
                    }
                }
                result = this.delegate.next();
            }
            this.resultIteratorReady = true;
            this.byteSize = queueEntries.getByteSize();
        }
        catch (IOException e) {
            LOGGER.error("Error while getting result iterator from OrderedResultIterator.", (Throwable)e);
            ClientUtil.createIOException(e.getMessage(), e);
            throw new SQLException(e);
        }
        finally {
            this.delegate.close();
        }
        return this.resultIterator;
    }

    private void getDummyResult() {
        if (this.scanStartRowKey.length > 0 && !ScanUtil.isLocalIndex(this.scan)) {
            if (Bytes.compareTo((byte[])this.actualScanStartRowKey, (byte[])this.scanStartRowKey) != 0 || this.actualScanIncludeStartRowKey != this.includeStartRowKey) {
                byte[] lastByte = new byte[]{this.scanStartRowKey[this.scanStartRowKey.length - 1]};
                if (this.scanStartRowKey.length > 1 && Bytes.compareTo((byte[])lastByte, (byte[])ByteUtil.ZERO_BYTE) == 0) {
                    byte[] prevKey = new byte[this.scanStartRowKey.length - 1];
                    System.arraycopy(this.scanStartRowKey, 0, prevKey, 0, prevKey.length);
                    this.dummyTuple = ScanUtil.getDummyTuple(prevKey);
                } else {
                    this.dummyTuple = ScanUtil.getDummyTuple(this.scanStartRowKey);
                }
            } else {
                this.dummyTuple = ScanUtil.getDummyTuple(this.scanStartRowKey);
            }
        } else {
            this.dummyTuple = ScanUtil.getDummyTuple(this.scanStartRowKey);
        }
    }

    @Override
    public Tuple peek() throws SQLException {
        return this.getResultIterator().peek();
    }

    @Override
    public void close() throws SQLException {
        if (null != this.resultIterator) {
            this.resultIterator.close();
        }
        this.resultIterator = PeekingResultIterator.EMPTY_ITERATOR;
    }

    @Override
    public void explain(List<String> planSteps) {
        this.delegate.explain(planSteps);
        planSteps.add("CLIENT" + (this.offset == null || this.offset == 0 ? "" : " OFFSET " + this.offset) + (this.limit == null ? "" : " TOP " + this.limit + " ROW" + (this.limit == 1 ? "" : "S")) + " SORTED BY " + this.orderByExpressions.toString());
    }

    @Override
    public void explain(List<String> planSteps, ExplainPlanAttributes.ExplainPlanAttributesBuilder explainPlanAttributesBuilder) {
        this.delegate.explain(planSteps, explainPlanAttributesBuilder);
        explainPlanAttributesBuilder.setClientOffset(this.offset);
        explainPlanAttributesBuilder.setClientRowLimit(this.limit);
        explainPlanAttributesBuilder.setClientSortedBy(this.orderByExpressions.toString());
        planSteps.add("CLIENT" + (this.offset == null || this.offset == 0 ? "" : " OFFSET " + this.offset) + (this.limit == null ? "" : " TOP " + this.limit + " ROW" + (this.limit == 1 ? "" : "S")) + " SORTED BY " + this.orderByExpressions.toString());
    }

    public String toString() {
        return "OrderedResultIterator [thresholdBytes=" + this.thresholdBytes + ", limit=" + this.limit + ", offset=" + this.offset + ", delegate=" + this.delegate + ", orderByExpressions=" + this.orderByExpressions + ", estimatedByteSize=" + this.estimatedByteSize + ", resultIterator=" + this.resultIterator + ", byteSize=" + this.byteSize + "]";
    }

    private class RecordPeekingResultIterator
    implements PeekingResultIterator {
        int count = 0;
        private SizeAwareQueue<ResultEntry> queueEntries;

        RecordPeekingResultIterator(SizeAwareQueue<ResultEntry> queueEntries) {
            this.queueEntries = queueEntries;
        }

        public SizeAwareQueue<ResultEntry> getQueueEntries() {
            return this.queueEntries;
        }

        @Override
        public Tuple next() throws SQLException {
            ResultEntry entry = (ResultEntry)this.queueEntries.poll();
            while (entry != null && OrderedResultIterator.this.offset != null && this.count < OrderedResultIterator.this.offset) {
                ++this.count;
                if (entry.getResult() == null) {
                    return null;
                }
                entry = (ResultEntry)this.queueEntries.poll();
            }
            if (entry == null || OrderedResultIterator.this.limit != null && this.count++ > OrderedResultIterator.this.limit) {
                OrderedResultIterator.this.resultIterator.close();
                OrderedResultIterator.this.resultIterator = PeekingResultIterator.EMPTY_ITERATOR;
                return null;
            }
            return entry.getResult();
        }

        @Override
        public Tuple peek() throws SQLException {
            ResultEntry entry = (ResultEntry)this.queueEntries.peek();
            while (entry != null && OrderedResultIterator.this.offset != null && this.count < OrderedResultIterator.this.offset) {
                entry = (ResultEntry)this.queueEntries.poll();
                ++this.count;
                if (entry != null) continue;
                return null;
            }
            if (OrderedResultIterator.this.limit != null && this.count > OrderedResultIterator.this.limit) {
                return null;
            }
            entry = (ResultEntry)this.queueEntries.peek();
            if (entry == null) {
                return null;
            }
            return entry.getResult();
        }

        @Override
        public void explain(List<String> planSteps) {
        }

        @Override
        public void explain(List<String> planSteps, ExplainPlanAttributes.ExplainPlanAttributesBuilder explainPlanAttributesBuilder) {
        }

        @Override
        public void close() throws SQLException {
            try {
                this.queueEntries.close();
            }
            catch (IOException e) {
                throw new SQLException(e);
            }
        }
    }

    private static class NthKey
    implements Function<ResultEntry, ImmutableBytesWritable> {
        private final int index;

        NthKey(int index) {
            this.index = index;
        }

        public ImmutableBytesWritable apply(ResultEntry entry) {
            return entry.getSortKey(this.index);
        }
    }

    protected static class ResultEntry {
        protected final ImmutableBytesWritable[] sortKeys;
        protected final Tuple result;

        ResultEntry(ImmutableBytesWritable[] sortKeys, Tuple result) {
            this.sortKeys = sortKeys;
            this.result = result;
        }

        ImmutableBytesWritable getSortKey(int index) {
            Preconditions.checkPositionIndex((int)index, (int)this.sortKeys.length);
            return this.sortKeys[index];
        }

        Tuple getResult() {
            return this.result;
        }

        static long sizeOf(ResultEntry e) {
            return ResultEntry.sizeof(e.sortKeys) + ResultEntry.sizeof(ResultEntry.toKeyValues(e));
        }

        private static long sizeof(List<KeyValue> kvs) {
            long size = 4L;
            for (KeyValue kv : kvs) {
                size += (long)kv.getLength();
                size += 4L;
            }
            return size;
        }

        private static long sizeof(ImmutableBytesWritable[] sortKeys) {
            long size = 4L;
            if (sortKeys != null) {
                for (ImmutableBytesWritable sortKey : sortKeys) {
                    if (sortKey != null) {
                        size += (long)sortKey.getLength();
                    }
                    size += 4L;
                }
            }
            return size;
        }

        private static List<KeyValue> toKeyValues(ResultEntry entry) {
            Tuple result = entry.getResult();
            int size = result.size();
            ArrayList<KeyValue> kvs = new ArrayList<KeyValue>(size);
            for (int i = 0; i < size; ++i) {
                kvs.add(PhoenixKeyValueUtil.maybeCopyCell(result.getValue(i)));
            }
            return kvs;
        }
    }
}

