/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.iterate;

import java.sql.SQLException;
import java.util.List;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.phoenix.compile.QueryPlan;
import org.apache.phoenix.compile.StatementContext;
import org.apache.phoenix.iterate.ParallelScanGrouper;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.util.ScanUtil;

public class DefaultParallelScanGrouper
implements ParallelScanGrouper {
    private static DefaultParallelScanGrouper INSTANCE = new DefaultParallelScanGrouper();

    public static DefaultParallelScanGrouper getInstance() {
        return INSTANCE;
    }

    @Override
    public boolean shouldStartNewScan(QueryPlan plan, Scan lastScan, byte[] startKey, boolean crossesRegionBoundary) {
        PTable table = plan.getTableRef().getTable();
        if (lastScan == null) {
            return false;
        }
        if (!plan.isRowKeyOrdered()) {
            return true;
        }
        if (crossesRegionBoundary && table.getIndexType() == PTable.IndexType.LOCAL) {
            return true;
        }
        if (table.getBucketNum() != null) {
            return crossesRegionBoundary || ScanUtil.crossesPrefixBoundary(startKey, ScanUtil.getPrefix(lastScan.getStartRow(), 1), 1);
        }
        return false;
    }

    @Override
    public List<HRegionLocation> getRegionBoundaries(StatementContext context, byte[] tableName) throws SQLException {
        return context.getConnection().getQueryServices().getAllTableRegions(tableName, context.getStatement().getQueryTimeoutInMillis());
    }

    @Override
    public List<HRegionLocation> getRegionBoundaries(StatementContext context, byte[] tableName, byte[] startRegionBoundaryKey, byte[] stopRegionBoundaryKey) throws SQLException {
        return context.getConnection().getQueryServices().getTableRegions(tableName, startRegionBoundaryKey, stopRegionBoundaryKey, context.getStatement().getQueryTimeoutInMillis());
    }
}

