/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.iterate;

import java.sql.SQLException;
import java.util.List;
import org.apache.phoenix.compile.ExplainPlanAttributes;
import org.apache.phoenix.iterate.PeekingResultIterator;
import org.apache.phoenix.iterate.ResultIterators;
import org.apache.phoenix.schema.tuple.Tuple;
import org.apache.phoenix.util.ClientUtil;

public class ConcatResultIterator
implements PeekingResultIterator {
    private final ResultIterators resultIterators;
    private List<PeekingResultIterator> iterators;
    private int index;

    public ConcatResultIterator(ResultIterators iterators) {
        this.resultIterators = iterators;
    }

    private ConcatResultIterator(List<PeekingResultIterator> iterators) {
        this.resultIterators = null;
        this.iterators = iterators;
    }

    private List<PeekingResultIterator> getIterators() throws SQLException {
        if (this.iterators == null && this.resultIterators != null) {
            this.iterators = this.resultIterators.getIterators();
        }
        return this.iterators;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws SQLException {
        block23: {
            SQLException toThrow = null;
            try {
                if (this.resultIterators != null) {
                    this.resultIterators.close();
                }
            }
            catch (Exception e) {
                toThrow = ClientUtil.parseServerException(e);
            }
            finally {
                try {
                    if (this.iterators != null) {
                        while (this.index < this.iterators.size()) {
                            PeekingResultIterator iterator = this.iterators.get(this.index);
                            try {
                                iterator.close();
                            }
                            catch (Exception e) {
                                if (toThrow == null) {
                                    toThrow = ClientUtil.parseServerException(e);
                                }
                                toThrow.setNextException(ClientUtil.parseServerException(e));
                            }
                            ++this.index;
                        }
                    }
                }
                finally {
                    if (toThrow == null) break block23;
                    throw toThrow;
                }
            }
        }
    }

    @Override
    public void explain(List<String> planSteps) {
        if (this.resultIterators != null) {
            this.resultIterators.explain(planSteps);
        }
    }

    @Override
    public void explain(List<String> planSteps, ExplainPlanAttributes.ExplainPlanAttributesBuilder explainPlanAttributesBuilder) {
        if (this.resultIterators != null) {
            this.resultIterators.explain(planSteps, explainPlanAttributesBuilder);
        }
    }

    private PeekingResultIterator currentIterator() throws SQLException {
        List<PeekingResultIterator> iterators = this.getIterators();
        while (this.index < iterators.size()) {
            PeekingResultIterator iterator = iterators.get(this.index);
            Tuple r = iterator.peek();
            if (r != null) {
                return iterator;
            }
            iterator.close();
            ++this.index;
        }
        return EMPTY_ITERATOR;
    }

    @Override
    public Tuple peek() throws SQLException {
        return this.currentIterator().peek();
    }

    @Override
    public Tuple next() throws SQLException {
        Tuple next = this.currentIterator().next();
        if (next == null) {
            this.close();
        }
        return next;
    }

    public String toString() {
        return "ConcatResultIterator [" + this.resultIterators == null ? "iterators=" + this.iterators : "resultIterators=" + this.resultIterators + ", index=" + this.index + "]";
    }

    public static PeekingResultIterator newIterator(List<PeekingResultIterator> concatIterators) {
        if (concatIterators.isEmpty()) {
            return PeekingResultIterator.EMPTY_ITERATOR;
        }
        if (concatIterators.size() == 1) {
            return concatIterators.get(0);
        }
        return new ConcatResultIterator(concatIterators);
    }
}

