/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.index;

import java.io.IOException;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.List;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.client.ConnectionUtils;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.phoenix.exception.SQLExceptionCode;
import org.apache.phoenix.hbase.index.exception.IndexWriteException;
import org.apache.phoenix.hbase.index.exception.MultiIndexWriteFailureException;
import org.apache.phoenix.hbase.index.exception.SingleIndexWriteFailureException;
import org.apache.phoenix.hbase.index.table.HTableInterfaceReference;
import org.apache.phoenix.index.PhoenixIndexMetaData;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.schema.PIndexState;
import org.apache.phoenix.util.ClientUtil;
import org.apache.phoenix.util.IndexUtil;
import org.apache.phoenix.util.ReadOnlyProps;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PhoenixIndexFailurePolicyHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(PhoenixIndexFailurePolicyHelper.class);

    public static void doBatchWithRetries(MutateCommand mutateCommand, IndexWriteException iwe, PhoenixConnection connection, ReadOnlyProps config) throws IOException {
        if (!PhoenixIndexMetaData.isIndexRebuild(mutateCommand.getMutationList().get(0).getAttributesMap())) {
            PhoenixIndexFailurePolicyHelper.incrementPendingDisableCounter(iwe, connection);
        }
        int maxTries = config.getInt("hbase.client.retries.number", 15);
        long pause = config.getLong("hbase.client.pause", 100L);
        int numRetry = 1;
        int timeout = 0;
        for (int i = 0; i < maxTries; ++i) {
            timeout = (int)((long)timeout + ConnectionUtils.getPauseTime((long)pause, (int)i));
        }
        long canRetryUntil = EnvironmentEdgeManager.currentTime() + (long)timeout;
        while (PhoenixIndexFailurePolicyHelper.canRetryMore(numRetry++, maxTries, canRetryUntil)) {
            try {
                Thread.sleep(ConnectionUtils.getPauseTime((long)pause, (int)numRetry));
                mutateCommand.doMutation();
                if (!PhoenixIndexMetaData.isIndexRebuild(mutateCommand.getMutationList().get(0).getAttributesMap())) {
                    PhoenixIndexFailurePolicyHelper.handleIndexWriteSuccessFromClient(iwe, connection);
                }
                return;
            }
            catch (IOException e) {
                SQLException inferredE = ClientUtil.parseLocalOrRemoteServerException(e);
                if (inferredE == null || inferredE.getErrorCode() == SQLExceptionCode.INDEX_WRITE_FAILURE.getErrorCode() || inferredE.getErrorCode() == SQLExceptionCode.INDEX_METADATA_NOT_FOUND.getErrorCode()) continue;
                throw e;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new IOException(e);
            }
        }
        if (!PhoenixIndexMetaData.isIndexRebuild(mutateCommand.getMutationList().get(0).getAttributesMap())) {
            PhoenixIndexFailurePolicyHelper.handleIndexWriteFailureFromClient(iwe, connection);
        }
        throw new DoNotRetryIOException((Throwable)((Object)iwe));
    }

    private static void handleIndexWriteFailureFromClient(IndexWriteException indexWriteException, PhoenixConnection conn) {
        PhoenixIndexFailurePolicyHelper.handleExceptionFromClient(indexWriteException, conn, PIndexState.DISABLE);
    }

    private static void handleIndexWriteSuccessFromClient(IndexWriteException indexWriteException, PhoenixConnection conn) {
        PhoenixIndexFailurePolicyHelper.handleExceptionFromClient(indexWriteException, conn, PIndexState.ACTIVE);
    }

    private static void handleExceptionFromClient(IndexWriteException indexWriteException, PhoenixConnection conn, PIndexState indexState) {
        try {
            HashSet<String> indexesToUpdate = new HashSet<String>();
            if (indexWriteException instanceof MultiIndexWriteFailureException) {
                MultiIndexWriteFailureException indexException = (MultiIndexWriteFailureException)indexWriteException;
                List<HTableInterfaceReference> failedIndexes = indexException.getFailedTables();
                if (indexException.isDisableIndexOnFailure() && failedIndexes != null) {
                    for (HTableInterfaceReference failedIndex : failedIndexes) {
                        String failedIndexTable = failedIndex.getTableName();
                        if (indexesToUpdate.contains(failedIndexTable)) continue;
                        PhoenixIndexFailurePolicyHelper.updateIndex(failedIndexTable, conn, indexState);
                        indexesToUpdate.add(failedIndexTable);
                    }
                }
            } else if (indexWriteException instanceof SingleIndexWriteFailureException) {
                SingleIndexWriteFailureException indexException = (SingleIndexWriteFailureException)indexWriteException;
                String failedIndex = indexException.getTableName();
                if (indexException.isDisableIndexOnFailure() && failedIndex != null) {
                    PhoenixIndexFailurePolicyHelper.updateIndex(failedIndex, conn, indexState);
                }
            }
        }
        catch (Exception handleE) {
            LOGGER.warn("Error while trying to handle index write exception", (Throwable)((Object)indexWriteException));
        }
    }

    private static void incrementPendingDisableCounter(IndexWriteException indexWriteException, PhoenixConnection conn) {
        try {
            HashSet<String> indexesToUpdate = new HashSet<String>();
            if (indexWriteException instanceof MultiIndexWriteFailureException) {
                MultiIndexWriteFailureException indexException = (MultiIndexWriteFailureException)indexWriteException;
                List<HTableInterfaceReference> failedIndexes = indexException.getFailedTables();
                if (indexException.isDisableIndexOnFailure() && failedIndexes != null) {
                    for (HTableInterfaceReference failedIndex : failedIndexes) {
                        String failedIndexTable = failedIndex.getTableName();
                        if (indexesToUpdate.contains(failedIndexTable)) continue;
                        PhoenixIndexFailurePolicyHelper.incrementCounterForIndex(conn, failedIndexTable);
                        indexesToUpdate.add(failedIndexTable);
                    }
                }
            } else if (indexWriteException instanceof SingleIndexWriteFailureException) {
                SingleIndexWriteFailureException indexException = (SingleIndexWriteFailureException)indexWriteException;
                String failedIndex = indexException.getTableName();
                if (indexException.isDisableIndexOnFailure() && failedIndex != null) {
                    PhoenixIndexFailurePolicyHelper.incrementCounterForIndex(conn, failedIndex);
                }
            }
        }
        catch (Exception handleE) {
            LOGGER.warn("Error while trying to handle index write exception", (Throwable)((Object)indexWriteException));
        }
    }

    private static void incrementCounterForIndex(PhoenixConnection conn, String failedIndexTable) throws IOException {
        IndexUtil.incrementCounterForIndex(conn, failedIndexTable, 1L);
    }

    private static void decrementCounterForIndex(PhoenixConnection conn, String failedIndexTable) throws IOException {
        IndexUtil.incrementCounterForIndex(conn, failedIndexTable, -1L);
    }

    private static boolean canRetryMore(int numRetry, int maxRetries, long canRetryUntil) {
        return numRetry < maxRetries || maxRetries > 1 && EnvironmentEdgeManager.currentTime() < canRetryUntil;
    }

    public static IndexWriteException getIndexWriteException(SQLException sqlE) {
        String sqlMsg = sqlE.getMessage();
        if (sqlMsg.contains("Failed to write to multiple index tables: ")) {
            return new MultiIndexWriteFailureException(sqlMsg);
        }
        if (sqlMsg.contains("Failed to make index update:")) {
            return new SingleIndexWriteFailureException(sqlMsg);
        }
        return null;
    }

    private static void updateIndex(String indexFullName, PhoenixConnection conn, PIndexState indexState) throws SQLException, IOException {
        block5: {
            PhoenixIndexFailurePolicyHelper.decrementCounterForIndex(conn, indexFullName);
            Long indexDisableTimestamp = null;
            if (PIndexState.DISABLE.equals((Object)indexState)) {
                LOGGER.info("Disabling index after hitting max number of index write retries: " + indexFullName);
                IndexUtil.updateIndexState(conn, indexFullName, indexState, indexDisableTimestamp);
            } else if (PIndexState.ACTIVE.equals((Object)indexState)) {
                LOGGER.debug("Resetting index to active after subsequent success " + indexFullName);
                indexDisableTimestamp = 0L;
                try {
                    IndexUtil.updateIndexState(conn, indexFullName, indexState, indexDisableTimestamp);
                }
                catch (SQLException e) {
                    if (e.getErrorCode() == SQLExceptionCode.INVALID_INDEX_STATE_TRANSITION.getErrorCode()) break block5;
                    throw e;
                }
            }
        }
    }

    public static interface MutateCommand {
        public void doMutation() throws IOException;

        public List<Mutation> getMutationList();
    }
}

