/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.filter;

import java.io.IOException;
import java.util.List;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hbase.thirdparty.com.google.common.base.Preconditions;
import org.apache.phoenix.filter.DelegateFilter;
import org.apache.phoenix.query.QueryConstants;
import org.apache.phoenix.util.ScanUtil;

public class UnverifiedRowFilter
extends DelegateFilter {
    private final byte[] emptyCF;
    private final byte[] emptyCQ;
    private boolean verified = false;
    private Filter.ReturnCode recordedRetCode = null;

    private void init() {
        this.verified = false;
        this.recordedRetCode = null;
    }

    public UnverifiedRowFilter(Filter delegate, byte[] emptyCF, byte[] emptyCQ) {
        super(delegate);
        Preconditions.checkArgument((emptyCF != null ? 1 : 0) != 0, (Object)"Column family must not be null");
        Preconditions.checkArgument((emptyCQ != null ? 1 : 0) != 0, (Object)"Column qualifier must not be null");
        this.emptyCF = emptyCF;
        this.emptyCQ = emptyCQ;
        this.init();
    }

    @Override
    public void reset() throws IOException {
        this.init();
        this.delegate.reset();
    }

    public Filter.ReturnCode filterKeyValue(Cell v) throws IOException {
        return this.filterCell(v);
    }

    @Override
    public Filter.ReturnCode filterCell(Cell cell) throws IOException {
        if (this.verified) {
            return this.delegate.filterCell(cell);
        }
        if (ScanUtil.isEmptyColumn(cell, this.emptyCF, this.emptyCQ)) {
            boolean bl = this.verified = Bytes.compareTo((byte[])cell.getValueArray(), (int)cell.getValueOffset(), (int)cell.getValueLength(), (byte[])QueryConstants.VERIFIED_BYTES, (int)0, (int)QueryConstants.VERIFIED_BYTES.length) == 0;
            if (this.verified) {
                return this.recordedRetCode != null ? this.recordedRetCode : this.delegate.filterCell(cell);
            }
            return Filter.ReturnCode.INCLUDE_AND_SEEK_NEXT_ROW;
        }
        if (this.recordedRetCode != null) {
            return Filter.ReturnCode.NEXT_COL;
        }
        Filter.ReturnCode ret = this.delegate.filterCell(cell);
        if (ret == Filter.ReturnCode.NEXT_ROW || ret == Filter.ReturnCode.INCLUDE_AND_SEEK_NEXT_ROW) {
            this.recordedRetCode = ret;
            ret = Filter.ReturnCode.NEXT_COL;
        }
        return ret;
    }

    @Override
    public void filterRowCells(List<Cell> kvs) throws IOException {
        if (this.verified) {
            this.delegate.filterRowCells(kvs);
        }
    }

    @Override
    public boolean filterRow() throws IOException {
        if (this.verified) {
            return this.delegate.filterRow();
        }
        return false;
    }
}

