/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.filter;

import java.io.DataInput;
import java.io.IOException;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.KeyValueColumnExpression;
import org.apache.phoenix.expression.visitor.StatelessTraverseAllExpressionVisitor;
import org.apache.phoenix.filter.BooleanExpressionFilter;
import org.apache.phoenix.schema.tuple.SingleKeyValueTuple;

public abstract class SingleKeyValueComparisonFilter
extends BooleanExpressionFilter {
    private final SingleKeyValueTuple inputTuple = new SingleKeyValueTuple();
    private boolean matchedColumn;
    protected byte[] cf;
    protected byte[] cq;

    public SingleKeyValueComparisonFilter() {
    }

    public SingleKeyValueComparisonFilter(Expression expression) {
        super(expression);
        this.init();
    }

    protected abstract int compare(byte[] var1, int var2, int var3, byte[] var4, int var5, int var6);

    private void init() {
        StatelessTraverseAllExpressionVisitor<Void> visitor = new StatelessTraverseAllExpressionVisitor<Void>(){

            @Override
            public Void visit(KeyValueColumnExpression expression) {
                SingleKeyValueComparisonFilter.this.cf = expression.getColumnFamily();
                SingleKeyValueComparisonFilter.this.cq = expression.getColumnQualifier();
                return null;
            }
        };
        this.expression.accept(visitor);
    }

    private boolean foundColumn() {
        return this.inputTuple.size() > 0;
    }

    public Filter.ReturnCode filterKeyValue(Cell keyValue) {
        return this.filterCell(keyValue);
    }

    public Filter.ReturnCode filterCell(Cell keyValue) {
        if (this.matchedColumn) {
            return Filter.ReturnCode.INCLUDE_AND_NEXT_COL;
        }
        if (this.foundColumn()) {
            return Filter.ReturnCode.NEXT_ROW;
        }
        if (this.compare(keyValue.getFamilyArray(), keyValue.getFamilyOffset(), keyValue.getFamilyLength(), keyValue.getQualifierArray(), keyValue.getQualifierOffset(), keyValue.getQualifierLength()) != 0) {
            this.inputTuple.setKey(keyValue);
            return Filter.ReturnCode.INCLUDE_AND_NEXT_COL;
        }
        this.inputTuple.setCell(keyValue);
        if (!Boolean.TRUE.equals(this.evaluate(this.inputTuple))) {
            return Filter.ReturnCode.NEXT_ROW;
        }
        this.matchedColumn = true;
        return Filter.ReturnCode.INCLUDE_AND_NEXT_COL;
    }

    public boolean filterRow() {
        if (this.foundColumn()) {
            return !this.matchedColumn;
        }
        if (this.inputTuple.hasKey() && this.expression.requiresFinalEvaluation()) {
            return !Boolean.TRUE.equals(this.evaluate(this.inputTuple));
        }
        return true;
    }

    @Override
    public void reset() {
        this.inputTuple.reset();
        this.matchedColumn = false;
        super.reset();
    }

    @Override
    public void readFields(DataInput input) throws IOException {
        super.readFields(input);
        this.init();
    }

    public boolean isFamilyEssential(byte[] name) {
        return Bytes.compareTo((byte[])this.cf, (byte[])name) == 0;
    }
}

