/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.filter;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.EOFException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.KeyValueColumnExpression;
import org.apache.phoenix.expression.visitor.StatelessTraverseAllExpressionVisitor;
import org.apache.phoenix.filter.BooleanExpressionFilter;
import org.apache.phoenix.schema.tuple.BaseTuple;
import org.apache.phoenix.util.ByteUtil;
import org.apache.phoenix.util.ClientUtil;

public abstract class MultiKeyValueComparisonFilter
extends BooleanExpressionFilter {
    private static final byte[] UNITIALIZED_KEY_BUFFER = new byte[0];
    private Boolean matchedColumn;
    protected final IncrementalResultTuple inputTuple = new IncrementalResultTuple();
    protected TreeSet<byte[]> cfSet;
    private byte[] essentialCF = ByteUtil.EMPTY_BYTE_ARRAY;
    private boolean allCFs;

    public MultiKeyValueComparisonFilter() {
    }

    public MultiKeyValueComparisonFilter(Expression expression, boolean allCFs, byte[] essentialCF) {
        super(expression);
        this.allCFs = allCFs;
        this.essentialCF = essentialCF == null ? ByteUtil.EMPTY_BYTE_ARRAY : essentialCF;
        this.init();
    }

    protected abstract Object setColumnKey(byte[] var1, int var2, int var3, byte[] var4, int var5, int var6);

    protected abstract Object newColumnKey(byte[] var1, int var2, int var3, byte[] var4, int var5, int var6);

    protected void init() {
        this.cfSet = new TreeSet(Bytes.BYTES_COMPARATOR);
        StatelessTraverseAllExpressionVisitor<Void> visitor = new StatelessTraverseAllExpressionVisitor<Void>(){

            @Override
            public Void visit(KeyValueColumnExpression expression) {
                MultiKeyValueComparisonFilter.this.inputTuple.addColumn(expression.getColumnFamily(), expression.getColumnQualifier());
                return null;
            }
        };
        this.expression.accept(visitor);
    }

    public Filter.ReturnCode filterKeyValue(Cell cell) {
        return this.filterCell(cell);
    }

    public Filter.ReturnCode filterCell(Cell cell) {
        if (Boolean.TRUE.equals(this.matchedColumn)) {
            return Filter.ReturnCode.INCLUDE_AND_NEXT_COL;
        }
        if (Boolean.FALSE.equals(this.matchedColumn)) {
            return Filter.ReturnCode.NEXT_ROW;
        }
        Filter.ReturnCode code = this.inputTuple.resolveColumn(cell);
        if (code != null) {
            return code;
        }
        this.matchedColumn = this.evaluate(this.inputTuple);
        if (this.matchedColumn == null) {
            if (this.inputTuple.isImmutable()) {
                this.matchedColumn = Boolean.FALSE;
            } else {
                return Filter.ReturnCode.INCLUDE_AND_NEXT_COL;
            }
        }
        return this.matchedColumn != false ? Filter.ReturnCode.INCLUDE_AND_NEXT_COL : Filter.ReturnCode.NEXT_ROW;
    }

    public boolean filterRow() {
        if (this.matchedColumn == null && !this.inputTuple.isImmutable() && this.expression.requiresFinalEvaluation()) {
            this.inputTuple.setImmutable();
            this.matchedColumn = this.evaluate(this.inputTuple);
        }
        return !Boolean.TRUE.equals(this.matchedColumn);
    }

    @Override
    public void reset() {
        this.matchedColumn = null;
        this.inputTuple.reset();
        super.reset();
    }

    public boolean isFamilyEssential(byte[] name) {
        return this.allCFs || Bytes.compareTo((byte[])name, (byte[])this.essentialCF) == 0 || this.cfSet.contains(name);
    }

    @Override
    public void readFields(DataInput input) throws IOException {
        super.readFields(input);
        try {
            this.allCFs = input.readBoolean();
            if (!this.allCFs) {
                this.essentialCF = Bytes.readByteArray((DataInput)input);
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        this.init();
    }

    @Override
    public void write(DataOutput output) throws IOException {
        super.write(output);
        try {
            output.writeBoolean(this.allCFs);
            if (!this.allCFs) {
                Bytes.writeByteArray((DataOutput)output, (byte[])this.essentialCF);
            }
        }
        catch (Throwable t) {
            ClientUtil.throwIOException("MultiKeyValueComparisonFilter failed during writing", t);
        }
    }

    private final class IncrementalResultTuple
    extends BaseTuple {
        private int refCount;
        private final ImmutableBytesWritable keyPtr = new ImmutableBytesWritable(MultiKeyValueComparisonFilter.access$100());
        private final Map<Object, CellRef> foundColumns = new HashMap<Object, CellRef>(5);

        private IncrementalResultTuple() {
        }

        public void reset() {
            this.refCount = 0;
            this.keyPtr.set(UNITIALIZED_KEY_BUFFER);
            for (CellRef ref : this.foundColumns.values()) {
                ref.cell = null;
            }
        }

        @Override
        public boolean isImmutable() {
            return this.refCount == this.foundColumns.size();
        }

        public void setImmutable() {
            this.refCount = this.foundColumns.size();
        }

        private Filter.ReturnCode resolveColumn(Cell value) {
            this.setKey(value);
            Object ptr = MultiKeyValueComparisonFilter.this.setColumnKey(value.getFamilyArray(), value.getFamilyOffset(), value.getFamilyLength(), value.getQualifierArray(), value.getQualifierOffset(), value.getQualifierLength());
            CellRef ref = this.foundColumns.get(ptr);
            if (ref == null) {
                return Filter.ReturnCode.INCLUDE_AND_NEXT_COL;
            }
            if (ref.cell != null) {
                return Filter.ReturnCode.NEXT_COL;
            }
            ref.cell = value;
            ++this.refCount;
            return null;
        }

        public void addColumn(byte[] cf, byte[] cq) {
            Object ptr = MultiKeyValueComparisonFilter.this.newColumnKey(cf, 0, cf.length, cq, 0, cq.length);
            this.foundColumns.put(ptr, new CellRef());
        }

        public void setKey(Cell value) {
            this.keyPtr.set(value.getRowArray(), value.getRowOffset(), (int)value.getRowLength());
        }

        @Override
        public void getKey(ImmutableBytesWritable ptr) {
            ptr.set(this.keyPtr.get(), this.keyPtr.getOffset(), this.keyPtr.getLength());
        }

        @Override
        public Cell getValue(byte[] cf, byte[] cq) {
            Object ptr = MultiKeyValueComparisonFilter.this.setColumnKey(cf, 0, cf.length, cq, 0, cq.length);
            CellRef ref = this.foundColumns.get(ptr);
            return ref == null ? null : ref.cell;
        }

        public String toString() {
            return this.foundColumns.toString();
        }

        @Override
        public int size() {
            return this.refCount;
        }

        @Override
        public Cell getValue(int index) {
            for (CellRef ref : this.foundColumns.values()) {
                if (ref.cell == null) continue;
                if (index == 0) {
                    return ref.cell;
                }
                --index;
            }
            throw new IndexOutOfBoundsException(Integer.toString(index));
        }

        @Override
        public boolean getValue(byte[] family, byte[] qualifier, ImmutableBytesWritable ptr) {
            Cell cell = this.getValue(family, qualifier);
            if (cell == null) {
                return false;
            }
            ptr.set(cell.getValueArray(), cell.getValueOffset(), cell.getValueLength());
            return true;
        }

        @Override
        public long getSerializedSize() {
            if (this.foundColumns.isEmpty()) {
                return 0L;
            }
            long totalSize = 0L;
            for (CellRef ref : this.foundColumns.values()) {
                if (ref == null || ref.cell == null) continue;
                totalSize += (long)ref.cell.getSerializedSize();
            }
            return totalSize;
        }
    }

    private static final class CellRef {
        public Cell cell;

        private CellRef() {
        }

        public String toString() {
            if (this.cell != null) {
                return this.cell.toString() + " value = " + Bytes.toStringBinary((byte[])this.cell.getValueArray(), (int)this.cell.getValueOffset(), (int)this.cell.getValueLength());
            }
            return super.toString();
        }
    }
}

