/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.expression.util.bson;

import java.math.BigDecimal;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.phoenix.expression.util.bson.BsonUpdateInvalidArgumentException;
import org.apache.phoenix.expression.util.bson.CommonComparisonExpressionUtils;
import org.bson.BsonArray;
import org.bson.BsonDecimal128;
import org.bson.BsonDocument;
import org.bson.BsonDouble;
import org.bson.BsonInt32;
import org.bson.BsonInt64;
import org.bson.BsonNumber;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.bson.types.Decimal128;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateExpressionUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(UpdateExpressionUtils.class);
    private static final String INVALID_UPDATE_PATH_MESSAGE = "The document path provided in the update expression is invalid for update";

    public static void updateExpression(BsonDocument updateExpression, BsonDocument bsonDocument) {
        LOGGER.info("Update Expression: {} , current bsonDocument: {}", (Object)updateExpression, (Object)bsonDocument);
        if (updateExpression.containsKey((Object)"$SET")) {
            UpdateExpressionUtils.executeSetExpression((BsonDocument)updateExpression.get((Object)"$SET"), bsonDocument);
        }
        if (updateExpression.containsKey((Object)"$UNSET")) {
            UpdateExpressionUtils.executeRemoveExpression((BsonDocument)updateExpression.get((Object)"$UNSET"), bsonDocument);
        }
        if (updateExpression.containsKey((Object)"$ADD")) {
            UpdateExpressionUtils.executeAddExpression((BsonDocument)updateExpression.get((Object)"$ADD"), bsonDocument);
        }
        if (updateExpression.containsKey((Object)"$DELETE_FROM_SET")) {
            UpdateExpressionUtils.executeDeleteExpression((BsonDocument)updateExpression.get((Object)"$DELETE_FROM_SET"), bsonDocument);
        }
    }

    private static void executeDeleteExpression(BsonDocument deleteExpr, BsonDocument bsonDocument) {
        for (Map.Entry deleteEntry : deleteExpr.entrySet()) {
            String fieldKey = (String)deleteEntry.getKey();
            BsonValue newVal = (BsonValue)deleteEntry.getValue();
            BsonValue topLevelValue = bsonDocument.get((Object)fieldKey);
            if (!CommonComparisonExpressionUtils.isBsonSet(newVal)) {
                throw new RuntimeException("Type of new value to be removed should be sets only");
            }
            if (topLevelValue != null) {
                BsonValue value = UpdateExpressionUtils.modifyFieldValueByDeleteFromSet(topLevelValue, newVal);
                if (value == null) {
                    bsonDocument.remove((Object)fieldKey);
                    continue;
                }
                bsonDocument.put(fieldKey, value);
                continue;
            }
            if (!fieldKey.contains(".") && !fieldKey.contains("[")) {
                LOGGER.info("Nothing to be removed as field with key {} does not exist", (Object)fieldKey);
                continue;
            }
            UpdateExpressionUtils.updateNestedField((BsonValue)bsonDocument, 0, fieldKey, newVal, UpdateOp.DELETE_FROM_SET);
        }
    }

    private static BsonValue modifyFieldValueByDeleteFromSet(BsonValue currentValue, BsonValue setValuesToDelete) {
        if (UpdateExpressionUtils.areBsonSetOfSameType(currentValue, setValuesToDelete)) {
            HashSet set1 = new HashSet(((BsonArray)((BsonDocument)currentValue).get((Object)"$set")).getValues());
            HashSet set2 = new HashSet(((BsonArray)((BsonDocument)setValuesToDelete).get((Object)"$set")).getValues());
            set1.removeAll(set2);
            if (set1.isEmpty()) {
                return null;
            }
            BsonDocument bsonDocument = new BsonDocument();
            bsonDocument.put("$set", (BsonValue)new BsonArray(new ArrayList(set1)));
            return bsonDocument;
        }
        throw new BsonUpdateInvalidArgumentException(INVALID_UPDATE_PATH_MESSAGE);
    }

    private static void executeAddExpression(BsonDocument addExpr, BsonDocument bsonDocument) {
        for (Map.Entry addEntry : addExpr.entrySet()) {
            String fieldKey = (String)addEntry.getKey();
            BsonValue newVal = (BsonValue)addEntry.getValue();
            BsonValue topLevelValue = bsonDocument.get((Object)fieldKey);
            if (!(newVal.isNumber() || newVal.isDecimal128() || CommonComparisonExpressionUtils.isBsonSet(newVal))) {
                throw new RuntimeException("Type of new value to be updated should be either number or sets only");
            }
            if (topLevelValue != null) {
                if (!(topLevelValue.isNumber() || topLevelValue.isDecimal128() || CommonComparisonExpressionUtils.isBsonSet(topLevelValue))) {
                    throw new BsonUpdateInvalidArgumentException(INVALID_UPDATE_PATH_MESSAGE);
                }
                bsonDocument.put(fieldKey, UpdateExpressionUtils.modifyFieldValueByAdd(topLevelValue, newVal));
                continue;
            }
            if (!fieldKey.contains(".") && !fieldKey.contains("[")) {
                bsonDocument.put(fieldKey, newVal);
                continue;
            }
            UpdateExpressionUtils.updateNestedField((BsonValue)bsonDocument, 0, fieldKey, newVal, UpdateOp.ADD);
        }
    }

    private static BsonValue modifyFieldValueByAdd(BsonValue currentValue, BsonValue newVal) {
        if ((currentValue.isNumber() || currentValue.isDecimal128()) && (newVal.isNumber() || newVal.isDecimal128())) {
            Number num1 = UpdateExpressionUtils.getNumberFromBsonNumber((BsonNumber)currentValue);
            Number num2 = UpdateExpressionUtils.getNumberFromBsonNumber((BsonNumber)newVal);
            Number newNum = UpdateExpressionUtils.addNum(num1, num2);
            return UpdateExpressionUtils.getBsonNumberFromNumber(newNum);
        }
        if (UpdateExpressionUtils.areBsonSetOfSameType(currentValue, newVal)) {
            HashSet set1 = new HashSet(((BsonArray)((BsonDocument)currentValue).get((Object)"$set")).getValues());
            HashSet set2 = new HashSet(((BsonArray)((BsonDocument)newVal).get((Object)"$set")).getValues());
            set1.addAll(set2);
            BsonDocument bsonDocument = new BsonDocument();
            bsonDocument.put("$set", (BsonValue)new BsonArray(new ArrayList(set1)));
            return bsonDocument;
        }
        throw new BsonUpdateInvalidArgumentException(INVALID_UPDATE_PATH_MESSAGE);
    }

    private static void executeRemoveExpression(BsonDocument unsetExpr, BsonDocument bsonDocument) {
        for (Map.Entry removeField : unsetExpr.entrySet()) {
            String fieldKey = (String)removeField.getKey();
            BsonValue topLevelValue = bsonDocument.get((Object)fieldKey);
            if (topLevelValue != null || !fieldKey.contains(".") && !fieldKey.contains("[")) {
                bsonDocument.remove((Object)fieldKey);
                continue;
            }
            UpdateExpressionUtils.updateNestedField((BsonValue)bsonDocument, 0, fieldKey, null, UpdateOp.UNSET);
        }
    }

    private static void executeSetExpression(BsonDocument setExpression, BsonDocument bsonDocument) {
        for (Map.Entry setEntry : setExpression.entrySet()) {
            String fieldKey = (String)setEntry.getKey();
            BsonValue fieldVal = (BsonValue)setEntry.getValue();
            BsonValue topLevelValue = bsonDocument.get((Object)fieldKey);
            BsonValue newVal = UpdateExpressionUtils.getNewFieldValue(fieldVal, bsonDocument);
            if (topLevelValue != null || !fieldKey.contains(".") && !fieldKey.contains("[")) {
                bsonDocument.put(fieldKey, newVal);
                continue;
            }
            UpdateExpressionUtils.updateNestedField((BsonValue)bsonDocument, 0, fieldKey, newVal, UpdateOp.SET);
        }
    }

    private static void updateNestedField(BsonValue value, int idx, String fieldKey, BsonValue newVal, UpdateOp updateOp) {
        int curIdx = idx;
        if (fieldKey.charAt(curIdx) == '.') {
            if (value == null || !value.isDocument()) {
                LOGGER.error("Value is null or not document. Value: {}, Idx: {}, fieldKey: {}, New val: {}, Update op: {}", new Object[]{value, idx, fieldKey, newVal, updateOp});
                throw new BsonUpdateInvalidArgumentException(INVALID_UPDATE_PATH_MESSAGE);
            }
            BsonDocument nestedDocument = (BsonDocument)value;
            ++curIdx;
            StringBuilder sb = new StringBuilder();
            while (curIdx < fieldKey.length()) {
                if (fieldKey.charAt(curIdx) == '.' || fieldKey.charAt(curIdx) == '[') {
                    BsonValue nestedValue = nestedDocument.get((Object)sb.toString());
                    if (nestedValue == null) {
                        LOGGER.error("Should have found nested map for {}", (Object)sb);
                        throw new BsonUpdateInvalidArgumentException(INVALID_UPDATE_PATH_MESSAGE);
                    }
                    UpdateExpressionUtils.updateNestedField(nestedValue, curIdx, fieldKey, newVal, updateOp);
                    return;
                }
                sb.append(fieldKey.charAt(curIdx));
                ++curIdx;
            }
            UpdateExpressionUtils.updateDocumentAtLeafNode(newVal, updateOp, nestedDocument, sb);
        } else if (fieldKey.charAt(curIdx) == '[') {
            ++curIdx;
            StringBuilder arrayIdxStr = new StringBuilder();
            while (fieldKey.charAt(curIdx) != ']') {
                arrayIdxStr.append(fieldKey.charAt(curIdx));
                ++curIdx;
            }
            ++curIdx;
            int arrayIdx = Integer.parseInt(arrayIdxStr.toString());
            if (value == null || !value.isArray()) {
                LOGGER.error("Value is null or not document. Value: {}, Idx: {}, fieldKey: {}, New val: {}", new Object[]{value, idx, fieldKey, newVal});
                throw new BsonUpdateInvalidArgumentException(INVALID_UPDATE_PATH_MESSAGE);
            }
            BsonArray nestedArray = (BsonArray)value;
            if (curIdx == fieldKey.length()) {
                UpdateExpressionUtils.updateArrayAtLeafNode(fieldKey, newVal, updateOp, arrayIdx, nestedArray);
                return;
            }
            BsonValue nestedValue = nestedArray.get(arrayIdx);
            if (nestedValue == null) {
                LOGGER.error("Should have found nested list for index {}", (Object)arrayIdx);
                return;
            }
            UpdateExpressionUtils.updateNestedField(nestedValue, curIdx, fieldKey, newVal, updateOp);
        } else {
            StringBuilder sb = new StringBuilder();
            for (int i = idx; i < fieldKey.length(); ++i) {
                if (fieldKey.charAt(i) == '.') {
                    BsonValue topFieldValue = ((BsonDocument)value).get((Object)sb.toString());
                    if (topFieldValue == null) {
                        throw new BsonUpdateInvalidArgumentException(INVALID_UPDATE_PATH_MESSAGE);
                    }
                    UpdateExpressionUtils.updateNestedField(topFieldValue, i, fieldKey, newVal, updateOp);
                    return;
                }
                if (fieldKey.charAt(i) == '[') {
                    BsonValue topFieldValue = ((BsonDocument)value).get((Object)sb.toString());
                    if (topFieldValue == null) {
                        throw new BsonUpdateInvalidArgumentException(INVALID_UPDATE_PATH_MESSAGE);
                    }
                    UpdateExpressionUtils.updateNestedField(topFieldValue, i, fieldKey, newVal, updateOp);
                    return;
                }
                sb.append(fieldKey.charAt(i));
            }
        }
    }

    private static void updateArrayAtLeafNode(String fieldKey, BsonValue newVal, UpdateOp updateOp, int arrayIdx, BsonArray nestedArray) {
        switch (updateOp) {
            case SET: {
                if (arrayIdx >= nestedArray.size()) {
                    nestedArray.add(newVal);
                    break;
                }
                nestedArray.set(arrayIdx, newVal);
                break;
            }
            case UNSET: {
                if (arrayIdx >= nestedArray.size()) break;
                nestedArray.remove(arrayIdx);
                break;
            }
            case ADD: {
                if (arrayIdx < nestedArray.size()) {
                    BsonValue currentValue = nestedArray.get(arrayIdx);
                    if (currentValue != null) {
                        if (!(currentValue.isNumber() || currentValue.isDecimal128() || CommonComparisonExpressionUtils.isBsonSet(currentValue))) {
                            throw new BsonUpdateInvalidArgumentException(INVALID_UPDATE_PATH_MESSAGE);
                        }
                        nestedArray.set(arrayIdx, UpdateExpressionUtils.modifyFieldValueByAdd(currentValue, newVal));
                        break;
                    }
                    nestedArray.set(arrayIdx, newVal);
                    break;
                }
                nestedArray.add(newVal);
                break;
            }
            case DELETE_FROM_SET: {
                if (arrayIdx >= nestedArray.size()) break;
                BsonValue currentValue = nestedArray.get(arrayIdx);
                if (currentValue != null) {
                    BsonValue modifiedVal = UpdateExpressionUtils.modifyFieldValueByDeleteFromSet(currentValue, newVal);
                    if (modifiedVal == null) {
                        nestedArray.remove(arrayIdx);
                        break;
                    }
                    nestedArray.set(arrayIdx, modifiedVal);
                    break;
                }
                LOGGER.info("Nothing to be removed as nested list does not have value for field {}. Update operator: {}", (Object)fieldKey, (Object)updateOp);
            }
        }
    }

    private static void updateDocumentAtLeafNode(BsonValue newVal, UpdateOp updateOp, BsonDocument nestedDocument, StringBuilder targetNodeFieldKey) {
        switch (updateOp) {
            case SET: {
                nestedDocument.put(targetNodeFieldKey.toString(), newVal);
                break;
            }
            case UNSET: {
                nestedDocument.remove((Object)targetNodeFieldKey.toString());
                break;
            }
            case ADD: {
                BsonValue currentValue = nestedDocument.get((Object)targetNodeFieldKey.toString());
                if (currentValue != null) {
                    if (!(currentValue.isNumber() || currentValue.isDecimal128() || CommonComparisonExpressionUtils.isBsonSet(currentValue))) {
                        throw new BsonUpdateInvalidArgumentException(INVALID_UPDATE_PATH_MESSAGE);
                    }
                    nestedDocument.put(targetNodeFieldKey.toString(), UpdateExpressionUtils.modifyFieldValueByAdd(currentValue, newVal));
                    break;
                }
                nestedDocument.put(targetNodeFieldKey.toString(), newVal);
                break;
            }
            case DELETE_FROM_SET: {
                BsonValue currentValue = nestedDocument.get((Object)targetNodeFieldKey.toString());
                if (currentValue != null) {
                    BsonValue modifiedVal = UpdateExpressionUtils.modifyFieldValueByDeleteFromSet(currentValue, newVal);
                    if (modifiedVal == null) {
                        nestedDocument.remove((Object)targetNodeFieldKey.toString());
                        break;
                    }
                    nestedDocument.put(targetNodeFieldKey.toString(), modifiedVal);
                    break;
                }
                LOGGER.info("Nothing to be removed as field with key {} does not exist. Update operator: {}", (Object)targetNodeFieldKey, (Object)updateOp);
                break;
            }
        }
    }

    private static BsonValue getNewFieldValue(BsonValue curValue, BsonDocument bsonDocument) {
        if (curValue != null && curValue.isString() && (((BsonString)curValue).getValue().contains(" + ") || ((BsonString)curValue).getValue().contains(" - "))) {
            String[] tokens = ((BsonString)curValue).getValue().split("\\s+");
            boolean addNum = true;
            Pattern pattern = Pattern.compile("[#:$]?[^\\s\\n]+");
            Number newNum = null;
            for (String token : tokens) {
                Number val;
                Number literalNum;
                BsonValue bsonValue;
                if (token.equals("+")) {
                    addNum = true;
                    continue;
                }
                if (token.equals("-")) {
                    addNum = false;
                    continue;
                }
                Matcher matcher = pattern.matcher(token);
                if (!matcher.find()) continue;
                String operand = matcher.group();
                BsonValue topLevelValue = bsonDocument.get((Object)operand);
                BsonValue bsonValue2 = bsonValue = topLevelValue != null ? topLevelValue : CommonComparisonExpressionUtils.getFieldFromDocument(operand, bsonDocument);
                if (bsonValue == null && (literalNum = UpdateExpressionUtils.stringToNumber(operand)) != null) {
                    val = literalNum;
                    newNum = newNum == null ? (Number)val : (Number)(addNum ? (Number)UpdateExpressionUtils.addNum(newNum, val) : (Number)UpdateExpressionUtils.subtractNum(newNum, val));
                    continue;
                }
                if (bsonValue == null) {
                    throw new IllegalArgumentException("Operand " + operand + " does not exist");
                }
                if (!bsonValue.isNumber() && !bsonValue.isDecimal128()) {
                    throw new IllegalArgumentException("Operand " + operand + " is not provided as number type");
                }
                val = UpdateExpressionUtils.getNumberFromBsonNumber((BsonNumber)bsonValue);
                newNum = newNum == null ? (Number)val : (Number)(addNum ? (Number)UpdateExpressionUtils.addNum(newNum, val) : (Number)UpdateExpressionUtils.subtractNum(newNum, val));
            }
            return UpdateExpressionUtils.getBsonNumberFromNumber(newNum);
        }
        if (curValue instanceof BsonDocument && ((BsonDocument)curValue).get((Object)"$IF_NOT_EXISTS") != null) {
            BsonValue ifNotExistsDoc = ((BsonDocument)curValue).get((Object)"$IF_NOT_EXISTS");
            Map.Entry ifNotExistsEntry = (Map.Entry)((BsonDocument)ifNotExistsDoc).entrySet().iterator().next();
            String ifNotExistsKey = (String)ifNotExistsEntry.getKey();
            BsonValue ifNotExistsVal = (BsonValue)ifNotExistsEntry.getValue();
            BsonValue val = CommonComparisonExpressionUtils.getFieldFromDocument(ifNotExistsKey, bsonDocument);
            return val != null ? val : ifNotExistsVal;
        }
        return curValue;
    }

    private static Number addNum(Number num1, Number num2) {
        if (num1 instanceof Double || num2 instanceof Double) {
            return num1.doubleValue() + num2.doubleValue();
        }
        if (num1 instanceof Float || num2 instanceof Float) {
            return Float.valueOf(num1.floatValue() + num2.floatValue());
        }
        if (num1 instanceof Long || num2 instanceof Long) {
            return num1.longValue() + num2.longValue();
        }
        return num1.intValue() + num2.intValue();
    }

    private static Number subtractNum(Number num1, Number num2) {
        if (num1 instanceof Double || num2 instanceof Double) {
            return num1.doubleValue() - num2.doubleValue();
        }
        if (num1 instanceof Float || num2 instanceof Float) {
            return Float.valueOf(num1.floatValue() - num2.floatValue());
        }
        if (num1 instanceof Long || num2 instanceof Long) {
            return num1.longValue() - num2.longValue();
        }
        return num1.intValue() - num2.intValue();
    }

    private static String numberToString(Number number) {
        if (number instanceof Integer || number instanceof Short || number instanceof Byte) {
            return Integer.toString(number.intValue());
        }
        if (number instanceof Long) {
            return Long.toString(number.longValue());
        }
        if (number instanceof Double) {
            return Double.toString(number.doubleValue());
        }
        if (number instanceof Float) {
            return Float.toString(number.floatValue());
        }
        throw new RuntimeException("Number type is not known for number: " + number);
    }

    private static Number stringToNumber(String number) {
        try {
            return Integer.parseInt(number);
        }
        catch (NumberFormatException numberFormatException) {
            try {
                return Long.parseLong(number);
            }
            catch (NumberFormatException numberFormatException2) {
                try {
                    return Double.parseDouble(number);
                }
                catch (NumberFormatException numberFormatException3) {
                    try {
                        return NumberFormat.getInstance().parse(number);
                    }
                    catch (ParseException e) {
                        return null;
                    }
                }
            }
        }
    }

    private static BsonNumber getBsonNumberFromNumber(Number number) {
        BsonInt32 bsonNumber;
        if (number instanceof Integer || number instanceof Short || number instanceof Byte) {
            bsonNumber = new BsonInt32(number.intValue());
        } else if (number instanceof Long) {
            bsonNumber = new BsonInt64(number.longValue());
        } else if (number instanceof Double || number instanceof Float) {
            bsonNumber = new BsonDouble(number.doubleValue());
        } else if (number instanceof BigDecimal) {
            bsonNumber = new BsonDecimal128(new Decimal128((BigDecimal)number));
        } else {
            throw new IllegalArgumentException("Unsupported Number type: " + number.getClass());
        }
        return bsonNumber;
    }

    public static Number getNumberFromBsonNumber(BsonNumber bsonNumber) {
        if (bsonNumber instanceof BsonInt32) {
            return ((BsonInt32)bsonNumber).getValue();
        }
        if (bsonNumber instanceof BsonInt64) {
            return ((BsonInt64)bsonNumber).getValue();
        }
        if (bsonNumber instanceof BsonDouble) {
            return ((BsonDouble)bsonNumber).getValue();
        }
        if (bsonNumber instanceof BsonDecimal128) {
            return ((BsonDecimal128)bsonNumber).getValue().bigDecimalValue();
        }
        throw new IllegalArgumentException("Unsupported BsonNumber type: " + bsonNumber.getClass());
    }

    private static boolean areBsonSetOfSameType(BsonValue bsonValue1, BsonValue bsonValue2) {
        if (!CommonComparisonExpressionUtils.isBsonSet(bsonValue1) || !CommonComparisonExpressionUtils.isBsonSet(bsonValue2)) {
            return false;
        }
        BsonArray bsonArray1 = (BsonArray)((BsonDocument)bsonValue1).get((Object)"$set");
        BsonArray bsonArray2 = (BsonArray)((BsonDocument)bsonValue2).get((Object)"$set");
        if (bsonArray1.isEmpty() || bsonArray2.isEmpty()) {
            return true;
        }
        return bsonArray1.get(0).getBsonType().equals((Object)bsonArray2.get(0).getBsonType());
    }

    private static enum UpdateOp {
        SET,
        UNSET,
        ADD,
        DELETE_FROM_SET;

    }
}

