/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.expression.util.bson;

import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.thirdparty.com.google.common.base.Preconditions;
import org.bson.BsonArray;
import org.bson.BsonBinary;
import org.bson.BsonDateTime;
import org.bson.BsonDocument;
import org.bson.BsonNumber;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommonComparisonExpressionUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(CommonComparisonExpressionUtils.class);

    static boolean isBsonSet(BsonValue bsonValue) {
        if (!bsonValue.isDocument()) {
            return false;
        }
        BsonDocument bsonDocument = (BsonDocument)bsonValue;
        if (bsonDocument.size() == 1 && bsonDocument.containsKey((Object)"$set")) {
            BsonValue value = bsonDocument.get((Object)"$set");
            return value != null && value.isArray();
        }
        return false;
    }

    public static boolean isBsonNumberSet(BsonValue bsonValue) {
        if (!CommonComparisonExpressionUtils.isBsonSet(bsonValue)) {
            return false;
        }
        BsonArray bsonArray = ((BsonDocument)bsonValue).get((Object)"$set").asArray();
        return !bsonArray.isEmpty() && bsonArray.get(0).isNumber();
    }

    public static boolean isBsonBinarySet(BsonValue bsonValue) {
        if (!CommonComparisonExpressionUtils.isBsonSet(bsonValue)) {
            return false;
        }
        BsonArray bsonArray = ((BsonDocument)bsonValue).get((Object)"$set").asArray();
        return !bsonArray.isEmpty() && bsonArray.get(0).isBinary();
    }

    public static boolean isBsonStringSet(BsonValue bsonValue) {
        if (!CommonComparisonExpressionUtils.isBsonSet(bsonValue)) {
            return false;
        }
        BsonArray bsonArray = ((BsonDocument)bsonValue).get((Object)"$set").asArray();
        return !bsonArray.isEmpty() && bsonArray.get(0).isString();
    }

    public static BsonValue getFieldFromDocument(String documentFieldKey, BsonDocument rawBsonDocument) {
        if (documentFieldKey.contains(".") || documentFieldKey.contains("[")) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < documentFieldKey.length(); ++i) {
                if (documentFieldKey.charAt(i) == '.') {
                    BsonValue value = rawBsonDocument.get((Object)sb.toString());
                    if (value == null) {
                        return null;
                    }
                    return CommonComparisonExpressionUtils.getNestedFieldVal(value, i, documentFieldKey);
                }
                if (documentFieldKey.charAt(i) == '[') {
                    BsonValue value = rawBsonDocument.get((Object)sb.toString());
                    if (value == null) {
                        return null;
                    }
                    return CommonComparisonExpressionUtils.getNestedFieldVal(value, i, documentFieldKey);
                }
                sb.append(documentFieldKey.charAt(i));
            }
        } else {
            return rawBsonDocument.get((Object)documentFieldKey);
        }
        return null;
    }

    public static BsonValue getNestedFieldVal(BsonValue value, int idx, String documentFieldKey) {
        if (idx == documentFieldKey.length()) {
            return value;
        }
        int curIdx = idx;
        if (documentFieldKey.charAt(curIdx) == '.') {
            BsonDocument nestedDocument;
            BsonDocument bsonDocument = nestedDocument = value != null && value.isDocument() ? (BsonDocument)value : null;
            if (nestedDocument == null) {
                LOGGER.warn("Incorrect access. Should have found nested map for value: {}", (Object)value);
                return null;
            }
            ++curIdx;
            StringBuilder sb = new StringBuilder();
            while (curIdx < documentFieldKey.length()) {
                if (documentFieldKey.charAt(curIdx) == '.' || documentFieldKey.charAt(curIdx) == '[') {
                    BsonValue nestedValue = nestedDocument.get((Object)sb.toString());
                    if (nestedValue == null) {
                        return null;
                    }
                    return CommonComparisonExpressionUtils.getNestedFieldVal(nestedValue, curIdx, documentFieldKey);
                }
                sb.append(documentFieldKey.charAt(curIdx));
                ++curIdx;
            }
            return nestedDocument.get((Object)sb.toString());
        }
        if (documentFieldKey.charAt(curIdx) == '[') {
            BsonArray nestedArray;
            ++curIdx;
            StringBuilder arrayIdxStr = new StringBuilder();
            while (documentFieldKey.charAt(curIdx) != ']') {
                arrayIdxStr.append(documentFieldKey.charAt(curIdx));
                ++curIdx;
            }
            ++curIdx;
            int arrayIdx = Integer.parseInt(arrayIdxStr.toString());
            BsonArray bsonArray = nestedArray = value != null && value.isArray() ? (BsonArray)value : null;
            if (nestedArray == null) {
                LOGGER.warn("Incorrect access. Should have found nested list for value: {}", (Object)value);
                return null;
            }
            if (arrayIdx >= nestedArray.size()) {
                LOGGER.warn("Incorrect access. Nested list size {} is less than attempted index access at {}", (Object)nestedArray.size(), (Object)arrayIdx);
                return null;
            }
            BsonValue valueAtIdx = nestedArray.get(arrayIdx);
            if (curIdx == documentFieldKey.length()) {
                return valueAtIdx;
            }
            return CommonComparisonExpressionUtils.getNestedFieldVal(valueAtIdx, curIdx, documentFieldKey);
        }
        LOGGER.warn("This is erroneous case. getNestedFieldVal should not be used for top level document fields");
        return null;
    }

    public static boolean compareValues(BsonValue lhsOperand, BsonValue rhsOperand, CompareOp operator) {
        Preconditions.checkNotNull((Object)((Object)operator), (Object)"Comparison operator should not be null");
        Preconditions.checkNotNull((Object)lhsOperand, (Object)"LHS operand for the Comparison operation should not be null");
        if (operator == CompareOp.EQUALS) {
            return lhsOperand.equals(rhsOperand);
        }
        if (operator == CompareOp.NOT_EQUALS) {
            return !lhsOperand.equals(rhsOperand);
        }
        Preconditions.checkNotNull((Object)rhsOperand, (Object)"RHS operand for the Comparison operation should not be null");
        if (lhsOperand.isString() && rhsOperand.isString()) {
            int compare = ((BsonString)lhsOperand).getValue().compareTo(((BsonString)rhsOperand).getValue());
            switch (operator) {
                case LESS: {
                    return compare < 0;
                }
                case LESS_OR_EQUAL: {
                    return compare <= 0;
                }
                case GREATER: {
                    return compare > 0;
                }
                case GREATER_OR_EQUAL: {
                    return compare >= 0;
                }
            }
        }
        if ((lhsOperand.isNumber() || lhsOperand.isDecimal128()) && (rhsOperand.isNumber() || rhsOperand.isDecimal128())) {
            switch (operator) {
                case LESS: {
                    return ((BsonNumber)lhsOperand).doubleValue() < ((BsonNumber)rhsOperand).doubleValue();
                }
                case LESS_OR_EQUAL: {
                    return ((BsonNumber)lhsOperand).doubleValue() <= ((BsonNumber)rhsOperand).doubleValue();
                }
                case GREATER: {
                    return ((BsonNumber)lhsOperand).doubleValue() > ((BsonNumber)rhsOperand).doubleValue();
                }
                case GREATER_OR_EQUAL: {
                    return ((BsonNumber)lhsOperand).doubleValue() >= ((BsonNumber)rhsOperand).doubleValue();
                }
            }
        }
        if (lhsOperand.isBinary() && rhsOperand.isBinary() && ((BsonBinary)lhsOperand).getType() == ((BsonBinary)rhsOperand).getType()) {
            byte[] b1 = ((BsonBinary)lhsOperand).getData();
            byte[] b2 = ((BsonBinary)rhsOperand).getData();
            switch (operator) {
                case LESS: {
                    return Bytes.compareTo((byte[])b1, (byte[])b2) < 0;
                }
                case LESS_OR_EQUAL: {
                    return Bytes.compareTo((byte[])b1, (byte[])b2) <= 0;
                }
                case GREATER: {
                    return Bytes.compareTo((byte[])b1, (byte[])b2) > 0;
                }
                case GREATER_OR_EQUAL: {
                    return Bytes.compareTo((byte[])b1, (byte[])b2) >= 0;
                }
            }
        }
        if (lhsOperand.isDateTime() && rhsOperand.isDateTime()) {
            switch (operator) {
                case LESS: {
                    return ((BsonDateTime)lhsOperand).getValue() < ((BsonDateTime)rhsOperand).getValue();
                }
                case LESS_OR_EQUAL: {
                    return ((BsonDateTime)lhsOperand).getValue() <= ((BsonDateTime)rhsOperand).getValue();
                }
                case GREATER: {
                    return ((BsonDateTime)lhsOperand).getValue() > ((BsonDateTime)rhsOperand).getValue();
                }
                case GREATER_OR_EQUAL: {
                    return ((BsonDateTime)lhsOperand).getValue() >= ((BsonDateTime)rhsOperand).getValue();
                }
            }
        }
        LOGGER.error("Expected comparison for {} is not of type String, Number, Binary or DateTime. LhsOperand: {} , RhsOperand: {}", new Object[]{operator, lhsOperand, rhsOperand});
        return false;
    }

    public static enum CompareOp {
        LESS,
        LESS_OR_EQUAL,
        GREATER_OR_EQUAL,
        GREATER,
        EQUALS,
        NOT_EQUALS;

    }
}

