/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.expression.function;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.util.DynamicClassLoader;
import org.apache.hadoop.io.WritableUtils;
import org.apache.phoenix.compile.KeyPart;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.function.FunctionExpression;
import org.apache.phoenix.expression.function.ScalarFunction;
import org.apache.phoenix.expression.visitor.ExpressionVisitor;
import org.apache.phoenix.parse.PFunction;
import org.apache.phoenix.schema.PName;
import org.apache.phoenix.schema.PNameFactory;
import org.apache.phoenix.schema.tuple.Tuple;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.phoenix.thirdparty.com.google.common.collect.MapMaker;

public class UDFExpression
extends ScalarFunction {
    private static Configuration config = HBaseConfiguration.create();
    private static final ConcurrentMap<PName, DynamicClassLoader> tenantIdSpecificCls = new MapMaker().concurrencyLevel(3).weakValues().makeMap();
    private static final ConcurrentMap<String, DynamicClassLoader> pathSpecificCls = new MapMaker().concurrencyLevel(3).weakValues().makeMap();
    private PName tenantId;
    private String functionClassName;
    private String jarPath;
    private ScalarFunction udfFunction;

    public UDFExpression() {
    }

    public UDFExpression(List<Expression> children, PFunction functionInfo) {
        super(children);
        this.tenantId = functionInfo.getTenantId() == null ? PName.EMPTY_NAME : functionInfo.getTenantId();
        this.functionClassName = functionInfo.getClassName();
        this.jarPath = functionInfo.getJarPath();
        this.constructUDFFunction();
    }

    public UDFExpression(List<Expression> children, PName tenantId, String functionClassName, String jarPath, ScalarFunction udfFunction) {
        super(children);
        this.tenantId = tenantId;
        this.functionClassName = functionClassName;
        this.jarPath = jarPath;
        if (udfFunction != null) {
            this.udfFunction = udfFunction;
        } else {
            this.constructUDFFunction();
        }
    }

    @Override
    public boolean evaluate(Tuple tuple, ImmutableBytesWritable ptr) {
        return this.udfFunction.evaluate(tuple, ptr);
    }

    @Override
    public <T> T accept(ExpressionVisitor<T> visitor) {
        return this.udfFunction.accept(visitor);
    }

    @Override
    public PDataType getDataType() {
        return this.udfFunction.getDataType();
    }

    @Override
    public String getName() {
        return this.udfFunction.getName();
    }

    @Override
    public FunctionExpression.OrderPreserving preservesOrder() {
        return this.udfFunction.preservesOrder();
    }

    @Override
    public KeyPart newKeyPart(KeyPart childPart) {
        return this.udfFunction.newKeyPart(childPart);
    }

    @Override
    public int getKeyFormationTraversalIndex() {
        return this.udfFunction.getKeyFormationTraversalIndex();
    }

    public PName getTenantId() {
        return this.tenantId;
    }

    public String getFunctionClassName() {
        return this.functionClassName;
    }

    public String getJarPath() {
        return this.jarPath;
    }

    public ScalarFunction getUdfFunction() {
        return this.udfFunction;
    }

    @Override
    public void write(DataOutput output) throws IOException {
        super.write(output);
        WritableUtils.writeString((DataOutput)output, (String)this.tenantId.getString());
        WritableUtils.writeString((DataOutput)output, (String)this.functionClassName);
        if (this.jarPath == null) {
            WritableUtils.writeString((DataOutput)output, (String)"");
        } else {
            WritableUtils.writeString((DataOutput)output, (String)this.jarPath);
        }
    }

    @Override
    public void readFields(DataInput input) throws IOException {
        super.readFields(input);
        this.tenantId = PNameFactory.newName(WritableUtils.readString((DataInput)input));
        this.functionClassName = WritableUtils.readString((DataInput)input);
        String str = WritableUtils.readString((DataInput)input);
        this.jarPath = str.length() == 0 ? null : str;
        this.constructUDFFunction();
    }

    private void constructUDFFunction() {
        try {
            DynamicClassLoader classLoader = UDFExpression.getClassLoader(this.tenantId, this.jarPath);
            Class clazz = classLoader.loadClass(this.functionClassName);
            Constructor constructor = clazz.getConstructor(List.class);
            this.udfFunction = (ScalarFunction)constructor.newInstance(this.children);
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public static DynamicClassLoader getClassLoader(PName tenantId, String jarPath) {
        Path allowedDynamicJarsPath;
        DynamicClassLoader cl = (DynamicClassLoader)tenantIdSpecificCls.get(tenantId);
        Path parent = null;
        if (cl != null) {
            return cl;
        }
        if (jarPath != null && !jarPath.isEmpty()) {
            cl = (DynamicClassLoader)pathSpecificCls.get(jarPath);
            if (cl != null) {
                return cl;
            }
            parent = UDFExpression.getPathForParent(jarPath);
        }
        Path path = allowedDynamicJarsPath = config.get("hbase.dynamic.jars.dir") != null ? new Path(config.get("hbase.dynamic.jars.dir")) : null;
        if (jarPath == null || jarPath.isEmpty() || allowedDynamicJarsPath != null && parent != null && parent.equals((Object)allowedDynamicJarsPath)) {
            DynamicClassLoader prev;
            cl = (DynamicClassLoader)tenantIdSpecificCls.get(tenantId);
            if (cl == null) {
                cl = new DynamicClassLoader(config, UDFExpression.class.getClassLoader());
            }
            if ((prev = tenantIdSpecificCls.putIfAbsent(tenantId, cl)) != null) {
                cl = prev;
            }
            return cl;
        }
        throw new SecurityException("Loading jars from " + jarPath + " is not allowed. The only location that is allowed is " + config.get("hbase.dynamic.jars.dir"));
    }

    public static Path getPathForParent(String jarPath) {
        Path path = new Path(jarPath);
        if (jarPath.endsWith(".jar")) {
            return path.getParent();
        }
        return path;
    }

    @VisibleForTesting
    public static void setConfig(Configuration conf) {
        config = conf;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof UDFExpression)) {
            return false;
        }
        UDFExpression that = (UDFExpression)obj;
        if (!this.udfFunction.getName().equals(that.udfFunction.getName())) {
            return false;
        }
        if (!this.udfFunction.getChildren().equals(that.udfFunction.getChildren())) {
            return false;
        }
        if (!this.functionClassName.equals(that.functionClassName)) {
            return false;
        }
        return this.jarPath.equals(that.jarPath);
    }
}

