/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.expression.function;

import java.io.DataInput;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.LiteralExpression;
import org.apache.phoenix.expression.function.FunctionExpression;
import org.apache.phoenix.expression.function.PrefixFunction;
import org.apache.phoenix.parse.FunctionParseNode;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.tuple.Tuple;
import org.apache.phoenix.schema.types.PBinary;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PLong;
import org.apache.phoenix.schema.types.PVarbinary;
import org.apache.phoenix.schema.types.PVarbinaryEncoded;

@FunctionParseNode.BuiltInFunction(name="SUBBINARY", args={@FunctionParseNode.Argument(allowedTypes={PBinary.class, PVarbinary.class, PVarbinaryEncoded.class}), @FunctionParseNode.Argument(allowedTypes={PLong.class}), @FunctionParseNode.Argument(allowedTypes={PLong.class}, defaultValue="null")})
public class SubBinaryFunction
extends PrefixFunction {
    public static final String NAME = "SUBBINARY";
    private boolean hasLengthExpression;
    private boolean isOffsetConstant;
    private boolean isLengthConstant;
    private boolean isFixedWidth;
    private Integer maxLength;

    public SubBinaryFunction() {
    }

    public SubBinaryFunction(List<Expression> children) {
        super(children);
        this.init();
    }

    private void init() {
        Number offsetNumber;
        this.isOffsetConstant = this.getOffsetExpression() instanceof LiteralExpression;
        this.isLengthConstant = this.getLengthExpression() instanceof LiteralExpression;
        this.hasLengthExpression = !this.isLengthConstant || ((LiteralExpression)this.getLengthExpression()).getValue() != null;
        boolean bl = this.isFixedWidth = this.getBinaryExpression().getDataType().isFixedWidth() && (this.hasLengthExpression && this.isLengthConstant || !this.hasLengthExpression && this.isOffsetConstant);
        if (this.hasLengthExpression && this.isLengthConstant) {
            Integer maxLength = ((Number)((LiteralExpression)this.getLengthExpression()).getValue()).intValue();
            this.maxLength = maxLength >= 0 ? maxLength : 0;
        } else if (this.isOffsetConstant && (offsetNumber = (Number)((LiteralExpression)this.getOffsetExpression()).getValue()) != null) {
            int offset = offsetNumber.intValue();
            PDataType type = this.getBinaryExpression().getDataType();
            if (type.isFixedWidth() && offset >= 0) {
                Integer maxLength = this.getBinaryExpression().getMaxLength();
                this.maxLength = maxLength - offset + (offset == 0 ? 0 : 1);
            }
        }
    }

    @Override
    public boolean evaluate(Tuple tuple, ImmutableBytesWritable ptr) {
        int binLength;
        Expression offsetExpression = this.getOffsetExpression();
        if (!offsetExpression.evaluate(tuple, ptr)) {
            return false;
        }
        if (ptr.getLength() == 0) {
            return true;
        }
        int offset = offsetExpression.getDataType().getCodec().decodeInt(ptr, offsetExpression.getSortOrder());
        int length = -1;
        if (this.hasLengthExpression) {
            Expression lengthExpression = this.getLengthExpression();
            if (!lengthExpression.evaluate(tuple, ptr)) {
                return false;
            }
            if (ptr.getLength() == 0) {
                return true;
            }
            length = lengthExpression.getDataType().getCodec().decodeInt(ptr, lengthExpression.getSortOrder());
            if (length <= 0) {
                return false;
            }
        }
        if (!this.getBinaryExpression().evaluate(tuple, ptr)) {
            return false;
        }
        if (ptr.getLength() == 0) {
            return true;
        }
        byte[] bytes = new byte[]{};
        if (this.getDataType() == PVarbinaryEncoded.INSTANCE) {
            bytes = (byte[])PVarbinaryEncoded.INSTANCE.toObject(ptr.get(), ptr.getOffset(), ptr.getLength());
            binLength = bytes.length;
        } else {
            binLength = ptr.getLength();
        }
        if ((offset -= offset <= 0 ? 0 : 1) < 0) {
            offset = binLength + offset;
        }
        if (offset < 0 || offset >= binLength) {
            return false;
        }
        int maxLength = binLength - offset;
        int n = length = length == -1 ? maxLength : Math.min(length, maxLength);
        if (this.getDataType() == PVarbinaryEncoded.INSTANCE) {
            byte[] result = Arrays.copyOfRange(bytes, offset, offset + length);
            ptr.set(PVarbinaryEncoded.INSTANCE.toBytes(result));
        } else {
            ptr.set(ptr.get(), ptr.getOffset() + offset, length);
        }
        return true;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public PDataType getDataType() {
        return this.getBinaryExpression().getDataType();
    }

    @Override
    public boolean isNullable() {
        return this.getBinaryExpression().isNullable() || !this.isFixedWidth || this.getOffsetExpression().isNullable();
    }

    @Override
    public Integer getMaxLength() {
        return this.maxLength;
    }

    @Override
    public SortOrder getSortOrder() {
        return this.getBinaryExpression().getSortOrder();
    }

    @Override
    public void readFields(DataInput input) throws IOException {
        super.readFields(input);
        this.init();
    }

    @Override
    public FunctionExpression.OrderPreserving preservesOrder() {
        int offset;
        LiteralExpression literal;
        Number offsetNumber;
        if (!(!this.isOffsetConstant || (offsetNumber = (Number)(literal = (LiteralExpression)this.getOffsetExpression()).getValue()) == null || (offset = offsetNumber.intValue()) != 0 && offset != 1 || this.hasLengthExpression && !this.isLengthConstant)) {
            return FunctionExpression.OrderPreserving.YES_IF_LAST;
        }
        return FunctionExpression.OrderPreserving.NO;
    }

    private Expression getBinaryExpression() {
        return (Expression)this.children.get(0);
    }

    private Expression getOffsetExpression() {
        return (Expression)this.children.get(1);
    }

    private Expression getLengthExpression() {
        return (Expression)this.children.get(2);
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder(this.getName() + "(");
        if (this.children.isEmpty()) {
            return buf.append(")").toString();
        }
        if (this.hasLengthExpression) {
            buf.append(this.getBinaryExpression());
            buf.append(", ");
            buf.append(this.getOffsetExpression());
            buf.append(", ");
            buf.append(this.getLengthExpression());
        } else {
            buf.append(this.getBinaryExpression());
            buf.append(", ");
            buf.append(this.getOffsetExpression());
        }
        buf.append(")");
        return buf.toString();
    }
}

