/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.expression.function;

import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.hadoop.hbase.CompareOperator;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.phoenix.compile.KeyPart;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.function.FunctionExpression;
import org.apache.phoenix.expression.function.ScalarFunction;
import org.apache.phoenix.parse.FunctionParseNode;
import org.apache.phoenix.query.KeyRange;
import org.apache.phoenix.query.QueryConstants;
import org.apache.phoenix.schema.PColumn;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.tuple.Tuple;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PVarchar;
import org.apache.phoenix.util.ByteUtil;
import org.apache.phoenix.util.StringUtil;

@FunctionParseNode.BuiltInFunction(name="RTRIM", args={@FunctionParseNode.Argument(allowedTypes={PVarchar.class})})
public class RTrimFunction
extends ScalarFunction {
    public static final String NAME = "RTRIM";

    public RTrimFunction() {
    }

    public RTrimFunction(List<Expression> children) throws SQLException {
        super(children);
    }

    private Expression getStringExpression() {
        return (Expression)this.children.get(0);
    }

    @Override
    public SortOrder getSortOrder() {
        return ((Expression)this.children.get(0)).getSortOrder();
    }

    @Override
    public boolean evaluate(Tuple tuple, ImmutableBytesWritable ptr) {
        SortOrder sortOrder;
        int length;
        int offset;
        if (!this.getStringExpression().evaluate(tuple, ptr)) {
            return false;
        }
        if (ptr.getLength() == 0) {
            ptr.set(ByteUtil.EMPTY_BYTE_ARRAY);
            return true;
        }
        byte[] string = ptr.get();
        int i = StringUtil.getFirstNonBlankCharIdxFromEnd(string, offset = ptr.getOffset(), length = ptr.getLength(), sortOrder = this.getStringExpression().getSortOrder());
        if (i == offset - 1) {
            ptr.set(ByteUtil.EMPTY_BYTE_ARRAY);
            return true;
        }
        ptr.set(string, offset, i - offset + 1);
        return true;
    }

    @Override
    public FunctionExpression.OrderPreserving preservesOrder() {
        return FunctionExpression.OrderPreserving.YES_IF_LAST;
    }

    @Override
    public int getKeyFormationTraversalIndex() {
        return 0;
    }

    @Override
    public KeyPart newKeyPart(final KeyPart childPart) {
        return new KeyPart(){

            @Override
            public KeyRange getKeyRange(CompareOperator op, Expression rhs) {
                byte[] lowerRange = KeyRange.UNBOUND;
                byte[] upperRange = KeyRange.UNBOUND;
                boolean lowerInclusive = true;
                boolean upperInclusive = false;
                PDataType type = this.getColumn().getDataType();
                SortOrder sortOrder = this.getColumn().getSortOrder();
                switch (op) {
                    case LESS_OR_EQUAL: {
                        lowerInclusive = false;
                    }
                    case EQUAL: {
                        upperRange = ScalarFunction.evaluateExpression(rhs);
                        if (op == CompareOperator.EQUAL) {
                            lowerRange = upperRange;
                        }
                        if (sortOrder == SortOrder.ASC || !this.getTable().rowKeyOrderOptimizable()) {
                            upperRange = Arrays.copyOf(upperRange, upperRange.length + 1);
                            upperRange[upperRange.length - 1] = 32;
                            ByteUtil.nextKey(upperRange, upperRange.length);
                            break;
                        }
                        upperInclusive = true;
                        if (op == CompareOperator.LESS_OR_EQUAL) break;
                        lowerRange = Arrays.copyOf(lowerRange, lowerRange.length + 2);
                        lowerRange[lowerRange.length - 2] = StringUtil.INVERTED_SPACE_UTF8;
                        lowerRange[lowerRange.length - 1] = 0;
                        upperRange = Arrays.copyOf(upperRange, upperRange.length + 1);
                        upperRange[upperRange.length - 1] = QueryConstants.DESC_SEPARATOR_BYTE;
                        break;
                    }
                    default: {
                        return childPart.getKeyRange(op, rhs);
                    }
                }
                Integer length = this.getColumn().getMaxLength();
                if (type.isFixedWidth() && length != null) {
                    if (lowerRange != KeyRange.UNBOUND) {
                        lowerRange = type.pad(lowerRange, length, SortOrder.ASC);
                    }
                    if (upperRange != KeyRange.UNBOUND) {
                        upperRange = type.pad(upperRange, length, SortOrder.ASC);
                    }
                }
                KeyRange range = KeyRange.getKeyRange(lowerRange, lowerInclusive, upperRange, upperInclusive);
                if (this.getColumn().getSortOrder() == SortOrder.DESC) {
                    range = range.invert();
                }
                return range;
            }

            @Override
            public Set<Expression> getExtractNodes() {
                return Collections.emptySet();
            }

            @Override
            public PColumn getColumn() {
                return childPart.getColumn();
            }

            @Override
            public PTable getTable() {
                return childPart.getTable();
            }
        };
    }

    @Override
    public Integer getMaxLength() {
        return this.getStringExpression().getMaxLength();
    }

    @Override
    public PDataType getDataType() {
        return PVarchar.INSTANCE;
    }

    @Override
    public String getName() {
        return NAME;
    }
}

