/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.expression.function;

import java.util.List;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.function.ScalarFunction;
import org.apache.phoenix.parse.FunctionParseNode;
import org.apache.phoenix.parse.JsonExistsParseNode;
import org.apache.phoenix.schema.tuple.Tuple;
import org.apache.phoenix.schema.types.PBoolean;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PJson;
import org.apache.phoenix.schema.types.PVarbinary;
import org.apache.phoenix.schema.types.PVarchar;
import org.apache.phoenix.thirdparty.com.google.common.base.Preconditions;
import org.apache.phoenix.util.json.JsonDataFormat;
import org.apache.phoenix.util.json.JsonDataFormatFactory;

@FunctionParseNode.BuiltInFunction(name="JSON_EXISTS", nodeClass=JsonExistsParseNode.class, args={@FunctionParseNode.Argument(allowedTypes={PJson.class, PVarbinary.class}), @FunctionParseNode.Argument(allowedTypes={PVarchar.class})})
public class JsonExistsFunction
extends ScalarFunction {
    public static final String NAME = "JSON_EXISTS";
    private final JsonDataFormat jsonDataFormat = JsonDataFormatFactory.getJsonDataFormat(JsonDataFormatFactory.DataFormat.BSON);

    public JsonExistsFunction() {
    }

    public JsonExistsFunction(List<Expression> children) {
        super(children);
        Preconditions.checkNotNull((Object)this.getJSONPathExpr());
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public boolean evaluate(Tuple tuple, ImmutableBytesWritable ptr) {
        if (!this.getColValExpr().evaluate(tuple, ptr)) {
            return false;
        }
        if (ptr == null || ptr.getLength() == 0) {
            return false;
        }
        Object top = PJson.INSTANCE.toObject(ptr, this.getColValExpr().getSortOrder());
        if (!this.getJSONPathExpr().evaluate(tuple, ptr)) {
            return false;
        }
        if (ptr.getLength() == 0) {
            return false;
        }
        String jsonPathExprStr = (String)PVarchar.INSTANCE.toObject(ptr, this.getJSONPathExpr().getSortOrder());
        if (jsonPathExprStr == null) {
            return false;
        }
        boolean isPathValid = this.jsonDataFormat.isPathValid(top, jsonPathExprStr);
        ptr.set(PBoolean.INSTANCE.toBytes(isPathValid));
        return true;
    }

    private Expression getColValExpr() {
        return this.getChildren().get(0);
    }

    private Expression getJSONPathExpr() {
        return this.getChildren().get(1);
    }

    @Override
    public PDataType getDataType() {
        return PBoolean.INSTANCE;
    }
}

