/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.expression.function;

import java.sql.SQLException;
import java.util.List;
import java.util.Set;
import org.apache.hadoop.hbase.CompareOperator;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.phoenix.compile.KeyPart;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.function.FunctionExpression;
import org.apache.phoenix.expression.function.ScalarFunction;
import org.apache.phoenix.parse.FunctionParseNode;
import org.apache.phoenix.query.KeyRange;
import org.apache.phoenix.schema.PColumn;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.tuple.Tuple;
import org.apache.phoenix.schema.types.PDataType;

@FunctionParseNode.BuiltInFunction(name="INVERT", args={@FunctionParseNode.Argument})
public class InvertFunction
extends ScalarFunction {
    public static final String NAME = "INVERT";

    public InvertFunction() throws SQLException {
    }

    public InvertFunction(List<Expression> children) throws SQLException {
        super(children);
    }

    @Override
    public boolean evaluate(Tuple tuple, ImmutableBytesWritable ptr) {
        if (!this.getChildExpression().evaluate(tuple, ptr)) {
            return false;
        }
        if (ptr.getLength() == 0) {
            return true;
        }
        PDataType type = this.getDataType();
        type.coerceBytes(ptr, type, this.getChildExpression().getSortOrder(), this.getSortOrder());
        return true;
    }

    @Override
    public SortOrder getSortOrder() {
        return this.getChildExpression().getSortOrder() == SortOrder.ASC ? SortOrder.DESC : SortOrder.ASC;
    }

    @Override
    public PDataType getDataType() {
        return this.getChildExpression().getDataType();
    }

    @Override
    public Integer getMaxLength() {
        return this.getChildExpression().getMaxLength();
    }

    @Override
    public boolean isNullable() {
        return this.getChildExpression().isNullable();
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public int getKeyFormationTraversalIndex() {
        return 0;
    }

    @Override
    public KeyPart newKeyPart(KeyPart childPart) {
        return new InvertKeyPart(childPart);
    }

    @Override
    public FunctionExpression.OrderPreserving preservesOrder() {
        return FunctionExpression.OrderPreserving.YES;
    }

    private Expression getChildExpression() {
        return (Expression)this.children.get(0);
    }

    private static class InvertKeyPart
    implements KeyPart {
        private final KeyPart childPart;

        public InvertKeyPart(KeyPart childPart) {
            this.childPart = childPart;
        }

        @Override
        public KeyRange getKeyRange(CompareOperator op, Expression rhs) {
            byte[] upper;
            KeyRange range = this.childPart.getKeyRange(op, rhs);
            byte[] lower = range.getLowerRange();
            if (!range.lowerUnbound()) {
                lower = SortOrder.invert(lower, 0, lower.length);
            }
            if (range.isSingleKey()) {
                upper = lower;
            } else {
                upper = range.getUpperRange();
                if (!range.upperUnbound()) {
                    upper = SortOrder.invert(upper, 0, upper.length);
                }
            }
            range = KeyRange.getKeyRange(lower, range.isLowerInclusive(), upper, range.isUpperInclusive());
            if (this.getColumn().getSortOrder() == SortOrder.DESC) {
                range = range.invert();
            }
            return range;
        }

        @Override
        public Set<Expression> getExtractNodes() {
            return this.childPart.getExtractNodes();
        }

        @Override
        public PColumn getColumn() {
            return this.childPart.getColumn();
        }

        @Override
        public PTable getTable() {
            return this.childPart.getTable();
        }
    }
}

