/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.expression.function;

import java.sql.SQLException;
import java.util.List;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.phoenix.compile.StatementContext;
import org.apache.phoenix.expression.CurrentDateTimeFunction;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.parse.CurrentDateParseNode;
import org.apache.phoenix.parse.FunctionParseNode;
import org.apache.phoenix.schema.tuple.Tuple;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PDate;
import org.apache.phoenix.util.EnvironmentEdgeManager;

@FunctionParseNode.BuiltInFunction(name="CURRENT_DATE", nodeClass=CurrentDateParseNode.class, args={})
public class CurrentDateFunction
extends CurrentDateTimeFunction {
    public static final String NAME = "CURRENT_DATE";
    private final ImmutableBytesWritable currentDate = new ImmutableBytesWritable(new byte[PDate.INSTANCE.getByteSize().intValue()]);

    public CurrentDateFunction() {
        this(EnvironmentEdgeManager.currentTimeMillis());
    }

    public CurrentDateFunction(List<Expression> children, StatementContext context) throws SQLException {
        this(context.getCurrentTimeWithDisplacement());
    }

    public CurrentDateFunction(long timeStamp) {
        this.getDataType().getCodec().encodeLong(timeStamp, this.currentDate);
    }

    @Override
    public boolean evaluate(Tuple tuple, ImmutableBytesWritable ptr) {
        ptr.set(this.currentDate.get(), 0, PDate.INSTANCE.getByteSize().intValue());
        return true;
    }

    @Override
    public final PDataType getDataType() {
        return PDate.INSTANCE;
    }

    @Override
    public String getName() {
        return NAME;
    }
}

