/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.expression.function;

import java.util.List;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.function.ScalarFunction;
import org.apache.phoenix.expression.util.bson.CommonComparisonExpressionUtils;
import org.apache.phoenix.parse.BsonValueTypeParseNode;
import org.apache.phoenix.parse.FunctionParseNode;
import org.apache.phoenix.schema.tuple.Tuple;
import org.apache.phoenix.schema.types.PBoolean;
import org.apache.phoenix.schema.types.PBson;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PDate;
import org.apache.phoenix.schema.types.PDouble;
import org.apache.phoenix.schema.types.PInteger;
import org.apache.phoenix.schema.types.PJson;
import org.apache.phoenix.schema.types.PLong;
import org.apache.phoenix.schema.types.PVarbinary;
import org.apache.phoenix.schema.types.PVarchar;
import org.apache.phoenix.thirdparty.com.google.common.base.Preconditions;
import org.bson.BsonArray;
import org.bson.BsonBinary;
import org.bson.BsonBoolean;
import org.bson.BsonDateTime;
import org.bson.BsonDecimal128;
import org.bson.BsonDocument;
import org.bson.BsonDouble;
import org.bson.BsonInt32;
import org.bson.BsonInt64;
import org.bson.BsonNull;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.bson.RawBsonDocument;

@FunctionParseNode.BuiltInFunction(name="BSON_VALUE_TYPE", nodeClass=BsonValueTypeParseNode.class, args={@FunctionParseNode.Argument(allowedTypes={PJson.class, PBson.class, PVarbinary.class}), @FunctionParseNode.Argument(allowedTypes={PVarchar.class}, isConstant=true)})
public class BsonValueTypeFunction
extends ScalarFunction {
    public static final String NAME = "BSON_VALUE_TYPE";

    public BsonValueTypeFunction() {
    }

    public BsonValueTypeFunction(List<Expression> children) {
        super(children);
        Preconditions.checkNotNull((Object)this.getChildren().get(1));
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public boolean evaluate(Tuple tuple, ImmutableBytesWritable ptr) {
        if (!this.getChildren().get(0).evaluate(tuple, ptr)) {
            return false;
        }
        if (ptr == null || ptr.getLength() == 0) {
            return false;
        }
        Object object = PBson.INSTANCE.toObject(ptr, this.getChildren().get(0).getSortOrder());
        RawBsonDocument rawBsonDocument = (RawBsonDocument)object;
        if (!this.getChildren().get(1).evaluate(tuple, ptr)) {
            return false;
        }
        if (ptr.getLength() == 0) {
            return false;
        }
        String documentFieldKey = (String)PVarchar.INSTANCE.toObject(ptr, this.getChildren().get(1).getSortOrder());
        if (documentFieldKey == null) {
            return false;
        }
        BsonValue bsonValue = CommonComparisonExpressionUtils.getFieldFromDocument(documentFieldKey, (BsonDocument)rawBsonDocument);
        if (bsonValue == null) {
            ptr.set(PVarchar.INSTANCE.toBytes("NULL"));
            return true;
        }
        String sqlTypeName = this.getValueType(bsonValue);
        ptr.set(PVarchar.INSTANCE.toBytes(sqlTypeName));
        return true;
    }

    private String getValueType(BsonValue bsonValue) {
        if (bsonValue instanceof BsonString) {
            return PVarchar.INSTANCE.getSqlTypeName();
        }
        if (bsonValue instanceof BsonInt32) {
            return PInteger.INSTANCE.getSqlTypeName();
        }
        if (bsonValue instanceof BsonInt64) {
            return PLong.INSTANCE.getSqlTypeName();
        }
        if (bsonValue instanceof BsonDouble || bsonValue instanceof BsonDecimal128) {
            return PDouble.INSTANCE.getSqlTypeName();
        }
        if (bsonValue instanceof BsonBoolean) {
            return PBoolean.INSTANCE.getSqlTypeName();
        }
        if (bsonValue instanceof BsonBinary) {
            return PVarbinary.INSTANCE.getSqlTypeName();
        }
        if (bsonValue instanceof BsonDateTime) {
            return PDate.INSTANCE.getSqlTypeName();
        }
        if (bsonValue instanceof BsonDocument || bsonValue instanceof BsonArray) {
            return PBson.INSTANCE.getSqlTypeName();
        }
        if (bsonValue instanceof BsonNull) {
            return "NULL";
        }
        return PVarchar.INSTANCE.getSqlTypeName();
    }

    @Override
    public PDataType<?> getDataType() {
        return PVarchar.INSTANCE;
    }
}

