/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.expression.function;

import java.util.List;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.function.ScalarFunction;
import org.apache.phoenix.expression.util.bson.DocumentComparisonExpressionUtils;
import org.apache.phoenix.expression.util.bson.SQLComparisonExpressionUtils;
import org.apache.phoenix.parse.BsonConditionExpressionParseNode;
import org.apache.phoenix.parse.FunctionParseNode;
import org.apache.phoenix.schema.tuple.Tuple;
import org.apache.phoenix.schema.types.PBoolean;
import org.apache.phoenix.schema.types.PBson;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PVarbinary;
import org.apache.phoenix.schema.types.PVarchar;
import org.apache.phoenix.thirdparty.com.google.common.base.Preconditions;
import org.bson.BsonDocument;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.bson.RawBsonDocument;

@FunctionParseNode.BuiltInFunction(name="BSON_CONDITION_EXPRESSION", nodeClass=BsonConditionExpressionParseNode.class, args={@FunctionParseNode.Argument(allowedTypes={PBson.class, PVarbinary.class}), @FunctionParseNode.Argument(allowedTypes={PBson.class, PVarbinary.class}, isConstant=true)})
public class BsonConditionExpressionFunction
extends ScalarFunction {
    public static final String NAME = "BSON_CONDITION_EXPRESSION";

    public BsonConditionExpressionFunction() {
    }

    public BsonConditionExpressionFunction(List<Expression> children) {
        super(children);
        Preconditions.checkNotNull((Object)this.getChildren().get(1));
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public boolean evaluate(Tuple tuple, ImmutableBytesWritable ptr) {
        RawBsonDocument conditionExpressionBsonDoc;
        if (!this.getChildren().get(0).evaluate(tuple, ptr)) {
            return false;
        }
        if (ptr == null || ptr.getLength() == 0) {
            return false;
        }
        RawBsonDocument rawBsonDocument = (RawBsonDocument)PBson.INSTANCE.toObject(ptr);
        if (!this.getChildren().get(1).evaluate(tuple, ptr)) {
            return false;
        }
        if (ptr.getLength() == 0) {
            return false;
        }
        if (this.getChildren().get(1).getDataType() == PVarchar.INSTANCE) {
            String conditionExpression = (String)PVarchar.INSTANCE.toObject(ptr, this.getChildren().get(1).getSortOrder());
            if (conditionExpression == null || conditionExpression.isEmpty()) {
                ptr.set(PBoolean.INSTANCE.toBytes(true));
                return true;
            }
            conditionExpressionBsonDoc = RawBsonDocument.parse((String)conditionExpression);
        } else {
            conditionExpressionBsonDoc = (RawBsonDocument)PBson.INSTANCE.toObject(ptr);
            if (conditionExpressionBsonDoc == null || conditionExpressionBsonDoc.isEmpty()) {
                ptr.set(PBoolean.INSTANCE.toBytes(true));
                return true;
            }
        }
        BsonValue conditionExp = conditionExpressionBsonDoc.get((Object)"$EXPR");
        BsonValue exprValues = conditionExpressionBsonDoc.get((Object)"$VAL");
        BsonValue keyAlias = conditionExpressionBsonDoc.get((Object)"$KEYS");
        if (conditionExp != null && exprValues != null) {
            if (conditionExp.isString() && exprValues.isDocument()) {
                boolean result = SQLComparisonExpressionUtils.evaluateConditionExpression(((BsonString)conditionExp).getValue(), rawBsonDocument, (BsonDocument)exprValues, keyAlias == null ? null : (BsonDocument)keyAlias);
                ptr.set(PBoolean.INSTANCE.toBytes(result));
                return true;
            }
            throw new IllegalArgumentException("Condition Expression should contain valid expression and values");
        }
        boolean result = DocumentComparisonExpressionUtils.evaluateConditionExpression((BsonDocument)rawBsonDocument, (BsonDocument)conditionExpressionBsonDoc);
        ptr.set(PBoolean.INSTANCE.toBytes(result));
        return true;
    }

    @Override
    public PDataType getDataType() {
        return PBoolean.INSTANCE;
    }
}

