/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.expression.function;

import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.function.ScalarFunction;
import org.apache.phoenix.parse.FunctionParseNode;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.TypeMismatchException;
import org.apache.phoenix.schema.tuple.Tuple;
import org.apache.phoenix.schema.types.PArrayDataType;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PInteger;
import org.apache.phoenix.schema.types.PVarbinary;
import org.apache.phoenix.schema.types.PhoenixArray;

@FunctionParseNode.BuiltInFunction(name="ARRAY_FILL", args={@FunctionParseNode.Argument(allowedTypes={PVarbinary.class}), @FunctionParseNode.Argument(allowedTypes={PInteger.class})})
public class ArrayFillFunction
extends ScalarFunction {
    public static final String NAME = "ARRAY_FILL";

    public ArrayFillFunction() {
    }

    public ArrayFillFunction(List<Expression> children) throws TypeMismatchException {
        super(children);
    }

    @Override
    public boolean evaluate(Tuple tuple, ImmutableBytesWritable ptr) {
        if (!this.getElementExpr().evaluate(tuple, ptr)) {
            return false;
        }
        Object element = this.getElementExpr().getDataType().toObject(ptr, this.getElementExpr().getSortOrder(), this.getElementExpr().getMaxLength(), this.getElementExpr().getScale());
        if (!this.getLengthExpr().evaluate(tuple, ptr) || ptr.getLength() == 0) {
            return false;
        }
        int length = (Integer)this.getLengthExpr().getDataType().toObject(ptr, this.getLengthExpr().getSortOrder(), this.getLengthExpr().getMaxLength(), this.getLengthExpr().getScale());
        if (length <= 0) {
            throw new IllegalArgumentException("Array length should be greater than 0");
        }
        Object[] elements = new Object[length];
        Arrays.fill(elements, element);
        PhoenixArray array = PDataType.instantiatePhoenixArray(this.getElementExpr().getDataType(), elements);
        if (this.getElementExpr().getDataType().isFixedWidth() && this.getMaxLength() != null && !this.getMaxLength().equals(array.getMaxLength())) {
            array = new PhoenixArray(array, this.getMaxLength());
        }
        ptr.set(((PArrayDataType)this.getDataType()).toBytes((Object)array, this.getElementExpr().getDataType(), this.getElementExpr().getSortOrder()));
        return true;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public PDataType getDataType() {
        return PArrayDataType.fromTypeId(3000 + this.getElementExpr().getDataType().getSqlType());
    }

    @Override
    public Integer getMaxLength() {
        return this.getElementExpr().getDataType().getByteSize() == null ? this.getElementExpr().getMaxLength() : null;
    }

    @Override
    public SortOrder getSortOrder() {
        return ((Expression)this.children.get(0)).getSortOrder();
    }

    public Expression getElementExpr() {
        return (Expression)this.children.get(0);
    }

    public Expression getLengthExpr() {
        return (Expression)this.children.get(1);
    }
}

