/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.expression;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.phoenix.expression.ColumnExpression;
import org.apache.phoenix.expression.visitor.ExpressionVisitor;
import org.apache.phoenix.schema.PDatum;
import org.apache.phoenix.schema.RowKeyValueAccessor;
import org.apache.phoenix.schema.tuple.Tuple;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PVarbinaryEncoded;
import org.apache.phoenix.util.ByteUtil;

public class RowKeyColumnExpression
extends ColumnExpression {
    private PDataType fromType;
    private RowKeyValueAccessor accessor;
    protected final String name;
    private int offset;

    public RowKeyColumnExpression() {
        this.name = null;
    }

    private RowKeyColumnExpression(PDatum datum, RowKeyValueAccessor accessor, PDataType fromType, String name) {
        super(datum);
        this.accessor = accessor;
        this.fromType = fromType;
        this.name = name;
    }

    public RowKeyColumnExpression(PDatum datum, RowKeyValueAccessor accessor) {
        this(datum, accessor, datum.getDataType(), datum.toString());
    }

    public RowKeyColumnExpression(PDatum datum, RowKeyValueAccessor accessor, String name) {
        this(datum, accessor, datum.getDataType(), name);
    }

    public RowKeyColumnExpression(PDatum datum, RowKeyValueAccessor accessor, PDataType fromType) {
        this(datum, accessor, fromType, datum.toString());
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public int getPosition() {
        return this.accessor.getIndex();
    }

    public String getName() {
        return this.name;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.accessor == null ? 0 : this.accessor.hashCode());
        return result;
    }

    public String toString() {
        return this.name == null ? "PK[" + this.accessor.getIndex() + "]" : this.name;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RowKeyColumnExpression other = (RowKeyColumnExpression)obj;
        return this.accessor.equals(other.accessor);
    }

    @Override
    public boolean evaluate(Tuple tuple, ImmutableBytesWritable ptr) {
        tuple.getKey(ptr);
        int offset = this.accessor.getOffset(ptr.get(), ptr.getOffset() + this.offset);
        int maxOffset = ptr.getOffset() + ptr.getLength();
        if (offset < maxOffset) {
            int length;
            byte[] buffer = ptr.get();
            int byteSize = -1;
            if (this.fromType.isFixedWidth()) {
                Integer maxLength = this.getMaxLength();
                byteSize = this.fromType.getByteSize() == null ? maxLength : this.fromType.getByteSize();
                byteSize = byteSize <= maxOffset ? byteSize : 0;
            }
            int n = length = byteSize >= 0 ? byteSize : this.accessor.getLength(buffer, offset, maxOffset, this.type, this.getSortOrder());
            if (length > 0) {
                ptr.set(buffer, offset, length);
                this.type.coerceBytes(ptr, this.fromType, this.getSortOrder(), this.getSortOrder());
            } else {
                ptr.set(ByteUtil.EMPTY_BYTE_ARRAY);
            }
        } else {
            ptr.set(ByteUtil.EMPTY_BYTE_ARRAY);
        }
        return true;
    }

    public int evaluateAndGetNextOffset(Tuple tuple, ImmutableBytesWritable ptr, int offset) {
        tuple.getKey(ptr);
        int maxOffset = ptr.getOffset() + ptr.getLength();
        if (offset < maxOffset) {
            int length;
            byte[] buffer = ptr.get();
            int byteSize = -1;
            if (this.fromType.isFixedWidth()) {
                Integer maxLength = this.getMaxLength();
                byteSize = this.fromType.getByteSize() == null ? maxLength : this.fromType.getByteSize();
                byteSize = byteSize <= maxOffset ? byteSize : 0;
            }
            int n = length = byteSize >= 0 ? byteSize : this.accessor.getLength(buffer, offset, maxOffset, this.type, this.getSortOrder());
            if (length > 0) {
                ptr.set(buffer, offset, length);
                this.type.coerceBytes(ptr, this.fromType, this.getSortOrder(), this.getSortOrder());
                if (this.fromType.isFixedWidth()) {
                    return offset + length;
                }
                if (this.fromType == PVarbinaryEncoded.INSTANCE) {
                    return offset + length + 2;
                }
                return offset + length + 1;
            }
            ptr.set(ByteUtil.EMPTY_BYTE_ARRAY);
            return offset + 1;
        }
        ptr.set(ByteUtil.EMPTY_BYTE_ARRAY);
        return maxOffset;
    }

    @Override
    public void readFields(DataInput input) throws IOException {
        super.readFields(input);
        this.accessor = new RowKeyValueAccessor();
        this.accessor.readFields(input);
        this.fromType = this.type;
    }

    @Override
    public void write(DataOutput output) throws IOException {
        super.write(output);
        this.accessor.write(output);
    }

    @Override
    public final <T> T accept(ExpressionVisitor<T> visitor) {
        return visitor.visit(this);
    }

    @Override
    public boolean requiresFinalEvaluation() {
        return true;
    }
}

