/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.execute;

import java.sql.SQLException;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.phoenix.compile.ExplainPlan;
import org.apache.phoenix.compile.ExplainPlanAttributes;
import org.apache.phoenix.compile.OrderByCompiler;
import org.apache.phoenix.compile.RowProjector;
import org.apache.phoenix.compile.StatementContext;
import org.apache.phoenix.execute.ClientProcessingPlan;
import org.apache.phoenix.execute.visitor.QueryPlanVisitor;
import org.apache.phoenix.iterate.ParallelScanGrouper;
import org.apache.phoenix.iterate.ResultIterator;
import org.apache.phoenix.iterate.SegmentResultIterator;
import org.apache.phoenix.parse.FilterableStatement;
import org.apache.phoenix.query.ConnectionQueryServices;
import org.apache.phoenix.schema.TableRef;
import org.apache.phoenix.thirdparty.com.google.common.collect.ImmutableSet;

public class SegmentInfoPlan
extends ClientProcessingPlan {
    private final Integer totalSegmentsValue;
    private final Set<TableRef> sourceTables;

    public SegmentInfoPlan(StatementContext context, FilterableStatement statement, TableRef tableRef, RowProjector projector, Integer totalSegmentsValue) {
        super(context, statement, tableRef, projector, null, null, null, OrderByCompiler.OrderBy.EMPTY_ORDER_BY, null);
        this.totalSegmentsValue = totalSegmentsValue;
        this.sourceTables = ImmutableSet.of((Object)tableRef);
    }

    @Override
    public Set<TableRef> getSourceRefs() {
        return this.sourceTables;
    }

    @Override
    public boolean isApplicable() {
        return true;
    }

    @Override
    public ResultIterator iterator(ParallelScanGrouper scanGrouper, Scan scan) throws SQLException {
        ConnectionQueryServices services = this.context.getConnection().getQueryServices();
        byte[] tableName = this.table.getTable().getPhysicalName().getBytes();
        int queryTimeout = this.context.getConnection().getQueryServices().getProps().getInt("phoenix.query.timeoutMs", 600000);
        int totalSegments = this.totalSegmentsValue;
        List<HRegionLocation> regions = services.getAllTableRegions(tableName, queryTimeout);
        return new SegmentResultIterator(regions, totalSegments);
    }

    @Override
    public <T> T accept(QueryPlanVisitor<T> visitor) {
        return visitor.defaultReturn(this);
    }

    @Override
    public ExplainPlan getExplainPlan() throws SQLException {
        List<String> planSteps = Collections.singletonList("CLIENT REGION SCAN");
        ExplainPlanAttributes.ExplainPlanAttributesBuilder builder = new ExplainPlanAttributes.ExplainPlanAttributesBuilder();
        return new ExplainPlan(planSteps, builder.build());
    }
}

