/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.execute;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.phoenix.compile.ExplainPlan;
import org.apache.phoenix.compile.ExplainPlanAttributes;
import org.apache.phoenix.compile.OrderByCompiler;
import org.apache.phoenix.compile.QueryPlan;
import org.apache.phoenix.compile.RowProjector;
import org.apache.phoenix.compile.StatementContext;
import org.apache.phoenix.execute.ClientProcessingPlan;
import org.apache.phoenix.execute.visitor.ByteCountVisitor;
import org.apache.phoenix.execute.visitor.QueryPlanVisitor;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.iterate.FilterResultIterator;
import org.apache.phoenix.iterate.LimitingResultIterator;
import org.apache.phoenix.iterate.OffsetResultIterator;
import org.apache.phoenix.iterate.OrderedResultIterator;
import org.apache.phoenix.iterate.ParallelScanGrouper;
import org.apache.phoenix.iterate.ResultIterator;
import org.apache.phoenix.iterate.SequenceResultIterator;
import org.apache.phoenix.optimize.Cost;
import org.apache.phoenix.parse.FilterableStatement;
import org.apache.phoenix.schema.TableRef;
import org.apache.phoenix.thirdparty.com.google.common.collect.Lists;
import org.apache.phoenix.util.CostUtil;

public class ClientScanPlan
extends ClientProcessingPlan {
    private List<OrderByCompiler.OrderBy> actualOutputOrderBys;

    public ClientScanPlan(StatementContext context, FilterableStatement statement, TableRef table, RowProjector projector, Integer limit, Integer offset, Expression where, OrderByCompiler.OrderBy orderBy, QueryPlan delegate) {
        super(context, statement, table, projector, limit, offset, where, orderBy, delegate);
        this.actualOutputOrderBys = ClientScanPlan.convertActualOutputOrderBy(orderBy, delegate, context);
    }

    @Override
    public Cost getCost() {
        Double inputBytes = this.getDelegate().accept(new ByteCountVisitor());
        Double outputBytes = this.accept(new ByteCountVisitor());
        if (inputBytes == null || outputBytes == null) {
            return Cost.UNKNOWN;
        }
        int parallelLevel = CostUtil.estimateParallelLevel(false, this.context.getConnection().getQueryServices());
        Cost cost = new Cost(0.0, 0.0, 0.0);
        if (!this.orderBy.getOrderByExpressions().isEmpty()) {
            Cost orderByCost = CostUtil.estimateOrderByCost(inputBytes, outputBytes, parallelLevel);
            cost = cost.plus(orderByCost);
        }
        return super.getCost().plus(cost);
    }

    @Override
    public <T> T accept(QueryPlanVisitor<T> visitor) {
        return visitor.visit(this);
    }

    @Override
    public ResultIterator iterator(ParallelScanGrouper scanGrouper, Scan scan) throws SQLException {
        ResultIterator iterator = this.delegate.iterator(scanGrouper, scan);
        if (this.where != null) {
            iterator = new FilterResultIterator(iterator, this.where);
        }
        if (!this.orderBy.getOrderByExpressions().isEmpty()) {
            long thresholdBytes = this.context.getConnection().getQueryServices().getProps().getLongBytes("phoenix.query.client.spoolThresholdBytes", 0x1400000L);
            boolean spoolingEnabled = this.context.getConnection().getQueryServices().getProps().getBoolean("phoenix.query.client.orderBy.spooling.enabled", true);
            iterator = new OrderedResultIterator(iterator, this.orderBy.getOrderByExpressions(), spoolingEnabled, thresholdBytes, this.limit, this.offset, this.projector.getEstimatedRowByteSize());
        } else {
            if (this.offset != null) {
                iterator = new OffsetResultIterator(iterator, this.offset);
            }
            if (this.limit != null) {
                iterator = new LimitingResultIterator(iterator, this.limit);
            }
        }
        if (this.context.getSequenceManager().getSequenceCount() > 0) {
            iterator = new SequenceResultIterator(iterator, this.context.getSequenceManager());
        }
        return iterator;
    }

    @Override
    public ExplainPlan getExplainPlan() throws SQLException {
        ExplainPlan explainPlan = this.delegate.getExplainPlan();
        List<String> currentPlanSteps = explainPlan.getPlanSteps();
        ExplainPlanAttributes explainPlanAttributes = explainPlan.getPlanStepsAsAttributes();
        ArrayList planSteps = Lists.newArrayList(currentPlanSteps);
        ExplainPlanAttributes.ExplainPlanAttributesBuilder newBuilder = new ExplainPlanAttributes.ExplainPlanAttributesBuilder(explainPlanAttributes);
        if (this.where != null) {
            planSteps.add("CLIENT FILTER BY " + this.where.toString());
            newBuilder.setClientFilterBy(this.where.toString());
        }
        if (!this.orderBy.getOrderByExpressions().isEmpty()) {
            if (this.offset != null) {
                planSteps.add("CLIENT OFFSET " + this.offset);
                newBuilder.setClientOffset(this.offset);
            }
            planSteps.add("CLIENT" + (this.limit == null ? "" : " TOP " + this.limit + " ROW" + (this.limit == 1 ? "" : "S")) + " SORTED BY " + this.orderBy.getOrderByExpressions().toString());
            newBuilder.setClientRowLimit(this.limit);
            newBuilder.setClientSortedBy(this.orderBy.getOrderByExpressions().toString());
        } else {
            if (this.offset != null) {
                planSteps.add("CLIENT OFFSET " + this.offset);
                newBuilder.setClientOffset(this.offset);
            }
            if (this.limit != null) {
                planSteps.add("CLIENT " + this.limit + " ROW LIMIT");
                newBuilder.setClientRowLimit(this.limit);
            }
        }
        if (this.context.getSequenceManager().getSequenceCount() > 0) {
            int nSequences = this.context.getSequenceManager().getSequenceCount();
            planSteps.add("CLIENT RESERVE VALUES FROM " + nSequences + " SEQUENCE" + (nSequences == 1 ? "" : "S"));
            newBuilder.setClientSequenceCount(nSequences);
        }
        return new ExplainPlan(planSteps, newBuilder.build());
    }

    private static List<OrderByCompiler.OrderBy> convertActualOutputOrderBy(OrderByCompiler.OrderBy orderBy, QueryPlan targetQueryPlan, StatementContext statementContext) {
        if (!orderBy.isEmpty()) {
            return Collections.singletonList(OrderByCompiler.OrderBy.convertCompiledOrderByToOutputOrderBy(orderBy));
        }
        assert (orderBy != OrderByCompiler.OrderBy.REV_ROW_KEY_ORDER_BY);
        return targetQueryPlan.getOutputOrderBys();
    }

    @Override
    public List<OrderByCompiler.OrderBy> getOutputOrderBys() {
        return this.actualOutputOrderBys;
    }
}

