/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.execute;

import java.io.ByteArrayOutputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.io.WritableUtils;
import org.apache.phoenix.cache.ServerCacheClient;
import org.apache.phoenix.compile.GroupByCompiler;
import org.apache.phoenix.compile.OrderByCompiler;
import org.apache.phoenix.compile.QueryPlan;
import org.apache.phoenix.compile.RowProjector;
import org.apache.phoenix.compile.StatementContext;
import org.apache.phoenix.execute.BaseQueryPlan;
import org.apache.phoenix.execute.visitor.AvgRowWidthVisitor;
import org.apache.phoenix.execute.visitor.ByteCountVisitor;
import org.apache.phoenix.execute.visitor.QueryPlanVisitor;
import org.apache.phoenix.execute.visitor.RowCountVisitor;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.ExpressionType;
import org.apache.phoenix.expression.OrderByExpression;
import org.apache.phoenix.expression.RowKeyExpression;
import org.apache.phoenix.expression.aggregator.Aggregators;
import org.apache.phoenix.hbase.index.util.ImmutableBytesPtr;
import org.apache.phoenix.iterate.AggregatingResultIterator;
import org.apache.phoenix.iterate.BaseResultIterators;
import org.apache.phoenix.iterate.ConcatResultIterator;
import org.apache.phoenix.iterate.DistinctAggregatingResultIterator;
import org.apache.phoenix.iterate.FilterAggregatingResultIterator;
import org.apache.phoenix.iterate.GroupedAggregatingResultIterator;
import org.apache.phoenix.iterate.LimitingResultIterator;
import org.apache.phoenix.iterate.MergeSortRowKeyResultIterator;
import org.apache.phoenix.iterate.OffsetResultIterator;
import org.apache.phoenix.iterate.OrderedAggregatingResultIterator;
import org.apache.phoenix.iterate.OrderedResultIterator;
import org.apache.phoenix.iterate.ParallelIteratorFactory;
import org.apache.phoenix.iterate.ParallelIterators;
import org.apache.phoenix.iterate.ParallelScanGrouper;
import org.apache.phoenix.iterate.PeekingResultIterator;
import org.apache.phoenix.iterate.ResultIterator;
import org.apache.phoenix.iterate.RowKeyOrderedAggregateResultIterator;
import org.apache.phoenix.iterate.SequenceResultIterator;
import org.apache.phoenix.iterate.SerialIterators;
import org.apache.phoenix.iterate.SpoolingResultIterator;
import org.apache.phoenix.iterate.UngroupedAggregatingResultIterator;
import org.apache.phoenix.optimize.Cost;
import org.apache.phoenix.parse.FilterableStatement;
import org.apache.phoenix.parse.HintNode;
import org.apache.phoenix.query.ConnectionQueryServices;
import org.apache.phoenix.query.KeyRange;
import org.apache.phoenix.query.QueryConstants;
import org.apache.phoenix.query.QueryServices;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.TableRef;
import org.apache.phoenix.schema.types.PInteger;
import org.apache.phoenix.util.CostUtil;
import org.apache.phoenix.util.ExpressionUtil;
import org.apache.phoenix.util.ScanUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AggregatePlan
extends BaseQueryPlan {
    private final Aggregators aggregators;
    private final Expression having;
    private List<KeyRange> splits;
    private List<List<Scan>> scans;
    private static final Logger LOGGER = LoggerFactory.getLogger(AggregatePlan.class);
    private boolean isSerial;
    private OrderByCompiler.OrderBy actualOutputOrderBy;

    public AggregatePlan(StatementContext context, FilterableStatement statement, TableRef table, RowProjector projector, Integer limit, Integer offset, OrderByCompiler.OrderBy orderBy, ParallelIteratorFactory parallelIteratorFactory, GroupByCompiler.GroupBy groupBy, Expression having, QueryPlan dataPlan) throws SQLException {
        super(context, statement, table, projector, context.getBindManager().getParameterMetaData(), limit, offset, orderBy, groupBy, parallelIteratorFactory, dataPlan);
        this.having = having;
        this.aggregators = context.getAggregationManager().getAggregators();
        boolean hasSerialHint = statement.getHint().hasHint(HintNode.Hint.SERIAL);
        boolean canBeExecutedSerially = ScanUtil.canQueryBeExecutedSerially(table.getTable(), orderBy, context);
        if (hasSerialHint && !canBeExecutedSerially) {
            LOGGER.warn("This query cannot be executed serially. Ignoring the hint");
        }
        this.isSerial = hasSerialHint && canBeExecutedSerially;
        this.actualOutputOrderBy = AggregatePlan.convertActualOutputOrderBy(orderBy, groupBy, context);
    }

    public Expression getHaving() {
        return this.having;
    }

    @Override
    public Cost getCost() {
        Double outputBytes = this.accept(new ByteCountVisitor());
        Double rowWidth = this.accept(new AvgRowWidthVisitor());
        Long inputRows = null;
        try {
            inputRows = this.getEstimatedRowsToScan();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        if (inputRows == null || outputBytes == null || rowWidth == null) {
            return Cost.UNKNOWN;
        }
        double inputBytes = (double)inputRows.longValue() * rowWidth;
        double rowsBeforeHaving = RowCountVisitor.aggregate(RowCountVisitor.filter(inputRows.doubleValue(), RowCountVisitor.stripSkipScanFilter(this.context.getScan().getFilter())), this.groupBy);
        double rowsAfterHaving = RowCountVisitor.filter(rowsBeforeHaving, this.having);
        double bytesBeforeHaving = rowWidth * rowsBeforeHaving;
        double bytesAfterHaving = rowWidth * rowsAfterHaving;
        int parallelLevel = CostUtil.estimateParallelLevel(true, this.context.getConnection().getQueryServices());
        Cost cost = new Cost(0.0, 0.0, inputBytes);
        Cost aggCost = CostUtil.estimateAggregateCost(inputBytes, bytesBeforeHaving, this.groupBy, parallelLevel);
        cost = cost.plus(aggCost);
        if (!this.orderBy.getOrderByExpressions().isEmpty()) {
            parallelLevel = CostUtil.estimateParallelLevel(false, this.context.getConnection().getQueryServices());
            Cost orderByCost = CostUtil.estimateOrderByCost(bytesAfterHaving, outputBytes, parallelLevel);
            cost = cost.plus(orderByCost);
        }
        return cost;
    }

    @Override
    public List<KeyRange> getSplits() {
        if (this.splits == null) {
            return Collections.emptyList();
        }
        return this.splits;
    }

    @Override
    public List<List<Scan>> getScans() {
        if (this.scans == null) {
            return Collections.emptyList();
        }
        return this.scans;
    }

    private ParallelIteratorFactory wrapParallelIteratorFactory() {
        ConnectionQueryServices services = this.context.getConnection().getQueryServices();
        ParallelIteratorFactory innerFactory = this.groupBy.isEmpty() || this.groupBy.isOrderPreserving() ? (ScanUtil.isPacingScannersPossible(this.context) ? ParallelIteratorFactory.NOOP_FACTORY : new SpoolingResultIterator.SpoolingResultIteratorFactory(services)) : new OrderingResultIteratorFactory(services, this.getOrderBy());
        if (this.parallelIteratorFactory == null) {
            return innerFactory;
        }
        return new WrappingResultIteratorFactory(innerFactory, this.parallelIteratorFactory);
    }

    public void serializeGroupedAggregateRegionObserverIntoScan(Scan scan, String attribName, List<Expression> groupByExpressions) {
        ByteArrayOutputStream stream = new ByteArrayOutputStream(Math.max(1, groupByExpressions.size() * 10));
        try {
            if (groupByExpressions.isEmpty()) {
                stream.write(QueryConstants.TRUE);
            } else {
                DataOutputStream output = new DataOutputStream(stream);
                for (Expression expression : groupByExpressions) {
                    WritableUtils.writeVInt((DataOutput)output, (int)ExpressionType.valueOf(expression).ordinal());
                    expression.write(output);
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                stream.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        scan.setAttribute(attribName, stream.toByteArray());
    }

    public void serializeUngroupedAggregateRegionObserverIntoScan(Scan scan) {
        scan.setAttribute("_UngroupedAgg", QueryConstants.TRUE);
    }

    @Override
    protected ResultIterator newIterator(ParallelScanGrouper scanGrouper, Scan scan, Map<ImmutableBytesPtr, ServerCacheClient.ServerCache> caches) throws SQLException {
        if (this.groupBy.isEmpty()) {
            this.serializeUngroupedAggregateRegionObserverIntoScan(scan);
        } else {
            this.serializeGroupedAggregateRegionObserverIntoScan(scan, this.groupBy.getScanAttribName(), this.groupBy.getKeyExpressions());
            if (this.limit != null && this.orderBy.getOrderByExpressions().isEmpty() && this.having == null && (this.statement.isDistinct() && !this.statement.isAggregate() || !this.statement.isDistinct() && (this.context.getAggregationManager().isEmpty() || "_OrderedGroupByExpressions".equals(this.groupBy.getScanAttribName())))) {
                scan.setAttribute("_GroupByLimit", PInteger.INSTANCE.toBytes(this.limit + (this.offset == null ? 0 : this.offset)));
            }
        }
        BaseResultIterators iterators = this.isSerial ? new SerialIterators(this, null, null, this.wrapParallelIteratorFactory(), scanGrouper, scan, caches, this.dataPlan) : new ParallelIterators((QueryPlan)this, null, this.wrapParallelIteratorFactory(), scan, false, caches, this.dataPlan);
        this.estimatedRows = iterators.getEstimatedRowCount();
        this.estimatedSize = iterators.getEstimatedByteCount();
        this.estimateInfoTimestamp = iterators.getEstimateInfoTimestamp();
        this.splits = iterators.getSplits();
        this.scans = iterators.getScans();
        AggregatingResultIterator aggResultIterator = this.groupBy.isEmpty() || this.groupBy.isUngroupedAggregate() ? new UngroupedAggregatingResultIterator(new ConcatResultIterator(iterators), this.aggregators) : (this.groupBy.isOrderPreserving() && this.getTableRef().getTable().getBucketNum() == null && this.getTableRef().getTable().getIndexType() != PTable.IndexType.LOCAL ? new RowKeyOrderedAggregateResultIterator(iterators, this.aggregators) : new GroupedAggregatingResultIterator(new MergeSortRowKeyResultIterator(iterators, 0, this.getOrderBy() == OrderByCompiler.OrderBy.REV_ROW_KEY_ORDER_BY), this.aggregators));
        if (this.having != null) {
            aggResultIterator = new FilterAggregatingResultIterator(aggResultIterator, this.having);
        }
        if (this.statement.isDistinct() && this.statement.isAggregate()) {
            aggResultIterator = new DistinctAggregatingResultIterator(aggResultIterator, this.getProjector());
        }
        ResultIterator resultScanner = aggResultIterator;
        if (this.orderBy.getOrderByExpressions().isEmpty()) {
            if (this.offset != null) {
                resultScanner = new OffsetResultIterator(aggResultIterator, this.offset);
            }
            if (this.limit != null) {
                resultScanner = new LimitingResultIterator(resultScanner, this.limit);
            }
        } else {
            long thresholdBytes = this.context.getConnection().getQueryServices().getProps().getLongBytes("phoenix.query.client.spoolThresholdBytes", 0x1400000L);
            boolean spoolingEnabled = this.context.getConnection().getQueryServices().getProps().getBoolean("phoenix.query.client.orderBy.spooling.enabled", true);
            resultScanner = new OrderedAggregatingResultIterator(aggResultIterator, this.orderBy.getOrderByExpressions(), spoolingEnabled, thresholdBytes, this.limit, this.offset);
        }
        if (this.context.getSequenceManager().getSequenceCount() > 0) {
            resultScanner = new SequenceResultIterator(resultScanner, this.context.getSequenceManager());
        }
        return resultScanner;
    }

    @Override
    public boolean useRoundRobinIterator() throws SQLException {
        return false;
    }

    @Override
    public <T> T accept(QueryPlanVisitor<T> visitor) {
        return visitor.visit(this);
    }

    private static OrderByCompiler.OrderBy convertActualOutputOrderBy(OrderByCompiler.OrderBy orderBy, GroupByCompiler.GroupBy groupBy, StatementContext statementContext) {
        if (!orderBy.isEmpty()) {
            return OrderByCompiler.OrderBy.convertCompiledOrderByToOutputOrderBy(orderBy);
        }
        return ExpressionUtil.convertGroupByToOrderBy(groupBy, orderBy == OrderByCompiler.OrderBy.REV_ROW_KEY_ORDER_BY);
    }

    @Override
    public List<OrderByCompiler.OrderBy> getOutputOrderBys() {
        return OrderByCompiler.OrderBy.wrapForOutputOrderBys(this.actualOutputOrderBy);
    }

    @Override
    protected void setScanReversedWhenOrderByIsReversed(Scan scan) {
        if (this.groupBy.isOrderPreserving()) {
            super.setScanReversedWhenOrderByIsReversed(scan);
        }
    }

    private static class WrappingResultIteratorFactory
    implements ParallelIteratorFactory {
        private final ParallelIteratorFactory innerFactory;
        private final ParallelIteratorFactory outerFactory;

        public WrappingResultIteratorFactory(ParallelIteratorFactory innerFactory, ParallelIteratorFactory outerFactory) {
            this.innerFactory = innerFactory;
            this.outerFactory = outerFactory;
        }

        @Override
        public PeekingResultIterator newIterator(StatementContext context, ResultIterator scanner, Scan scan, String tableName, QueryPlan plan) throws SQLException {
            PeekingResultIterator iterator = this.innerFactory.newIterator(context, scanner, scan, tableName, plan);
            return this.outerFactory.newIterator(context, iterator, scan, tableName, plan);
        }
    }

    private static class OrderingResultIteratorFactory
    implements ParallelIteratorFactory {
        private final QueryServices services;
        private final OrderByCompiler.OrderBy orderBy;

        public OrderingResultIteratorFactory(QueryServices services, OrderByCompiler.OrderBy orderBy) {
            this.services = services;
            this.orderBy = orderBy;
        }

        @Override
        public PeekingResultIterator newIterator(StatementContext context, ResultIterator scanner, Scan scan, String tableName, QueryPlan plan) throws SQLException {
            OrderByExpression orderByExpression = OrderByExpression.createByCheckIfOrderByReverse(RowKeyExpression.INSTANCE, false, true, this.orderBy == OrderByCompiler.OrderBy.REV_ROW_KEY_ORDER_BY);
            long threshold = this.services.getProps().getLongBytes("phoenix.query.client.spoolThresholdBytes", 0x1400000L);
            boolean spoolingEnabled = this.services.getProps().getBoolean("phoenix.query.client.orderBy.spooling.enabled", true);
            return new OrderedResultIterator(scanner, Collections.singletonList(orderByExpression), spoolingEnabled, threshold);
        }
    }
}

