/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.coprocessorclient.metrics;

import org.apache.hadoop.hbase.metrics.BaseSourceImpl;
import org.apache.hadoop.metrics2.MetricHistogram;
import org.apache.hadoop.metrics2.lib.MutableFastCounter;
import org.apache.phoenix.coprocessorclient.metrics.MetricsMetadataCachingSource;

public class MetricsMetadataCachingSourceImpl
extends BaseSourceImpl
implements MetricsMetadataCachingSource {
    private final MutableFastCounter cacheHitCounter = this.getMetricsRegistry().newCounter("numRegionServerMetadataCacheHits", "Number of cache hits in PhoenixRegionServerEndpoint when serving validate ddl timestamp requests.", 0L);
    private final MutableFastCounter cacheMissCounter = this.getMetricsRegistry().newCounter("numRegionServerMetadataCacheMisses", "Number of cache misses in PhoenixRegionServerEndpoint when serving validate ddl timestamp requests.", 0L);
    private final MutableFastCounter validateDDLTimestampRequestCounter = this.getMetricsRegistry().newCounter("numValidateLastDDLTimestampRequests", "Number of validate last ddl timestamp requests.", 0L);
    private final MutableFastCounter cacheInvalidationOpsCounter = this.getMetricsRegistry().newCounter("numMetadataCacheInvalidationOps", "Number of times we invoke cache invalidation within a DDL operation", 0L);
    private final MutableFastCounter cacheInvalidationSuccessCounter = this.getMetricsRegistry().newCounter("numMetadataCacheInvalidationOpsSuccess", "Number of times cache invalidation was successful.", 0L);
    private final MutableFastCounter cacheInvalidationFailureCounter = this.getMetricsRegistry().newCounter("numMetadataCacheInvalidationOpsFailure", "Number of times cache invalidation failed.", 0L);
    private final MetricHistogram cacheInvalidationRpcTimeHistogram = this.getMetricsRegistry().newHistogram("metadataCacheInvalidationRpcTimeMs", "Histogram for the time in milliseconds for cache invalidation RPC");
    private final MetricHistogram cacheInvalidationTotalTimeHistogram = this.getMetricsRegistry().newHistogram("metadataCacheInvalidationTotalTimeMs", "Histogram for the total time in milliseconds for cache invalidation on all regionservers");

    public MetricsMetadataCachingSourceImpl() {
        this("MetadataCaching", "Metrics about Distributed Metadata Caching", "phoenix", "RegionServer,sub=MetadataCaching");
    }

    public MetricsMetadataCachingSourceImpl(String metricsName, String metricsDescription, String metricsContext, String metricsJmxContext) {
        super(metricsName, metricsDescription, metricsContext, metricsJmxContext);
    }

    @Override
    public void incrementRegionServerMetadataCacheHitCount() {
        this.cacheHitCounter.incr();
    }

    @Override
    public void incrementRegionServerMetadataCacheMissCount() {
        this.cacheMissCounter.incr();
    }

    @Override
    public void incrementValidateTimestampRequestCount() {
        this.validateDDLTimestampRequestCounter.incr();
    }

    @Override
    public void addMetadataCacheInvalidationRpcTime(long t) {
        this.cacheInvalidationRpcTimeHistogram.add(t);
    }

    @Override
    public void addMetadataCacheInvalidationTotalTime(long t) {
        this.cacheInvalidationTotalTimeHistogram.add(t);
    }

    @Override
    public void incrementMetadataCacheInvalidationOperationsCount() {
        this.cacheInvalidationOpsCounter.incr();
    }

    @Override
    public void incrementMetadataCacheInvalidationSuccessCount() {
        this.cacheInvalidationSuccessCounter.incr();
    }

    @Override
    public void incrementMetadataCacheInvalidationFailureCount() {
        this.cacheInvalidationFailureCounter.incr();
    }

    @Override
    public MetricsMetadataCachingSource.MetadataCachingMetricValues getCurrentMetricValues() {
        return new MetricsMetadataCachingSource.MetadataCachingMetricValues.Builder().setCacheHitCount(this.cacheHitCounter.value()).setCacheMissCount(this.cacheMissCounter.value()).setValidateDDLTimestampRequestsCount(this.validateDDLTimestampRequestCounter.value()).setCacheInvalidationRpcTimeCount(this.cacheInvalidationRpcTimeHistogram.getCount()).setCacheInvalidationTotalTimeCount(this.cacheInvalidationTotalTimeHistogram.getCount()).setCacheInvalidationOpsCount(this.cacheInvalidationOpsCounter.value()).setCacheInvalidationSuccessCount(this.cacheInvalidationSuccessCounter.value()).setCacheInvalidationFailureCount(this.cacheInvalidationFailureCounter.value()).build();
    }
}

