/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.coprocessorclient.metrics;

import org.apache.hadoop.hbase.metrics.BaseSource;
import org.apache.phoenix.thirdparty.com.google.common.annotations.VisibleForTesting;

public interface MetricsMetadataCachingSource
extends BaseSource {
    public static final String METRICS_NAME = "MetadataCaching";
    public static final String METRICS_CONTEXT = "phoenix";
    public static final String METRICS_DESCRIPTION = "Metrics about Distributed Metadata Caching";
    public static final String METRICS_JMX_CONTEXT = "RegionServer,sub=MetadataCaching";
    public static final String REGIONSERVER_METADATA_CACHE_HITS = "numRegionServerMetadataCacheHits";
    public static final String REGIONSERVER_METADATA_CACHE_HITS_DESC = "Number of cache hits in PhoenixRegionServerEndpoint when serving validate ddl timestamp requests.";
    public static final String REGIONSERVER_METADATA_CACHE_MISSES = "numRegionServerMetadataCacheMisses";
    public static final String REGIONSERVER_METADATA_CACHE_MISSES_DESC = "Number of cache misses in PhoenixRegionServerEndpoint when serving validate ddl timestamp requests.";
    public static final String VALIDATE_LAST_DDL_TIMESTAMP_REQUESTS = "numValidateLastDDLTimestampRequests";
    public static final String VALIDATE_LAST_DDL_TIMESTAMP_REQUEST_DESC = "Number of validate last ddl timestamp requests.";
    public static final String METADATA_CACHE_INVALIDATION_OPERATIONS = "numMetadataCacheInvalidationOps";
    public static final String METADATA_CACHE_INVALIDATION_OPERATIONS_DESC = "Number of times we invoke cache invalidation within a DDL operation";
    public static final String METADATA_CACHE_INVALIDATION_SUCCESS = "numMetadataCacheInvalidationOpsSuccess";
    public static final String METADATA_CACHE_INVALIDATION_SUCCESS_DESC = "Number of times cache invalidation was successful.";
    public static final String METADATA_CACHE_INVALIDATION_FAILURE = "numMetadataCacheInvalidationOpsFailure";
    public static final String METADATA_CACHE_INVALIDATION_FAILURE_DESC = "Number of times cache invalidation failed.";
    public static final String METADATA_CACHE_INVALIDATION_RPC_TIME = "metadataCacheInvalidationRpcTimeMs";
    public static final String METADATA_CACHE_INVALIDATION_RPC_TIME_DESC = "Histogram for the time in milliseconds for cache invalidation RPC";
    public static final String METADATA_CACHE_INVALIDATION_TOTAL_TIME = "metadataCacheInvalidationTotalTimeMs";
    public static final String METADATA_CACHE_INVALIDATION_TOTAL_TIME_DESC = "Histogram for the total time in milliseconds for cache invalidation on all regionservers";

    public void incrementRegionServerMetadataCacheHitCount();

    public void incrementRegionServerMetadataCacheMissCount();

    public void incrementValidateTimestampRequestCount();

    public void incrementMetadataCacheInvalidationOperationsCount();

    public void incrementMetadataCacheInvalidationSuccessCount();

    public void incrementMetadataCacheInvalidationFailureCount();

    public void addMetadataCacheInvalidationRpcTime(long var1);

    public void addMetadataCacheInvalidationTotalTime(long var1);

    @VisibleForTesting
    public MetadataCachingMetricValues getCurrentMetricValues();

    @VisibleForTesting
    public static class MetadataCachingMetricValues {
        private long cacheHitCount;
        private long cacheMissCount;
        private long validateDDLTimestampRequestsCount;
        private long cacheInvalidationOpsCount;
        private long cacheInvalidationSuccessCount;
        private long cacheInvalidationFailureCount;
        private long cacheInvalidationRpcTimeCount;
        private long cacheInvalidationTotalTimeCount;

        MetadataCachingMetricValues(Builder builder) {
            this.cacheHitCount = builder.cacheHitCount;
            this.cacheMissCount = builder.cacheMissCount;
            this.validateDDLTimestampRequestsCount = builder.validateDDLTimestampRequestsCount;
            this.cacheInvalidationOpsCount = builder.cacheInvalidationOpsCount;
            this.cacheInvalidationSuccessCount = builder.cacheInvalidationSuccessCount;
            this.cacheInvalidationFailureCount = builder.cacheInvalidationFailureCount;
            this.cacheInvalidationRpcTimeCount = builder.cacheInvalidationRpcTimeCount;
            this.cacheInvalidationTotalTimeCount = builder.cacheInvalidationTotalTimeCount;
        }

        public long getCacheHitCount() {
            return this.cacheHitCount;
        }

        public long getCacheMissCount() {
            return this.cacheMissCount;
        }

        public long getValidateDDLTimestampRequestsCount() {
            return this.validateDDLTimestampRequestsCount;
        }

        public long getCacheInvalidationOpsCount() {
            return this.cacheInvalidationOpsCount;
        }

        public long getCacheInvalidationSuccessCount() {
            return this.cacheInvalidationSuccessCount;
        }

        public long getCacheInvalidationFailureCount() {
            return this.cacheInvalidationFailureCount;
        }

        public long getCacheInvalidationRpcTimeCount() {
            return this.cacheInvalidationRpcTimeCount;
        }

        public long getCacheInvalidationTotalTimeCount() {
            return this.cacheInvalidationTotalTimeCount;
        }

        public static class Builder {
            private long cacheHitCount;
            private long cacheMissCount;
            private long validateDDLTimestampRequestsCount;
            private long cacheInvalidationOpsCount;
            private long cacheInvalidationSuccessCount;
            private long cacheInvalidationFailureCount;
            private long cacheInvalidationRpcTimeCount;
            private long cacheInvalidationTotalTimeCount;

            public MetadataCachingMetricValues build() {
                return new MetadataCachingMetricValues(this);
            }

            public Builder setCacheHitCount(long c) {
                this.cacheHitCount = c;
                return this;
            }

            public Builder setCacheMissCount(long cacheMissCount) {
                this.cacheMissCount = cacheMissCount;
                return this;
            }

            public Builder setValidateDDLTimestampRequestsCount(long validateDDLTimestampRequestsCount) {
                this.validateDDLTimestampRequestsCount = validateDDLTimestampRequestsCount;
                return this;
            }

            public Builder setCacheInvalidationOpsCount(long cacheInvalidationOpsCount) {
                this.cacheInvalidationOpsCount = cacheInvalidationOpsCount;
                return this;
            }

            public Builder setCacheInvalidationSuccessCount(long cacheInvalidationSuccessCount) {
                this.cacheInvalidationSuccessCount = cacheInvalidationSuccessCount;
                return this;
            }

            public Builder setCacheInvalidationFailureCount(long cacheInvalidationFailureCount) {
                this.cacheInvalidationFailureCount = cacheInvalidationFailureCount;
                return this;
            }

            public Builder setCacheInvalidationRpcTimeCount(long cacheInvalidationRpcTimeCount) {
                this.cacheInvalidationRpcTimeCount = cacheInvalidationRpcTimeCount;
                return this;
            }

            public Builder setCacheInvalidationTotalTimeCount(long cacheInvalidationTotalTimeCount) {
                this.cacheInvalidationTotalTimeCount = cacheInvalidationTotalTimeCount;
                return this;
            }
        }
    }
}

