/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.coprocessorclient;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.StampedLock;
import org.apache.phoenix.coprocessorclient.TableTTLInfo;

public class TableTTLInfoCache {
    private final Map<TableTTLInfo, Integer> tableToTableIdMap = new HashMap<TableTTLInfo, Integer>();
    private final List<TableTTLInfo> cachedInfo = new ArrayList<TableTTLInfo>();
    private final StampedLock lock = new StampedLock();
    private int nextId;

    public int addTable(TableTTLInfo tableRow) {
        return this.putTableIfAbsent(tableRow);
    }

    public int getNumTablesInCache() {
        if (this.cachedInfo.size() != this.tableToTableIdMap.keySet().size()) {
            throw new IllegalStateException();
        }
        return this.cachedInfo.size();
    }

    public Set<TableTTLInfo> getAllTables() {
        if (this.cachedInfo.size() != this.tableToTableIdMap.keySet().size()) {
            throw new IllegalStateException();
        }
        HashSet<TableTTLInfo> tables = new HashSet<TableTTLInfo>();
        tables.addAll(this.cachedInfo);
        return tables;
    }

    public TableTTLInfo getTableById(Integer id) {
        if (id == null) {
            return null;
        }
        return this.cachedInfo.get(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Integer tryOptimisticGet(TableTTLInfo newRow) {
        long stamp = this.lock.tryOptimisticRead();
        Integer tableId = this.tableToTableIdMap.get(newRow);
        if (!this.lock.validate(stamp)) {
            stamp = this.lock.readLock();
            try {
                tableId = this.tableToTableIdMap.get(newRow);
            }
            finally {
                this.lock.unlockRead(stamp);
            }
        }
        return tableId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int putTableIfAbsent(TableTTLInfo newRow) {
        if (newRow == null) {
            throw new IllegalArgumentException();
        }
        Integer tableId = this.tryOptimisticGet(newRow);
        if (tableId == null) {
            long writeStamp = this.lock.writeLock();
            try {
                tableId = this.tableToTableIdMap.get(newRow);
                if (tableId == null) {
                    tableId = this.nextId++;
                    this.cachedInfo.add(newRow);
                    if (this.nextId != this.cachedInfo.size()) {
                        throw new IllegalStateException();
                    }
                    this.tableToTableIdMap.put(newRow, tableId);
                }
            }
            finally {
                this.lock.unlock(writeStamp);
            }
        }
        return tableId;
    }
}

