/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.coprocessorclient;

import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.util.SchemaUtil;

public class InvalidateServerMetadataCacheRequest {
    private final byte[] tenantId;
    private final byte[] schemaName;
    private final byte[] tableName;

    public InvalidateServerMetadataCacheRequest(byte[] tenantId, byte[] schemaName, byte[] tableName) {
        this.tenantId = tenantId;
        this.schemaName = schemaName;
        this.tableName = tableName;
    }

    public byte[] getTenantId() {
        return this.tenantId;
    }

    public byte[] getSchemaName() {
        return this.schemaName;
    }

    public byte[] getTableName() {
        return this.tableName;
    }

    public String toString() {
        String fullTableName = SchemaUtil.getTableName(this.schemaName, this.tableName);
        return "tenantId = " + Bytes.toString((byte[])this.tenantId) + ", table name = " + fullTableName;
    }
}

