/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.coprocessorclient;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.schema.types.PUnsignedTinyint;

public class BaseScannerRegionObserverConstants {
    public static final String AGGREGATORS = "_Aggs";
    public static final String UNORDERED_GROUP_BY_EXPRESSIONS = "_UnorderedGroupByExpressions";
    public static final String KEY_ORDERED_GROUP_BY_EXPRESSIONS = "_OrderedGroupByExpressions";
    public static final String ESTIMATED_DISTINCT_VALUES = "_EstDistinctValues";
    public static final String NON_AGGREGATE_QUERY = "_NonAggregateQuery";
    public static final String TOPN = "_TopN";
    public static final String UNGROUPED_AGG = "_UngroupedAgg";
    public static final String DELETE_AGG = "_DeleteAgg";
    public static final String SINGLE_ROW_DELETE = "_SingleRowDelete";
    public static final String UPSERT_SELECT_TABLE = "_UpsertSelectTable";
    public static final String UPSERT_SELECT_EXPRS = "_UpsertSelectExprs";
    public static final String DELETE_CQ = "_DeleteCQ";
    public static final String DELETE_CF = "_DeleteCF";
    public static final String UPSERT_STATUS_CQ = "_UpsertStatusCQ";
    public static final String UPSERT_CF = "_UpsertCF";
    public static final String EMPTY_CF = "_EmptyCF";
    public static final String EMPTY_COLUMN_QUALIFIER = "_EmptyColumnQualifier";
    public static final String SPECIFIC_ARRAY_INDEX = "_SpecificArrayIndex";
    public static final String GROUP_BY_LIMIT = "_GroupByLimit";
    public static final String LOCAL_INDEX = "_LocalIndex";
    public static final String LOCAL_INDEX_BUILD = "_LocalIndexBuild";
    public static final String UNCOVERED_GLOBAL_INDEX = "_UncoveredGlobalIndex";
    public static final String INDEX_REBUILD_PAGING = "_IndexRebuildPaging";
    public static final String INDEX_REBUILD_PAGE_ROWS = "_IndexRebuildPageRows";
    public static final String INDEX_PAGE_ROWS = "_IndexPageRows";
    public static final String SERVER_PAGE_SIZE_MS = "_ServerPageSizeMs";
    public static final String INDEX_REBUILD_VERIFY_TYPE = "_IndexRebuildVerifyType";
    public static final String INDEX_RETRY_VERIFY = "_IndexRetryVerify";
    public static final String INDEX_REBUILD_DISABLE_LOGGING_VERIFY_TYPE = "_IndexRebuildDisableLoggingVerifyType";
    public static final String INDEX_REBUILD_DISABLE_LOGGING_BEYOND_MAXLOOKBACK_AGE = "_IndexRebuildDisableLoggingBeyondMaxLookbackAge";
    @Deprecated
    public static final String LOCAL_INDEX_FILTER = "_LocalIndexFilter";
    @Deprecated
    public static final String LOCAL_INDEX_LIMIT = "_LocalIndexLimit";
    @Deprecated
    public static final String LOCAL_INDEX_FILTER_STR = "_LocalIndexFilterStr";
    public static final String INDEX_FILTER = "_IndexFilter";
    public static final String INDEX_LIMIT = "_IndexLimit";
    public static final String INDEX_FILTER_STR = "_IndexFilterStr";
    public static final String JSON_VALUE_FUNCTION = "_JsonValueFunction";
    public static final String JSON_QUERY_FUNCTION = "_JsonQueryFunction";
    public static final String BSON_VALUE_FUNCTION = "_BsonValueFunction";
    public static final String LOCAL_INDEX_BUILD_PROTO = "_LocalIndexBuild";
    public static final String LOCAL_INDEX_JOIN_SCHEMA = "_LocalIndexJoinSchema";
    public static final String DATA_TABLE_COLUMNS_TO_JOIN = "_DataTableColumnsToJoin";
    public static final String COLUMNS_STORED_IN_SINGLE_CELL = "_ColumnsStoredInSingleCell";
    public static final String VIEW_CONSTANTS = "_ViewConstants";
    public static final String EXPECTED_UPPER_REGION_KEY = "_ExpectedUpperRegionKey";
    public static final String REVERSE_SCAN = "_ReverseScan";
    public static final String ANALYZE_TABLE = "_ANALYZETABLE";
    public static final String REBUILD_INDEXES = "_RebuildIndexes";
    public static final String DO_TRANSFORMING = "_DoTransforming";
    public static final String TX_STATE = "_TxState";
    public static final String GUIDEPOST_WIDTH_BYTES = "_GUIDEPOST_WIDTH_BYTES";
    public static final String GUIDEPOST_PER_REGION = "_GUIDEPOST_PER_REGION";
    public static final String UPGRADE_DESC_ROW_KEY = "_UPGRADE_DESC_ROW_KEY";
    public static final String SCAN_REGION_SERVER = "_SCAN_REGION_SERVER";
    public static final String RUN_UPDATE_STATS_ASYNC_ATTRIB = "_RunUpdateStatsAsync";
    public static final String SKIP_REGION_BOUNDARY_CHECK = "_SKIP_REGION_BOUNDARY_CHECK";
    public static final String TX_SCN = "_TxScn";
    public static final String TTL = "_TTL";
    public static final String IS_STRICT_TTL = "_IS_STRICT_TTL";
    public static final String SCAN_ACTUAL_START_ROW = "_ScanActualStartRow";
    public static final String REPLAY_WRITES = "_IGNORE_NEWER_MUTATIONS";
    public static final String SCAN_OFFSET = "_RowOffset";
    public static final String SCAN_START_ROW_SUFFIX = "_ScanStartRowSuffix";
    public static final String SCAN_STOP_ROW_SUFFIX = "_ScanStopRowSuffix";
    public static final String MIN_QUALIFIER = "_MinQualifier";
    public static final String MAX_QUALIFIER = "_MaxQualifier";
    public static final String USE_NEW_VALUE_COLUMN_QUALIFIER = "_UseNewValueColumnQualifier";
    public static final String QUALIFIER_ENCODING_SCHEME = "_QualifierEncodingScheme";
    public static final String IMMUTABLE_STORAGE_ENCODING_SCHEME = "_ImmutableStorageEncodingScheme";
    public static final String USE_ENCODED_COLUMN_QUALIFIER_LIST = "_UseEncodedColumnQualifierList";
    public static final String CLIENT_VERSION = "_ClientVersion";
    public static final String CHECK_VERIFY_COLUMN = "_CheckVerifyColumn";
    public static final String PHYSICAL_DATA_TABLE_NAME = "_PhysicalDataTableName";
    public static final String EMPTY_COLUMN_FAMILY_NAME = "_EmptyCFName";
    public static final String EMPTY_COLUMN_QUALIFIER_NAME = "_EmptyCQName";
    public static final String INDEX_ROW_KEY = "_IndexRowKey";
    public static final String READ_REPAIR_TRANSFORMING_TABLE = "_ReadRepairTransformingTable";
    public static final String CDC_DATA_TABLE_DEF = "_CdcDataTableDef";
    public static final String SCAN_ANALYZE_ACTUAL_START_ROW = "_ScanAnalyzeActualStartRow";
    public static final String SCAN_ANALYZE_ACTUAL_STOP_ROW = "_ScanAnalyzeActualStopRow";
    public static final String SCAN_ANALYZE_INCLUDE_START_ROW = "_ScanAnalyzeIncludeStartRow";
    public static final String SCAN_ANALYZE_INCLUDE_STOP_ROW = "_ScanAnalyzeIncludeStopRow";
    public static final String SCAN_SERVER_RETURN_VALID_ROW_KEY = "_ScanServerValidRowKey";
    public static final byte[] REPLAY_TABLE_AND_INDEX_WRITES = PUnsignedTinyint.INSTANCE.toBytes(1);
    public static final byte[] REPLAY_ONLY_INDEX_WRITES = PUnsignedTinyint.INSTANCE.toBytes(2);
    public static final byte[] REPLAY_INDEX_REBUILD_WRITES = PUnsignedTinyint.INSTANCE.toBytes(3);
    public static final String PHOENIX_MAX_LOOKBACK_AGE_CONF_KEY = "phoenix.max.lookback.age.seconds";
    public static final int DEFAULT_PHOENIX_MAX_LOOKBACK_AGE = 0;
    public static final String CUSTOM_ANNOTATIONS = "_Annot";
    public static final String SCANNER_OPENED_TRACE_INFO = "Scanner opened on server";

    public static long getMaxLookbackInMillis(Configuration conf) {
        return conf.getLong(PHOENIX_MAX_LOOKBACK_AGE_CONF_KEY, 0L) * 1000L;
    }

    public static enum ReplayWrite {
        TABLE_AND_INDEX,
        INDEX_ONLY,
        REBUILD_INDEX_ONLY;


        public static ReplayWrite fromBytes(byte[] replayWriteBytes) {
            if (replayWriteBytes == null) {
                return null;
            }
            if (Bytes.compareTo((byte[])REPLAY_TABLE_AND_INDEX_WRITES, (byte[])replayWriteBytes) == 0) {
                return TABLE_AND_INDEX;
            }
            if (Bytes.compareTo((byte[])REPLAY_ONLY_INDEX_WRITES, (byte[])replayWriteBytes) == 0) {
                return INDEX_ONLY;
            }
            if (Bytes.compareTo((byte[])REPLAY_INDEX_REBUILD_WRITES, (byte[])replayWriteBytes) == 0) {
                return REBUILD_INDEX_ONLY;
            }
            throw new IllegalArgumentException("Unknown ReplayWrite code of " + Bytes.toStringBinary((byte[])replayWriteBytes));
        }
    }
}

