/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.compile;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import org.apache.phoenix.compile.FromCompiler;
import org.apache.phoenix.compile.StatementContext;
import org.apache.phoenix.parse.AliasedNode;
import org.apache.phoenix.parse.ColumnParseNode;
import org.apache.phoenix.parse.FamilyWildcardParseNode;
import org.apache.phoenix.parse.OrderByNode;
import org.apache.phoenix.parse.ParseNode;
import org.apache.phoenix.parse.ParseNodeFactory;
import org.apache.phoenix.parse.SelectStatement;
import org.apache.phoenix.parse.StatelessTraverseAllParseNodeVisitor;
import org.apache.phoenix.parse.TableName;
import org.apache.phoenix.parse.WildcardParseNode;
import org.apache.phoenix.query.QueryConstants;
import org.apache.phoenix.schema.ColumnFamilyNotFoundException;
import org.apache.phoenix.schema.ColumnNotFoundException;
import org.apache.phoenix.schema.ColumnRef;
import org.apache.phoenix.schema.IndexUncoveredDataColumnRef;
import org.apache.phoenix.schema.PColumn;
import org.apache.phoenix.schema.PName;
import org.apache.phoenix.schema.PNameFactory;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.PTableImpl;
import org.apache.phoenix.schema.PTableType;
import org.apache.phoenix.schema.ProjectedColumn;
import org.apache.phoenix.schema.SaltingUtil;
import org.apache.phoenix.schema.TableRef;
import org.apache.phoenix.thirdparty.com.google.common.base.Preconditions;
import org.apache.phoenix.thirdparty.com.google.common.collect.ImmutableList;
import org.apache.phoenix.util.EncodedColumnsUtil;
import org.apache.phoenix.util.IndexUtil;
import org.apache.phoenix.util.SchemaUtil;

public class TupleProjectionCompiler {
    public static final PName PROJECTED_TABLE_SCHEMA = PNameFactory.newName(".");
    public static final EnumSet<PTableType> PROJECTED_TABLE_TYPES = EnumSet.of(PTableType.TABLE, PTableType.INDEX, PTableType.VIEW, PTableType.CDC);
    private static final ParseNodeFactory NODE_FACTORY = new ParseNodeFactory();

    public static PTable createProjectedTable(SelectStatement select, StatementContext context) throws SQLException {
        int position;
        Preconditions.checkArgument((!select.isJoin() ? 1 : 0) != 0);
        if (select.getInnerSelectStatement() != null || select.getFrom() == null || select.isAggregate() || select.isDistinct() || !PROJECTED_TABLE_TYPES.contains((Object)context.getResolver().getTables().get(0).getTable().getType())) {
            return null;
        }
        ArrayList<PColumn> projectedColumns = new ArrayList<PColumn>();
        boolean isWildcard = false;
        HashSet<String> families = new HashSet<String>();
        ColumnRefVisitor visitor = new ColumnRefVisitor(context);
        TableRef tableRef = context.getCurrentTable();
        PTable table = tableRef.getTable();
        for (AliasedNode aliasedNode : select.getSelect()) {
            ParseNode node = aliasedNode.getNode();
            if (node instanceof WildcardParseNode) {
                if (((WildcardParseNode)node).isRewrite()) {
                    TableRef parentTableRef = FromCompiler.getResolver(NODE_FACTORY.namedTable(null, TableName.create(table.getSchemaName().getString(), table.getParentTableName().getString())), context.getConnection()).resolveTable(table.getSchemaName().getString(), table.getParentTableName().getString());
                    for (PColumn pColumn : parentTableRef.getTable().getColumns()) {
                        if (pColumn == SaltingUtil.SALTING_COLUMN) continue;
                        NODE_FACTORY.column(null, '\"' + IndexUtil.getIndexColumnName(pColumn) + '\"', null).accept(visitor);
                    }
                }
                isWildcard = true;
                continue;
            }
            if (node instanceof FamilyWildcardParseNode) {
                FamilyWildcardParseNode familyWildcardNode = (FamilyWildcardParseNode)node;
                String familyName = familyWildcardNode.getName();
                if (familyWildcardNode.isRewrite()) {
                    TableRef tableRef2 = FromCompiler.getResolver(NODE_FACTORY.namedTable(null, TableName.create(table.getSchemaName().getString(), table.getParentTableName().getString())), context.getConnection()).resolveTable(table.getSchemaName().getString(), table.getParentTableName().getString());
                    for (PColumn column3 : tableRef2.getTable().getColumnFamily(familyName).getColumns()) {
                        NODE_FACTORY.column(null, '\"' + IndexUtil.getIndexColumnName(column3) + '\"', null).accept(visitor);
                    }
                } else {
                    for (PColumn column4 : table.getColumnFamily(familyName).getColumns()) {
                        NODE_FACTORY.column(TableName.create(null, familyName), '\"' + column4.getName().getString() + '\"', null).accept(visitor);
                    }
                }
                families.add(familyName);
                continue;
            }
            node.accept(visitor);
        }
        if (!isWildcard) {
            for (OrderByNode orderBy : select.getOrderBy()) {
                orderBy.getNode().accept(visitor);
            }
        }
        boolean hasSaltingColumn = table.getBucketNum() != null;
        for (int i = position = hasSaltingColumn ? 1 : 0; i < table.getPKColumns().size(); ++i) {
            PColumn sourceColumn = table.getPKColumns().get(i);
            ColumnRef sourceColumnRef = new ColumnRef(tableRef, sourceColumn.getPosition());
            ProjectedColumn projectedColumn = new ProjectedColumn(sourceColumn.getName(), sourceColumn.getFamilyName(), position++, sourceColumn.isNullable(), sourceColumnRef, null);
            projectedColumns.add(projectedColumn);
        }
        ArrayList nonPkColumnRefList = new ArrayList(visitor.nonPkColumnRefSet);
        for (PColumn sourceColumn : table.getColumns()) {
            if (SchemaUtil.isPKColumn(sourceColumn)) continue;
            ColumnRef columnRef = new ColumnRef(tableRef, sourceColumn.getPosition());
            if (!isWildcard && !visitor.nonPkColumnRefSet.contains(columnRef) && !families.contains(sourceColumn.getFamilyName().getString())) continue;
            ProjectedColumn column = new ProjectedColumn(sourceColumn.getName(), sourceColumn.getFamilyName(), visitor.nonPkColumnRefSet.contains(columnRef) ? position + nonPkColumnRefList.indexOf(columnRef) : position++, sourceColumn.isNullable(), columnRef, sourceColumn.getColumnQualifierBytes());
            projectedColumns.add(column);
            if (isWildcard || families.contains(sourceColumn.getFamilyName().toString())) continue;
            EncodedColumnsUtil.setColumns(column, table, context.getScan());
        }
        position = projectedColumns.size() + (hasSaltingColumn ? 1 : 0);
        for (ColumnRef sourceColumnRef : visitor.indexColumnRefSet) {
            ProjectedColumn projectedColumn = new ProjectedColumn(sourceColumnRef.getColumn().getName(), sourceColumnRef.getColumn().getFamilyName(), position++, sourceColumnRef.getColumn().isNullable(), sourceColumnRef, sourceColumnRef.getColumn().getColumnQualifierBytes());
            projectedColumns.add(projectedColumn);
        }
        if (!visitor.indexColumnRefSet.isEmpty() && tableRef.isHinted()) {
            context.setUncoveredIndex(true);
        }
        return PTableImpl.builderWithColumns(table, projectedColumns).setType(PTableType.PROJECTED).setBaseColumnCount(-1).setExcludedColumns((List<PColumn>)ImmutableList.of()).setPhysicalNames((List<PName>)ImmutableList.of()).build();
    }

    public static PTable createProjectedTable(TableRef tableRef, List<ColumnRef> sourceColumnRefs, boolean retainPKColumns) throws SQLException {
        int i;
        PTable table = tableRef.getTable();
        ArrayList<PColumn> projectedColumns = new ArrayList<PColumn>();
        int position = table.getBucketNum() != null ? 1 : 0;
        int n = i = retainPKColumns ? position : 0;
        while (i < sourceColumnRefs.size()) {
            String aliasedName;
            ColumnRef sourceColumnRef = sourceColumnRefs.get(i);
            PColumn sourceColumn = sourceColumnRef.getColumn();
            String colName = sourceColumn.getName().getString();
            String string = aliasedName = tableRef.getTableAlias() == null ? SchemaUtil.getColumnName(table.getName().getString(), colName) : SchemaUtil.getColumnName(tableRef.getTableAlias(), colName);
            PName familyName = SchemaUtil.isPKColumn(sourceColumn) ? (retainPKColumns ? null : PNameFactory.newName(QueryConstants.VALUE_COLUMN_FAMILY)) : sourceColumn.getFamilyName();
            ProjectedColumn column = new ProjectedColumn(PNameFactory.newName(aliasedName), familyName, position++, sourceColumn.isNullable(), sourceColumnRef, sourceColumn.getColumnQualifierBytes());
            projectedColumns.add(column);
            ++i;
        }
        PTable.EncodedCQCounter cqCounter = PTable.EncodedCQCounter.NULL_COUNTER;
        if (EncodedColumnsUtil.usesEncodedColumnNames(table)) {
            cqCounter = PTable.EncodedCQCounter.copy(table.getEncodedCQCounter());
        }
        return new PTableImpl.Builder().setType(PTableType.PROJECTED).setTimeStamp(table.getTimeStamp()).setIndexDisableTimestamp(table.getIndexDisableTimestamp()).setSequenceNumber(table.getSequenceNumber()).setImmutableRows(table.isImmutableRows()).setDisableWAL(table.isWALDisabled()).setMultiTenant(table.isMultiTenant()).setStoreNulls(table.getStoreNulls()).setViewType(table.getViewType()).setViewIndexIdType(table.getviewIndexIdType()).setViewIndexId(table.getViewIndexId()).setTransactionProvider(table.getTransactionProvider()).setUpdateCacheFrequency(table.getUpdateCacheFrequency()).setNamespaceMapped(table.isNamespaceMapped()).setAutoPartitionSeqName(table.getAutoPartitionSeqName()).setAppendOnlySchema(table.isAppendOnlySchema()).setImmutableStorageScheme(table.getImmutableStorageScheme()).setQualifierEncodingScheme(table.getEncodingScheme()).setBaseColumnCount(-1).setEncodedCQCounter(cqCounter).setUseStatsForParallelization(table.useStatsForParallelization()).setExcludedColumns((List<PColumn>)ImmutableList.of()).setTenantId(table.getTenantId()).setSchemaName(PROJECTED_TABLE_SCHEMA).setTableName(table.getTableName()).setPkName(table.getPKName()).setRowKeyOrderOptimizable(table.rowKeyOrderOptimizable()).setBucketNum(table.getBucketNum()).setIndexes(Collections.emptyList()).setPhysicalNames((List<PName>)ImmutableList.of()).setColumns(projectedColumns).build();
    }

    private static class ColumnRefVisitor
    extends StatelessTraverseAllParseNodeVisitor {
        private final StatementContext context;
        private final LinkedHashSet<ColumnRef> nonPkColumnRefSet;
        private final LinkedHashSet<IndexUncoveredDataColumnRef> indexColumnRefSet;

        private ColumnRefVisitor(StatementContext context) {
            this.context = context;
            this.nonPkColumnRefSet = new LinkedHashSet();
            this.indexColumnRefSet = new LinkedHashSet();
        }

        @Override
        public Void visit(ColumnParseNode node) throws SQLException {
            try {
                ColumnRef resolveColumn = this.context.getResolver().resolveColumn(node.getSchemaName(), node.getTableName(), node.getName());
                if (!SchemaUtil.isPKColumn(resolveColumn.getColumn())) {
                    this.nonPkColumnRefSet.add(resolveColumn);
                }
            }
            catch (ColumnNotFoundException e) {
                if (IndexUtil.shouldIndexBeUsedForUncoveredQuery(this.context.getCurrentTable())) {
                    try {
                        this.context.setUncoveredIndex(true);
                        this.indexColumnRefSet.add(new IndexUncoveredDataColumnRef(this.context, this.context.getCurrentTable(), node.getName()));
                    }
                    catch (ColumnFamilyNotFoundException c) {
                        throw e;
                    }
                }
                throw e;
            }
            return null;
        }
    }
}

