/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.compile;

import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.phoenix.compile.ColumnResolver;
import org.apache.phoenix.compile.FromCompiler;
import org.apache.phoenix.compile.LimitCompiler;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.parse.AliasedNode;
import org.apache.phoenix.parse.ColumnParseNode;
import org.apache.phoenix.parse.DerivedTableNode;
import org.apache.phoenix.parse.FamilyWildcardParseNode;
import org.apache.phoenix.parse.HintNode;
import org.apache.phoenix.parse.LimitNode;
import org.apache.phoenix.parse.OffsetNode;
import org.apache.phoenix.parse.OrderByNode;
import org.apache.phoenix.parse.ParseNode;
import org.apache.phoenix.parse.ParseNodeFactory;
import org.apache.phoenix.parse.ParseNodeRewriter;
import org.apache.phoenix.parse.SelectStatement;
import org.apache.phoenix.parse.TableNode;
import org.apache.phoenix.parse.TableWildcardParseNode;
import org.apache.phoenix.parse.WildcardParseNode;
import org.apache.phoenix.thirdparty.com.google.common.collect.Lists;
import org.apache.phoenix.util.ParseNodeUtil;
import org.apache.phoenix.util.SchemaUtil;

public class SubselectRewriter
extends ParseNodeRewriter {
    private final String tableAlias;
    private final Map<String, ParseNode> aliasMap;
    private boolean removeAlias = false;

    public static SelectStatement applyPreFiltersForSubselect(SelectStatement subselectStatement, List<ParseNode> preFilterParseNodes, String subselectAlias) {
        if (preFilterParseNodes.isEmpty()) {
            return subselectStatement;
        }
        assert (SubselectRewriter.isFilterCanPushDownToSelect(subselectStatement));
        ArrayList newFilterParseNodes = Lists.newArrayList(preFilterParseNodes);
        if (subselectStatement.getGroupBy().isEmpty()) {
            ParseNode where = subselectStatement.getWhere();
            if (where != null) {
                newFilterParseNodes.add(where);
            }
            return NODE_FACTORY.select(subselectStatement, SubselectRewriter.combine(newFilterParseNodes));
        }
        ParseNode having = subselectStatement.getHaving();
        if (having != null) {
            newFilterParseNodes.add(having);
        }
        return NODE_FACTORY.select(subselectStatement, subselectStatement.getWhere(), SubselectRewriter.combine(newFilterParseNodes));
    }

    public static ParseNode rewritePreFilterForSubselect(ParseNode preFilterParseNode, SelectStatement subselectStatement, String subselectAlias) throws SQLException {
        SubselectRewriter subselectRewriter = new SubselectRewriter(null, subselectStatement.getSelect(), subselectAlias);
        return preFilterParseNode.accept(subselectRewriter);
    }

    public static boolean isFilterCanPushDownToSelect(SelectStatement statement) {
        return statement.getLimit() == null && (!statement.isAggregate() || !statement.getGroupBy().isEmpty());
    }

    public static SelectStatement applyOrderByAndPostFilters(SelectStatement subselectStatement, List<OrderByNode> orderByNodes, String subselectTableAliasName, List<ParseNode> postFilterParseNodes) throws SQLException {
        if (orderByNodes == null) {
            orderByNodes = Collections.emptyList();
        }
        if (postFilterParseNodes == null) {
            postFilterParseNodes = Collections.emptyList();
        }
        if (orderByNodes.isEmpty() && postFilterParseNodes.isEmpty()) {
            return subselectStatement;
        }
        List<AliasedNode> subselectAliasedNodes = subselectStatement.getSelect();
        ArrayList<AliasedNode> newOuterSelectAliasedNodes = new ArrayList<AliasedNode>(subselectAliasedNodes.size());
        HashMap<String, ParseNode> subselectAliasFullNameToNewColumnParseNode = new HashMap<String, ParseNode>();
        String newSubselectTableAliasName = ParseNodeFactory.createTempAlias();
        ArrayList<AliasedNode> newSubselectAliasedNodes = null;
        int index = 0;
        for (AliasedNode subselectAliasedNode : subselectAliasedNodes) {
            Object aliasName = subselectAliasedNode.getAlias();
            ParseNode aliasParseNode = subselectAliasedNode.getNode();
            if (aliasName == null) {
                aliasName = aliasParseNode.getAlias();
            }
            if (aliasName == null) {
                aliasName = ParseNodeFactory.createTempAlias();
                if (newSubselectAliasedNodes == null) {
                    newSubselectAliasedNodes = new ArrayList<AliasedNode>(subselectAliasedNodes.size());
                    if (index > 0) {
                        newSubselectAliasedNodes.addAll(subselectAliasedNodes.subList(0, index));
                    }
                }
                newSubselectAliasedNodes.add(NODE_FACTORY.aliasedNode((String)aliasName, aliasParseNode));
            } else if (newSubselectAliasedNodes != null) {
                newSubselectAliasedNodes.add(subselectAliasedNode);
            }
            ColumnParseNode newColumnParseNode = NODE_FACTORY.column(NODE_FACTORY.table(null, newSubselectTableAliasName), (String)aliasName, (String)aliasName);
            subselectAliasFullNameToNewColumnParseNode.put(SchemaUtil.getColumnName(subselectTableAliasName, SchemaUtil.normalizeIdentifier((String)aliasName)), newColumnParseNode);
            AliasedNode newOuterSelectAliasNode = NODE_FACTORY.aliasedNode((String)aliasName, newColumnParseNode);
            newOuterSelectAliasedNodes.add(newOuterSelectAliasNode);
            ++index;
        }
        SubselectRewriter subselectRewriter = new SubselectRewriter(subselectAliasFullNameToNewColumnParseNode);
        ArrayList<OrderByNode> rewrittenOrderByNodes = null;
        if (orderByNodes.size() > 0) {
            rewrittenOrderByNodes = new ArrayList<OrderByNode>(orderByNodes.size());
            for (OrderByNode orderByNode : orderByNodes) {
                ParseNode parseNode = orderByNode.getNode();
                rewrittenOrderByNodes.add(NODE_FACTORY.orderBy(parseNode.accept(subselectRewriter), orderByNode.isNullsLast(), orderByNode.isAscending()));
            }
        }
        ParseNode newWhereParseNode = null;
        if (postFilterParseNodes.size() > 0) {
            ArrayList<ParseNode> rewrittenPostFilterParseNodes = new ArrayList<ParseNode>(postFilterParseNodes.size());
            for (ParseNode postFilterParseNode : postFilterParseNodes) {
                rewrittenPostFilterParseNodes.add(postFilterParseNode.accept(subselectRewriter));
            }
            newWhereParseNode = SubselectRewriter.combine(rewrittenPostFilterParseNodes);
        }
        SelectStatement subselectStatementToUse = subselectStatement;
        if (newSubselectAliasedNodes != null) {
            subselectStatementToUse = NODE_FACTORY.select(subselectStatement, subselectStatement.isDistinct(), newSubselectAliasedNodes);
        }
        return NODE_FACTORY.select(NODE_FACTORY.derivedTable(newSubselectTableAliasName, subselectStatementToUse), HintNode.EMPTY_HINT_NODE, false, newOuterSelectAliasedNodes, newWhereParseNode, null, null, rewrittenOrderByNodes, null, null, 0, false, subselectStatementToUse.hasSequence(), Collections.emptyList(), subselectStatementToUse.getUdfParseNodes());
    }

    private static SelectStatement pruneInnerSubselectAliasedNodes(SelectStatement selectStatement, PhoenixConnection pheonixConnection) throws SQLException {
        TableNode fromTableNode = selectStatement.getFrom();
        if (fromTableNode == null || !(fromTableNode instanceof DerivedTableNode)) {
            return selectStatement;
        }
        DerivedTableNode derivedTableNode = (DerivedTableNode)fromTableNode;
        SelectStatement subSelectStatement = derivedTableNode.getSelect();
        if (subSelectStatement.isUnion()) {
            return selectStatement;
        }
        Set<String> referencedColumnNames = ParseNodeUtil.collectReferencedColumnNamesForSingleTable(selectStatement);
        SelectStatement newSubselectStatement = SubselectRewriter.pruneSelectAliasedNodes(subSelectStatement, referencedColumnNames, pheonixConnection);
        if (newSubselectStatement != subSelectStatement) {
            return NODE_FACTORY.select(selectStatement, NODE_FACTORY.derivedTable(derivedTableNode.getAlias(), newSubselectStatement));
        }
        return selectStatement;
    }

    public static SelectStatement pruneSelectAliasedNodes(SelectStatement selectStatement, Set<String> referencedColumnNames, PhoenixConnection phoenixConnection) throws SQLException {
        if (referencedColumnNames == null || referencedColumnNames.isEmpty()) {
            return selectStatement;
        }
        if (selectStatement.isDistinct()) {
            return selectStatement;
        }
        selectStatement = ParseNodeRewriter.resolveInternalAlias(selectStatement, phoenixConnection);
        List<AliasedNode> selectAliasedNodes = selectStatement.getSelect();
        ArrayList<AliasedNode> newSelectAliasedNodes = new ArrayList<AliasedNode>(selectAliasedNodes.size());
        for (AliasedNode selectAliasedNode : selectAliasedNodes) {
            String aliasName = selectAliasedNode.getAlias();
            ParseNode aliasParseNode = selectAliasedNode.getNode();
            if (aliasParseNode instanceof WildcardParseNode || aliasParseNode instanceof TableWildcardParseNode || aliasParseNode instanceof FamilyWildcardParseNode) {
                throw new SQLFeatureNotSupportedException("Wildcard in subqueries not supported.");
            }
            if (aliasName == null) {
                aliasName = aliasParseNode.getAlias();
            }
            if (aliasName == null || !referencedColumnNames.contains(aliasName = SchemaUtil.normalizeIdentifier(aliasName))) continue;
            newSelectAliasedNodes.add(selectAliasedNode);
        }
        if (newSelectAliasedNodes.isEmpty() || newSelectAliasedNodes.equals(selectAliasedNodes)) {
            return selectStatement;
        }
        return NODE_FACTORY.select(selectStatement, selectStatement.isDistinct(), newSelectAliasedNodes);
    }

    public static SelectStatement flatten(SelectStatement select, PhoenixConnection connection) throws SQLException {
        ColumnResolver resolver;
        SubselectRewriter rewriter;
        SelectStatement ret;
        DerivedTableNode derivedTable;
        SelectStatement subselect;
        TableNode from = select.getFrom();
        while (from != null && from instanceof DerivedTableNode && !(subselect = (derivedTable = (DerivedTableNode)from).getSelect()).isUnion() && (ret = (rewriter = new SubselectRewriter(resolver = FromCompiler.getResolverForQuery(subselect, connection), subselect.getSelect(), derivedTable.getAlias())).flatten(select, subselect)) != select) {
            select = ret;
            from = select.getFrom();
        }
        return SubselectRewriter.pruneInnerSubselectAliasedNodes(select, connection);
    }

    private SubselectRewriter(ColumnResolver resolver, List<AliasedNode> aliasedNodes, String tableAlias) {
        super(resolver, aliasedNodes.size());
        this.tableAlias = tableAlias;
        this.aliasMap = new HashMap<String, ParseNode>();
        for (AliasedNode aliasedNode : aliasedNodes) {
            String alias = aliasedNode.getAlias();
            ParseNode node = aliasedNode.getNode();
            if (alias == null) {
                alias = SchemaUtil.normalizeIdentifier(node.getAlias());
            }
            if (alias == null) continue;
            this.aliasMap.put(SchemaUtil.getColumnName(tableAlias, alias), node);
        }
    }

    private SubselectRewriter(Map<String, ParseNode> selectAliasFullNameToAliasParseNode) {
        super(null, selectAliasFullNameToAliasParseNode.size());
        this.tableAlias = null;
        this.aliasMap = selectAliasFullNameToAliasParseNode;
    }

    private SelectStatement removeOuterSelectStatementOrderByIfNecessary(SelectStatement outerSelectStatement, SelectStatement innerSelectStatement) throws SQLException {
        if (outerSelectStatement.isDistinct() || outerSelectStatement.isAggregate() || outerSelectStatement.getGroupBy() != null && !outerSelectStatement.getGroupBy().isEmpty() || outerSelectStatement.isJoin() || outerSelectStatement.isUnion()) {
            return outerSelectStatement;
        }
        List<OrderByNode> outerOrderByNodes = outerSelectStatement.getOrderBy();
        if (outerOrderByNodes == null || outerOrderByNodes.isEmpty()) {
            return outerSelectStatement;
        }
        if (this.isOuterOrderByNodesPrefixOfInner(innerSelectStatement.getOrderBy(), outerOrderByNodes)) {
            return NODE_FACTORY.select(outerSelectStatement, (List<OrderByNode>)null);
        }
        return outerSelectStatement;
    }

    private boolean isOuterOrderByNodesPrefixOfInner(List<OrderByNode> innerOrderByNodes, List<OrderByNode> outerOrderByNodes) throws SQLException {
        assert (outerOrderByNodes != null && outerOrderByNodes.size() > 0);
        if (innerOrderByNodes == null || outerOrderByNodes.size() > innerOrderByNodes.size()) {
            return false;
        }
        Iterator<OrderByNode> innerOrderByNodeIter = innerOrderByNodes.iterator();
        for (OrderByNode outerOrderByNode : outerOrderByNodes) {
            ParseNode outerOrderByParseNode = outerOrderByNode.getNode();
            OrderByNode rewrittenOuterOrderByNode = NODE_FACTORY.orderBy(outerOrderByParseNode.accept(this), outerOrderByNode.isNullsLast(), outerOrderByNode.isAscending());
            assert (innerOrderByNodeIter.hasNext());
            OrderByNode innerOrderByNode = innerOrderByNodeIter.next();
            if (innerOrderByNode.equals(rewrittenOuterOrderByNode)) continue;
            return false;
        }
        return true;
    }

    private SelectStatement flatten(SelectStatement select, SelectStatement subselect) throws SQLException {
        HintNode hint;
        List<ParseNode> groupBy;
        subselect = ParseNodeRewriter.rewrite(subselect, (ParseNodeRewriter)this);
        ParseNode whereRewrite = subselect.getWhere();
        ArrayList groupByRewrite = subselect.getGroupBy();
        ParseNode havingRewrite = subselect.getHaving();
        ArrayList orderByRewrite = subselect.getOrderBy();
        LimitNode limitRewrite = subselect.getLimit();
        OffsetNode offsetRewrite = subselect.getOffset();
        HintNode hintRewrite = subselect.getHint();
        boolean isDistinctRewrite = subselect.isDistinct();
        boolean isAggregateRewrite = subselect.isAggregate();
        ParseNode where = select.getWhere();
        if (where != null) {
            if (subselect.getLimit() != null || subselect.isAggregate() && subselect.getGroupBy().isEmpty()) {
                return this.removeOuterSelectStatementOrderByIfNecessary(select, subselect);
            }
            ParseNode postFilter = where.accept(this);
            if (subselect.getGroupBy().isEmpty()) {
                whereRewrite = whereRewrite == null ? postFilter : NODE_FACTORY.and(Arrays.asList(whereRewrite, postFilter));
            } else {
                ParseNode parseNode = havingRewrite = havingRewrite == null ? postFilter : NODE_FACTORY.and(Arrays.asList(havingRewrite, postFilter));
            }
        }
        if (select.isDistinct()) {
            if (subselect.getLimit() != null || subselect.isAggregate() || subselect.isDistinct()) {
                return this.removeOuterSelectStatementOrderByIfNecessary(select, subselect);
            }
            isDistinctRewrite = true;
            orderByRewrite = null;
        }
        if (select.isAggregate()) {
            if (subselect.getLimit() != null || subselect.isAggregate() || subselect.isDistinct()) {
                return this.removeOuterSelectStatementOrderByIfNecessary(select, subselect);
            }
            isAggregateRewrite = true;
            orderByRewrite = null;
        }
        if (!(groupBy = select.getGroupBy()).isEmpty()) {
            if (subselect.getLimit() != null || subselect.isAggregate() || subselect.isDistinct()) {
                return this.removeOuterSelectStatementOrderByIfNecessary(select, subselect);
            }
            groupByRewrite = Lists.newArrayListWithExpectedSize((int)groupBy.size());
            for (ParseNode node : groupBy) {
                groupByRewrite.add(node.accept(this));
            }
            if (select.getHaving() != null) {
                havingRewrite = select.getHaving().accept(this);
            }
            orderByRewrite = null;
        }
        List<AliasedNode> selectNodes = select.getSelect();
        ArrayList selectNodesRewrite = Lists.newArrayListWithExpectedSize((int)selectNodes.size());
        for (AliasedNode aliasedNode : selectNodes) {
            ParseNode node = aliasedNode.getNode();
            if (node instanceof WildcardParseNode || node instanceof TableWildcardParseNode && ((TableWildcardParseNode)node).getTableName().toString().equals(this.tableAlias)) {
                for (AliasedNode aNode : subselect.getSelect()) {
                    String alias = aNode.getAlias();
                    String aliasRewrite = alias == null ? null : SchemaUtil.getColumnName(this.tableAlias, alias);
                    selectNodesRewrite.add(NODE_FACTORY.aliasedNode(aliasRewrite, aNode.getNode()));
                }
                continue;
            }
            selectNodesRewrite.add(NODE_FACTORY.aliasedNode(aliasedNode.getAlias(), node.accept(this)));
        }
        List<OrderByNode> orderBy = select.getOrderBy();
        if (!orderBy.isEmpty()) {
            if (subselect.getLimit() != null) {
                return this.removeOuterSelectStatementOrderByIfNecessary(select, subselect);
            }
            orderByRewrite = Lists.newArrayListWithExpectedSize((int)orderBy.size());
            for (OrderByNode orderByNode : orderBy) {
                ParseNode node = orderByNode.getNode();
                orderByRewrite.add(NODE_FACTORY.orderBy(node.accept(this), orderByNode.isNullsLast(), orderByNode.isAscending()));
            }
        }
        OffsetNode offsetNode = select.getOffset();
        if (offsetRewrite != null || limitRewrite != null && offsetNode != null) {
            return this.removeOuterSelectStatementOrderByIfNecessary(select, subselect);
        }
        offsetRewrite = offsetNode;
        LimitNode limit = select.getLimit();
        if (limit != null) {
            if (limitRewrite == null) {
                limitRewrite = limit;
            } else {
                Integer limitValue = LimitCompiler.compile(null, select);
                Integer limitValueSubselect = LimitCompiler.compile(null, subselect);
                if (limitValue != null && limitValueSubselect != null) {
                    limitRewrite = limitValue < limitValueSubselect ? limit : limitRewrite;
                } else {
                    return this.removeOuterSelectStatementOrderByIfNecessary(select, subselect);
                }
            }
        }
        if ((hint = select.getHint()) != null) {
            hintRewrite = hintRewrite == null ? hint : HintNode.combine(hint, hintRewrite);
        }
        SelectStatement stmt = NODE_FACTORY.select(subselect.getFrom(), hintRewrite, isDistinctRewrite, selectNodesRewrite, whereRewrite, groupByRewrite, havingRewrite, orderByRewrite, limitRewrite, offsetRewrite, select.getBindCount(), isAggregateRewrite, select.hasSequence(), select.getSelects(), select.getUdfParseNodes());
        if (this.tableAlias != null) {
            this.removeAlias = true;
            stmt = ParseNodeRewriter.rewrite(stmt, (ParseNodeRewriter)this);
        }
        return stmt;
    }

    @Override
    public ParseNode visit(ColumnParseNode node) throws SQLException {
        if (node.getTableName() == null) {
            return super.visit(node);
        }
        if (this.removeAlias) {
            if (node.getTableName().equals(this.tableAlias)) {
                return NODE_FACTORY.column(null, node.getName(), node.getAlias());
            }
            return super.visit(node);
        }
        ParseNode aliasedNode = this.aliasMap.get(node.getFullName());
        if (aliasedNode != null) {
            return aliasedNode;
        }
        return node;
    }

    private static ParseNode combine(List<ParseNode> nodes) {
        if (nodes.isEmpty()) {
            return null;
        }
        if (nodes.size() == 1) {
            return nodes.get(0);
        }
        return NODE_FACTORY.and(nodes);
    }
}

