/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.compile;

import java.sql.SQLException;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.compile.MutationPlan;
import org.apache.phoenix.compile.ServerBuildIndexCompiler;
import org.apache.phoenix.coprocessorclient.MetaDataProtocol;
import org.apache.phoenix.execute.BaseQueryPlan;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.jdbc.PhoenixStatement;
import org.apache.phoenix.schema.PColumnFamily;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.TableRef;
import org.apache.phoenix.schema.transform.TransformMaintainer;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.util.ByteUtil;
import org.apache.phoenix.util.EncodedColumnsUtil;
import org.apache.phoenix.util.ScanUtil;
import org.apache.phoenix.util.SchemaUtil;

public class ServerBuildTransformingTableCompiler
extends ServerBuildIndexCompiler {
    public ServerBuildTransformingTableCompiler(PhoenixConnection connection, String tableName) {
        super(connection, tableName);
    }

    @Override
    public MutationPlan compile(PTable newTable) throws SQLException {
        try (PhoenixStatement statement = new PhoenixStatement(this.connection);){
            String query = "SELECT /*+ NO_INDEX */ count(*) FROM " + this.tableName;
            this.plan = statement.compileQuery(query);
            TableRef tableRef = this.plan.getTableRef();
            Scan scan = this.plan.getContext().getScan();
            ImmutableBytesWritable ptr = new ImmutableBytesWritable();
            this.dataTable = tableRef.getTable();
            for (PColumnFamily family : this.dataTable.getColumnFamilies()) {
                scan.addFamily(family.getName().getBytes());
            }
            scan.setAttribute("_DoTransforming", PDataType.TRUE_BYTES);
            TransformMaintainer.serialize(this.dataTable, ptr, newTable, this.plan.getContext().getConnection());
            ScanUtil.annotateScanWithMetadataAttributes(this.dataTable, scan);
            scan.setAttribute("IdxProtoMD", ByteUtil.copyKeyBytesIfNecessary(ptr));
            scan.setAttribute("_RebuildIndexes", PDataType.TRUE_BYTES);
            ScanUtil.setClientVersion(scan, MetaDataProtocol.PHOENIX_VERSION);
            scan.setAttribute("_IndexRebuildPaging", PDataType.TRUE_BYTES);
            String rebuildPageRowSize = this.connection.getQueryServices().getProps().get("phoenix.index.rebuild_page_size_in_rows");
            if (rebuildPageRowSize != null) {
                scan.setAttribute("_IndexRebuildPageRows", Bytes.toBytes((long)Long.valueOf(rebuildPageRowSize)));
            }
            BaseQueryPlan.serializeViewConstantsIntoScan(scan, this.dataTable);
            PTable.QualifierEncodingScheme encodingScheme = newTable.getEncodingScheme();
            ScanUtil.addEmptyColumnToScan(scan, SchemaUtil.getEmptyColumnFamily(newTable), (byte[])EncodedColumnsUtil.getEmptyKeyValueInfo(encodingScheme).getFirst());
            if (this.dataTable.isTransactional()) {
                scan.setAttribute("_TxState", this.connection.getMutationState().encodeTransaction());
            }
            ServerBuildIndexCompiler.RowCountMutationPlan rowCountMutationPlan = new ServerBuildIndexCompiler.RowCountMutationPlan(this.plan.getContext(), PhoenixStatement.Operation.UPSERT);
            return rowCountMutationPlan;
        }
    }
}

