/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.compile;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.phoenix.compile.ColumnProjector;
import org.apache.phoenix.compile.ExpressionProjector;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.visitor.CloneExpressionVisitor;
import org.apache.phoenix.schema.ColumnNotFoundException;
import org.apache.phoenix.thirdparty.com.google.common.collect.ArrayListMultimap;
import org.apache.phoenix.thirdparty.com.google.common.collect.ListMultimap;
import org.apache.phoenix.util.SchemaUtil;

public class RowProjector {
    public static final RowProjector EMPTY_PROJECTOR = new RowProjector(Collections.emptyList(), 0, true);
    private final List<? extends ColumnProjector> columnProjectors;
    private final ListMultimap<String, Integer> reverseIndex;
    private final boolean allCaseSensitive;
    private final boolean someCaseSensitive;
    private final int estimatedSize;
    private final boolean isProjectAll;
    private final boolean isProjectEmptyKeyValue;
    private final boolean cloneRequired;
    private final boolean hasUDFs;
    private final boolean isProjectDynColsInWildcardQueries;

    public RowProjector(RowProjector projector, boolean isProjectEmptyKeyValue) {
        this(projector.getColumnProjectors(), projector.getEstimatedRowByteSize(), isProjectEmptyKeyValue, projector.hasUDFs, projector.isProjectAll, projector.isProjectDynColsInWildcardQueries);
    }

    public RowProjector(List<? extends ColumnProjector> columnProjectors, int estimatedRowSize, boolean isProjectEmptyKeyValue) {
        this(columnProjectors, estimatedRowSize, isProjectEmptyKeyValue, false, false, false);
    }

    public RowProjector(List<? extends ColumnProjector> columnProjectors, int estimatedRowSize, boolean isProjectEmptyKeyValue, boolean hasUDFs, boolean isProjectAll, boolean isProjectDynColsInWildcardQueries) {
        this.columnProjectors = Collections.unmodifiableList(columnProjectors);
        int position = columnProjectors.size();
        this.reverseIndex = ArrayListMultimap.create();
        boolean allCaseSensitive = true;
        boolean someCaseSensitive = false;
        --position;
        while (position >= 0) {
            ColumnProjector colProjector = columnProjectors.get(position);
            allCaseSensitive &= colProjector.isCaseSensitive();
            someCaseSensitive |= colProjector.isCaseSensitive();
            this.reverseIndex.put((Object)colProjector.getLabel(), (Object)position);
            if (!colProjector.getTableName().isEmpty()) {
                this.reverseIndex.put((Object)SchemaUtil.getColumnName(colProjector.getTableName(), colProjector.getLabel()), (Object)position);
            }
            --position;
        }
        this.allCaseSensitive = allCaseSensitive;
        this.someCaseSensitive = someCaseSensitive;
        this.estimatedSize = estimatedRowSize;
        this.isProjectEmptyKeyValue = isProjectEmptyKeyValue;
        this.isProjectAll = isProjectAll;
        this.hasUDFs = hasUDFs;
        boolean cloneRequired = false;
        if (!hasUDFs) {
            for (int i = 0; i < this.columnProjectors.size(); ++i) {
                Expression expression = this.columnProjectors.get(i).getExpression();
                if (!expression.isCloneExpression()) continue;
                cloneRequired = true;
                break;
            }
        }
        this.cloneRequired = cloneRequired || hasUDFs;
        this.isProjectDynColsInWildcardQueries = isProjectDynColsInWildcardQueries;
    }

    public RowProjector cloneIfNecessary() {
        if (!this.cloneRequired) {
            return this;
        }
        ArrayList<ColumnProjector> clonedColProjectors = new ArrayList<ColumnProjector>(this.columnProjectors.size());
        for (int i = 0; i < this.columnProjectors.size(); ++i) {
            ColumnProjector colProjector = this.columnProjectors.get(i);
            Expression expression = colProjector.getExpression();
            if (expression.isCloneExpression()) {
                CloneExpressionVisitor visitor = new CloneExpressionVisitor();
                Expression clonedExpression = expression.accept(visitor);
                clonedColProjectors.add(new ExpressionProjector(colProjector.getName(), colProjector.getLabel(), colProjector.getTableName(), clonedExpression, colProjector.isCaseSensitive()));
                continue;
            }
            clonedColProjectors.add(colProjector);
        }
        return new RowProjector(clonedColProjectors, this.estimatedSize, this.isProjectEmptyKeyValue, this.hasUDFs, this.isProjectAll, this.isProjectDynColsInWildcardQueries);
    }

    public boolean projectEveryRow() {
        return this.isProjectEmptyKeyValue;
    }

    public boolean projectEverything() {
        return this.isProjectAll;
    }

    public boolean hasUDFs() {
        return this.hasUDFs;
    }

    public boolean projectDynColsInWildcardQueries() {
        return this.isProjectDynColsInWildcardQueries;
    }

    public List<? extends ColumnProjector> getColumnProjectors() {
        return this.columnProjectors;
    }

    public int getColumnIndex(String name) throws SQLException {
        List index;
        if (!this.someCaseSensitive) {
            name = SchemaUtil.normalizeIdentifier(name);
        }
        if ((index = this.reverseIndex.get((Object)name)).isEmpty()) {
            if (!this.allCaseSensitive && this.someCaseSensitive) {
                name = SchemaUtil.normalizeIdentifier(name);
                index = this.reverseIndex.get((Object)name);
            }
            if (index.isEmpty()) {
                throw new ColumnNotFoundException(name);
            }
        }
        return (Integer)index.get(0);
    }

    public ColumnProjector getColumnProjector(int index) {
        return this.columnProjectors.get(index);
    }

    public int getColumnCount() {
        return this.columnProjectors.size();
    }

    public String toString() {
        StringBuilder buf = new StringBuilder("[");
        for (ColumnProjector columnProjector : this.columnProjectors) {
            buf.append(columnProjector.getExpression());
            buf.append(',');
        }
        if (buf.length() > 1) {
            buf.setLength(buf.length() - 1);
        }
        buf.append(']');
        return buf.toString();
    }

    public int getEstimatedRowByteSize() {
        return this.estimatedSize;
    }

    public void reset() {
        for (ColumnProjector columnProjector : this.columnProjectors) {
            columnProjector.getExpression().reset();
        }
    }
}

