/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.compile;

import java.sql.SQLException;
import java.util.List;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.phoenix.compile.ExplainPlanAttributes;
import org.apache.phoenix.compile.QueryPlan;
import org.apache.phoenix.compile.StatementContext;
import org.apache.phoenix.execute.MutationState;
import org.apache.phoenix.iterate.ParallelIteratorFactory;
import org.apache.phoenix.iterate.PeekingResultIterator;
import org.apache.phoenix.iterate.ResultIterator;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.query.QueryConstants;
import org.apache.phoenix.schema.tuple.SingleKeyValueTuple;
import org.apache.phoenix.schema.tuple.Tuple;
import org.apache.phoenix.schema.types.PLong;
import org.apache.phoenix.util.PhoenixKeyValueUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MutatingParallelIteratorFactory
implements ParallelIteratorFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(MutatingParallelIteratorFactory.class);
    protected final PhoenixConnection connection;

    protected MutatingParallelIteratorFactory(PhoenixConnection connection) {
        this.connection = connection;
    }

    protected abstract MutationState mutate(StatementContext var1, ResultIterator var2, PhoenixConnection var3) throws SQLException;

    @Override
    public PeekingResultIterator newIterator(StatementContext parentContext, ResultIterator iterator, Scan scan, String tableName, QueryPlan plan) throws SQLException {
        final PhoenixConnection clonedConnection = new PhoenixConnection(this.connection);
        this.connection.addChildConnection(clonedConnection);
        try {
            boolean autoFlush;
            MutationState state = this.mutate(parentContext, iterator, clonedConnection);
            long totalRowCount = state.getUpdateCount();
            boolean bl = autoFlush = this.connection.getAutoCommit() || plan.getTableRef().getTable().isTransactional();
            if (autoFlush) {
                clonedConnection.getMutationState().join(state);
                state = clonedConnection.getMutationState();
            }
            final MutationState finalState = state;
            byte[] value = PLong.INSTANCE.toBytes(totalRowCount);
            Cell keyValue = PhoenixKeyValueUtil.newKeyValue(QueryConstants.UNGROUPED_AGG_ROW_KEY, QueryConstants.SINGLE_COLUMN_FAMILY, QueryConstants.SINGLE_COLUMN, Long.MAX_VALUE, value, 0, value.length);
            final SingleKeyValueTuple tuple = new SingleKeyValueTuple(keyValue);
            return new PeekingResultIterator(){
                private boolean done = false;

                @Override
                public Tuple next() {
                    if (this.done) {
                        return null;
                    }
                    this.done = true;
                    return tuple;
                }

                @Override
                public void explain(List<String> planSteps) {
                }

                @Override
                public void explain(List<String> planSteps, ExplainPlanAttributes.ExplainPlanAttributesBuilder explainPlanAttributesBuilder) {
                }

                @Override
                public void close() throws SQLException {
                    try {
                        MutatingParallelIteratorFactory.this.connection.getMutationState().join(finalState);
                    }
                    finally {
                        MutatingParallelIteratorFactory.this.connection.removeChildConnection(clonedConnection);
                        clonedConnection.close();
                    }
                }

                @Override
                public Tuple peek() {
                    return this.done ? null : tuple;
                }
            };
        }
        catch (Throwable ex) {
            try {
                this.connection.removeChildConnection(clonedConnection);
                clonedConnection.close();
            }
            catch (SQLException sqlEx) {
                LOGGER.error("Closing cloned Phoenix connection inside iterator, failed with: ", (Throwable)sqlEx);
            }
            throw ex;
        }
    }
}

