/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.compile;

import java.sql.SQLException;
import java.util.Map;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.phoenix.compile.ColumnResolver;
import org.apache.phoenix.parse.ColumnParseNode;
import org.apache.phoenix.parse.FamilyWildcardParseNode;
import org.apache.phoenix.parse.LiteralParseNode;
import org.apache.phoenix.parse.ParseNode;
import org.apache.phoenix.parse.ParseNodeFactory;
import org.apache.phoenix.parse.ParseNodeRewriter;
import org.apache.phoenix.parse.SelectStatement;
import org.apache.phoenix.parse.TableName;
import org.apache.phoenix.parse.TableWildcardParseNode;
import org.apache.phoenix.parse.WildcardParseNode;
import org.apache.phoenix.schema.ColumnRef;
import org.apache.phoenix.schema.PColumn;
import org.apache.phoenix.schema.TableRef;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.util.IndexUtil;

public class IndexStatementRewriter
extends ParseNodeRewriter {
    private static final ParseNodeFactory FACTORY = new ParseNodeFactory();
    private Map<TableRef, TableRef> multiTableRewriteMap;
    private final ImmutableBytesWritable ptr = new ImmutableBytesWritable();
    private final boolean setTableAlias;

    public IndexStatementRewriter(ColumnResolver dataResolver, Map<TableRef, TableRef> multiTableRewriteMap, boolean setTableAlias) {
        super(dataResolver);
        this.multiTableRewriteMap = multiTableRewriteMap;
        this.setTableAlias = setTableAlias;
    }

    public static ParseNode translate(ParseNode node, ColumnResolver dataResolver) throws SQLException {
        return IndexStatementRewriter.rewrite(node, (ParseNodeRewriter)new IndexStatementRewriter(dataResolver, null, false));
    }

    public static SelectStatement translate(SelectStatement statement, ColumnResolver dataResolver) throws SQLException {
        return IndexStatementRewriter.translate(statement, dataResolver, null);
    }

    public static SelectStatement translate(SelectStatement statement, ColumnResolver dataResolver, Map<TableRef, TableRef> multiTableRewriteMap) throws SQLException {
        return IndexStatementRewriter.rewrite(statement, (ParseNodeRewriter)new IndexStatementRewriter(dataResolver, multiTableRewriteMap, false));
    }

    @Override
    public ParseNode visit(ColumnParseNode node) throws SQLException {
        ColumnRef dataColRef = this.getResolver().resolveColumn(node.getSchemaName(), node.getTableName(), node.getName());
        PColumn dataCol = dataColRef.getColumn();
        TableRef dataTableRef = dataColRef.getTableRef();
        if (dataCol.getViewConstant() != null) {
            byte[] viewConstant = dataCol.getViewConstant();
            this.ptr.set(viewConstant, 0, viewConstant.length - 1);
            Object literal = dataCol.getDataType().toObject(this.ptr, dataCol.getSortOrder());
            return new LiteralParseNode(literal, dataCol.getDataType());
        }
        TableName tName = this.getReplacedTableName(dataTableRef);
        if (this.multiTableRewriteMap != null && tName == null) {
            return node;
        }
        String indexColName = IndexUtil.getIndexColumnName(dataCol);
        ParseNode indexColNode = new ColumnParseNode(tName, '\"' + indexColName + '\"', node.getAlias());
        PDataType indexColType = IndexUtil.getIndexColumnDataType(dataCol);
        PDataType dataColType = dataColRef.getColumn().getDataType();
        if (!this.isTopLevel() && indexColType != dataColType) {
            indexColNode = FACTORY.cast(indexColNode, dataColType, null, null);
        }
        return indexColNode;
    }

    @Override
    public ParseNode visit(WildcardParseNode node) throws SQLException {
        return this.multiTableRewriteMap != null ? node : WildcardParseNode.REWRITE_INSTANCE;
    }

    @Override
    public ParseNode visit(TableWildcardParseNode node) throws SQLException {
        TableName tName = this.getReplacedTableName(this.getResolver().resolveTable(node.getTableName().getSchemaName(), node.getTableName().getTableName()));
        return tName == null ? node : TableWildcardParseNode.create(tName, true);
    }

    @Override
    public ParseNode visit(FamilyWildcardParseNode node) throws SQLException {
        return this.multiTableRewriteMap != null ? node : new FamilyWildcardParseNode(node, true);
    }

    private TableName getReplacedTableName(TableRef origRef) {
        if (this.setTableAlias && origRef.getTableAlias() != null) {
            return TableName.create(null, origRef.getTableAlias());
        }
        if (this.multiTableRewriteMap == null) {
            return null;
        }
        TableRef tableRef = this.multiTableRewriteMap.get(origRef);
        if (tableRef == null) {
            return null;
        }
        if (origRef.getTableAlias() != null) {
            return TableName.create(null, origRef.getTableAlias());
        }
        String schemaName = tableRef.getTable().getSchemaName().getString();
        return TableName.create(schemaName.length() == 0 ? null : schemaName, tableRef.getTable().getTableName().getString());
    }
}

