/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.compile;

import java.util.List;
import java.util.Set;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.client.Consistency;
import org.apache.phoenix.parse.HintNode;
import org.apache.phoenix.schema.PColumn;

public class ExplainPlanAttributes {
    private final String abstractExplainPlan;
    private final Integer splitsChunk;
    private final Long estimatedRows;
    private final Long estimatedSizeInBytes;
    private final String iteratorTypeAndScanSize;
    private final Double samplingRate;
    private final boolean useRoundRobinIterator;
    private final String hexStringRVCOffset;
    private final Consistency consistency;
    private final HintNode.Hint hint;
    private final String serverSortedBy;
    private final String explainScanType;
    private final String tableName;
    private final String keyRanges;
    private final Long scanTimeRangeMin;
    private final Long scanTimeRangeMax;
    private final String serverWhereFilter;
    private final String serverDistinctFilter;
    private final Integer serverOffset;
    private final Long serverRowLimit;
    private final boolean serverArrayElementProjection;
    private final String serverAggregate;
    private final String clientFilterBy;
    private final String clientAggregate;
    private final String clientSortedBy;
    private final String clientAfterAggregate;
    private final String clientDistinctFilter;
    private final Integer clientOffset;
    private final Integer clientRowLimit;
    private final Integer clientSequenceCount;
    private final String clientCursorName;
    private final String clientSortAlgo;
    private final ExplainPlanAttributes rhsJoinQueryExplainPlan;
    private final Set<PColumn> serverMergeColumns;
    private final List<HRegionLocation> regionLocations;
    private final int numRegionLocationLookups;
    private static final ExplainPlanAttributes EXPLAIN_PLAN_INSTANCE = new ExplainPlanAttributes();

    private ExplainPlanAttributes() {
        this.abstractExplainPlan = null;
        this.splitsChunk = null;
        this.estimatedRows = null;
        this.estimatedSizeInBytes = null;
        this.iteratorTypeAndScanSize = null;
        this.samplingRate = null;
        this.useRoundRobinIterator = false;
        this.hexStringRVCOffset = null;
        this.consistency = null;
        this.hint = null;
        this.serverSortedBy = null;
        this.explainScanType = null;
        this.tableName = null;
        this.keyRanges = null;
        this.scanTimeRangeMin = null;
        this.scanTimeRangeMax = null;
        this.serverWhereFilter = null;
        this.serverDistinctFilter = null;
        this.serverOffset = null;
        this.serverRowLimit = null;
        this.serverArrayElementProjection = false;
        this.serverAggregate = null;
        this.clientFilterBy = null;
        this.clientAggregate = null;
        this.clientSortedBy = null;
        this.clientAfterAggregate = null;
        this.clientDistinctFilter = null;
        this.clientOffset = null;
        this.clientRowLimit = null;
        this.clientSequenceCount = null;
        this.clientCursorName = null;
        this.clientSortAlgo = null;
        this.rhsJoinQueryExplainPlan = null;
        this.serverMergeColumns = null;
        this.regionLocations = null;
        this.numRegionLocationLookups = 0;
    }

    public ExplainPlanAttributes(String abstractExplainPlan, Integer splitsChunk, Long estimatedRows, Long estimatedSizeInBytes, String iteratorTypeAndScanSize, Double samplingRate, boolean useRoundRobinIterator, String hexStringRVCOffset, Consistency consistency, HintNode.Hint hint, String serverSortedBy, String explainScanType, String tableName, String keyRanges, Long scanTimeRangeMin, Long scanTimeRangeMax, String serverWhereFilter, String serverDistinctFilter, Integer serverOffset, Long serverRowLimit, boolean serverArrayElementProjection, String serverAggregate, String clientFilterBy, String clientAggregate, String clientSortedBy, String clientAfterAggregate, String clientDistinctFilter, Integer clientOffset, Integer clientRowLimit, Integer clientSequenceCount, String clientCursorName, String clientSortAlgo, ExplainPlanAttributes rhsJoinQueryExplainPlan, Set<PColumn> serverMergeColumns, List<HRegionLocation> regionLocations, int numRegionLocationLookups) {
        this.abstractExplainPlan = abstractExplainPlan;
        this.splitsChunk = splitsChunk;
        this.estimatedRows = estimatedRows;
        this.estimatedSizeInBytes = estimatedSizeInBytes;
        this.iteratorTypeAndScanSize = iteratorTypeAndScanSize;
        this.samplingRate = samplingRate;
        this.useRoundRobinIterator = useRoundRobinIterator;
        this.hexStringRVCOffset = hexStringRVCOffset;
        this.consistency = consistency;
        this.hint = hint;
        this.serverSortedBy = serverSortedBy;
        this.explainScanType = explainScanType;
        this.tableName = tableName;
        this.keyRanges = keyRanges;
        this.scanTimeRangeMin = scanTimeRangeMin;
        this.scanTimeRangeMax = scanTimeRangeMax;
        this.serverWhereFilter = serverWhereFilter;
        this.serverDistinctFilter = serverDistinctFilter;
        this.serverOffset = serverOffset;
        this.serverRowLimit = serverRowLimit;
        this.serverArrayElementProjection = serverArrayElementProjection;
        this.serverAggregate = serverAggregate;
        this.clientFilterBy = clientFilterBy;
        this.clientAggregate = clientAggregate;
        this.clientSortedBy = clientSortedBy;
        this.clientAfterAggregate = clientAfterAggregate;
        this.clientDistinctFilter = clientDistinctFilter;
        this.clientOffset = clientOffset;
        this.clientRowLimit = clientRowLimit;
        this.clientSequenceCount = clientSequenceCount;
        this.clientCursorName = clientCursorName;
        this.clientSortAlgo = clientSortAlgo;
        this.rhsJoinQueryExplainPlan = rhsJoinQueryExplainPlan;
        this.serverMergeColumns = serverMergeColumns;
        this.regionLocations = regionLocations;
        this.numRegionLocationLookups = numRegionLocationLookups;
    }

    public String getAbstractExplainPlan() {
        return this.abstractExplainPlan;
    }

    public Integer getSplitsChunk() {
        return this.splitsChunk;
    }

    public Long getEstimatedRows() {
        return this.estimatedRows;
    }

    public Long getEstimatedSizeInBytes() {
        return this.estimatedSizeInBytes;
    }

    public String getIteratorTypeAndScanSize() {
        return this.iteratorTypeAndScanSize;
    }

    public Double getSamplingRate() {
        return this.samplingRate;
    }

    public boolean isUseRoundRobinIterator() {
        return this.useRoundRobinIterator;
    }

    public String getHexStringRVCOffset() {
        return this.hexStringRVCOffset;
    }

    public Consistency getConsistency() {
        return this.consistency;
    }

    public HintNode.Hint getHint() {
        return this.hint;
    }

    public String getServerSortedBy() {
        return this.serverSortedBy;
    }

    public String getExplainScanType() {
        return this.explainScanType;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getKeyRanges() {
        return this.keyRanges;
    }

    public Long getScanTimeRangeMin() {
        return this.scanTimeRangeMin;
    }

    public Long getScanTimeRangeMax() {
        return this.scanTimeRangeMax;
    }

    public String getServerWhereFilter() {
        return this.serverWhereFilter;
    }

    public String getServerDistinctFilter() {
        return this.serverDistinctFilter;
    }

    public Integer getServerOffset() {
        return this.serverOffset;
    }

    public Long getServerRowLimit() {
        return this.serverRowLimit;
    }

    public boolean isServerArrayElementProjection() {
        return this.serverArrayElementProjection;
    }

    public String getServerAggregate() {
        return this.serverAggregate;
    }

    public String getClientFilterBy() {
        return this.clientFilterBy;
    }

    public String getClientAggregate() {
        return this.clientAggregate;
    }

    public String getClientSortedBy() {
        return this.clientSortedBy;
    }

    public String getClientAfterAggregate() {
        return this.clientAfterAggregate;
    }

    public String getClientDistinctFilter() {
        return this.clientDistinctFilter;
    }

    public Integer getClientOffset() {
        return this.clientOffset;
    }

    public Integer getClientRowLimit() {
        return this.clientRowLimit;
    }

    public Integer getClientSequenceCount() {
        return this.clientSequenceCount;
    }

    public String getClientCursorName() {
        return this.clientCursorName;
    }

    public String getClientSortAlgo() {
        return this.clientSortAlgo;
    }

    public ExplainPlanAttributes getRhsJoinQueryExplainPlan() {
        return this.rhsJoinQueryExplainPlan;
    }

    public Set<PColumn> getServerMergeColumns() {
        return this.serverMergeColumns;
    }

    public List<HRegionLocation> getRegionLocations() {
        return this.regionLocations;
    }

    public int getNumRegionLocationLookups() {
        return this.numRegionLocationLookups;
    }

    public static ExplainPlanAttributes getDefaultExplainPlan() {
        return EXPLAIN_PLAN_INSTANCE;
    }

    public static class ExplainPlanAttributesBuilder {
        private String abstractExplainPlan;
        private Integer splitsChunk;
        private Long estimatedRows;
        private Long estimatedSizeInBytes;
        private String iteratorTypeAndScanSize;
        private Double samplingRate;
        private boolean useRoundRobinIterator;
        private String hexStringRVCOffset;
        private Consistency consistency;
        private HintNode.Hint hint;
        private String serverSortedBy;
        private String explainScanType;
        private String tableName;
        private String keyRanges;
        private Long scanTimeRangeMin;
        private Long scanTimeRangeMax;
        private String serverWhereFilter;
        private String serverDistinctFilter;
        private Integer serverOffset;
        private Long serverRowLimit;
        private boolean serverArrayElementProjection;
        private String serverAggregate;
        private String clientFilterBy;
        private String clientAggregate;
        private String clientSortedBy;
        private String clientAfterAggregate;
        private String clientDistinctFilter;
        private Integer clientOffset;
        private Integer clientRowLimit;
        private Integer clientSequenceCount;
        private String clientCursorName;
        private String clientSortAlgo;
        private ExplainPlanAttributes rhsJoinQueryExplainPlan;
        private Set<PColumn> serverMergeColumns;
        private List<HRegionLocation> regionLocations;
        private int numRegionLocationLookups;

        public ExplainPlanAttributesBuilder() {
        }

        public ExplainPlanAttributesBuilder(ExplainPlanAttributes explainPlanAttributes) {
            this.abstractExplainPlan = explainPlanAttributes.getAbstractExplainPlan();
            this.splitsChunk = explainPlanAttributes.getSplitsChunk();
            this.estimatedRows = explainPlanAttributes.getEstimatedRows();
            this.estimatedSizeInBytes = explainPlanAttributes.getEstimatedSizeInBytes();
            this.iteratorTypeAndScanSize = explainPlanAttributes.getIteratorTypeAndScanSize();
            this.samplingRate = explainPlanAttributes.getSamplingRate();
            this.useRoundRobinIterator = explainPlanAttributes.isUseRoundRobinIterator();
            this.hexStringRVCOffset = explainPlanAttributes.getHexStringRVCOffset();
            this.consistency = explainPlanAttributes.getConsistency();
            this.hint = explainPlanAttributes.getHint();
            this.serverSortedBy = explainPlanAttributes.getServerSortedBy();
            this.explainScanType = explainPlanAttributes.getExplainScanType();
            this.tableName = explainPlanAttributes.getTableName();
            this.keyRanges = explainPlanAttributes.getKeyRanges();
            this.scanTimeRangeMin = explainPlanAttributes.getScanTimeRangeMin();
            this.scanTimeRangeMax = explainPlanAttributes.getScanTimeRangeMax();
            this.serverWhereFilter = explainPlanAttributes.getServerWhereFilter();
            this.serverDistinctFilter = explainPlanAttributes.getServerDistinctFilter();
            this.serverOffset = explainPlanAttributes.getServerOffset();
            this.serverRowLimit = explainPlanAttributes.getServerRowLimit();
            this.serverArrayElementProjection = explainPlanAttributes.isServerArrayElementProjection();
            this.serverAggregate = explainPlanAttributes.getServerAggregate();
            this.clientFilterBy = explainPlanAttributes.getClientFilterBy();
            this.clientAggregate = explainPlanAttributes.getClientAggregate();
            this.clientSortedBy = explainPlanAttributes.getClientSortedBy();
            this.clientAfterAggregate = explainPlanAttributes.getClientAfterAggregate();
            this.clientDistinctFilter = explainPlanAttributes.getClientDistinctFilter();
            this.clientOffset = explainPlanAttributes.getClientOffset();
            this.clientRowLimit = explainPlanAttributes.getClientRowLimit();
            this.clientSequenceCount = explainPlanAttributes.getClientSequenceCount();
            this.clientCursorName = explainPlanAttributes.getClientCursorName();
            this.clientSortAlgo = explainPlanAttributes.getClientSortAlgo();
            this.rhsJoinQueryExplainPlan = explainPlanAttributes.getRhsJoinQueryExplainPlan();
            this.serverMergeColumns = explainPlanAttributes.getServerMergeColumns();
            this.regionLocations = explainPlanAttributes.getRegionLocations();
            this.numRegionLocationLookups = explainPlanAttributes.getNumRegionLocationLookups();
        }

        public ExplainPlanAttributesBuilder setAbstractExplainPlan(String abstractExplainPlan) {
            this.abstractExplainPlan = abstractExplainPlan;
            return this;
        }

        public ExplainPlanAttributesBuilder setSplitsChunk(Integer splitsChunk) {
            this.splitsChunk = splitsChunk;
            return this;
        }

        public ExplainPlanAttributesBuilder setEstimatedRows(Long estimatedRows) {
            this.estimatedRows = estimatedRows;
            return this;
        }

        public ExplainPlanAttributesBuilder setEstimatedSizeInBytes(Long estimatedSizeInBytes) {
            this.estimatedSizeInBytes = estimatedSizeInBytes;
            return this;
        }

        public ExplainPlanAttributesBuilder setIteratorTypeAndScanSize(String iteratorTypeAndScanSize) {
            this.iteratorTypeAndScanSize = iteratorTypeAndScanSize;
            return this;
        }

        public ExplainPlanAttributesBuilder setSamplingRate(Double samplingRate) {
            this.samplingRate = samplingRate;
            return this;
        }

        public ExplainPlanAttributesBuilder setUseRoundRobinIterator(boolean useRoundRobinIterator) {
            this.useRoundRobinIterator = useRoundRobinIterator;
            return this;
        }

        public ExplainPlanAttributesBuilder setHexStringRVCOffset(String hexStringRVCOffset) {
            this.hexStringRVCOffset = hexStringRVCOffset;
            return this;
        }

        public ExplainPlanAttributesBuilder setConsistency(Consistency consistency) {
            this.consistency = consistency;
            return this;
        }

        public ExplainPlanAttributesBuilder setHint(HintNode.Hint hint) {
            this.hint = hint;
            return this;
        }

        public ExplainPlanAttributesBuilder setServerSortedBy(String serverSortedBy) {
            this.serverSortedBy = serverSortedBy;
            return this;
        }

        public ExplainPlanAttributesBuilder setExplainScanType(String explainScanType) {
            this.explainScanType = explainScanType;
            return this;
        }

        public ExplainPlanAttributesBuilder setTableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public ExplainPlanAttributesBuilder setKeyRanges(String keyRanges) {
            this.keyRanges = keyRanges;
            return this;
        }

        public ExplainPlanAttributesBuilder setScanTimeRangeMin(Long scanTimeRangeMin) {
            this.scanTimeRangeMin = scanTimeRangeMin;
            return this;
        }

        public ExplainPlanAttributesBuilder setScanTimeRangeMax(Long scanTimeRangeMax) {
            this.scanTimeRangeMax = scanTimeRangeMax;
            return this;
        }

        public ExplainPlanAttributesBuilder setServerWhereFilter(String serverWhereFilter) {
            this.serverWhereFilter = serverWhereFilter;
            return this;
        }

        public ExplainPlanAttributesBuilder setServerDistinctFilter(String serverDistinctFilter) {
            this.serverDistinctFilter = serverDistinctFilter;
            return this;
        }

        public ExplainPlanAttributesBuilder setServerOffset(Integer serverOffset) {
            this.serverOffset = serverOffset;
            return this;
        }

        public ExplainPlanAttributesBuilder setServerRowLimit(Long serverRowLimit) {
            this.serverRowLimit = serverRowLimit;
            return this;
        }

        public ExplainPlanAttributesBuilder setServerArrayElementProjection(boolean serverArrayElementProjection) {
            this.serverArrayElementProjection = serverArrayElementProjection;
            return this;
        }

        public ExplainPlanAttributesBuilder setServerAggregate(String serverAggregate) {
            this.serverAggregate = serverAggregate;
            return this;
        }

        public ExplainPlanAttributesBuilder setClientFilterBy(String clientFilterBy) {
            this.clientFilterBy = clientFilterBy;
            return this;
        }

        public ExplainPlanAttributesBuilder setClientAggregate(String clientAggregate) {
            this.clientAggregate = clientAggregate;
            return this;
        }

        public ExplainPlanAttributesBuilder setClientSortedBy(String clientSortedBy) {
            this.clientSortedBy = clientSortedBy;
            return this;
        }

        public ExplainPlanAttributesBuilder setClientAfterAggregate(String clientAfterAggregate) {
            this.clientAfterAggregate = clientAfterAggregate;
            return this;
        }

        public ExplainPlanAttributesBuilder setClientDistinctFilter(String clientDistinctFilter) {
            this.clientDistinctFilter = clientDistinctFilter;
            return this;
        }

        public ExplainPlanAttributesBuilder setClientOffset(Integer clientOffset) {
            this.clientOffset = clientOffset;
            return this;
        }

        public ExplainPlanAttributesBuilder setClientRowLimit(Integer clientRowLimit) {
            this.clientRowLimit = clientRowLimit;
            return this;
        }

        public ExplainPlanAttributesBuilder setClientSequenceCount(Integer clientSequenceCount) {
            this.clientSequenceCount = clientSequenceCount;
            return this;
        }

        public ExplainPlanAttributesBuilder setClientCursorName(String clientCursorName) {
            this.clientCursorName = clientCursorName;
            return this;
        }

        public ExplainPlanAttributesBuilder setClientSortAlgo(String clientSortAlgo) {
            this.clientSortAlgo = clientSortAlgo;
            return this;
        }

        public ExplainPlanAttributesBuilder setRhsJoinQueryExplainPlan(ExplainPlanAttributes rhsJoinQueryExplainPlan) {
            this.rhsJoinQueryExplainPlan = rhsJoinQueryExplainPlan;
            return this;
        }

        public ExplainPlanAttributesBuilder setServerMergeColumns(Set<PColumn> columns) {
            this.serverMergeColumns = columns;
            return this;
        }

        public ExplainPlanAttributesBuilder setRegionLocations(List<HRegionLocation> regionLocations) {
            this.regionLocations = regionLocations;
            return this;
        }

        public ExplainPlanAttributesBuilder setNumRegionLocationLookups(int numRegionLocationLookups) {
            this.numRegionLocationLookups = numRegionLocationLookups;
            return this;
        }

        public ExplainPlanAttributes build() {
            return new ExplainPlanAttributes(this.abstractExplainPlan, this.splitsChunk, this.estimatedRows, this.estimatedSizeInBytes, this.iteratorTypeAndScanSize, this.samplingRate, this.useRoundRobinIterator, this.hexStringRVCOffset, this.consistency, this.hint, this.serverSortedBy, this.explainScanType, this.tableName, this.keyRanges, this.scanTimeRangeMin, this.scanTimeRangeMax, this.serverWhereFilter, this.serverDistinctFilter, this.serverOffset, this.serverRowLimit, this.serverArrayElementProjection, this.serverAggregate, this.clientFilterBy, this.clientAggregate, this.clientSortedBy, this.clientAfterAggregate, this.clientDistinctFilter, this.clientOffset, this.clientRowLimit, this.clientSequenceCount, this.clientCursorName, this.clientSortAlgo, this.rhsJoinQueryExplainPlan, this.serverMergeColumns, this.regionLocations, this.numRegionLocationLookups);
        }
    }
}

