/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.cache;

import java.io.Closeable;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collections;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.cache.TenantCache;
import org.apache.phoenix.coprocessorclient.ServerCachingProtocol;
import org.apache.phoenix.hbase.index.util.ImmutableBytesPtr;
import org.apache.phoenix.memory.MemoryManager;
import org.apache.phoenix.thirdparty.com.google.common.base.Ticker;
import org.apache.phoenix.thirdparty.com.google.common.cache.Cache;
import org.apache.phoenix.thirdparty.com.google.common.cache.CacheBuilder;
import org.apache.phoenix.thirdparty.com.google.common.cache.RemovalListener;
import org.apache.phoenix.thirdparty.com.google.common.cache.RemovalNotification;
import org.apache.phoenix.util.Closeables;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TenantCacheImpl
implements TenantCache {
    private static final Logger LOGGER = LoggerFactory.getLogger(TenantCacheImpl.class);
    private final int maxTimeToLiveMs;
    private final int maxPersistenceTimeToLiveMs;
    private final MemoryManager memoryManager;
    private final Ticker ticker;
    private volatile Cache<ImmutableBytesPtr, CacheEntry> serverCaches;
    private volatile Cache<ImmutableBytesPtr, CacheEntry> persistentServerCaches;
    private final long EVICTION_MARGIN_BYTES = 10000000L;

    public TenantCacheImpl(MemoryManager memoryManager, int maxTimeToLiveMs, int maxPersistenceTimeToLiveMs) {
        this(memoryManager, maxTimeToLiveMs, maxPersistenceTimeToLiveMs, Ticker.systemTicker());
    }

    public TenantCacheImpl(MemoryManager memoryManager, int maxTimeToLiveMs, int maxPersistenceTimeToLiveMs, Ticker ticker) {
        this.memoryManager = memoryManager;
        this.maxTimeToLiveMs = maxTimeToLiveMs;
        this.maxPersistenceTimeToLiveMs = maxPersistenceTimeToLiveMs;
        this.ticker = ticker;
    }

    public Ticker getTicker() {
        return this.ticker;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanUp() {
        TenantCacheImpl tenantCacheImpl = this;
        synchronized (tenantCacheImpl) {
            if (this.serverCaches != null) {
                this.serverCaches.cleanUp();
            }
            if (this.persistentServerCaches != null) {
                this.persistentServerCaches.cleanUp();
            }
        }
    }

    @Override
    public MemoryManager getMemoryManager() {
        return this.memoryManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Cache<ImmutableBytesPtr, CacheEntry> getServerCaches() {
        if (this.serverCaches == null) {
            TenantCacheImpl tenantCacheImpl = this;
            synchronized (tenantCacheImpl) {
                if (this.serverCaches == null) {
                    this.serverCaches = this.buildCache(this.maxTimeToLiveMs, false);
                }
            }
        }
        return this.serverCaches;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Cache<ImmutableBytesPtr, CacheEntry> getPersistentServerCaches() {
        if (this.persistentServerCaches == null) {
            TenantCacheImpl tenantCacheImpl = this;
            synchronized (tenantCacheImpl) {
                if (this.persistentServerCaches == null) {
                    this.persistentServerCaches = this.buildCache(this.maxPersistenceTimeToLiveMs, true);
                }
            }
        }
        return this.persistentServerCaches;
    }

    private Cache<ImmutableBytesPtr, CacheEntry> buildCache(int ttl, final boolean isPersistent) {
        CacheBuilder builder = CacheBuilder.newBuilder();
        if (isPersistent) {
            builder.expireAfterWrite((long)ttl, TimeUnit.MILLISECONDS);
        } else {
            builder.expireAfterAccess((long)ttl, TimeUnit.MILLISECONDS);
        }
        return builder.ticker(this.getTicker()).removalListener((RemovalListener)new RemovalListener<ImmutableBytesPtr, CacheEntry>(){

            public void onRemoval(RemovalNotification<ImmutableBytesPtr, CacheEntry> notification) {
                if (isPersistent || !((CacheEntry)notification.getValue()).getUsePersistentCache()) {
                    Closeables.closeAllQuietly(Collections.singletonList(notification.getValue()));
                }
            }
        }).build();
    }

    private synchronized void evictInactiveEntries(long bytesNeeded) {
        LOGGER.debug("Trying to evict inactive cache entries to free up " + bytesNeeded + " bytes");
        Object[] entries = this.getPersistentServerCaches().asMap().values().toArray(new CacheEntry[0]);
        Arrays.sort(entries);
        long available = this.getMemoryManager().getAvailableMemory();
        for (int i = 0; i < entries.length && available < bytesNeeded; ++i) {
            Object entry = entries[i];
            ImmutableBytesPtr cacheId = ((CacheEntry)entry).getCacheId();
            this.getPersistentServerCaches().invalidate((Object)cacheId);
            available = this.getMemoryManager().getAvailableMemory();
            LOGGER.debug("Evicted cache ID " + Bytes.toLong((byte[])cacheId.get()) + ", we now have " + available + " bytes available");
        }
    }

    private CacheEntry getIfPresent(ImmutableBytesPtr cacheId) {
        CacheEntry entry = (CacheEntry)this.getPersistentServerCaches().getIfPresent((Object)cacheId);
        if (entry != null) {
            return entry;
        }
        return (CacheEntry)this.getServerCaches().getIfPresent((Object)cacheId);
    }

    @Override
    public Closeable getServerCache(ImmutableBytesPtr cacheId) {
        this.getServerCaches().cleanUp();
        CacheEntry entry = this.getIfPresent(cacheId);
        if (entry == null) {
            return null;
        }
        return entry.closeable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Closeable addServerCache(ImmutableBytesPtr cacheId, ImmutableBytesWritable cachePtr, byte[] txState, ServerCachingProtocol.ServerCacheFactory cacheFactory, boolean useProtoForIndexMaintainer, boolean usePersistentCache, int clientVersion) throws SQLException {
        this.getServerCaches().cleanUp();
        long available = this.getMemoryManager().getAvailableMemory();
        int size = cachePtr.getLength() + txState.length;
        if ((long)size > available) {
            this.evictInactiveEntries((long)size - available + 10000000L);
        }
        MemoryManager.MemoryChunk chunk = this.getMemoryManager().allocate(size);
        boolean success = false;
        try {
            CacheEntry entry;
            Object object = this;
            synchronized (object) {
                entry = this.getIfPresent(cacheId);
                if (entry == null) {
                    entry = new CacheEntry(cacheId, cachePtr, cacheFactory, txState, chunk, usePersistentCache, useProtoForIndexMaintainer, clientVersion);
                    this.getServerCaches().put((Object)cacheId, (Object)entry);
                    if (usePersistentCache) {
                        this.getPersistentServerCaches().put((Object)cacheId, (Object)entry);
                    }
                }
                entry.incrementLiveQueryCount();
            }
            success = true;
            object = entry;
            return object;
        }
        finally {
            if (!success) {
                Closeables.closeAllQuietly(Collections.singletonList(chunk));
            }
        }
    }

    @Override
    public synchronized void removeServerCache(ImmutableBytesPtr cacheId) {
        CacheEntry entry = (CacheEntry)this.getServerCaches().getIfPresent((Object)cacheId);
        if (entry == null) {
            return;
        }
        entry.decrementLiveQueryCount();
        if (!entry.isLive()) {
            LOGGER.debug("Cache ID " + Bytes.toLong((byte[])cacheId.get()) + " is no longer live, invalidate it");
            this.getServerCaches().invalidate((Object)cacheId);
        }
    }

    @Override
    public void removeAllServerCache() {
        this.getServerCaches().invalidateAll();
        this.getPersistentServerCaches().invalidateAll();
    }

    private static class CacheEntry
    implements Comparable<CacheEntry>,
    Closeable {
        private ImmutableBytesPtr cacheId;
        private ImmutableBytesWritable cachePtr;
        private int hits;
        private int liveQueriesCount;
        private boolean usePersistentCache;
        private long size;
        private Closeable closeable;

        public CacheEntry(ImmutableBytesPtr cacheId, ImmutableBytesWritable cachePtr, ServerCachingProtocol.ServerCacheFactory cacheFactory, byte[] txState, MemoryManager.MemoryChunk chunk, boolean usePersistentCache, boolean useProtoForIndexMaintainer, int clientVersion) throws SQLException {
            this.cacheId = cacheId;
            this.cachePtr = cachePtr;
            this.size = cachePtr.getLength();
            this.hits = 0;
            this.liveQueriesCount = 0;
            this.usePersistentCache = usePersistentCache;
            this.closeable = cacheFactory.newCache(cachePtr, txState, chunk, useProtoForIndexMaintainer, clientVersion);
        }

        @Override
        public void close() throws IOException {
            this.closeable.close();
        }

        public synchronized void incrementLiveQueryCount() {
            ++this.liveQueriesCount;
            ++this.hits;
        }

        public synchronized void decrementLiveQueryCount() {
            --this.liveQueriesCount;
        }

        public synchronized boolean isLive() {
            return this.liveQueriesCount > 0;
        }

        public boolean getUsePersistentCache() {
            return this.usePersistentCache;
        }

        public ImmutableBytesPtr getCacheId() {
            return this.cacheId;
        }

        private Float rank() {
            return Float.valueOf(this.hits);
        }

        @Override
        public int compareTo(CacheEntry o) {
            return this.rank().compareTo(o.rank());
        }
    }
}

