/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.ipc.controller;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.ipc.DelegatingHBaseRpcController;
import org.apache.hadoop.hbase.ipc.HBaseRpcController;
import org.apache.phoenix.util.IndexUtil;

class IndexRpcController
extends DelegatingHBaseRpcController {
    private final int priority;
    private final String tracingTableName;

    public IndexRpcController(HBaseRpcController delegate, Configuration conf) {
        super(delegate);
        this.priority = IndexUtil.getIndexPriority(conf);
        this.tracingTableName = conf.get("phoenix.trace.statsTableName", "SYSTEM.TRACING_STATS");
    }

    public void setPriority(TableName tn) {
        if (!tn.isSystemTable() && !tn.getNameAsString().equals(this.tracingTableName)) {
            this.setPriority(this.priority);
        } else {
            super.setPriority(tn);
        }
    }
}

