/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.util;

import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.phoenix.execute.MutationState;

public class WALAnnotationUtil {
    public static void annotateMutation(Mutation m, byte[] externalSchemaId) {
        if (!m.getDurability().equals((Object)Durability.SKIP_WAL) && externalSchemaId != null) {
            m.setAttribute(MutationState.MutationMetadataType.EXTERNAL_SCHEMA_ID.toString(), externalSchemaId);
        }
    }

    public static void annotateMutation(Mutation m, byte[] tenantId, byte[] schemaName, byte[] logicalTableName, byte[] tableType, byte[] ddlTimestamp) {
        if (!m.getDurability().equals((Object)Durability.SKIP_WAL)) {
            if (tenantId != null) {
                m.setAttribute(MutationState.MutationMetadataType.TENANT_ID.toString(), tenantId);
            }
            m.setAttribute(MutationState.MutationMetadataType.SCHEMA_NAME.toString(), schemaName);
            m.setAttribute(MutationState.MutationMetadataType.LOGICAL_TABLE_NAME.toString(), logicalTableName);
            m.setAttribute(MutationState.MutationMetadataType.TABLE_TYPE.toString(), tableType);
            m.setAttribute(MutationState.MutationMetadataType.TIMESTAMP.toString(), ddlTimestamp);
        }
    }
}

