/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.util;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.CompareOperator;
import org.apache.hadoop.hbase.ExtendedCellBuilder;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.SingleColumnValueFilter;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.phoenix.compile.ColumnNameTrackingExpressionCompiler;
import org.apache.phoenix.coprocessorclient.MetaDataEndpointImplConstants;
import org.apache.phoenix.coprocessorclient.MetaDataProtocol;
import org.apache.phoenix.coprocessorclient.TableInfo;
import org.apache.phoenix.coprocessorclient.WhereConstantParser;
import org.apache.phoenix.index.IndexMaintainer;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.jdbc.PhoenixDatabaseMetaData;
import org.apache.phoenix.parse.ParseNode;
import org.apache.phoenix.parse.SQLParser;
import org.apache.phoenix.schema.ColumnNotFoundException;
import org.apache.phoenix.schema.PColumn;
import org.apache.phoenix.schema.PColumnImpl;
import org.apache.phoenix.schema.PName;
import org.apache.phoenix.schema.PNameFactory;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.PTableImpl;
import org.apache.phoenix.schema.PTableType;
import org.apache.phoenix.schema.SaltingUtil;
import org.apache.phoenix.schema.TableNotFoundException;
import org.apache.phoenix.schema.types.PBoolean;
import org.apache.phoenix.schema.types.PLong;
import org.apache.phoenix.schema.types.PSmallint;
import org.apache.phoenix.thirdparty.com.google.common.base.Objects;
import org.apache.phoenix.thirdparty.com.google.common.base.Preconditions;
import org.apache.phoenix.thirdparty.com.google.common.collect.ImmutableList;
import org.apache.phoenix.thirdparty.com.google.common.collect.Lists;
import org.apache.phoenix.thirdparty.com.google.common.collect.Maps;
import org.apache.phoenix.util.IndexUtil;
import org.apache.phoenix.util.MetaDataUtil;
import org.apache.phoenix.util.QueryUtil;
import org.apache.phoenix.util.ReadOnlyProps;
import org.apache.phoenix.util.SchemaUtil;
import org.apache.phoenix.util.TableViewFinderResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ViewUtil {
    private static final Logger logger = LoggerFactory.getLogger(ViewUtil.class);
    private static final byte[] LINK_ROW = new byte[]{PTable.LinkType.CHILD_TABLE.getSerializedValue()};

    public static Pair<List<PTable>, List<TableInfo>> findAllDescendantViews(Table sysCatOrsysChildLink, Configuration serverSideConfig, byte[] tenantId, byte[] schemaName, byte[] tableOrViewName, long clientTimeStamp, boolean findJustOneLegitimateChildView, boolean isServerConnection) throws IOException, SQLException {
        ArrayList<PTable> legitimateChildViews = new ArrayList<PTable>();
        ArrayList<TableInfo> orphanChildViews = new ArrayList<TableInfo>();
        return ViewUtil.findAllDescendantViews(sysCatOrsysChildLink, serverSideConfig, tenantId, schemaName, tableOrViewName, clientTimeStamp, legitimateChildViews, orphanChildViews, findJustOneLegitimateChildView, isServerConnection);
    }

    public static Pair<List<PTable>, List<TableInfo>> findAllDescendantViews(Table sysCatOrsysChildLink, Configuration serverSideConfig, byte[] parentTenantId, byte[] parentSchemaName, byte[] parentTableOrViewName, long clientTimeStamp, List<PTable> legitimateChildViews, List<TableInfo> orphanChildViews, boolean findJustOneLegitimateChildView, boolean isServerConnection) throws IOException, SQLException {
        return ViewUtil.findAllDescendantViews(sysCatOrsysChildLink, null, serverSideConfig, parentTenantId, parentSchemaName, parentTableOrViewName, clientTimeStamp, legitimateChildViews, orphanChildViews, findJustOneLegitimateChildView, (Pair<Boolean, Boolean>)new Pair((Object)false, (Object)false), isServerConnection);
    }

    public static Pair<List<PTable>, List<TableInfo>> findAllDescendantViews(Table sysCatOrsysChildLink, Table sysCat, Configuration serverSideConfig, byte[] parentTenantId, byte[] parentSchemaName, byte[] parentTableOrViewName, long clientTimeStamp, List<PTable> legitimateChildViews, List<TableInfo> orphanChildViews, boolean findJustOneLegitimateChildView, Pair<Boolean, Boolean> scanSysCatForTTLDefinedOnAnyChildPair, boolean isServerConnection) throws IOException, SQLException {
        TableViewFinderResult currentResult = ViewUtil.findImmediateRelatedViews(sysCatOrsysChildLink, sysCat, parentTenantId, parentSchemaName, parentTableOrViewName, PTable.LinkType.CHILD_TABLE, clientTimeStamp, scanSysCatForTTLDefinedOnAnyChildPair);
        for (TableInfo viewInfo : currentResult.getLinks()) {
            PTable view;
            byte[] viewTenantId = viewInfo.getTenantId();
            byte[] viewSchemaName = viewInfo.getSchemaName();
            byte[] viewName = viewInfo.getTableName();
            Properties props = new Properties();
            if (viewTenantId != null) {
                props.setProperty("TenantId", Bytes.toString((byte[])viewTenantId));
            }
            if (clientTimeStamp != Long.MAX_VALUE) {
                props.setProperty("CurrentSCN", Long.toString(clientTimeStamp));
            }
            PhoenixConnection connection = isServerConnection ? QueryUtil.getConnectionOnServer(props, serverSideConfig).unwrap(PhoenixConnection.class) : QueryUtil.getConnection(props, serverSideConfig).unwrap(PhoenixConnection.class);
            try {
                view = connection.getTableNoCache(SchemaUtil.getTableName(viewSchemaName, viewName));
            }
            catch (TableNotFoundException ex) {
                logger.error("Found an orphan parent->child link keyed by this parent. Parent Tenant Id: '" + Bytes.toString((byte[])parentTenantId) + "'. Parent Schema Name: '" + Bytes.toString((byte[])parentSchemaName) + "'. Parent Table/View Name: '" + Bytes.toString((byte[])parentTableOrViewName) + "'. The child view which could not be resolved has ViewInfo: '" + viewInfo + "'.", (Throwable)ex);
                orphanChildViews.add(viewInfo);
                if (connection == null) continue;
                connection.close();
                continue;
            }
            try {
                if (ViewUtil.isLegitimateChildView(view, parentSchemaName, parentTableOrViewName)) {
                    legitimateChildViews.add(view);
                    if (findJustOneLegitimateChildView) break;
                    ViewUtil.findAllDescendantViews(sysCatOrsysChildLink, sysCat, serverSideConfig, viewInfo.getTenantId(), viewInfo.getSchemaName(), viewInfo.getTableName(), clientTimeStamp, legitimateChildViews, orphanChildViews, findJustOneLegitimateChildView, scanSysCatForTTLDefinedOnAnyChildPair, isServerConnection);
                    continue;
                }
                logger.error("Found an orphan parent->child link keyed by this parent. Parent Tenant Id: '" + Bytes.toString((byte[])parentTenantId) + "'. Parent Schema Name: '" + Bytes.toString((byte[])parentSchemaName) + "'. Parent Table/View Name: '" + Bytes.toString((byte[])parentTableOrViewName) + "'. There currently exists a legitimate view of the same name which is not a descendant of this table/view. View Info: '" + viewInfo + "'. Ignoring this view and not counting it as a child view.");
            }
            finally {
                if (connection == null) continue;
                connection.close();
            }
        }
        return new Pair(legitimateChildViews, orphanChildViews);
    }

    private static boolean isLegitimateChildView(PTable view, byte[] parentSchemaName, byte[] parentTableOrViewName) {
        return view != null && view.getParentSchemaName() != null && view.getParentTableName() != null && Arrays.equals(view.getParentSchemaName().getBytes(), parentSchemaName) && Arrays.equals(view.getParentTableName().getBytes(), parentTableOrViewName);
    }

    public static void findAllRelatives(Table sysCatOrsysChildLink, byte[] tenantId, byte[] schema, byte[] table, PTable.LinkType linkType, TableViewFinderResult result) throws IOException {
        ViewUtil.findAllRelatives(sysCatOrsysChildLink, tenantId, schema, table, linkType, Long.MAX_VALUE, result);
    }

    private static void findAllRelatives(Table sysCatOrsysChildLink, byte[] tenantId, byte[] schema, byte[] table, PTable.LinkType linkType, long timestamp, TableViewFinderResult result) throws IOException {
        TableViewFinderResult currentResult = ViewUtil.findImmediateRelatedViews(sysCatOrsysChildLink, tenantId, schema, table, linkType, timestamp);
        result.addResult(currentResult);
        for (TableInfo viewInfo : currentResult.getLinks()) {
            ViewUtil.findAllRelatives(sysCatOrsysChildLink, viewInfo.getTenantId(), viewInfo.getSchemaName(), viewInfo.getTableName(), linkType, timestamp, result);
        }
    }

    static TableViewFinderResult findImmediateRelatedViews(Table sysCatOrsysChildLink, byte[] tenantId, byte[] schema, byte[] table, PTable.LinkType linkType, long timestamp) throws IOException {
        return ViewUtil.findImmediateRelatedViews(sysCatOrsysChildLink, null, tenantId, schema, table, linkType, timestamp, (Pair<Boolean, Boolean>)new Pair((Object)false, (Object)false));
    }

    private static TableViewFinderResult findImmediateRelatedViews(Table sysCatOrsysChildLink, @Nullable Table sysCat, byte[] tenantId, byte[] schema, byte[] table, PTable.LinkType linkType, long timestamp, Pair<Boolean, Boolean> scanSysCatForTTLDefinedOnAnyChildPair) throws IOException {
        if (linkType == PTable.LinkType.INDEX_TABLE || linkType == PTable.LinkType.EXCLUDED_COLUMN) {
            throw new IllegalArgumentException("findAllRelatives does not support link type " + linkType);
        }
        if (sysCat == null) {
            scanSysCatForTTLDefinedOnAnyChildPair.setFirst((Object)false);
        }
        byte[] key = SchemaUtil.getTableKey(tenantId, schema, table);
        Scan scan = MetaDataUtil.newTableRowsScan(key, 0L, timestamp);
        SingleColumnValueFilter linkFilter = new SingleColumnValueFilter(PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, PhoenixDatabaseMetaData.LINK_TYPE_BYTES, CompareOperator.EQUAL, linkType.getSerializedValueAsByteArray());
        linkFilter.setFilterIfMissing(true);
        scan.setFilter((Filter)linkFilter);
        scan.addColumn(PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, PhoenixDatabaseMetaData.LINK_TYPE_BYTES);
        if (linkType == PTable.LinkType.PARENT_TABLE) {
            scan.addColumn(PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, PhoenixDatabaseMetaData.PARENT_TENANT_ID_BYTES);
        }
        if (linkType == PTable.LinkType.PHYSICAL_TABLE) {
            scan.addColumn(PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, PhoenixDatabaseMetaData.TABLE_TYPE_BYTES);
        }
        ArrayList tableInfoList = Lists.newArrayList();
        try (ResultScanner scanner = sysCatOrsysChildLink.getScanner(scan);){
            Result result = scanner.next();
            while (result != null) {
                block19: {
                    byte[] viewKey;
                    Scan ttlScan;
                    Result ttlResult;
                    byte[] viewTenantId;
                    byte[][] rowKeyMetaData;
                    block16: {
                        block18: {
                            block17: {
                                block15: {
                                    rowKeyMetaData = new byte[5][];
                                    viewTenantId = null;
                                    SchemaUtil.getVarChars(result.getRow(), 5, rowKeyMetaData);
                                    if (linkType != PTable.LinkType.PARENT_TABLE) break block15;
                                    viewTenantId = result.getValue(PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, PhoenixDatabaseMetaData.PARENT_TENANT_ID_BYTES);
                                    break block16;
                                }
                                if (linkType != PTable.LinkType.CHILD_TABLE) break block17;
                                viewTenantId = rowKeyMetaData[3];
                                break block16;
                            }
                            if (linkType != PTable.LinkType.VIEW_INDEX_PARENT_TABLE) break block18;
                            viewTenantId = rowKeyMetaData[0];
                            break block16;
                        }
                        if (linkType == PTable.LinkType.PHYSICAL_TABLE && result.getValue(PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, PhoenixDatabaseMetaData.TABLE_TYPE_BYTES) != null) break block19;
                    }
                    byte[] viewSchemaName = SchemaUtil.getSchemaNameFromFullName(rowKeyMetaData[4]).getBytes(StandardCharsets.UTF_8);
                    byte[] viewName = SchemaUtil.getTableNameFromFullName(rowKeyMetaData[4]).getBytes(StandardCharsets.UTF_8);
                    tableInfoList.add(new TableInfo(viewTenantId, viewSchemaName, viewName));
                    if (((Boolean)scanSysCatForTTLDefinedOnAnyChildPair.getFirst()).booleanValue() && (ttlResult = sysCat.getScanner(ttlScan = MetaDataUtil.newTableRowsScan(viewKey = SchemaUtil.getTableKey(viewTenantId, viewSchemaName, viewName), 0L, timestamp)).next()) != null && ttlResult.getValue(PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, PhoenixDatabaseMetaData.TTL_BYTES) != null) {
                        scanSysCatForTTLDefinedOnAnyChildPair.setSecond((Object)true);
                        scanSysCatForTTLDefinedOnAnyChildPair.setFirst((Object)false);
                    }
                }
                result = scanner.next();
            }
            TableViewFinderResult tableViewFinderResult = new TableViewFinderResult(tableInfoList);
            return tableViewFinderResult;
        }
    }

    public static TableViewFinderResult findChildViews(PhoenixConnection connection, String tenantId, String schema, String tableName) throws IOException, SQLException {
        TableViewFinderResult childViewsResult = new TableViewFinderResult();
        ReadOnlyProps readOnlyProps = connection.getQueryServices().getProps();
        for (int i = 0; i < 2; ++i) {
            try (Table sysCatOrSysChildLinkTable = connection.getQueryServices().getTable(SchemaUtil.getPhysicalName(i == 0 ? PhoenixDatabaseMetaData.SYSTEM_CHILD_LINK_NAME_BYTES : PhoenixDatabaseMetaData.SYSTEM_CATALOG_TABLE_BYTES, readOnlyProps).getName());){
                byte[] tenantIdBytes = tenantId != null ? tenantId.getBytes() : null;
                ViewUtil.findAllRelatives(sysCatOrSysChildLinkTable, tenantIdBytes, schema == null ? null : schema.getBytes(), tableName.getBytes(), PTable.LinkType.CHILD_TABLE, childViewsResult);
                break;
            }
            catch (TableNotFoundException ex) {
                if (i != 1) continue;
                throw ex;
            }
        }
        return childViewsResult;
    }

    public static boolean hasChildViews(Table sysCatOrsysChildLink, byte[] tenantId, byte[] schemaName, byte[] tableName, long timestamp) throws IOException {
        byte[] key = SchemaUtil.getTableKey(tenantId, schemaName, tableName);
        Scan scan = MetaDataUtil.newTableRowsScan(key, 0L, timestamp);
        SingleColumnValueFilter linkFilter = new SingleColumnValueFilter(PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, PhoenixDatabaseMetaData.LINK_TYPE_BYTES, CompareOperator.EQUAL, PTable.LinkType.CHILD_TABLE.getSerializedValueAsByteArray()){

            public boolean filterAllRemaining() {
                return this.matchedColumn;
            }
        };
        linkFilter.setFilterIfMissing(true);
        scan.setFilter((Filter)linkFilter);
        scan.addColumn(PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, PhoenixDatabaseMetaData.LINK_TYPE_BYTES);
        try (ResultScanner scanner = sysCatOrsysChildLink.getScanner(scan);){
            Result result = scanner.next();
            boolean bl = result != null;
            return bl;
        }
    }

    public static TableName getSystemTableForChildLinks(int clientVersion, Configuration conf) throws SQLException, IOException {
        byte[] fullTableName = PhoenixDatabaseMetaData.SYSTEM_CHILD_LINK_NAME_BYTES;
        if (clientVersion < MetaDataProtocol.MIN_SPLITTABLE_SYSTEM_CATALOG) {
            try (PhoenixConnection connection = QueryUtil.getConnectionOnServer(conf).unwrap(PhoenixConnection.class);){
                connection.getTableNoCache(PhoenixDatabaseMetaData.SYSTEM_CHILD_LINK_NAME);
            }
            catch (TableNotFoundException e) {
                fullTableName = PhoenixDatabaseMetaData.SYSTEM_CATALOG_NAME_BYTES;
            }
            catch (SQLException e) {
                logger.error("Error getting a connection on the server : " + e);
                throw e;
            }
        }
        return SchemaUtil.getPhysicalTableName(fullTableName, conf);
    }

    public static boolean isDivergedView(PTable view) {
        return view.getBaseColumnCount() == -100;
    }

    public static boolean isViewDiverging(PColumn columnToDelete, PTable view, long clientVersion) {
        return !ViewUtil.isDivergedView(view) && (clientVersion < (long)MetaDataProtocol.MIN_SPLITTABLE_SYSTEM_CATALOG ? columnToDelete.getPosition() < view.getBaseColumnCount() : columnToDelete.isDerived());
    }

    public static void addIndexesFromParent(PhoenixConnection connection, PTable view, PTable parentTable, List<PTable> inheritedIndexes) throws SQLException {
        List<PTable> parentTableIndexes = parentTable.getIndexes();
        for (PTable index : parentTableIndexes) {
            boolean containsAllReqdCols = true;
            IndexMaintainer indexMaintainer = index.getIndexMaintainer(parentTable, connection);
            Set<Pair<String, String>> indexedColInfos = indexMaintainer.getIndexedColumnInfo();
            for (Pair<String, String> colInfo : indexedColInfos) {
                try {
                    String colFamily = (String)colInfo.getFirst();
                    String colName = (String)colInfo.getSecond();
                    if (colFamily == null) {
                        view.getColumnForColumnName(colName);
                        continue;
                    }
                    view.getColumnFamily(colFamily).getPColumnForColumnName(colName);
                }
                catch (ColumnNotFoundException e) {
                    containsAllReqdCols = false;
                    break;
                }
            }
            for (PColumn col : view.getColumns()) {
                if (!col.isViewReferenced() && col.getViewConstant() == null) continue;
                try {
                    String indexColumnName = IndexUtil.getIndexColumnName(col);
                    index.getColumnForColumnName(indexColumnName);
                }
                catch (ColumnNotFoundException e1) {
                    PColumn indexCol = null;
                    try {
                        String cf = col.getFamilyName() != null ? col.getFamilyName().getString() : null;
                        String colName = col.getName().getString();
                        indexCol = cf != null ? parentTable.getColumnFamily(cf).getPColumnForColumnName(colName) : parentTable.getColumnForColumnName(colName);
                    }
                    catch (ColumnNotFoundException e2) {
                        containsAllReqdCols = false;
                        break;
                    }
                    if (indexCol.getViewConstant() != null && Bytes.compareTo((byte[])indexCol.getViewConstant(), (byte[])col.getViewConstant()) == 0) continue;
                    containsAllReqdCols = false;
                    break;
                }
            }
            if (!containsAllReqdCols) continue;
            String viewStatement = IndexUtil.rewriteViewStatement(connection, index, parentTable, view.getViewStatement());
            PName modifiedIndexName = PNameFactory.newName(view.getName().getString() + "#" + index.getName().getString());
            if (Objects.equal((Object)viewStatement, (Object)index.getViewStatement())) {
                inheritedIndexes.add(index);
                continue;
            }
            inheritedIndexes.add(PTableImpl.builderWithColumns(index, PTableImpl.getColumnsToClone(index)).setTableName(modifiedIndexName).setViewStatement(viewStatement).setUpdateCacheFrequency(view.getUpdateCacheFrequency()).setTenantId(index.getTenantId()).setPhysicalNames(Collections.singletonList(index.getPhysicalName())).build());
        }
    }

    public static PTable addDerivedColumnsAndIndexesFromAncestors(PhoenixConnection connection, PTable table) throws SQLException {
        ArrayList ancestorList = Lists.newArrayList((Object[])new PTable[]{table});
        PName parentName = table.getParentName();
        while (parentName != null && parentName.getString().length() > 0) {
            PTable parentTable;
            PTable currentTable = (PTable)ancestorList.get(ancestorList.size() - 1);
            String parentTableName = SchemaUtil.getTableName(currentTable.getParentSchemaName(), currentTable.getParentTableName()).getString();
            try {
                parentTable = connection.getTable(parentTableName);
            }
            catch (TableNotFoundException tnfe) {
                parentTable = connection.getTable(table.getTenantId().getString(), parentTableName);
            }
            ancestorList.add(parentTable);
            parentName = parentTable.getParentName();
        }
        if (ancestorList.size() > 1) {
            for (int k = ancestorList.size() - 2; k >= 0; --k) {
                ancestorList.set(k, ViewUtil.addDerivedColumnsAndIndexesFromParent(connection, (PTable)ancestorList.get(k), (PTable)ancestorList.get(k + 1)));
            }
            return (PTable)ancestorList.get(0);
        }
        return table;
    }

    public static PTable addDerivedColumnsAndIndexesFromParent(PhoenixConnection connection, PTable table, PTable parentTable) throws SQLException {
        boolean hasIndexId;
        PTable pTable = ViewUtil.addDerivedColumnsFromParent(connection, table, parentTable);
        boolean bl = hasIndexId = table.getViewIndexId() != null;
        if (!hasIndexId) {
            ArrayList allIndexes = Lists.newArrayList();
            if (pTable != null && pTable.getIndexes() != null && !pTable.getIndexes().isEmpty()) {
                for (PTable viewIndex : pTable.getIndexes()) {
                    PTable resolvedViewIndex = ViewUtil.addDerivedColumnsAndIndexesFromParent(connection, viewIndex, pTable);
                    if (resolvedViewIndex == null) continue;
                    allIndexes.add(resolvedViewIndex);
                }
            }
            ArrayList inheritedIndexes = Lists.newArrayList();
            ViewUtil.addIndexesFromParent(connection, pTable, parentTable, inheritedIndexes);
            allIndexes.addAll(inheritedIndexes);
            if (!allIndexes.isEmpty()) {
                pTable = PTableImpl.builderWithColumns(pTable, PTableImpl.getColumnsToClone(pTable)).setIndexes(allIndexes).build();
            }
        }
        return pTable;
    }

    public static PTable addDerivedColumnsFromParent(PhoenixConnection connection, PTable view, PTable parentTable) throws SQLException {
        return ViewUtil.addDerivedColumnsFromParent(connection, view, parentTable, true);
    }

    public static PTable addDerivedColumnsFromParent(PhoenixConnection connection, PTable view, PTable parentTable, boolean recalculateBaseColumnCount) throws SQLException {
        boolean isDiverged;
        boolean hasIndexId = view.getViewIndexId() != null;
        boolean isSalted = view.getBucketNum() != null;
        boolean isDivergedViewCreatedPre4_15 = isDiverged = ViewUtil.isDivergedView(view);
        ArrayList allColumns = Lists.newArrayList();
        ArrayList excludedColumns = Lists.newArrayList();
        List<PColumn> myColumns = view.getColumns();
        myColumns = myColumns.subList(isSalted ? 1 : 0, myColumns.size());
        for (int i = myColumns.size() - 1; i >= 0; --i) {
            PColumn pColumn = myColumns.get(i);
            if (pColumn.isExcluded()) {
                isDivergedViewCreatedPre4_15 = false;
                excludedColumns.add(pColumn);
            }
            allColumns.add(pColumn);
        }
        HashMap indexRequiredDroppedDataColMap = Maps.newHashMapWithExpectedSize((int)view.getColumns().size());
        if (hasIndexId) {
            int indexPosOffset = (isSalted ? 1 : 0) + (view.isMultiTenant() ? 1 : 0) + 1;
            ColumnNameTrackingExpressionCompiler expressionCompiler = new ColumnNameTrackingExpressionCompiler();
            for (int i = indexPosOffset; i < view.getPKColumns().size(); ++i) {
                PColumn indexColumn = view.getPKColumns().get(i);
                try {
                    expressionCompiler.reset();
                    String expressionStr = IndexUtil.getIndexColumnExpressionStr(indexColumn);
                    ParseNode parseNode = SQLParser.parseCondition(expressionStr);
                    parseNode.accept(expressionCompiler);
                    indexRequiredDroppedDataColMap.put(indexColumn, Lists.newArrayList(expressionCompiler.getDataColumnNames()));
                    continue;
                }
                catch (SQLException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        long maxTableTimestamp = view.getTimeStamp();
        long maxDDLTimestamp = view.getLastDDLTimestamp() != null ? view.getLastDDLTimestamp() : 0L;
        int numPKCols = view.getPKColumns().size();
        maxTableTimestamp = Math.max(maxTableTimestamp, parentTable.getTimeStamp());
        maxDDLTimestamp = Math.max(maxDDLTimestamp, parentTable.getLastDDLTimestamp() != null ? parentTable.getLastDDLTimestamp() : 0L);
        if (hasIndexId) {
            int startIndex;
            for (int index = startIndex = parentTable.getBucketNum() != null ? 1 : 0; index < parentTable.getPKColumns().size(); ++index) {
                int existingColumnIndex;
                PColumn pkColumn = parentTable.getPKColumns().get(index);
                if (pkColumn.equals(SaltingUtil.SALTING_COLUMN) || pkColumn.isExcluded() || pkColumn.getViewConstant() != null || (existingColumnIndex = allColumns.indexOf(pkColumn = IndexUtil.getIndexPKColumn(++numPKCols, pkColumn))) != -1) continue;
                allColumns.add(0, pkColumn);
            }
            for (int j = 0; j < parentTable.getColumns().size(); ++j) {
                PColumn tableColumn = parentTable.getColumns().get(j);
                if (tableColumn.isExcluded()) continue;
                String dataColumnName = tableColumn.getName().getString();
                for (Map.Entry entry : indexRequiredDroppedDataColMap.entrySet()) {
                    ((List)entry.getValue()).remove(dataColumnName);
                }
            }
        } else if (!isDivergedViewCreatedPre4_15) {
            ViewUtil.inheritColumnsFromParent(view, parentTable, isDiverged, excludedColumns, allColumns);
        }
        for (Map.Entry entry : indexRequiredDroppedDataColMap.entrySet()) {
            if (((List)entry.getValue()).isEmpty()) continue;
            PColumn indexColumnToBeDropped = (PColumn)entry.getKey();
            if (SchemaUtil.isPKColumn(indexColumnToBeDropped)) {
                return null;
            }
            allColumns.remove(indexColumnToBeDropped);
        }
        ArrayList columnsToAdd = Lists.newArrayList();
        int position = isSalted ? 1 : 0;
        for (int i = allColumns.size() - 1; i >= 0; --i) {
            PColumn column = (PColumn)allColumns.get(i);
            if (view.getColumns().contains(column)) {
                columnsToAdd.add(new PColumnImpl(column, position++));
                continue;
            }
            columnsToAdd.add(new PColumnImpl(column, true, position++));
        }
        int baseTableColumnCount = view.getBaseColumnCount();
        if (recalculateBaseColumnCount) {
            baseTableColumnCount = isDiverged ? -100 : columnsToAdd.size() - myColumns.size() + (isSalted ? 1 : 0);
        }
        long updateCacheFreq = view.getType() != PTableType.VIEW || view.hasViewModifiedUpdateCacheFrequency() ? view.getUpdateCacheFrequency() : parentTable.getUpdateCacheFrequency();
        Boolean useStatsForParallelization = view.getType() != PTableType.VIEW || view.hasViewModifiedUseStatsForParallelization() ? view.useStatsForParallelization() : parentTable.useStatsForParallelization();
        PTable pTable = PTableImpl.builderWithColumns(view, columnsToAdd).setImmutableRows(parentTable.isImmutableRows()).setDisableWAL(parentTable.isWALDisabled()).setMultiTenant(parentTable.isMultiTenant()).setStoreNulls(parentTable.getStoreNulls()).setTransactionProvider(parentTable.getTransactionProvider()).setAutoPartitionSeqName(parentTable.getAutoPartitionSeqName()).setAppendOnlySchema(parentTable.isAppendOnlySchema()).setBaseColumnCount(baseTableColumnCount).setBaseTableLogicalName(parentTable.getBaseTableLogicalName()).setTimeStamp(maxTableTimestamp).setExcludedColumns((List<PColumn>)ImmutableList.copyOf((Collection)excludedColumns)).setUpdateCacheFrequency(updateCacheFreq).setUseStatsForParallelization(useStatsForParallelization).setLastDDLTimestamp(maxDDLTimestamp).build();
        pTable = WhereConstantParser.addViewInfoToPColumnsIfNeeded(pTable);
        return pTable;
    }

    static void inheritColumnsFromParent(PTable view, PTable parentTable, boolean isDiverged, List<PColumn> excludedColumns, List<PColumn> allColumns) {
        List<PColumn> currAncestorTableCols = PTableImpl.getColumnsToClone(parentTable);
        if (currAncestorTableCols != null) {
            for (int j = currAncestorTableCols.size() - 1; j >= 0; --j) {
                int existingExcludedIndex;
                PColumn ancestorColumn = currAncestorTableCols.get(j);
                if (isDiverged && ancestorColumn.getFamilyName() != null && ancestorColumn.getTimestamp() > view.getTimeStamp() || (existingExcludedIndex = excludedColumns.indexOf(ancestorColumn)) != -1 && ancestorColumn.getTimestamp() <= excludedColumns.get(existingExcludedIndex).getTimestamp()) continue;
                if (ancestorColumn.isExcluded()) {
                    excludedColumns.add(ancestorColumn);
                    continue;
                }
                int existingColumnIndex = allColumns.indexOf(ancestorColumn);
                if (existingColumnIndex != -1) {
                    PColumn existingColumn = allColumns.get(existingColumnIndex);
                    if (!isDiverged && ancestorColumn.getTimestamp() > existingColumn.getTimestamp()) {
                        allColumns.remove(existingColumnIndex);
                        allColumns.add(new PColumnImpl(ancestorColumn, true, ancestorColumn.getPosition()));
                        continue;
                    }
                    allColumns.set(existingColumnIndex, new PColumnImpl(existingColumn, true, existingColumn.getPosition()));
                    continue;
                }
                allColumns.add(new PColumnImpl(ancestorColumn, true, ancestorColumn.getPosition()));
            }
        }
        for (PColumn excludedColumn : excludedColumns) {
            int index = allColumns.indexOf(excludedColumn);
            if (index == -1 || allColumns.get(index).getTimestamp() > excludedColumn.getTimestamp()) continue;
            allColumns.remove(excludedColumn);
        }
    }

    public static void addTagsToPutsForViewAlteredProperties(List<Mutation> tableMetaData, PTable parent, ExtendedCellBuilder extendedCellBuilder) {
        byte[] parentUpdateCacheFreqBytes = null;
        byte[] parentUseStatsForParallelizationBytes = null;
        if (parent != null) {
            parentUpdateCacheFreqBytes = new byte[PLong.INSTANCE.getByteSize().intValue()];
            PLong.INSTANCE.getCodec().encodeLong(parent.getUpdateCacheFrequency(), parentUpdateCacheFreqBytes, 0);
            if (parent.useStatsForParallelization() != null) {
                parentUseStatsForParallelizationBytes = PBoolean.INSTANCE.toBytes(parent.useStatsForParallelization());
            }
        }
        for (Mutation m : tableMetaData) {
            if (!(m instanceof Put)) continue;
            MetaDataUtil.conditionallyAddTagsToPutCells((Put)m, PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, PhoenixDatabaseMetaData.UPDATE_CACHE_FREQUENCY_BYTES, extendedCellBuilder, parentUpdateCacheFreqBytes, MetaDataEndpointImplConstants.VIEW_MODIFIED_PROPERTY_BYTES);
            MetaDataUtil.conditionallyAddTagsToPutCells((Put)m, PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, PhoenixDatabaseMetaData.USE_STATS_FOR_PARALLELIZATION_BYTES, extendedCellBuilder, parentUseStatsForParallelizationBytes, MetaDataEndpointImplConstants.VIEW_MODIFIED_PROPERTY_BYTES);
        }
    }

    public static List<String> getViewIndexIds(PhoenixConnection connection, String tableName, boolean includeTenantViewIndexes) throws IOException, SQLException {
        Preconditions.checkArgument((boolean)MetaDataUtil.isViewIndex(tableName));
        ArrayList<String> viewIndexIdsString = new ArrayList<String>();
        String viewIndexIdsQuery = ViewUtil.getViewIndexIdsQuery(tableName, includeTenantViewIndexes);
        logger.info(String.format("Query to get view index ids for %s with includeTenantViewIndexes as %b is %s", tableName, includeTenantViewIndexes, viewIndexIdsQuery));
        PreparedStatement preparedStatement = connection.prepareStatement(viewIndexIdsQuery);
        ResultSet resultSet = preparedStatement.executeQuery();
        while (resultSet.next()) {
            byte[] data;
            int viewIndexType = resultSet.getInt(2);
            if (resultSet.wasNull() || viewIndexType == 5) {
                data = PSmallint.INSTANCE.toBytes(resultSet.getObject(1));
                viewIndexIdsString.add(Hex.encodeHexString((byte[])data));
                continue;
            }
            data = PLong.INSTANCE.toBytes(resultSet.getObject(1));
            viewIndexIdsString.add(Hex.encodeHexString((byte[])data));
        }
        return viewIndexIdsString;
    }

    private static String getViewIndexIdsQuery(String tableName, boolean includeTenantViewIndexes) {
        String schema = SchemaUtil.getSchemaNameFromFullName(SchemaUtil.getParentTableNameFromIndexTable(tableName, "_IDX_"));
        Object TABLE_SCHEM_FILTER = !StringUtils.isEmpty((CharSequence)schema) ? " AND TABLE_SCHEM = '" + schema + "' " : " AND TABLE_SCHEM IS NULL ";
        String TENANT_ID_FILTER = !includeTenantViewIndexes ? " AND TENANT_ID IS NULL " : " ";
        String GET_VIEW_INDEX_TABLE_QUERY = "SELECT DISTINCT TABLE_NAME FROM SYSTEM.CATALOG WHERE LINK_TYPE = 2 AND COLUMN_FAMILY = '" + tableName + "' " + (String)TABLE_SCHEM_FILTER + TENANT_ID_FILTER;
        String GET_VIEW_INDEX_IDS_QUERY = "SELECT DISTINCT VIEW_INDEX_ID, VIEW_INDEX_ID_DATA_TYPE FROM SYSTEM.CATALOG WHERE VIEW_INDEX_ID IS NOT NULL AND TABLE_NAME IN ( " + GET_VIEW_INDEX_TABLE_QUERY + ") " + (String)TABLE_SCHEM_FILTER + TENANT_ID_FILTER;
        return GET_VIEW_INDEX_IDS_QUERY;
    }
}

