/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.util;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.TimeoutException;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.CompareOperator;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.KeepDeletedCells;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.PrivateCellUtil;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.CheckAndMutate;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.CoprocessorDescriptor;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.filter.BinaryComparator;
import org.apache.hadoop.hbase.filter.ByteArrayComparable;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterList;
import org.apache.hadoop.hbase.filter.PageFilter;
import org.apache.hadoop.hbase.filter.QualifierFilter;
import org.apache.hadoop.hbase.filter.SingleColumnValueFilter;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.snapshot.SnapshotCreationException;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.coprocessorclient.MetaDataEndpointImplConstants;
import org.apache.phoenix.coprocessorclient.MetaDataProtocol;
import org.apache.phoenix.coprocessorclient.TableInfo;
import org.apache.phoenix.hbase.index.util.GenericKeyValueBuilder;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.jdbc.PhoenixDatabaseMetaData;
import org.apache.phoenix.query.ConnectionQueryServices;
import org.apache.phoenix.query.QueryConstants;
import org.apache.phoenix.schema.LiteralTTLExpression;
import org.apache.phoenix.schema.MetaDataClient;
import org.apache.phoenix.schema.PName;
import org.apache.phoenix.schema.PNameFactory;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.PTableType;
import org.apache.phoenix.schema.SaltingUtil;
import org.apache.phoenix.schema.SequenceAllocation;
import org.apache.phoenix.schema.SequenceAlreadyExistsException;
import org.apache.phoenix.schema.SequenceKey;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.TableNotFoundException;
import org.apache.phoenix.schema.types.PBinary;
import org.apache.phoenix.schema.types.PBoolean;
import org.apache.phoenix.schema.types.PChar;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PDecimal;
import org.apache.phoenix.schema.types.PDouble;
import org.apache.phoenix.schema.types.PFloat;
import org.apache.phoenix.schema.types.PInteger;
import org.apache.phoenix.schema.types.PVarbinary;
import org.apache.phoenix.schema.types.PVarchar;
import org.apache.phoenix.thirdparty.com.google.common.base.Objects;
import org.apache.phoenix.thirdparty.com.google.common.base.Preconditions;
import org.apache.phoenix.thirdparty.com.google.common.base.Strings;
import org.apache.phoenix.thirdparty.com.google.common.collect.Lists;
import org.apache.phoenix.thirdparty.com.google.common.collect.Sets;
import org.apache.phoenix.util.ByteUtil;
import org.apache.phoenix.util.ClientUtil;
import org.apache.phoenix.util.EnvironmentEdgeManager;
import org.apache.phoenix.util.IndexUtil;
import org.apache.phoenix.util.MetaDataUtil;
import org.apache.phoenix.util.PhoenixKeyValueUtil;
import org.apache.phoenix.util.PhoenixRuntime;
import org.apache.phoenix.util.PropertiesUtil;
import org.apache.phoenix.util.ReadOnlyProps;
import org.apache.phoenix.util.SchemaUtil;
import org.apache.phoenix.util.TableViewFinderResult;
import org.apache.phoenix.util.ViewUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SuppressWarnings(value={"SQL_PREPARED_STATEMENT_GENERATED_FROM_NONCONSTANT_STRING"}, justification="Not possible to avoid")
public class UpgradeUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(UpgradeUtil.class);
    private static final byte[] SEQ_PREFIX_BYTES = ByteUtil.concat(QueryConstants.SEPARATOR_BYTE_ARRAY, new byte[][]{Bytes.toBytes((String)"_SEQ_")});
    public static final byte[] UPGRADE_TO_4_7_COLUMN_NAME = Bytes.toBytes((String)"UPGRADE_TO_4_7");
    private static final byte[] LINK_ROW = new byte[]{PTable.LinkType.CHILD_TABLE.getSerializedValue()};
    private static final String DO_NOT_UPGRADE = "DoNotUpgrade";
    public static final String UPSERT_BASE_COLUMN_COUNT_IN_HEADER_ROW = "UPSERT INTO SYSTEM.CATALOG (TENANT_ID, TABLE_SCHEM, TABLE_NAME, COLUMN_NAME, COLUMN_FAMILY, BASE_COLUMN_COUNT) VALUES (?, ?, ?, ?, ?, ?) ";
    public static final String UPSERT_UPDATE_CACHE_FREQUENCY = "UPSERT INTO SYSTEM.\"CATALOG\"( TENANT_ID,TABLE_SCHEM,TABLE_NAME,UPDATE_CACHE_FREQUENCY) VALUES (?, ?, ?, ?)";
    public static final String SELECT_BASE_COLUMN_COUNT_FROM_HEADER_ROW = "SELECT BASE_COLUMN_COUNT FROM \"SYSTEM\".CATALOG WHERE COLUMN_NAME IS NULL AND COLUMN_FAMILY IS NULL AND TENANT_ID %s AND TABLE_SCHEM %s AND TABLE_NAME = ? ";
    private static final String UPDATE_LINK = "UPSERT INTO SYSTEM.\"CATALOG\"( TENANT_ID,TABLE_SCHEM,TABLE_NAME,COLUMN_FAMILY,LINK_TYPE,TABLE_SEQ_NUM,TABLE_TYPE) SELECT TENANT_ID,TABLE_SCHEM,TABLE_NAME,'%s' AS COLUMN_FAMILY ,LINK_TYPE,TABLE_SEQ_NUM,TABLE_TYPE FROM SYSTEM.\"CATALOG\" WHERE  (TABLE_SCHEM=? OR (TABLE_SCHEM IS NULL AND ? IS NULL)) AND TABLE_NAME=? AND COLUMN_FAMILY=? AND LINK_TYPE = " + PTable.LinkType.PHYSICAL_TABLE.getSerializedValue();
    private static final String DELETE_LINK = "DELETE FROM SYSTEM.CATALOG WHERE (TABLE_SCHEM=? OR (TABLE_SCHEM IS NULL AND ? IS NULL)) AND TABLE_NAME=? AND COLUMN_FAMILY=? AND LINK_TYPE = " + PTable.LinkType.PHYSICAL_TABLE.getSerializedValue();

    private UpgradeUtil() {
    }

    private static byte[] getSequenceSnapshotName() {
        return Bytes.toBytes((String)("_BAK_" + PhoenixDatabaseMetaData.SYSTEM_SEQUENCE_NAME));
    }

    private static void createSequenceSnapshot(Admin admin, PhoenixConnection conn) throws SQLException {
        byte[] tableName = UpgradeUtil.getSequenceSnapshotName();
        TableDescriptor desc = TableDescriptorBuilder.newBuilder((TableName)TableName.valueOf((byte[])tableName)).setColumnFamily(ColumnFamilyDescriptorBuilder.of((byte[])PhoenixDatabaseMetaData.SYSTEM_SEQUENCE_FAMILY_BYTES)).build();
        try {
            admin.createTable(desc);
            UpgradeUtil.copyTable(conn, PhoenixDatabaseMetaData.SYSTEM_SEQUENCE_NAME_BYTES, tableName);
        }
        catch (IOException e) {
            throw ClientUtil.parseServerException(e);
        }
    }

    private static void restoreSequenceSnapshot(Admin admin, PhoenixConnection conn) throws SQLException {
        byte[] tableName = UpgradeUtil.getSequenceSnapshotName();
        UpgradeUtil.copyTable(conn, tableName, PhoenixDatabaseMetaData.SYSTEM_SEQUENCE_NAME_BYTES);
    }

    private static void deleteSequenceSnapshot(Admin admin) throws SQLException {
        TableName tableName = TableName.valueOf((byte[])UpgradeUtil.getSequenceSnapshotName());
        try {
            admin.disableTable(tableName);
            admin.deleteTable(tableName);
        }
        catch (IOException e) {
            throw ClientUtil.parseServerException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @SuppressWarnings(value={"deprecation"})
    private static void copyTable(PhoenixConnection conn, byte[] sourceName, byte[] targetName) throws SQLException {
        batchSizeBytes = 102400;
        sizeBytes = 0;
        mutations = Lists.newArrayListWithExpectedSize((int)10000);
        scan = new Scan();
        scan.setRaw(true);
        scan.readAllVersions();
        scanner = null;
        source = null;
        target = null;
        try {
            source = conn.getQueryServices().getTable(sourceName);
            target = conn.getQueryServices().getTable(targetName);
            scanner = source.getScanner(scan);
lbl16:
            // 3 sources

            while (true) {
                result = scanner.next();
                if (result == null) {
                    if (!mutations.isEmpty()) {
                        UpgradeUtil.LOGGER.info("Committing last bactch of temp rows");
                        target.batch((List)mutations, null);
                    }
                    UpgradeUtil.LOGGER.info("Successfully completed copy");
                    return;
                }
                var11_16 = result.rawCells();
                var12_17 = var11_16.length;
                break;
            }
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Exception e) {
            throw ClientUtil.parseServerException(e);
        }
        finally {
            try {
                if (scanner != null) {
                    scanner.close();
                }
            }
            finally {
                try {
                    if (source != null) {
                        source.close();
                    }
                }
                catch (IOException e) {
                    UpgradeUtil.LOGGER.warn("Exception during close of source table", (Throwable)e);
                }
                finally {
                    try {
                        if (target != null) {
                            target.close();
                        }
                    }
                    catch (IOException e) {
                        UpgradeUtil.LOGGER.warn("Exception during close of target table", (Throwable)e);
                    }
                }
            }
        }
        for (var13_18 = 0; var13_18 < var12_17; ++var13_18) {
            keyValue = var11_16[var13_18];
            sizeBytes += PrivateCellUtil.estimatedSerializedSizeOf((Cell)keyValue);
            if (keyValue.getType() == Cell.Type.Put) {
                put = new Put(keyValue.getRowArray(), keyValue.getRowOffset(), (int)keyValue.getRowLength());
                put.add(keyValue);
                mutations.add(put);
                continue;
            }
            if (keyValue.getType() != Cell.Type.Delete) continue;
            delete = new Delete(keyValue.getRowArray(), keyValue.getRowOffset(), (int)keyValue.getRowLength());
            delete.add(keyValue);
            mutations.add(delete);
        }
        if (sizeBytes < batchSizeBytes) ** GOTO lbl16
        UpgradeUtil.LOGGER.info("Committing bactch of temp rows");
        target.batch((List)mutations, null);
        mutations.clear();
        sizeBytes = 0;
        ** while (true)
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void preSplitSequenceTable(PhoenixConnection conn, int nSaltBuckets) throws SQLException {
        Admin admin = conn.getQueryServices().getAdmin();
        boolean snapshotCreated = false;
        boolean success = false;
        try {
            if (nSaltBuckets <= 0) {
                return;
            }
            LOGGER.warn("Pre-splitting SYSTEM.SEQUENCE table " + nSaltBuckets + "-ways. This may take some time - please do not close window.");
            TableDescriptor desc = admin.getDescriptor(TableName.valueOf((byte[])PhoenixDatabaseMetaData.SYSTEM_SEQUENCE_NAME_BYTES));
            UpgradeUtil.createSequenceSnapshot(admin, conn);
            snapshotCreated = true;
            admin.disableTable(TableName.valueOf((String)PhoenixDatabaseMetaData.SYSTEM_SEQUENCE_NAME));
            admin.deleteTable(TableName.valueOf((String)PhoenixDatabaseMetaData.SYSTEM_SEQUENCE_NAME));
            byte[][] splitPoints = SaltingUtil.getSalteByteSplitPoints(nSaltBuckets);
            admin.createTable(desc, splitPoints);
            UpgradeUtil.restoreSequenceSnapshot(admin, conn);
            success = true;
            LOGGER.warn("Completed pre-splitting SYSTEM.SEQUENCE table");
        }
        catch (IOException e) {
            throw new SQLException("Unable to pre-split SYSTEM.SEQUENCE table", e);
        }
        finally {
            try {
                if (snapshotCreated && success) {
                    try {
                        UpgradeUtil.deleteSequenceSnapshot(admin);
                    }
                    catch (SQLException e) {
                        LOGGER.warn("Exception while deleting SYSTEM.SEQUENCE snapshot during pre-split", (Throwable)e);
                    }
                }
            }
            finally {
                try {
                    admin.close();
                }
                catch (IOException e) {
                    LOGGER.warn("Exception while closing admin during pre-split", (Throwable)e);
                }
            }
        }
    }

    private static Connection getHBaseConnection(Configuration config, Map<String, String> options) throws IOException {
        Configuration conf = HBaseConfiguration.create((Configuration)config);
        conf.set("hbase.rpc.read.timeout", Integer.toString(1800000));
        conf.set("hbase.rpc.write.timeout", Integer.toString(1800000));
        conf.set("hbase.client.scanner.timeout.period", Integer.toString(1800000));
        if (options != null) {
            block6: for (Map.Entry<String, String> entry : options.entrySet()) {
                String k = entry.getKey();
                String v = entry.getValue();
                switch (k) {
                    case "hbase.rpc.timeout": {
                        conf.set("hbase.rpc.read.timeout", v);
                        conf.set("hbase.rpc.write.timeout", v);
                        continue block6;
                    }
                }
                conf.set(k, v);
            }
        }
        LOGGER.info(String.format("Creating HBase cluster connection to ==> %s", conf.get("hbase.zookeeper.quorum")));
        return ConnectionFactory.createConnection((Configuration)conf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PhoenixConnection upgradeLocalIndexes(PhoenixConnection metaConnection) throws SQLException, IOException, org.apache.hadoop.hbase.TableNotFoundException {
        PhoenixConnection toReturn;
        block31: {
            Properties props = PropertiesUtil.deepCopy(metaConnection.getClientInfo());
            Long originalScn = null;
            String str = props.getProperty("CurrentSCN");
            if (str != null) {
                originalScn = Long.valueOf(str);
            }
            props.setProperty("CurrentSCN", Long.toString(Long.MAX_VALUE));
            PhoenixConnection globalConnection = null;
            toReturn = null;
            globalConnection = new PhoenixConnection(metaConnection, metaConnection.getQueryServices(), props);
            SQLException sqlEx = null;
            try (Admin admin = globalConnection.getQueryServices().getAdmin();){
                ResultSet rs = globalConnection.createStatement().executeQuery("SELECT TABLE_SCHEM, TABLE_NAME, DATA_TABLE_NAME, TENANT_ID, MULTI_TENANT, SALT_BUCKETS FROM SYSTEM.CATALOG        WHERE COLUMN_NAME IS NULL           AND COLUMN_FAMILY IS NULL           AND INDEX_TYPE=" + PTable.IndexType.LOCAL.getSerializedValue());
                boolean droppedLocalIndexes = false;
                while (rs.next()) {
                    int i;
                    if (!droppedLocalIndexes) {
                        Object table2;
                        List localIndexTables = admin.listTableDescriptors(Pattern.compile("_LOCAL_IDX_.*"));
                        String localIndexSplitter = "org.apache.hadoop.hbase.regionserver.LocalIndexSplitter";
                        for (Object table2 : localIndexTables) {
                            TableDescriptor dataTableDesc = admin.getDescriptor(TableName.valueOf((String)MetaDataUtil.getLocalIndexUserTableName(table2.getTableName().getNameAsString())));
                            TableDescriptorBuilder dataTableDescBuilder = TableDescriptorBuilder.newBuilder((TableDescriptor)dataTableDesc);
                            ColumnFamilyDescriptor[] columnFamilies = dataTableDesc.getColumnFamilies();
                            boolean modifyTable = false;
                            for (ColumnFamilyDescriptor cf : columnFamilies) {
                                String localIndexCf = "L#" + cf.getNameAsString();
                                if (dataTableDesc.getColumnFamily(Bytes.toBytes((String)localIndexCf)) != null) continue;
                                ColumnFamilyDescriptorBuilder colDefBuilder = ColumnFamilyDescriptorBuilder.newBuilder((byte[])Bytes.toBytes((String)localIndexCf));
                                for (Map.Entry keyValue : cf.getValues().entrySet()) {
                                    colDefBuilder.setValue(((Bytes)keyValue.getKey()).copyBytes(), ((Bytes)keyValue.getValue()).copyBytes());
                                }
                                dataTableDescBuilder.setColumnFamily(colDefBuilder.build());
                                modifyTable = true;
                            }
                            Collection coprocessors = dataTableDesc.getCoprocessorDescriptors();
                            for (CoprocessorDescriptor coprocessor : coprocessors) {
                                if (!coprocessor.getClassName().equals(localIndexSplitter)) continue;
                                dataTableDescBuilder.removeCoprocessor(localIndexSplitter);
                                modifyTable = true;
                            }
                            if (!modifyTable) continue;
                            admin.modifyTable(dataTableDescBuilder.build());
                        }
                        Pattern pattern = Pattern.compile("_LOCAL_IDX_.*");
                        table2 = admin.listTableDescriptors(pattern).iterator();
                        while (table2.hasNext()) {
                            TableDescriptor tableDescriptor = (TableDescriptor)table2.next();
                            admin.disableTable(tableDescriptor.getTableName());
                            admin.deleteTable(tableDescriptor.getTableName());
                        }
                        droppedLocalIndexes = true;
                    }
                    String schemaName = rs.getString(1);
                    String indexTableName = rs.getString(2);
                    String dataTableName = rs.getString(3);
                    String tenantId = rs.getString(4);
                    boolean multiTenantTable = rs.getBoolean(5);
                    int numColumnsToSkip = 1 + (multiTenantTable ? 1 : 0);
                    String getColumns = "SELECT COLUMN_NAME, COLUMN_FAMILY FROM SYSTEM.CATALOG  WHERE TABLE_SCHEM " + (String)(schemaName == null ? "IS NULL " : "='" + schemaName + "'") + " AND TENANT_ID " + (String)(tenantId == null ? "IS NULL " : "='" + tenantId + "'") + " and TABLE_NAME='" + indexTableName + "' AND COLUMN_NAME IS NOT NULL AND KEY_SEQ > " + numColumnsToSkip + " ORDER BY KEY_SEQ";
                    ResultSet getColumnsRs = globalConnection.createStatement().executeQuery(getColumns);
                    ArrayList<String> indexedColumns = new ArrayList<String>(1);
                    ArrayList<String> coveredColumns = new ArrayList<String>(1);
                    while (getColumnsRs.next()) {
                        String column = getColumnsRs.getString(1);
                        String columnName = IndexUtil.getDataColumnName(column);
                        String columnFamily = IndexUtil.getDataColumnFamilyName(column);
                        if (getColumnsRs.getString(2) == null) {
                            if (columnFamily != null && !columnFamily.isEmpty()) {
                                if (SchemaUtil.normalizeIdentifier(columnFamily).equals("0")) {
                                    indexedColumns.add(columnName);
                                    continue;
                                }
                                indexedColumns.add(SchemaUtil.getCaseSensitiveColumnDisplayName(columnFamily, columnName));
                                continue;
                            }
                            indexedColumns.add(columnName);
                            continue;
                        }
                        coveredColumns.add(SchemaUtil.normalizeIdentifier(columnFamily).equals("0") ? columnName : SchemaUtil.getCaseSensitiveColumnDisplayName(columnFamily, columnName));
                    }
                    StringBuilder createIndex = new StringBuilder("CREATE LOCAL INDEX ");
                    createIndex.append(indexTableName);
                    createIndex.append(" ON ");
                    createIndex.append(SchemaUtil.getTableName(schemaName, dataTableName));
                    createIndex.append("(");
                    for (i = 0; i < indexedColumns.size(); ++i) {
                        createIndex.append((String)indexedColumns.get(i));
                        if (i >= indexedColumns.size() - 1) continue;
                        createIndex.append(",");
                    }
                    createIndex.append(")");
                    if (!coveredColumns.isEmpty()) {
                        createIndex.append(" INCLUDE(");
                        for (i = 0; i < coveredColumns.size(); ++i) {
                            createIndex.append((String)coveredColumns.get(i));
                            if (i >= coveredColumns.size() - 1) continue;
                            createIndex.append(",");
                        }
                        createIndex.append(")");
                    }
                    createIndex.append(" ASYNC");
                    LOGGER.info("Index creation query is : " + createIndex.toString());
                    LOGGER.info("Dropping the index " + indexTableName + " to clean up the index details from SYSTEM.CATALOG.");
                    PhoenixConnection localConnection = null;
                    if (tenantId != null) {
                        props.setProperty("TenantId", tenantId);
                        localConnection = new PhoenixConnection(globalConnection, globalConnection.getQueryServices(), props);
                    }
                    try {
                        (localConnection == null ? globalConnection : localConnection).createStatement().execute("DROP INDEX IF EXISTS " + indexTableName + " ON " + SchemaUtil.getTableName(schemaName, dataTableName));
                        LOGGER.info("Recreating the index " + indexTableName);
                        (localConnection == null ? globalConnection : localConnection).createStatement().execute(createIndex.toString());
                        LOGGER.info("Created the index " + indexTableName);
                        props.remove("TenantId");
                    }
                    catch (Throwable throwable) {
                        props.remove("TenantId");
                        if (localConnection != null && (sqlEx = UpgradeUtil.closeConnection(localConnection, sqlEx)) != null) {
                            throw sqlEx;
                        }
                        throw throwable;
                    }
                    if (localConnection == null || (sqlEx = UpgradeUtil.closeConnection(localConnection, sqlEx)) == null) continue;
                    throw sqlEx;
                }
                globalConnection.createStatement().execute("DELETE FROM SYSTEM.CATALOG WHERE SUBSTR(TABLE_NAME,0,11)='_LOCAL_IDX_'");
                if (originalScn != null) {
                    props.setProperty("CurrentSCN", Long.toString(originalScn));
                }
                toReturn = new PhoenixConnection(globalConnection, globalConnection.getQueryServices(), props);
            }
            catch (SQLException e) {
                sqlEx = e;
                return sqlEx;
            }
            finally {
                sqlEx = UpgradeUtil.closeConnection(metaConnection, sqlEx);
                sqlEx = UpgradeUtil.closeConnection(globalConnection, sqlEx);
                if (sqlEx == null) break block31;
                throw sqlEx;
            }
        }
        return toReturn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PhoenixConnection disableViewIndexes(PhoenixConnection connParam) throws SQLException, IOException, InterruptedException, TimeoutException {
        PhoenixConnection toReturn;
        block45: {
            Properties props = PropertiesUtil.deepCopy(connParam.getClientInfo());
            Long originalScn = null;
            String str = props.getProperty("CurrentSCN");
            if (str != null) {
                originalScn = Long.valueOf(str);
            }
            props.setProperty("CurrentSCN", Long.toString(Long.MAX_VALUE));
            HashSet<String> physicalTables = new HashSet<String>();
            SQLException sqlEx = null;
            PhoenixConnection globalConnection = null;
            toReturn = null;
            try {
                globalConnection = new PhoenixConnection(connParam, connParam.getQueryServices(), props);
                String tenantId = null;
                try (Admin admin = globalConnection.getQueryServices().getAdmin();){
                    String fetchViewIndexes = "SELECT TENANT_ID, TABLE_SCHEM, TABLE_NAME, DATA_TABLE_NAME FROM " + PhoenixDatabaseMetaData.SYSTEM_CATALOG_NAME + " WHERE VIEW_INDEX_ID IS NOT NULL";
                    String disableIndexDDL = "ALTER INDEX %s ON %s DISABLE";
                    try (ResultSet rs = globalConnection.createStatement().executeQuery(fetchViewIndexes);){
                        while (rs.next()) {
                            TableName tableName;
                            String indexPhysicalTableName;
                            tenantId = rs.getString(1);
                            String indexSchema = rs.getString(2);
                            String indexName = rs.getString(3);
                            String viewName = rs.getString(4);
                            String fullIndexName = SchemaUtil.getTableName(indexSchema, indexName);
                            String fullViewName = SchemaUtil.getTableName(indexSchema, viewName);
                            PTable viewPTable = null;
                            if (tenantId != null && !tenantId.isEmpty()) {
                                int existingViewIdxIdPosition;
                                Properties newProps = PropertiesUtil.deepCopy(globalConnection.getClientInfo());
                                newProps.setProperty("TenantId", tenantId);
                                PTable indexPTable = null;
                                try (PhoenixConnection tenantConnection = new PhoenixConnection(globalConnection, globalConnection.getQueryServices(), newProps);){
                                    viewPTable = tenantConnection.getTable(fullViewName);
                                    tenantConnection.createStatement().execute(String.format(disableIndexDDL, indexName, fullViewName));
                                    indexPTable = tenantConnection.getTable(fullIndexName);
                                }
                                int offset = indexPTable.getBucketNum() != null ? 1 : 0;
                                int existingTenantIdPosition = ++offset;
                                int newTenantIdPosition = existingViewIdxIdPosition = ++offset;
                                int newViewIdxPosition = existingTenantIdPosition;
                                String tenantIdColumn = indexPTable.getColumns().get(existingTenantIdPosition - 1).getName().getString();
                                int index = 0;
                                String updatePosition = "UPSERT INTO " + PhoenixDatabaseMetaData.SYSTEM_CATALOG_NAME + " ( TENANT_ID,TABLE_SCHEM,TABLE_NAME,COLUMN_NAME,COLUMN_FAMILY,ORDINAL_POSITION) SELECT TENANT_ID,TABLE_SCHEM,TABLE_NAME,COLUMN_NAME,COLUMN_FAMILY,? FROM " + PhoenixDatabaseMetaData.SYSTEM_CATALOG_NAME + " WHERE TENANT_ID = ?  AND TABLE_NAME = ?  AND " + (indexSchema == null ? "TABLE_SCHEM IS NULL" : "TABLE_SCHEM = ? ") + " AND COLUMN_NAME = ? ";
                                try (PreparedStatement s = globalConnection.prepareStatement(updatePosition);){
                                    index = 0;
                                    s.setInt(++index, newViewIdxPosition);
                                    s.setString(++index, tenantId);
                                    s.setString(++index, indexName);
                                    if (indexSchema != null) {
                                        s.setString(++index, indexSchema);
                                    }
                                    s.setString(++index, MetaDataUtil.getViewIndexIdColumnName());
                                    s.executeUpdate();
                                }
                                s = globalConnection.prepareStatement(updatePosition);
                                try {
                                    index = 0;
                                    s.setInt(++index, newTenantIdPosition);
                                    s.setString(++index, tenantId);
                                    s.setString(++index, indexName);
                                    if (indexSchema != null) {
                                        s.setString(++index, indexSchema);
                                    }
                                    s.setString(++index, tenantIdColumn);
                                    s.executeUpdate();
                                }
                                finally {
                                    if (s != null) {
                                        s.close();
                                    }
                                }
                                globalConnection.commit();
                            } else {
                                viewPTable = globalConnection.getTable(fullViewName);
                                globalConnection.createStatement().execute(String.format(disableIndexDDL, indexName, fullViewName));
                            }
                            if (!physicalTables.add(indexPhysicalTableName = MetaDataUtil.getViewIndexPhysicalName(viewPTable.getPhysicalName().getString())) || !admin.tableExists(tableName = TableName.valueOf((String)indexPhysicalTableName))) continue;
                            admin.disableTable(tableName);
                            admin.truncateTable(tableName, false);
                        }
                    }
                }
                if (originalScn != null) {
                    props.setProperty("CurrentSCN", Long.toString(originalScn));
                }
                toReturn = new PhoenixConnection(globalConnection, globalConnection.getQueryServices(), props);
            }
            catch (SQLException e) {
                sqlEx = e;
                return sqlEx;
            }
            finally {
                sqlEx = UpgradeUtil.closeConnection(connParam, sqlEx);
                sqlEx = UpgradeUtil.closeConnection(globalConnection, sqlEx);
                if (sqlEx == null) break block45;
                throw sqlEx;
            }
        }
        return toReturn;
    }

    public static SQLException closeConnection(PhoenixConnection conn, SQLException sqlEx) {
        SQLException toReturn = sqlEx;
        try {
            conn.close();
        }
        catch (SQLException e) {
            if (toReturn != null) {
                toReturn.setNextException(e);
            }
            toReturn = e;
        }
        return toReturn;
    }

    /*
     * Exception decompiling
     */
    @SuppressWarnings(value={"deprecation"})
    public static boolean upgradeSequenceTable(PhoenixConnection conn, int nSaltBuckets, PTable oldTable) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @SuppressWarnings(value={"deprecation"})
    private static KeyValue addSaltByte(Cell keyValue, int nSaltBuckets) {
        byte[] newBuf;
        boolean isViewSeq;
        byte[] buf = keyValue.getRowArray();
        int length = keyValue.getRowLength();
        int offset = keyValue.getRowOffset();
        boolean bl = isViewSeq = length > SEQ_PREFIX_BYTES.length && Bytes.compareTo((byte[])SEQ_PREFIX_BYTES, (int)0, (int)SEQ_PREFIX_BYTES.length, (byte[])buf, (int)offset, (int)SEQ_PREFIX_BYTES.length) == 0;
        if (!isViewSeq && nSaltBuckets == 0) {
            return null;
        }
        if (isViewSeq) {
            if (buf[length - 1] == 0) {
                --length;
            }
            byte[][] rowKeyMetaData = new byte[3][];
            SchemaUtil.getVarChars(buf, offset, length, 0, rowKeyMetaData);
            byte[] schemaName = rowKeyMetaData[1];
            byte[] unprefixedSchemaName = new byte[schemaName.length - MetaDataUtil.VIEW_INDEX_SEQUENCE_PREFIX_BYTES.length];
            System.arraycopy(schemaName, MetaDataUtil.VIEW_INDEX_SEQUENCE_PREFIX_BYTES.length, unprefixedSchemaName, 0, unprefixedSchemaName.length);
            byte[] tableName = rowKeyMetaData[2];
            PName physicalName = PNameFactory.newName(unprefixedSchemaName);
            newBuf = MetaDataUtil.getViewIndexSequenceKey(tableName == null ? null : Bytes.toString((byte[])tableName), physicalName, nSaltBuckets, false).getKey();
        } else {
            newBuf = new byte[length + 1];
            System.arraycopy(buf, offset, newBuf, 1, length);
            newBuf[0] = SaltingUtil.getSaltingByte(newBuf, 1, length, nSaltBuckets);
        }
        return new KeyValue(newBuf, 0, newBuf.length, buf, keyValue.getFamilyOffset(), (int)keyValue.getFamilyLength(), buf, keyValue.getQualifierOffset(), keyValue.getQualifierLength(), keyValue.getTimestamp(), KeyValue.Type.codeToType((byte)keyValue.getType().getCode()), buf, keyValue.getValueOffset(), keyValue.getValueLength());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void upgradeTo4_5_0(PhoenixConnection oldMetaConnection) throws SQLException {
        try (PhoenixConnection metaConnection = null;){
            metaConnection = new PhoenixConnection(oldMetaConnection, Long.MAX_VALUE);
            LOGGER.info("Upgrading metadata to support adding columns to tables with views");
            String getBaseTableAndViews = "SELECT COLUMN_FAMILY AS BASE_PHYSICAL_TABLE, TENANT_ID, TABLE_SCHEM AS VIEW_SCHEMA, TABLE_NAME AS VIEW_NAME FROM " + PhoenixDatabaseMetaData.SYSTEM_CATALOG_NAME + " WHERE COLUMN_FAMILY IS NOT NULL  AND COLUMN_NAME IS NULL  AND LINK_TYPE = ? ";
            HashMap<String, ArrayList<ViewKey>> parentTableViewsMap = new HashMap<String, ArrayList<ViewKey>>();
            try (PreparedStatement stmt = metaConnection.prepareStatement(getBaseTableAndViews);){
                stmt.setByte(1, PTable.LinkType.PHYSICAL_TABLE.getSerializedValue());
                try (ResultSet rs = stmt.executeQuery();){
                    while (rs.next()) {
                        String parentTable = rs.getString("BASE_PHYSICAL_TABLE");
                        String tenantId = rs.getString("TENANT_ID");
                        String viewSchema = rs.getString("VIEW_SCHEMA");
                        String viewName = rs.getString("VIEW_NAME");
                        ArrayList<ViewKey> viewKeysList = (ArrayList<ViewKey>)parentTableViewsMap.get(parentTable);
                        if (viewKeysList == null) {
                            viewKeysList = new ArrayList<ViewKey>();
                            parentTableViewsMap.put(parentTable, viewKeysList);
                        }
                        viewKeysList.add(new ViewKey(tenantId, viewSchema, viewName));
                    }
                }
            }
            boolean clearCache = false;
            for (Map.Entry entry : parentTableViewsMap.entrySet()) {
                String physicalTable = (String)entry.getKey();
                String baseTableSchemaName = SchemaUtil.getSchemaNameFromFullName(physicalTable).equals("") ? null : SchemaUtil.getSchemaNameFromFullName(physicalTable);
                String baseTableName = SchemaUtil.getTableNameFromFullName(physicalTable);
                ArrayList<ColumnDetails> basePhysicalTableColumns = new ArrayList<ColumnDetails>();
                String fetchColumnInfoForBasePhysicalTable = "SELECT COLUMN_NAME,COLUMN_FAMILY,DATA_TYPE,COLUMN_SIZE,DECIMAL_DIGITS,ORDINAL_POSITION,SORT_ORDER,ARRAY_SIZE FROM SYSTEM.CATALOG WHERE TABLE_SCHEM %s AND TABLE_NAME = ? AND COLUMN_NAME IS NOT NULL AND LINK_TYPE IS NULL ORDER BY ORDINAL_POSITION";
                PreparedStatement stmt = null;
                if (baseTableSchemaName == null) {
                    fetchColumnInfoForBasePhysicalTable = String.format(fetchColumnInfoForBasePhysicalTable, "IS NULL ");
                    stmt = metaConnection.prepareStatement(fetchColumnInfoForBasePhysicalTable);
                    stmt.setString(1, baseTableName);
                } else {
                    fetchColumnInfoForBasePhysicalTable = String.format(fetchColumnInfoForBasePhysicalTable, " = ? ");
                    stmt = metaConnection.prepareStatement(fetchColumnInfoForBasePhysicalTable);
                    stmt.setString(1, baseTableSchemaName);
                    stmt.setString(2, baseTableName);
                }
                try (ResultSet rs = stmt.executeQuery();){
                    while (rs.next()) {
                        basePhysicalTableColumns.add(new ColumnDetails(rs.getString("COLUMN_FAMILY"), rs.getString("COLUMN_NAME"), rs.getInt("ORDINAL_POSITION"), rs.getInt("DATA_TYPE"), rs.getInt("COLUMN_SIZE"), rs.getInt("DECIMAL_DIGITS"), rs.getInt("SORT_ORDER"), rs.getInt("ARRAY_SIZE")));
                    }
                }
                List viewKeys = (List)entry.getValue();
                StringBuilder sb = new StringBuilder();
                sb.append("SELECT TENANT_ID,TABLE_SCHEM,TABLE_NAME,COLUMN_NAME,COLUMN_FAMILY,DATA_TYPE,COLUMN_SIZE,DECIMAL_DIGITS,ORDINAL_POSITION,SORT_ORDER,ARRAY_SIZE FROM SYSTEM.CATALOG WHERE COLUMN_NAME IS NOT NULL AND ORDINAL_POSITION <= ? AND (TENANT_ID, TABLE_SCHEM, TABLE_NAME) IN (");
                int numViews = viewKeys.size();
                for (int i = 0; i < numViews; ++i) {
                    sb.append(" (?, ?, ?) ");
                    if (i >= numViews - 1) continue;
                    sb.append(", ");
                }
                sb.append(" ) ");
                sb.append(" GROUP BY TENANT_ID,TABLE_SCHEM,TABLE_NAME,COLUMN_NAME,COLUMN_FAMILY,DATA_TYPE,COLUMN_SIZE,DECIMAL_DIGITS,ORDINAL_POSITION,SORT_ORDER,ARRAY_SIZE ORDER BY TENANT_ID,TABLE_SCHEM, TABLE_NAME, ORDINAL_POSITION");
                String fetchViewColumnsSql = sb.toString();
                stmt = metaConnection.prepareStatement(fetchViewColumnsSql);
                int numColsInBaseTable = basePhysicalTableColumns.size();
                stmt.setInt(1, numColsInBaseTable);
                int paramIndex = 1;
                stmt.setInt(paramIndex++, numColsInBaseTable);
                for (ViewKey view : viewKeys) {
                    stmt.setString(paramIndex++, view.tenantId);
                    stmt.setString(paramIndex++, view.schema);
                    stmt.setString(paramIndex++, view.name);
                }
                String currentTenantId = null;
                String currentViewSchema = null;
                String currentViewName = null;
                try (ResultSet rs = stmt.executeQuery();){
                    int numBaseTableColsMatched = 0;
                    boolean ignore = false;
                    boolean baseColumnCountUpserted = false;
                    while (rs.next()) {
                        int arraySize;
                        int sortOrder;
                        int decimalDigits;
                        int columnSize;
                        int dataType;
                        int ordinalPos;
                        String viewTenantId = rs.getString("TENANT_ID");
                        String viewSchema = rs.getString("TABLE_SCHEM");
                        String viewName = rs.getString("TABLE_NAME");
                        if (!(Objects.equal((Object)viewTenantId, currentTenantId) && Objects.equal((Object)viewSchema, currentViewSchema) && Objects.equal((Object)viewName, currentViewName))) {
                            if (currentViewName != null && !baseColumnCountUpserted && numBaseTableColsMatched < numColsInBaseTable) {
                                UpgradeUtil.upsertBaseColumnCountInHeaderRow(metaConnection, currentTenantId, currentViewSchema, currentViewName, -100);
                                clearCache = true;
                            }
                            numBaseTableColsMatched = 0;
                            currentTenantId = viewTenantId;
                            currentViewSchema = viewSchema;
                            currentViewName = viewName;
                            ignore = false;
                            baseColumnCountUpserted = false;
                        }
                        if (ignore) continue;
                        ColumnDetails baseTableColumn = (ColumnDetails)basePhysicalTableColumns.get(numBaseTableColsMatched);
                        String columName = rs.getString("COLUMN_NAME");
                        String columnFamily = rs.getString("COLUMN_FAMILY");
                        ColumnDetails viewColumn = new ColumnDetails(columnFamily, columName, ordinalPos = rs.getInt("ORDINAL_POSITION"), dataType = rs.getInt("DATA_TYPE"), columnSize = rs.getInt("COLUMN_SIZE"), decimalDigits = rs.getInt("DECIMAL_DIGITS"), sortOrder = rs.getInt("SORT_ORDER"), arraySize = rs.getInt("ARRAY_SIZE"));
                        if (baseTableColumn.equals(viewColumn)) {
                            if (++numBaseTableColsMatched != numColsInBaseTable) continue;
                            UpgradeUtil.upsertBaseColumnCountInHeaderRow(metaConnection, viewTenantId, viewSchema, viewName, numColsInBaseTable);
                            baseColumnCountUpserted = true;
                            clearCache = true;
                            continue;
                        }
                        UpgradeUtil.upsertBaseColumnCountInHeaderRow(metaConnection, viewTenantId, viewSchema, viewName, -100);
                        baseColumnCountUpserted = true;
                        clearCache = true;
                        ignore = true;
                    }
                }
                UpgradeUtil.upsertBaseColumnCountInHeaderRow(metaConnection, null, baseTableSchemaName, baseTableName, -1);
                metaConnection.commit();
            }
            if (clearCache) {
                metaConnection.getQueryServices().clearCache();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addParentToChildLinks(PhoenixConnection oldMetaConnection) throws SQLException {
        try (PhoenixConnection metaConnection = null;){
            metaConnection = new PhoenixConnection(oldMetaConnection, Long.MAX_VALUE);
            LOGGER.info("Upgrading metadata to add parent to child links for views");
            metaConnection.commit();
            String createChildLink = "UPSERT INTO SYSTEM.CATALOG(TENANT_ID,TABLE_SCHEM,TABLE_NAME,COLUMN_NAME,COLUMN_FAMILY,LINK_TYPE)SELECT PARENT_TENANT_ID,       CASE INSTR(COLUMN_FAMILY,'.')              WHEN 0 THEN NULL              ELSE REGEXP_SUBSTR(COLUMN_FAMILY,'[^\\.]+')       END AS PARENT_SCHEMA,       CASE INSTR(COLUMN_FAMILY,'.')              WHEN 0 THEN COLUMN_FAMILY              ELSE SUBSTR(COLUMN_FAMILY,INSTR(COLUMN_FAMILY,'.')+1)       END AS PARENT_TABLE,       TENANT_ID,       CASE WHEN TABLE_SCHEM IS NULL THEN TABLE_NAME            ELSE TABLE_SCHEM||'.'||TABLE_NAME       END AS VIEW_NAME,       4 AS LINK_TYPE FROM SYSTEM.CATALOG(PARENT_TENANT_ID VARCHAR)WHERE LINK_TYPE = 2 AND TABLE_TYPE IS NULL AND (TENANT_ID, TABLE_SCHEM, TABLE_NAME) NOT IN (          SELECT TENANT_ID,               TABLE_SCHEM,               TABLE_NAME        FROM   SYSTEM.CATALOG        WHERE  LINK_TYPE = 3 )";
            metaConnection.createStatement().execute(createChildLink);
            metaConnection.commit();
            String createGrandChildLink = "UPSERT INTO SYSTEM.CATALOG(TENANT_ID,TABLE_SCHEM,TABLE_NAME,COLUMN_NAME,COLUMN_FAMILY,LINK_TYPE)SELECT PARENT_TENANT_ID,       CASE INSTR(COLUMN_FAMILY,'.')              WHEN 0 THEN NULL              ELSE REGEXP_SUBSTR(COLUMN_FAMILY,'[^\\.]+')       END AS PARENT_SCHEMA,       CASE INSTR(COLUMN_FAMILY,'.')              WHEN 0 THEN COLUMN_FAMILY              ELSE SUBSTR(COLUMN_FAMILY,INSTR(COLUMN_FAMILY,'.')+1)       END AS PARENT_TABLE,       TENANT_ID,       CASE WHEN TABLE_SCHEM IS NULL THEN TABLE_NAME            ELSE TABLE_SCHEM||'.'||TABLE_NAME       END AS VIEW_NAME,       4 AS LINK_TYPE FROM SYSTEM.CATALOG(PARENT_TENANT_ID VARCHAR)WHERE LINK_TYPE = 3 ";
            metaConnection.createStatement().execute(createGrandChildLink);
            metaConnection.commit();
            metaConnection.getQueryServices().clearCache();
        }
    }

    public static void moveOrCopyChildLinks(PhoenixConnection oldMetaConnection, Map<String, String> options) throws IOException {
        long numberOfCopiedParentChildRows = 0L;
        long numberOfDeletedParentChildRows = 0L;
        boolean moveChildLinksDuringUpgradeEnabled = oldMetaConnection.getQueryServices().getProps().getBoolean("phoenix.move.child_link.during.upgrade", true);
        Configuration conf = oldMetaConnection.getQueryServices().getConfiguration();
        ReadOnlyProps readOnlyProps = oldMetaConnection.getQueryServices().getProps();
        TableName sysCat = SchemaUtil.getPhysicalTableName(PhoenixDatabaseMetaData.SYSTEM_CATALOG_NAME, readOnlyProps);
        TableName sysChildLink = SchemaUtil.getPhysicalTableName(PhoenixDatabaseMetaData.SYSTEM_CHILD_LINK_NAME, readOnlyProps);
        LOGGER.debug(String.format("SYSTEM CATALOG tabled use for copying child links: %s", sysCat.toString()));
        LOGGER.debug(String.format("SYSTEM CHILD LINK table used for copying child links: %s", sysChildLink.toString()));
        try (Connection moveChildLinkConnection = UpgradeUtil.getHBaseConnection(conf, options);
             Table sysCatalogTable = moveChildLinkConnection.getTable(sysCat);){
            boolean pageMore = false;
            byte[] lastRowKey = null;
            do {
                Scan scan = new Scan();
                scan.addFamily(QueryConstants.DEFAULT_COLUMN_FAMILY_BYTES);
                SingleColumnValueFilter childLinkFilter = new SingleColumnValueFilter(QueryConstants.DEFAULT_COLUMN_FAMILY_BYTES, PhoenixDatabaseMetaData.LINK_TYPE_BYTES, CompareOperator.EQUAL, new byte[]{PTable.LinkType.CHILD_TABLE.getSerializedValue()});
                childLinkFilter.setFilterIfMissing(true);
                PageFilter pf = new PageFilter(32768L);
                scan.setFilter((Filter)new FilterList(FilterList.Operator.MUST_PASS_ALL, new Filter[]{pf, childLinkFilter}));
                if (pageMore) {
                    scan.withStartRow(lastRowKey, false);
                }
                try (ResultScanner scanner = sysCatalogTable.getScanner(scan);){
                    int count = 0;
                    ArrayList<byte[]> rowKeys = new ArrayList<byte[]>();
                    ArrayList<Put> puts = new ArrayList<Put>();
                    Result rr = scanner.next();
                    while (rr != null) {
                        ++count;
                        lastRowKey = rr.getRow();
                        byte[] tmpKey = new byte[lastRowKey.length];
                        System.arraycopy(lastRowKey, 0, tmpKey, 0, tmpKey.length);
                        long rowTS = rr.rawCells()[0].getTimestamp();
                        rowKeys.add(tmpKey);
                        Put put = new Put(tmpKey);
                        put.addColumn(QueryConstants.DEFAULT_COLUMN_FAMILY_BYTES, QueryConstants.EMPTY_COLUMN_BYTES, rowTS, QueryConstants.EMPTY_COLUMN_VALUE_BYTES);
                        put.addColumn(QueryConstants.DEFAULT_COLUMN_FAMILY_BYTES, PhoenixDatabaseMetaData.LINK_TYPE_BYTES, rowTS, LINK_ROW);
                        puts.add(put);
                        rr = scanner.next();
                    }
                    if (puts.size() > 0) {
                        Object[] putResults = new Object[puts.size()];
                        try (Table childLinkTable = moveChildLinkConnection.getTable(sysChildLink);){
                            childLinkTable.batch(puts, putResults);
                            if (moveChildLinksDuringUpgradeEnabled) {
                                ArrayList deletes = Lists.newArrayList();
                                for (int i = 0; i < putResults.length; ++i) {
                                    if (!java.util.Objects.nonNull(putResults[i])) continue;
                                    deletes.add(new Delete((byte[])rowKeys.get(i)));
                                }
                                numberOfCopiedParentChildRows += (long)deletes.size();
                                Object[] deleteResults = new Object[deletes.size()];
                                sysCatalogTable.batch((List)deletes, deleteResults);
                                int numDeletes = 0;
                                for (int i = 0; i < deleteResults.length; ++i) {
                                    if (!java.util.Objects.nonNull(deleteResults[i])) continue;
                                    ++numDeletes;
                                }
                                numberOfDeletedParentChildRows += (long)numDeletes;
                            } else {
                                int numCopied = 0;
                                for (int i = 0; i < putResults.length; ++i) {
                                    if (!java.util.Objects.nonNull(putResults[i])) continue;
                                    ++numCopied;
                                }
                                numberOfCopiedParentChildRows += (long)numCopied;
                            }
                        }
                        catch (Exception e) {
                            LOGGER.error(String.format("Failed adding child link batch from %s to %s with Exception :", PhoenixDatabaseMetaData.SYSTEM_CATALOG_NAME, PhoenixDatabaseMetaData.SYSTEM_CHILD_LINK_NAME), (Throwable)e);
                        }
                    }
                    pageMore = count != 0;
                    LOGGER.info(String.format("moveOrCopyChildLinks in progress => numberOfCopiedParentChildRows: %d numberOfDeletedParentChildRows: %d", numberOfCopiedParentChildRows, numberOfDeletedParentChildRows));
                }
            } while (pageMore);
        }
        catch (IOException ioe) {
            LOGGER.error(String.format("Failed adding child link rows from %s to %s with Exception :", PhoenixDatabaseMetaData.SYSTEM_CATALOG_NAME, PhoenixDatabaseMetaData.SYSTEM_CHILD_LINK_NAME), (Throwable)ioe);
            throw ioe;
        }
        LOGGER.info(String.format("Finished moving/copying child link rows from %s to %s ", PhoenixDatabaseMetaData.SYSTEM_CATALOG_NAME, PhoenixDatabaseMetaData.SYSTEM_CHILD_LINK_NAME));
    }

    public static void copyTTLValuesFromPhoenixTTLColumnToTTLColumn(PhoenixConnection oldMetaConnection, Map<String, String> options) throws IOException {
        long numOfCopiedTTLRows = 0L;
        ReadOnlyProps readOnlyProps = oldMetaConnection.getQueryServices().getProps();
        TableName sysCat = SchemaUtil.getPhysicalTableName(PhoenixDatabaseMetaData.SYSTEM_CATALOG_NAME, readOnlyProps);
        LOGGER.debug(String.format("SYSTEM CATALOG tabled use for copying TTL values: %s", sysCat.toString()));
        Configuration conf = oldMetaConnection.getQueryServices().getConfiguration();
        try (Connection copyTTLConnection = UpgradeUtil.getHBaseConnection(conf, options);
             Table sysCatalogTable = copyTTLConnection.getTable(sysCat);){
            boolean pageMore = false;
            byte[] lastRowKey = null;
            do {
                Scan scan = new Scan();
                scan.addFamily(QueryConstants.DEFAULT_COLUMN_FAMILY_BYTES);
                SingleColumnValueFilter copyTTLFilter = new SingleColumnValueFilter(QueryConstants.DEFAULT_COLUMN_FAMILY_BYTES, PhoenixDatabaseMetaData.PHOENIX_TTL_BYTES, CompareOperator.NOT_EQUAL, (byte[])null);
                copyTTLFilter.setFilterIfMissing(true);
                PageFilter pf = new PageFilter(32768L);
                scan.setFilter((Filter)new FilterList(FilterList.Operator.MUST_PASS_ALL, new Filter[]{pf, copyTTLFilter}));
                if (pageMore) {
                    scan.withStartRow(lastRowKey, false);
                }
                try (ResultScanner scanner = sysCatalogTable.getScanner(scan);){
                    int count = 0;
                    ArrayList<byte[]> rowKeys = new ArrayList<byte[]>();
                    ArrayList<Put> puts = new ArrayList<Put>();
                    Result rr = scanner.next();
                    while (rr != null) {
                        ++count;
                        lastRowKey = rr.getRow();
                        byte[] tmpKey = new byte[lastRowKey.length];
                        System.arraycopy(lastRowKey, 0, tmpKey, 0, tmpKey.length);
                        long rowTS = rr.rawCells()[0].getTimestamp();
                        rowKeys.add(tmpKey);
                        Put put = new Put(tmpKey);
                        put.addColumn(QueryConstants.DEFAULT_COLUMN_FAMILY_BYTES, QueryConstants.EMPTY_COLUMN_BYTES, rowTS, QueryConstants.EMPTY_COLUMN_VALUE_BYTES);
                        int result = new BigInteger(rr.getValue(QueryConstants.DEFAULT_COLUMN_FAMILY_BYTES, PhoenixDatabaseMetaData.PHOENIX_TTL_BYTES)).intValue();
                        if (result < 0) {
                            result = Integer.MAX_VALUE;
                        }
                        put.addColumn(QueryConstants.DEFAULT_COLUMN_FAMILY_BYTES, PhoenixDatabaseMetaData.TTL_BYTES, rowTS, PVarchar.INSTANCE.toBytes(String.valueOf(result)));
                        puts.add(put);
                        rr = scanner.next();
                    }
                    if (puts.size() > 0) {
                        Object[] putResults = new Object[puts.size()];
                        try (Table copyTTLTable = copyTTLConnection.getTable(sysCat);){
                            copyTTLTable.batch(puts, putResults);
                            int numCopied = 0;
                            for (int i = 0; i < putResults.length; ++i) {
                                if (!java.util.Objects.nonNull(putResults[i])) continue;
                                ++numCopied;
                            }
                            numOfCopiedTTLRows += (long)numCopied;
                        }
                        catch (Exception e) {
                            LOGGER.error(String.format("Failed copying ttl value batch from PHOENIX_TTL column to TTL column on %s with Exception :", PhoenixDatabaseMetaData.SYSTEM_CATALOG_NAME), (Throwable)e);
                        }
                    }
                    pageMore = count != 0;
                    LOGGER.info(String.format("copyTTLValues From PHOENIX_TTL to TTL Column is in progress => numOfCopiedTTLRows: %d", numOfCopiedTTLRows));
                }
            } while (pageMore);
        }
        catch (IOException ioe) {
            LOGGER.error(String.format("Failed copying ttl value batch from PHOENIX_TTL column to TTL column in %s with Exception :", PhoenixDatabaseMetaData.SYSTEM_CATALOG_NAME), (Throwable)ioe);
            throw ioe;
        }
        LOGGER.info(String.format("Finished copying ttl values link rows from PHOENIX_TTL column to TTL column on %s ", PhoenixDatabaseMetaData.SYSTEM_CATALOG_NAME));
    }

    public static void moveHBaseLevelTTLToSYSCAT(PhoenixConnection oldMetaConnection, Map<String, String> options) throws IOException {
        long numOfTableThatHasTTLMoved = 0L;
        ReadOnlyProps readOnlyProps = oldMetaConnection.getQueryServices().getProps();
        TableName sysCat = SchemaUtil.getPhysicalTableName(PhoenixDatabaseMetaData.SYSTEM_CATALOG_NAME, readOnlyProps);
        LOGGER.info(String.format("SYSTEM CATALOG table use for copying TTL values: %s", sysCat.toString()));
        Configuration conf = oldMetaConnection.getQueryServices().getConfiguration();
        try (Connection moveTTLConnection = UpgradeUtil.getHBaseConnection(conf, options);
             Table sysCatalogTable = moveTTLConnection.getTable(sysCat);
             Admin admin = moveTTLConnection.getAdmin();){
            boolean pageMore = false;
            byte[] lastRowKey = null;
            do {
                Scan scan = new Scan();
                scan.addFamily(QueryConstants.DEFAULT_COLUMN_FAMILY_BYTES);
                QualifierFilter tableTypeQualifierFilter = new QualifierFilter(CompareOperator.EQUAL, (ByteArrayComparable)new BinaryComparator(PhoenixDatabaseMetaData.TABLE_TYPE_BYTES));
                SingleColumnValueFilter tableTypeFilter = new SingleColumnValueFilter(QueryConstants.DEFAULT_COLUMN_FAMILY_BYTES, PhoenixDatabaseMetaData.TABLE_TYPE_BYTES, CompareOperator.EQUAL, PTableType.TABLE.getSerializedValue().getBytes(StandardCharsets.UTF_8));
                tableTypeFilter.setFilterIfMissing(true);
                PageFilter pf = new PageFilter(32768L);
                scan.setFilter((Filter)new FilterList(FilterList.Operator.MUST_PASS_ALL, new Filter[]{pf, tableTypeQualifierFilter, tableTypeFilter}));
                if (pageMore) {
                    scan.withStartRow(lastRowKey, false);
                }
                String currentTableName = "";
                try (ResultScanner scanner = sysCatalogTable.getScanner(scan);){
                    int count = 0;
                    ArrayList<byte[]> rowKeys = new ArrayList<byte[]>();
                    ArrayList<Put> mutations = new ArrayList<Put>();
                    Result rr = scanner.next();
                    while (rr != null) {
                        String fullTableName;
                        ++count;
                        lastRowKey = rr.getRow();
                        byte[] tmpKey = new byte[lastRowKey.length];
                        System.arraycopy(lastRowKey, 0, tmpKey, 0, tmpKey.length);
                        rowKeys.add(tmpKey);
                        byte[][] rowKeyMetaData = new byte[3][];
                        SchemaUtil.getVarChars(tmpKey, 3, rowKeyMetaData);
                        byte[] schemaName = rowKeyMetaData[1];
                        byte[] tableName = rowKeyMetaData[2];
                        currentTableName = fullTableName = SchemaUtil.getTableName(schemaName, tableName);
                        if (!SchemaUtil.isSystemTable(SchemaUtil.getTableNameAsBytes(schemaName, tableName))) {
                            PTable pTable = oldMetaConnection.getTable(null, fullTableName);
                            byte[] emptyCF = SchemaUtil.getEmptyColumnFamily(pTable);
                            TableDescriptor tableDesc = admin.getDescriptor(SchemaUtil.getPhysicalTableName(fullTableName, readOnlyProps));
                            ColumnFamilyDescriptor cfd = tableDesc.getColumnFamily(emptyCF);
                            if (cfd == null) {
                                LOGGER.warn("No emptyCF found. Not upgrading HBase level TTL definition for table {}", (Object)fullTableName);
                            } else {
                                LOGGER.info("Upgrading HBase level TTL definition for table {}", (Object)fullTableName);
                                int ttl = cfd.getTimeToLive();
                                long rowTS = EnvironmentEdgeManager.currentTimeMillis();
                                if (ttl != Integer.MAX_VALUE && ttl != 0) {
                                    Put put = new Put(tmpKey);
                                    put.addColumn(QueryConstants.DEFAULT_COLUMN_FAMILY_BYTES, QueryConstants.EMPTY_COLUMN_BYTES, rowTS, QueryConstants.EMPTY_COLUMN_VALUE_BYTES);
                                    put.addColumn(QueryConstants.DEFAULT_COLUMN_FAMILY_BYTES, PhoenixDatabaseMetaData.TTL_BYTES, rowTS, PVarchar.INSTANCE.toBytes(LiteralTTLExpression.TTL_EXPRESSION_DEFINED_IN_TABLE_DESCRIPTOR.getTTLExpression()));
                                    mutations.add(put);
                                }
                            }
                        }
                        rr = scanner.next();
                    }
                    if (!mutations.isEmpty()) {
                        Object[] mutationResults = new Object[mutations.size()];
                        try (Table moveTTLTable = moveTTLConnection.getTable(sysCat);){
                            moveTTLTable.batch(mutations, mutationResults);
                            int numMoved = 0;
                            for (Object mutationResult : mutationResults) {
                                if (!java.util.Objects.nonNull(mutationResult)) continue;
                                ++numMoved;
                            }
                            numOfTableThatHasTTLMoved += (long)numMoved;
                        }
                        catch (Exception e) {
                            LOGGER.error(String.format("Failed moving ttl value batch from ColumnDescriptor to TTL column on %s with Exception :", PhoenixDatabaseMetaData.SYSTEM_CATALOG_NAME), (Throwable)e);
                            throw new IOException(e);
                        }
                    }
                    pageMore = count != 0;
                    LOGGER.info(String.format("moveTTLValues From ColumnDescriptor to TTL Column is in progress => numOfTableHasTTLMoved: %d", numOfTableThatHasTTLMoved));
                }
                catch (Exception e) {
                    LOGGER.error(String.format("Failed moving ttl value to TTL column for %s with Exception :", currentTableName), (Throwable)e);
                    throw new IOException(e);
                }
            } while (pageMore);
        }
        catch (IOException ioe) {
            LOGGER.error(String.format("Failed moving ttl value batch from ColumnDescriptor to TTL column in %s with Exception :", PhoenixDatabaseMetaData.SYSTEM_CATALOG_NAME), (Throwable)ioe);
            throw ioe;
        }
        LOGGER.info(String.format("Finished moving ttl value batch from ColumnDescriptor to TTL column on %s ", PhoenixDatabaseMetaData.SYSTEM_CATALOG_NAME));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addViewIndexToParentLinks(PhoenixConnection oldMetaConnection) throws SQLException {
        PhoenixConnection metaConn = null;
        boolean isMetaConnUsingQueryConn = true;
        try (PhoenixConnection queryConn = new PhoenixConnection(oldMetaConnection, Long.MAX_VALUE);
             PhoenixConnection upsertConn = new PhoenixConnection(oldMetaConnection, Long.MAX_VALUE);){
            LOGGER.info("Upgrading metadata to add parent links for indexes on views");
            String indexQuery = "SELECT TENANT_ID, TABLE_SCHEM, TABLE_NAME, COLUMN_FAMILY FROM SYSTEM.CATALOG WHERE LINK_TYPE = " + PTable.LinkType.INDEX_TABLE.getSerializedValue();
            String createViewIndexLink = "UPSERT INTO SYSTEM.CATALOG (TENANT_ID, TABLE_SCHEM, TABLE_NAME, COLUMN_FAMILY, LINK_TYPE) VALUES (?,?,?,?,?) ";
            ResultSet rs = queryConn.createStatement().executeQuery(indexQuery);
            String prevTenantId = null;
            metaConn = queryConn;
            Properties props = new Properties(queryConn.getClientInfo());
            props.setProperty("CurrentSCN", Long.toString(Long.MAX_VALUE));
            while (rs.next()) {
                String tenantId = rs.getString("TENANT_ID");
                if (!java.util.Objects.equals(prevTenantId, tenantId)) {
                    prevTenantId = tenantId;
                    props.setProperty("TenantId", tenantId);
                    if (!isMetaConnUsingQueryConn) {
                        metaConn.close();
                    }
                    metaConn = new PhoenixConnection(oldMetaConnection, props);
                    isMetaConnUsingQueryConn = false;
                }
                String schemaName = rs.getString("TABLE_SCHEM");
                String parentTableName = rs.getString("TABLE_NAME");
                String fullParentTableName = SchemaUtil.getTableName(schemaName, parentTableName);
                String indexName = rs.getString("COLUMN_FAMILY");
                PTable table = metaConn.getTable(fullParentTableName);
                if (table == null) {
                    throw new TableNotFoundException(fullParentTableName);
                }
                if (!table.getType().equals((Object)PTableType.VIEW)) continue;
                PreparedStatement prepareStatement = upsertConn.prepareStatement(createViewIndexLink);
                prepareStatement.setString(1, tenantId);
                prepareStatement.setString(2, schemaName);
                prepareStatement.setString(3, indexName);
                prepareStatement.setString(4, parentTableName);
                prepareStatement.setByte(5, PTable.LinkType.VIEW_INDEX_PARENT_TABLE.getSerializedValue());
                prepareStatement.execute();
                upsertConn.commit();
            }
            queryConn.getQueryServices().clearCache();
        }
        finally {
            if (!isMetaConnUsingQueryConn) {
                metaConn.close();
            }
        }
    }

    private static TableDescriptorBuilder syncColFamProperties(TableDescriptor tableDesc, ColumnFamilyDescriptor defaultColFam, Map<String, Object> syncedProps) {
        TableDescriptorBuilder tableDescBuilder = TableDescriptorBuilder.newBuilder((TableDescriptor)tableDesc);
        for (ColumnFamilyDescriptor currentColFam : tableDesc.getColumnFamilies()) {
            if (currentColFam.equals(defaultColFam)) continue;
            ColumnFamilyDescriptorBuilder colFamDescBuilder = ColumnFamilyDescriptorBuilder.newBuilder((ColumnFamilyDescriptor)currentColFam);
            for (String prop : MetaDataUtil.SYNCED_DATA_TABLE_AND_INDEX_COL_FAM_PROPERTIES) {
                String existingPropVal = Bytes.toString((byte[])currentColFam.getValue(Bytes.toBytes((String)prop)));
                String expectedPropVal = syncedProps.get(prop).toString();
                if (existingPropVal != null && existingPropVal.toLowerCase().equals(expectedPropVal.toLowerCase())) continue;
                colFamDescBuilder.setValue(prop, expectedPropVal);
            }
            if (colFamDescBuilder.equals(ColumnFamilyDescriptorBuilder.newBuilder((ColumnFamilyDescriptor)currentColFam))) continue;
            tableDescBuilder.modifyColumnFamily(colFamDescBuilder.build());
        }
        return tableDescBuilder;
    }

    private static void addTableDescIfPropsChanged(TableDescriptor origTableDesc, ColumnFamilyDescriptor defaultColFam, Map<String, Object> syncedProps, Set<TableDescriptor> tableDescsToSync) throws SQLException {
        TableDescriptorBuilder tableDescBuilder = UpgradeUtil.syncColFamProperties(origTableDesc, defaultColFam, syncedProps);
        if (!origTableDesc.equals(tableDescBuilder.build())) {
            tableDescsToSync.add(tableDescBuilder.build());
        }
    }

    private static void syncGlobalIndexesForTable(ConnectionQueryServices cqs, PTable baseTable, ColumnFamilyDescriptor defaultColFam, Map<String, Object> syncedProps, Set<TableDescriptor> tableDescsToSync) throws SQLException {
        for (PTable indexTable : baseTable.getIndexes()) {
            if (!IndexUtil.isGlobalIndex(indexTable)) continue;
            UpgradeUtil.addTableDescIfPropsChanged(cqs.getTableDescriptor(indexTable.getPhysicalName().getBytes()), defaultColFam, syncedProps, tableDescsToSync);
        }
    }

    private static void syncViewIndexTable(ConnectionQueryServices cqs, PTable baseTable, ColumnFamilyDescriptor defaultColFam, Map<String, Object> syncedProps, Set<TableDescriptor> tableDescsToSync) throws SQLException {
        String viewIndexName = MetaDataUtil.getViewIndexPhysicalName(baseTable.getName().getString());
        if (!Strings.isNullOrEmpty((String)viewIndexName)) {
            try {
                UpgradeUtil.addTableDescIfPropsChanged(cqs.getTableDescriptor(Bytes.toBytes((String)viewIndexName)), defaultColFam, syncedProps, tableDescsToSync);
            }
            catch (TableNotFoundException tableNotFoundException) {
                // empty catch block
            }
        }
    }

    private static void syncUpdateCacheFreqForIndexesOfTable(PTable baseTable, PreparedStatement stmt, String tenantId) throws SQLException {
        for (PTable index : baseTable.getIndexes()) {
            if (index.getUpdateCacheFrequency() == baseTable.getUpdateCacheFrequency()) continue;
            stmt.setString(1, tenantId);
            stmt.setString(2, index.getSchemaName().getString());
            stmt.setString(3, index.getTableName().getString());
            stmt.setLong(4, baseTable.getUpdateCacheFrequency());
            stmt.addBatch();
        }
    }

    public static void syncUpdateCacheFreqAllIndexes(PhoenixConnection conn, PTable table) throws SQLException, IOException {
        try (PhoenixConnection newConn = new PhoenixConnection(conn, Long.MAX_VALUE);){
            newConn.unwrap(PhoenixConnection.class).getQueryServices().clearCache();
            byte[] tenantId = newConn.getTenantId() != null ? newConn.getTenantId().getBytes() : null;
            PreparedStatement stmt = newConn.prepareStatement(UPSERT_UPDATE_CACHE_FREQUENCY);
            UpgradeUtil.syncUpdateCacheFreqForIndexesOfTable(table, stmt, Bytes.toString((byte[])tenantId));
            TableViewFinderResult childViewsResult = new TableViewFinderResult();
            for (int i = 0; i < 2; ++i) {
                try (Table sysCatOrSysChildLinkTable = newConn.getQueryServices().getTable(SchemaUtil.getPhysicalName(i == 0 ? PhoenixDatabaseMetaData.SYSTEM_CHILD_LINK_NAME_BYTES : PhoenixDatabaseMetaData.SYSTEM_CATALOG_TABLE_BYTES, newConn.getQueryServices().getProps()).getName());){
                    ViewUtil.findAllRelatives(sysCatOrSysChildLinkTable, tenantId, table.getSchemaName().getBytes(), table.getTableName().getBytes(), PTable.LinkType.CHILD_TABLE, childViewsResult);
                    for (TableInfo tableInfo : childViewsResult.getLinks()) {
                        UpgradeUtil.getViewAndSyncCacheFreqForIndexes(newConn, stmt, tableInfo);
                    }
                    break;
                }
                catch (TableNotFoundException ex) {
                    if (i != 1) continue;
                    throw ex;
                }
            }
            stmt.executeBatch();
            newConn.commit();
        }
    }

    private static void getViewAndSyncCacheFreqForIndexes(PhoenixConnection newConn, PreparedStatement stmt, TableInfo tableInfo) throws SQLException {
        Optional<PTable> view;
        String viewName = SchemaUtil.getTableName(tableInfo.getSchemaName(), tableInfo.getTableName());
        String viewTenantId = Bytes.toString((byte[])tableInfo.getTenantId());
        if (StringUtils.isNotEmpty((CharSequence)viewTenantId)) {
            Properties props = new Properties(newConn.getClientInfo());
            props.setProperty("TenantId", viewTenantId);
            try (PhoenixConnection tenantConn = new PhoenixConnection(newConn, props);){
                view = UpgradeUtil.resolveView(viewName, tenantConn);
            }
        } else {
            view = UpgradeUtil.resolveView(viewName, newConn);
        }
        if (view.isPresent()) {
            UpgradeUtil.syncUpdateCacheFreqForIndexesOfTable(view.get(), stmt, viewTenantId);
        }
    }

    private static Optional<PTable> resolveView(String viewName, PhoenixConnection conn) throws SQLException {
        PTable view;
        try {
            view = conn.getTable(viewName);
        }
        catch (TableNotFoundException e) {
            LOGGER.error("Error getting PTable for view: {}", (Object)viewName, (Object)e);
            return Optional.empty();
        }
        return Optional.of(view);
    }

    public static void syncTableAndIndexProperties(PhoenixConnection conn) throws SQLException, IOException {
        try (Admin admin = conn.getQueryServices().getAdmin();){
            HashSet<TableDescriptor> tableDescriptorsToSynchronize = new HashSet<TableDescriptor>();
            for (TableDescriptor origTableDesc : admin.listTableDescriptors()) {
                PTable table;
                if (MetaDataUtil.isViewIndex(origTableDesc.getTableName().getNameWithNamespaceInclAsString())) continue;
                String fullTableName = SchemaUtil.getPhysicalTableName(origTableDesc.getTableName().getName(), SchemaUtil.isNamespaceMappingEnabled(null, conn.getQueryServices().getProps())).getNameAsString();
                try {
                    table = conn.getTable(null, fullTableName);
                }
                catch (TableNotFoundException e) {
                    LOGGER.warn("Error getting PTable for HBase table: {}", (Object)fullTableName);
                    continue;
                }
                if (table.getType() == PTableType.INDEX) continue;
                UpgradeUtil.syncUpdateCacheFreqAllIndexes(conn, table);
                ColumnFamilyDescriptor defaultColFam = origTableDesc.getColumnFamily(SchemaUtil.getEmptyColumnFamily(table));
                Map<String, Object> syncedProps = MetaDataUtil.getSyncedProps(defaultColFam);
                UpgradeUtil.addTableDescIfPropsChanged(origTableDesc, defaultColFam, syncedProps, tableDescriptorsToSynchronize);
                UpgradeUtil.syncGlobalIndexesForTable(conn.getQueryServices(), table, defaultColFam, syncedProps, tableDescriptorsToSynchronize);
                UpgradeUtil.syncViewIndexTable(conn.getQueryServices(), table, defaultColFam, syncedProps, tableDescriptorsToSynchronize);
            }
            for (TableDescriptor t : tableDescriptorsToSynchronize) {
                admin.modifyTable(t);
            }
        }
    }

    private static void upsertBaseColumnCountInHeaderRow(PhoenixConnection metaConnection, String tenantId, String schemaName, String viewOrTableName, int baseColumnCount) throws SQLException {
        try (PreparedStatement stmt = metaConnection.prepareStatement(UPSERT_BASE_COLUMN_COUNT_IN_HEADER_ROW);){
            stmt.setString(1, tenantId);
            stmt.setString(2, schemaName);
            stmt.setString(3, viewOrTableName);
            stmt.setString(4, null);
            stmt.setString(5, null);
            stmt.setInt(6, baseColumnCount);
            stmt.executeUpdate();
        }
    }

    private static String getTableRVCWithParam(List<String> tableNames) {
        StringBuilder query = new StringBuilder("(");
        for (int i = 0; i < tableNames.size(); i += 3) {
            String tenantId = tableNames.get(i);
            String schemaName = tableNames.get(i + 1);
            String tableName = tableNames.get(i + 2);
            query.append('(');
            query.append(tenantId == null ? "null" : " ? ");
            query.append(',');
            query.append(schemaName == null ? "null" : " ? ");
            query.append(',');
            query.append(" ? ");
            query.append("),");
        }
        query.setCharAt(query.length() - 1, ')');
        return query.toString();
    }

    private static String getTableRVC(List<String> tableNames) {
        StringBuilder query = new StringBuilder("(");
        for (int i = 0; i < tableNames.size(); i += 3) {
            String tenantId = tableNames.get(i);
            String schemaName = tableNames.get(i + 1);
            String tableName = tableNames.get(i + 2);
            query.append('(');
            query.append((String)(tenantId == null ? "null" : "'" + tenantId + "'"));
            query.append(',');
            query.append((String)(schemaName == null ? "null" : "'" + schemaName + "'"));
            query.append(',');
            query.append("'" + tableName + "'");
            query.append("),");
        }
        query.setCharAt(query.length() - 1, ')');
        return query.toString();
    }

    private static List<String> addPhysicalTables(PhoenixConnection conn, ResultSet rs, PTableType otherType, Set<String> physicalTables) throws SQLException {
        ArrayList tableNames = Lists.newArrayListWithExpectedSize((int)1024);
        while (rs.next()) {
            tableNames.add(rs.getString(1));
            tableNames.add(rs.getString(2));
            tableNames.add(rs.getString(3));
        }
        if (tableNames.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList otherTables = Lists.newArrayListWithExpectedSize((int)tableNames.size());
        String query = String.format("SELECT TENANT_ID,TABLE_SCHEM,TABLE_NAME,TABLE_TYPEFROM SYSTEM.CATALOG (ROW_KEY_ORDER_OPTIMIZABLE BOOLEAN)WHERE COLUMN_NAME IS NULLAND COLUMN_FAMILY IS NULLAND ROW_KEY_ORDER_OPTIMIZABLE IS NULLAND TABLE_TYPE IN (%s , %s )AND (TENANT_ID, TABLE_SCHEM, TABLE_NAME) IN %s ", PTableType.TABLE.getSerializedValue(), otherType.getSerializedValue(), UpgradeUtil.getTableRVCWithParam(tableNames));
        try (PreparedStatement selSysCat = conn.prepareStatement(query);){
            int param = 0;
            for (int i = 0; i < tableNames.size(); i += 3) {
                String tenantId = (String)tableNames.get(i);
                String schemaName = (String)tableNames.get(i + 1);
                String tableName = (String)tableNames.get(i + 2);
                if (tenantId != null) {
                    selSysCat.setString(++param, tenantId);
                }
                if (schemaName != null) {
                    selSysCat.setString(++param, schemaName);
                }
                selSysCat.setString(++param, tableName);
            }
            rs = selSysCat.executeQuery();
            while (rs.next()) {
                if (PTableType.TABLE.getSerializedValue().equals(rs.getString(4))) {
                    physicalTables.add(SchemaUtil.getTableName(rs.getString(2), rs.getString(3)));
                    continue;
                }
                otherTables.add(rs.getString(1));
                otherTables.add(rs.getString(2));
                otherTables.add(rs.getString(3));
            }
            ArrayList arrayList = otherTables;
            return arrayList;
        }
    }

    private static String getAffectedDataTypes() {
        StringBuilder buf = new StringBuilder("(" + PVarchar.INSTANCE.getSqlType() + "," + PChar.INSTANCE.getSqlType() + "," + PBinary.INSTANCE.getSqlType() + "," + PFloat.INSTANCE.getSqlType() + "," + PDouble.INSTANCE.getSqlType() + "," + PDecimal.INSTANCE.getSqlType() + ",");
        for (PDataType type : PDataType.values()) {
            if (!type.isArrayType()) continue;
            buf.append(type.getSqlType());
            buf.append(',');
        }
        buf.setCharAt(buf.length() - 1, ')');
        return buf.toString();
    }

    public static List<String> getPhysicalTablesWithDescVarbinaryRowKey(PhoenixConnection conn) throws SQLException {
        String query = "SELECT TENANT_ID,TABLE_SCHEM,TABLE_NAME\nFROM SYSTEM.CATALOG cat1\nWHERE COLUMN_NAME IS NOT NULL\nAND COLUMN_FAMILY IS NULL\nAND SORT_ORDER = " + SortOrder.DESC.getSystemValue() + "\nAND DATA_TYPE = " + PVarbinary.INSTANCE.getSqlType() + "\nGROUP BY TENANT_ID,TABLE_SCHEM,TABLE_NAME";
        return UpgradeUtil.getPhysicalTablesWithDescRowKey(query, conn);
    }

    public static List<String> getPhysicalTablesWithDescRowKey(PhoenixConnection conn) throws SQLException {
        String query = "SELECT TENANT_ID,TABLE_SCHEM,TABLE_NAME\nFROM SYSTEM.CATALOG cat1\nWHERE COLUMN_NAME IS NOT NULL\nAND COLUMN_FAMILY IS NULL\nAND ( ( SORT_ORDER = " + SortOrder.DESC.getSystemValue() + "\n        AND DATA_TYPE IN " + UpgradeUtil.getAffectedDataTypes() + ")\n    OR ( SORT_ORDER = " + SortOrder.ASC.getSystemValue() + "\n         AND DATA_TYPE = " + PBinary.INSTANCE.getSqlType() + "\n         AND COLUMN_SIZE > 1 ) )\nGROUP BY TENANT_ID,TABLE_SCHEM,TABLE_NAME";
        return UpgradeUtil.getPhysicalTablesWithDescRowKey(query, conn);
    }

    private static List<String> getPhysicalTablesWithDescRowKey(String query, PhoenixConnection conn) throws SQLException {
        HashSet physicalTables;
        ResultSet rs = conn.createStatement().executeQuery(query);
        List<String> remainingTableNames = UpgradeUtil.addPhysicalTables(conn, rs, PTableType.INDEX, physicalTables = Sets.newHashSetWithExpectedSize((int)1024));
        if (!remainingTableNames.isEmpty()) {
            String indexLinkQuery = "SELECT TENANT_ID,TABLE_SCHEM,TABLE_NAME\nFROM SYSTEM.CATALOG\nWHERE COLUMN_NAME IS NULL\nAND (TENANT_ID, TABLE_SCHEM, COLUMN_FAMILY) IN " + UpgradeUtil.getTableRVC(remainingTableNames) + "\nAND LINK_TYPE = " + PTable.LinkType.INDEX_TABLE.getSerializedValue();
            rs = conn.createStatement().executeQuery(indexLinkQuery);
            remainingTableNames = UpgradeUtil.addPhysicalTables(conn, rs, PTableType.VIEW, physicalTables);
            if (!remainingTableNames.isEmpty()) {
                String physicalLinkQuery = "SELECT null,  CASE WHEN INSTR(COLUMN_FAMILY,'.') = 0 THEN NULL ELSE SUBSTR(COLUMN_FAMILY,1,INSTR(COLUMN_FAMILY,'.')) END,\n CASE WHEN INSTR(COLUMN_FAMILY,'.') = 0 THEN COLUMN_FAMILY ELSE SUBSTR(COLUMN_FAMILY,INSTR(COLUMN_FAMILY,'.')+1) END\nFROM SYSTEM.CATALOG\nWHERE COLUMN_NAME IS NULL\nAND COLUMN_FAMILY IS NOT NULL\nAND (TENANT_ID, TABLE_SCHEM, TABLE_NAME) IN " + UpgradeUtil.getTableRVC(remainingTableNames) + "\nAND LINK_TYPE = " + PTable.LinkType.PHYSICAL_TABLE.getSerializedValue();
                rs = conn.createStatement().executeQuery(physicalLinkQuery);
                UpgradeUtil.addPhysicalTables(conn, rs, PTableType.TABLE, physicalTables);
            }
        }
        ArrayList<String> sortedPhysicalTables = new ArrayList<String>(physicalTables);
        Collections.sort(sortedPhysicalTables);
        return sortedPhysicalTables;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void upgradeDescVarLengthRowKeys(PhoenixConnection upgradeConn, PhoenixConnection globalConn, String schemaName, String tableName, boolean isTable, boolean bypassUpgrade) throws SQLException {
        TableName physicalName = TableName.valueOf((String)SchemaUtil.getTableName(schemaName, tableName));
        long currentTime = EnvironmentEdgeManager.currentTimeMillis();
        String snapshotName = physicalName + "_" + currentTime;
        Admin admin = null;
        if (isTable && !bypassUpgrade) {
            admin = globalConn.getQueryServices().getAdmin();
        }
        boolean restoreSnapshot = false;
        boolean success = false;
        try {
            String theTableName;
            String theSchemaName;
            String theTenantId;
            int i;
            ResultSet rs;
            if (isTable && !bypassUpgrade) {
                String msg = "Taking snapshot of physical table " + physicalName + " prior to upgrade...";
                System.out.println(msg);
                LOGGER.info(msg);
                admin.disableTable(physicalName);
                admin.snapshot(snapshotName, physicalName);
                admin.enableTable(physicalName);
                restoreSnapshot = true;
            }
            String escapedTableName = SchemaUtil.getEscapedTableName(schemaName, tableName);
            Object tenantInfo = "";
            PName tenantId = PName.EMPTY_NAME;
            if (upgradeConn.getTenantId() != null) {
                tenantId = upgradeConn.getTenantId();
                tenantInfo = " for tenant " + tenantId.getString();
            }
            String msg = "Starting upgrade of " + escapedTableName + (String)tenantInfo + "...";
            System.out.println(msg);
            LOGGER.info(msg);
            if (!bypassUpgrade) {
                rs = upgradeConn.createStatement().executeQuery("SELECT /*+ NO_INDEX */ count(*) FROM " + escapedTableName);
                rs.next();
            }
            ArrayList tableNames = Lists.newArrayListWithExpectedSize((int)1024);
            tableNames.add(tenantId == PName.EMPTY_NAME ? null : tenantId.getString());
            tableNames.add(schemaName);
            tableNames.add(tableName);
            if (isTable) {
                String query = "SELECT TENANT_ID,TABLE_SCHEM,TABLE_NAME\nFROM SYSTEM.CATALOG\nWHERE COLUMN_NAME IS NULL\nAND COLUMN_FAMILY = '" + physicalName + "'AND LINK_TYPE = " + PTable.LinkType.PHYSICAL_TABLE.getSerializedValue();
                rs = globalConn.createStatement().executeQuery(query);
                while (rs.next()) {
                    tableNames.add(rs.getString(1));
                    tableNames.add(rs.getString(2));
                    tableNames.add(rs.getString(3));
                }
            }
            for (i = 0; i < tableNames.size(); i += 3) {
                theTenantId = (String)tableNames.get(i);
                theSchemaName = (String)tableNames.get(i + 1);
                theTableName = (String)tableNames.get(i + 2);
                String upsSyscat = String.format("UPSERT INTO " + PhoenixDatabaseMetaData.SYSTEM_CATALOG_NAME + " (TENANT_ID,TABLE_SCHEM,TABLE_NAME,ROW_KEY_ORDER_OPTIMIZABLE BOOLEAN) VALUES ( ?, ?, ?, TRUE)", new Object[0]);
                try (PreparedStatement upsSyscatStmt = globalConn.prepareStatement(upsSyscat);){
                    int param = 0;
                    if (theTenantId == null) {
                        upsSyscatStmt.setNull(++param, 12);
                    } else {
                        upsSyscatStmt.setString(++param, theTenantId);
                    }
                    if (theSchemaName == null) {
                        upsSyscatStmt.setNull(++param, 12);
                    } else {
                        upsSyscatStmt.setString(++param, theSchemaName);
                    }
                    upsSyscatStmt.setString(++param, theTableName);
                    upsSyscatStmt.execute();
                    continue;
                }
            }
            globalConn.commit();
            for (i = 0; i < tableNames.size(); i += 3) {
                theTenantId = (String)tableNames.get(i);
                theSchemaName = (String)tableNames.get(i + 1);
                theTableName = (String)tableNames.get(i + 2);
                globalConn.getQueryServices().clearTableFromCache(theTenantId == null ? ByteUtil.EMPTY_BYTE_ARRAY : Bytes.toBytes((String)theTenantId), theSchemaName == null ? ByteUtil.EMPTY_BYTE_ARRAY : Bytes.toBytes((String)schemaName), Bytes.toBytes((String)theTableName), Long.MAX_VALUE);
            }
            success = true;
            msg = "Completed upgrade of " + escapedTableName + (String)tenantInfo;
            System.out.println(msg);
            LOGGER.info(msg);
        }
        catch (Exception e) {
            LOGGER.error("Exception during upgrade of " + physicalName + ":", (Throwable)e);
        }
        finally {
            boolean restored = false;
            try {
                if (!success && restoreSnapshot) {
                    admin.disableTable(physicalName);
                    admin.restoreSnapshot(snapshotName, false);
                    admin.enableTable(physicalName);
                    String msg = "Restored snapshot of " + physicalName + " due to failure of upgrade";
                    System.out.println(msg);
                    LOGGER.info(msg);
                }
                restored = true;
            }
            catch (Exception e) {
                LOGGER.warn("Unable to restoring snapshot " + snapshotName + " after failed upgrade", (Throwable)e);
            }
            finally {
                try {
                    if (restoreSnapshot && restored) {
                        admin.deleteSnapshot(snapshotName);
                    }
                }
                catch (Exception e) {
                    LOGGER.warn("Unable to delete snapshot " + snapshotName + " after upgrade:", (Throwable)e);
                }
                finally {
                    try {
                        if (admin != null) {
                            admin.close();
                        }
                    }
                    catch (IOException e) {
                        LOGGER.warn("Unable to close admin after upgrade:", (Throwable)e);
                    }
                }
            }
        }
    }

    private static boolean isInvalidTableToUpgrade(PTable table) throws SQLException {
        return table.getType() != PTableType.TABLE || table.getTenantId() != null || !table.getPhysicalName().equals(table.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void upgradeDescVarLengthRowKeys(PhoenixConnection conn, List<String> tablesToUpgrade, boolean bypassUpgrade) throws SQLException {
        if (tablesToUpgrade.isEmpty()) {
            return;
        }
        ArrayList tablesNeedingUpgrading = Lists.newArrayListWithExpectedSize((int)tablesToUpgrade.size());
        ArrayList invalidTables = Lists.newArrayListWithExpectedSize((int)tablesToUpgrade.size());
        for (String fullTableName : tablesToUpgrade) {
            PTable table = conn.getTable(fullTableName);
            if (UpgradeUtil.isInvalidTableToUpgrade(table)) {
                invalidTables.add(fullTableName);
                continue;
            }
            tablesNeedingUpgrading.add(table);
        }
        if (!invalidTables.isEmpty()) {
            StringBuilder buf = new StringBuilder("Only physical tables should be upgraded as their views and indexes will be updated with them: ");
            for (String fullTableName : invalidTables) {
                buf.append(fullTableName);
                buf.append(' ');
            }
            throw new SQLException(buf.toString());
        }
        try (PhoenixConnection upgradeConn = new PhoenixConnection(conn, true, true);){
            upgradeConn.setAutoCommit(true);
            for (PTable table : tablesNeedingUpgrading) {
                boolean wasUpgraded = false;
                if (!table.rowKeyOrderOptimizable()) {
                    wasUpgraded = true;
                    UpgradeUtil.upgradeDescVarLengthRowKeys(upgradeConn, conn, table.getSchemaName().getString(), table.getTableName().getString(), true, bypassUpgrade);
                }
                for (PTable index : table.getIndexes()) {
                    if (index.rowKeyOrderOptimizable() || index.getIndexType() == PTable.IndexType.LOCAL) continue;
                    wasUpgraded = true;
                    UpgradeUtil.upgradeDescVarLengthRowKeys(upgradeConn, conn, index.getSchemaName().getString(), index.getTableName().getString(), false, bypassUpgrade);
                }
                String sharedViewIndexName = Bytes.toString((byte[])MetaDataUtil.getViewIndexPhysicalName(table.getName().getBytes()));
                wasUpgraded |= UpgradeUtil.upgradeSharedIndex(upgradeConn, conn, sharedViewIndexName, bypassUpgrade);
                String sharedLocalIndexName = Bytes.toString((byte[])MetaDataUtil.getLocalIndexPhysicalName(table.getName().getBytes()));
                if (wasUpgraded |= UpgradeUtil.upgradeSharedIndex(upgradeConn, conn, sharedLocalIndexName, bypassUpgrade)) continue;
                System.out.println("Upgrade not required for this table or its indexes: " + table.getName().getString());
            }
        }
    }

    private static boolean upgradeSharedIndex(PhoenixConnection upgradeConn, PhoenixConnection globalConn, String physicalName, boolean bypassUpgrade) throws SQLException {
        String query = String.format("SELECT TENANT_ID,TABLE_SCHEM,TABLE_NAMEFROM SYSTEM.CATALOG cat1WHERE COLUMN_NAME IS NULLAND COLUMN_FAMILY = ? AND LINK_TYPE = %s ORDER BY TENANT_ID", PTable.LinkType.PHYSICAL_TABLE.getSerializedValue());
        try (PreparedStatement selSysCatstmt = globalConn.prepareStatement(query);){
            selSysCatstmt.setString(1, physicalName);
            ResultSet rs = selSysCatstmt.executeQuery();
            String lastTenantId = null;
            java.sql.Connection conn = globalConn;
            String url = globalConn.getURL();
            boolean wasUpgraded = false;
            while (rs.next()) {
                PTable table;
                String tableTenantId;
                String fullTableName = SchemaUtil.getTableName(rs.getString("TABLE_SCHEM"), rs.getString("TABLE_NAME"));
                String tenantId = rs.getString(1);
                if (tenantId != null && !tenantId.equals(lastTenantId)) {
                    if (lastTenantId != null) {
                        conn.close();
                    }
                    Properties props = new Properties(globalConn.getClientInfo());
                    props.setProperty("TenantId", tenantId);
                    conn = DriverManager.getConnection(url, props);
                    lastTenantId = tenantId;
                }
                if (!Objects.equal(lastTenantId, (Object)(tableTenantId = (table = conn.unwrap(PhoenixConnection.class).getTable(fullTableName)).getTenantId() == null ? null : table.getTenantId().getString())) || table.rowKeyOrderOptimizable()) continue;
                UpgradeUtil.upgradeDescVarLengthRowKeys(upgradeConn, globalConn, table.getSchemaName().getString(), table.getTableName().getString(), false, bypassUpgrade);
                wasUpgraded = true;
            }
            rs.close();
            if (lastTenantId != null) {
                conn.close();
            }
            boolean bl = wasUpgraded;
            return bl;
        }
    }

    public static void addRowKeyOrderOptimizableCell(List<Mutation> tableMetadata, byte[] tableHeaderRowKey, long clientTimeStamp) {
        Put put = new Put(tableHeaderRowKey, clientTimeStamp);
        put.addColumn(PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, MetaDataEndpointImplConstants.ROW_KEY_ORDER_OPTIMIZABLE_BYTES, PBoolean.INSTANCE.toBytes(true));
        tableMetadata.add((Mutation)put);
    }

    public static void addTTLForClientOlderThan530(List<Mutation> tableMetadata, byte[] tableHeaderRowKey, long clientTimeStamp, int clientVersion, ColumnFamilyDescriptor cfd) throws IOException {
        if (cfd.getTimeToLive() == Integer.MAX_VALUE || cfd.getTimeToLive() == 0) {
            Delete deleteColumn = new Delete(tableHeaderRowKey);
            KeyValue kv = GenericKeyValueBuilder.INSTANCE.buildDeleteColumns(new ImmutableBytesWritable(tableHeaderRowKey), new ImmutableBytesWritable(PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES), new ImmutableBytesWritable(PhoenixDatabaseMetaData.TTL_BYTES), clientTimeStamp);
            deleteColumn.add((Cell)kv);
            tableMetadata.add((Mutation)deleteColumn);
        } else {
            Put putColumn = new Put(tableHeaderRowKey, clientTimeStamp).addColumn(PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, PhoenixDatabaseMetaData.TTL_BYTES, PVarchar.INSTANCE.toBytes(LiteralTTLExpression.TTL_EXPRESSION_DEFINED_IN_TABLE_DESCRIPTOR.getTTLExpression()));
            tableMetadata.add((Mutation)putColumn);
        }
        LOGGER.info("Adding backward compatible TTL (create {}) for table-key {} with ttl value {}", new Object[]{clientVersion, Bytes.toStringBinary((byte[])tableHeaderRowKey), cfd.getTimeToLive()});
    }

    public static boolean truncateStats(Table metaTable, Table statsTable) throws IOException, InterruptedException {
        long timestamp;
        byte[] statsTableKey = SchemaUtil.getTableKey(null, "SYSTEM", "STATS");
        List columnCells = metaTable.get(new Get(statsTableKey)).getColumnCells(PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, QueryConstants.EMPTY_COLUMN_BYTES);
        if (!columnCells.isEmpty() && (timestamp = ((Cell)columnCells.get(0)).getTimestamp()) < 15L) {
            Cell upgradeKV = PhoenixKeyValueUtil.newKeyValue(statsTableKey, PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, UPGRADE_TO_4_7_COLUMN_NAME, timestamp, PBoolean.INSTANCE.toBytes(true));
            Put upgradePut = new Put(statsTableKey);
            upgradePut.add(upgradeKV);
            CheckAndMutate checkAndMutate = CheckAndMutate.newBuilder((byte[])statsTableKey).ifNotExists(PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, UPGRADE_TO_4_7_COLUMN_NAME).build(upgradePut);
            if (metaTable.checkAndMutate(checkAndMutate).isSuccess()) {
                Result r;
                ArrayList mutations = Lists.newArrayListWithExpectedSize((int)1000);
                Scan scan = new Scan();
                scan.setRaw(true);
                scan.readAllVersions();
                ResultScanner statsScanner = statsTable.getScanner(scan);
                mutations.clear();
                int count = 0;
                while ((r = statsScanner.next()) != null) {
                    Delete delete = null;
                    for (Cell keyValue : r.rawCells()) {
                        if (keyValue.getType() != Cell.Type.Put) continue;
                        if (delete == null) {
                            delete = new Delete(keyValue.getRowArray(), keyValue.getRowOffset(), (int)keyValue.getRowLength());
                        }
                        KeyValue deleteKeyValue = new KeyValue(keyValue.getRowArray(), keyValue.getRowOffset(), (int)keyValue.getRowLength(), keyValue.getFamilyArray(), keyValue.getFamilyOffset(), (int)keyValue.getFamilyLength(), keyValue.getQualifierArray(), keyValue.getQualifierOffset(), keyValue.getQualifierLength(), keyValue.getTimestamp(), KeyValue.Type.Delete, ByteUtil.EMPTY_BYTE_ARRAY, 0, 0);
                        delete.add((Cell)deleteKeyValue);
                    }
                    if (delete == null) continue;
                    mutations.add(delete);
                    if (count > 10) {
                        statsTable.batch((List)mutations, null);
                        mutations.clear();
                        count = 0;
                    }
                    ++count;
                }
                if (!mutations.isEmpty()) {
                    statsTable.batch((List)mutations, null);
                }
                return true;
            }
        }
        return false;
    }

    private static void mapTableToNamespace(Admin admin, Table metatable, String srcTableName, String destTableName, ReadOnlyProps props, Long ts, String phoenixTableName, PTableType pTableType, PName tenantId) throws SnapshotCreationException, IllegalArgumentException, IOException, InterruptedException, SQLException {
        if (!SchemaUtil.isNamespaceMappingEnabled(pTableType, props)) {
            throw new IllegalArgumentException(SchemaUtil.isSystemTable(srcTableName.getBytes(StandardCharsets.UTF_8)) ? "For system table phoenix.schema.mapSystemTablesToNamespace also needs to be enabled along with phoenix.schema.isNamespaceMappingEnabled" : "phoenix.schema.isNamespaceMappingEnabled is not enabled");
        }
        UpgradeUtil.mapTableToNamespace(admin, srcTableName, destTableName, pTableType);
        byte[] tableKey = SchemaUtil.getTableKey(tenantId != null ? tenantId.getString() : null, SchemaUtil.getSchemaNameFromFullName(phoenixTableName), SchemaUtil.getTableNameFromFullName(phoenixTableName));
        List columnCells = metatable.get(new Get(tableKey)).getColumnCells(PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, QueryConstants.EMPTY_COLUMN_BYTES);
        if (ts == null) {
            if (!columnCells.isEmpty()) {
                ts = ((Cell)columnCells.get(0)).getTimestamp();
            } else if (PTableType.SYSTEM != pTableType) {
                throw new IllegalArgumentException("Timestamp passed is null and cannot derive timestamp for " + tableKey + " from meta table!!");
            }
        }
        if (ts != null) {
            LOGGER.info(String.format("Updating meta information of phoenix table '%s' to map to namespace..", phoenixTableName));
            Put put = new Put(tableKey, ts.longValue());
            put.addColumn(QueryConstants.DEFAULT_COLUMN_FAMILY_BYTES, PhoenixDatabaseMetaData.IS_NAMESPACE_MAPPED_BYTES, PBoolean.INSTANCE.toBytes(Boolean.TRUE));
            metatable.put(put);
        }
    }

    public static void mapTableToNamespace(Admin admin, String srcTableName, String destTableName, PTableType pTableType) throws IOException {
        TableName srcTable = TableName.valueOf((String)SchemaUtil.normalizeIdentifier(srcTableName));
        TableName dstTable = TableName.valueOf((String)destTableName);
        boolean srcTableExists = admin.tableExists(srcTable);
        if (srcTableExists && (PTableType.TABLE.equals((Object)pTableType) || PTableType.INDEX.equals((Object)pTableType) || PTableType.SYSTEM.equals((Object)pTableType))) {
            boolean destTableExists = admin.tableExists(dstTable);
            if (!destTableExists) {
                String snapshotName = "_UPGRADING_TABLE_" + srcTableName;
                LOGGER.info("Disabling table " + srcTableName + " ..");
                admin.disableTable(srcTable);
                LOGGER.info(String.format("Taking snapshot %s of table %s..", snapshotName, srcTableName));
                admin.snapshot(snapshotName, srcTable);
                LOGGER.info(String.format("Restoring snapshot %s in destination table %s..", snapshotName, destTableName));
                admin.cloneSnapshot(snapshotName, dstTable);
                LOGGER.info(String.format("deleting old table %s..", srcTableName));
                admin.deleteTable(srcTable);
                LOGGER.info(String.format("deleting snapshot %s..", snapshotName));
                admin.deleteSnapshot(snapshotName);
            } else {
                LOGGER.info(String.format("Destination Table %s already exists. No migration needed.", destTableName));
            }
        }
    }

    public static void mapTableToNamespace(Admin admin, Table metatable, String tableName, ReadOnlyProps props, Long ts, PTableType pTableType, PName tenantId) throws IllegalArgumentException, IOException, InterruptedException, SQLException {
        String destTablename = SchemaUtil.normalizeIdentifier(SchemaUtil.getPhysicalTableName(tableName, props).getNameAsString());
        UpgradeUtil.mapTableToNamespace(admin, metatable, tableName, destTablename, props, ts, tableName, pTableType, tenantId);
    }

    public static void upgradeTable(PhoenixConnection conn, String srcTable) throws SQLException, IllegalArgumentException, IOException, InterruptedException {
        ReadOnlyProps readOnlyProps = conn.getQueryServices().getProps();
        if (conn.getSchema() != null) {
            throw new IllegalArgumentException("Schema should not be set for connection!!");
        }
        if (!SchemaUtil.isNamespaceMappingEnabled(PTableType.TABLE, readOnlyProps)) {
            throw new IllegalArgumentException("phoenix.schema.isNamespaceMappingEnabled is not enabled!!");
        }
        try (Admin admin = conn.getQueryServices().getAdmin();
             Table metatable = conn.getQueryServices().getTable(SchemaUtil.getPhysicalName(PhoenixDatabaseMetaData.SYSTEM_CATALOG_NAME_BYTES, readOnlyProps).getName());){
            byte[] tenantIdBytes;
            Object tenantId;
            String fullTableName = SchemaUtil.normalizeIdentifier(srcTable);
            String schemaName = SchemaUtil.getSchemaNameFromFullName(fullTableName);
            String tableName = SchemaUtil.getTableNameFromFullName(fullTableName);
            PTable table = conn.getTable(fullTableName);
            if (schemaName.equals("") && !PTableType.VIEW.equals((Object)table.getType())) {
                throw new IllegalArgumentException("Table doesn't have schema name");
            }
            if (table.isNamespaceMapped()) {
                throw new IllegalArgumentException("Table is already upgraded");
            }
            if (!schemaName.equals("")) {
                LOGGER.info(String.format("Creating schema %s..", schemaName));
                conn.createStatement().execute("CREATE SCHEMA IF NOT EXISTS " + schemaName);
            }
            String oldPhysicalName = table.getPhysicalName().getString();
            String newPhysicalTablename = SchemaUtil.normalizeIdentifier(SchemaUtil.getPhysicalTableName(oldPhysicalName, readOnlyProps).getNameAsString());
            LOGGER.info(String.format("Upgrading %s %s..", new Object[]{table.getType(), fullTableName}));
            LOGGER.info(String.format("oldPhysicalName %s newPhysicalTablename %s..", oldPhysicalName, newPhysicalTablename));
            LOGGER.info(String.format("teanantId %s..", conn.getTenantId()));
            TableViewFinderResult childViewsResult = new TableViewFinderResult();
            for (int i = 0; i < 2; ++i) {
                try (Table sysCatOrSysChildLinkTable = conn.getQueryServices().getTable(SchemaUtil.getPhysicalName(i == 0 ? PhoenixDatabaseMetaData.SYSTEM_CHILD_LINK_NAME_BYTES : PhoenixDatabaseMetaData.SYSTEM_CATALOG_TABLE_BYTES, readOnlyProps).getName());){
                    tenantId = conn.getTenantId() != null ? conn.getTenantId().getBytes() : null;
                    ViewUtil.findAllRelatives(sysCatOrSysChildLinkTable, (byte[])tenantId, schemaName.getBytes(StandardCharsets.UTF_8), tableName.getBytes(StandardCharsets.UTF_8), PTable.LinkType.CHILD_TABLE, childViewsResult);
                    break;
                }
                catch (TableNotFoundException ex) {
                    if (i != 1) continue;
                    throw ex;
                }
            }
            UpgradeUtil.mapTableToNamespace(admin, metatable, fullTableName, newPhysicalTablename, readOnlyProps, PhoenixRuntime.getCurrentScn(readOnlyProps), fullTableName, table.getType(), conn.getTenantId());
            MetaDataProtocol.MetaDataMutationResult result = UpgradeUtil.clearCacheAndGetNewTable(conn, conn.getTenantId(), table.getSchemaName() == null ? null : table.getSchemaName().getString(), table.getTableName().getString(), table.getParentName() == null ? null : table.getParentName().getString(), table.getTimeStamp());
            if (result.getMutationCode() != MetaDataProtocol.MutationCode.TABLE_ALREADY_EXISTS) {
                throw new TableNotFoundException(schemaName, fullTableName);
            }
            table = result.getTable();
            byte[] byArray = tenantIdBytes = conn.getTenantId() == null ? ByteUtil.EMPTY_BYTE_ARRAY : conn.getTenantId().getBytes();
            if (table.isNamespaceMapped()) {
                tenantId = table.getIndexes().iterator();
                while (tenantId.hasNext()) {
                    PTable index = (PTable)tenantId.next();
                    String srcTableName = index.getPhysicalName().getString();
                    String destTableName = null;
                    String phoenixTableName = index.getName().getString();
                    boolean updateLink = true;
                    if (srcTableName.contains(":")) {
                        LOGGER.info(String.format("skipping as it seems index '%s' is already upgraded..", index.getName()));
                        continue;
                    }
                    if (MetaDataUtil.isLocalIndex(srcTableName)) {
                        LOGGER.info(String.format("local index '%s' found with physical hbase table name ''..", index.getName(), srcTableName));
                        destTableName = Bytes.toString((byte[])MetaDataUtil.getLocalIndexPhysicalName(newPhysicalTablename.getBytes(StandardCharsets.UTF_8)));
                        conn.createStatement().execute(String.format("ALTER TABLE %s set PARENT_TABLE='%s'", phoenixTableName, table.getPhysicalName()));
                    } else if (MetaDataUtil.isViewIndex(srcTableName)) {
                        LOGGER.info(String.format("View index '%s' found with physical hbase table name ''..", index.getName(), srcTableName));
                        destTableName = Bytes.toString((byte[])MetaDataUtil.getViewIndexPhysicalName(newPhysicalTablename.getBytes(StandardCharsets.UTF_8)));
                    } else {
                        LOGGER.info(String.format("Global index '%s' found with physical hbase table name ''..", index.getName(), srcTableName));
                        destTableName = SchemaUtil.getPhysicalTableName(index.getPhysicalName().getString(), readOnlyProps).getNameAsString();
                    }
                    LOGGER.info(String.format("Upgrading index %s..", index.getName()));
                    if (table.getType() != PTableType.VIEW || MetaDataUtil.isViewIndex(srcTableName) || PTable.IndexType.LOCAL == index.getIndexType()) {
                        UpgradeUtil.mapTableToNamespace(admin, metatable, srcTableName, destTableName, readOnlyProps, PhoenixRuntime.getCurrentScn(readOnlyProps), phoenixTableName, index.getType(), conn.getTenantId());
                    }
                    if (updateLink) {
                        LOGGER.info(String.format("Updating link information for index '%s' ..", index.getName()));
                        UpgradeUtil.updateLink(conn, srcTableName, destTableName, index.getSchemaName(), index.getTableName());
                        conn.commit();
                    }
                    conn.getQueryServices().clearTableFromCache(tenantIdBytes, index.getSchemaName().getBytes(), index.getTableName().getBytes(), PhoenixRuntime.getCurrentScn(readOnlyProps));
                }
            } else {
                throw new RuntimeException("Error: problem occured during upgrade. Table is not upgraded successfully");
            }
            UpgradeUtil.updateIndexesSequenceIfPresent(conn, table);
            conn.commit();
            if (table.getType() == PTableType.VIEW) {
                LOGGER.info(String.format("Updating link information for view '%s' ..", table.getTableName()));
                UpgradeUtil.updateLink(conn, oldPhysicalName, newPhysicalTablename, table.getSchemaName(), table.getTableName());
                conn.commit();
                if (table.getParentName().equals(table.getPhysicalName())) {
                    LOGGER.info(String.format("Creating PARENT link for view '%s' ..", table.getTableName()));
                    PreparedStatement linkStatement = conn.prepareStatement(MetaDataClient.CREATE_VIEW_LINK);
                    linkStatement.setString(1, Bytes.toStringBinary((byte[])tenantIdBytes));
                    linkStatement.setString(2, table.getSchemaName().getString());
                    linkStatement.setString(3, table.getTableName().getString());
                    linkStatement.setString(4, table.getParentName().getString());
                    linkStatement.setByte(5, PTable.LinkType.PARENT_TABLE.getSerializedValue());
                    linkStatement.setString(6, null);
                    linkStatement.execute();
                    conn.commit();
                }
                conn.getQueryServices().clearTableFromCache(tenantIdBytes, table.getSchemaName().getBytes(), table.getTableName().getBytes(), PhoenixRuntime.getCurrentScn(readOnlyProps));
            }
            if (table.getType() == PTableType.TABLE) {
                UpgradeUtil.mapChildViewsToNamespace(conn.getURL(), conn.getClientInfo(), childViewsResult.getLinks());
            }
        }
    }

    public static MetaDataProtocol.MetaDataMutationResult clearCacheAndGetNewTable(PhoenixConnection conn, PName tenantId, String schemaName, String tableName, String parentName, long timestamp) throws SQLException {
        UpgradeUtil.clearCache(conn, tenantId, schemaName, tableName, parentName, timestamp);
        MetaDataProtocol.MetaDataMutationResult result = new MetaDataClient(conn).updateCache(tenantId, schemaName, tableName, true);
        return result;
    }

    public static void clearCache(PhoenixConnection conn, PName tenantId, String schemaName, String tableName, String parentName, long timestamp) throws SQLException {
        conn.removeTable(tenantId, SchemaUtil.getTableName(schemaName, tableName), parentName, timestamp);
        byte[] tenantIdBytes = tenantId == null ? ByteUtil.EMPTY_BYTE_ARRAY : tenantId.getBytes();
        byte[] schemaBytes = schemaName == null ? ByteUtil.EMPTY_BYTE_ARRAY : schemaName.getBytes();
        conn.getQueryServices().clearTableFromCache(tenantIdBytes, schemaBytes, tableName.getBytes(), PhoenixRuntime.getCurrentScn(conn.getQueryServices().getProps()));
    }

    private static void updateIndexesSequenceIfPresent(PhoenixConnection connection, PTable dataTable) throws SQLException {
        PName tenantId = connection.getTenantId();
        PName physicalName = dataTable.getName();
        PName oldPhysicalName = PNameFactory.newName(physicalName.toString().replace(":", "."));
        String oldSchemaName = MetaDataUtil.getViewIndexSequenceSchemaName(oldPhysicalName, false);
        String newSchemaName = MetaDataUtil.getViewIndexSequenceSchemaName(physicalName, true);
        String newSequenceName = MetaDataUtil.getViewIndexSequenceName(physicalName, tenantId, true);
        String upsert = "UPSERT INTO SYSTEM.\"SEQUENCE\" SELECT NULL, ?, ?, START_WITH,CURRENT_VALUE,INCREMENT_BY,CACHE_SIZE,MIN_VALUE,MAX_VALUE,CYCLE_FLAG,LIMIT_REACHED_FLAG FROM SYSTEM.\"SEQUENCE\" WHERE TENANT_ID IS NULL AND SEQUENCE_SCHEMA =  ?";
        try (PreparedStatement upsertSeqStmt = connection.prepareStatement(upsert);){
            upsertSeqStmt.setString(1, newSchemaName);
            upsertSeqStmt.setString(2, newSequenceName);
            upsertSeqStmt.setString(3, oldSchemaName);
            upsertSeqStmt.executeUpdate();
        }
    }

    private static void updateLink(PhoenixConnection conn, String srcTableName, String destTableName, PName schemaName, PName tableName) throws SQLException {
        boolean hasTenantId;
        Object updateLinkSql = String.format(UPDATE_LINK, destTableName);
        boolean bl = hasTenantId = conn.getTenantId() != null && conn.getTenantId().getBytes().length != 0;
        if (hasTenantId) {
            updateLinkSql = (String)updateLinkSql + " AND TENANT_ID  = ? ";
        }
        PreparedStatement updateLinkStatment = conn.prepareStatement((String)updateLinkSql);
        updateLinkStatment.setString(1, schemaName.getString());
        updateLinkStatment.setString(2, schemaName.getString());
        updateLinkStatment.setString(3, tableName.getString());
        updateLinkStatment.setString(4, srcTableName);
        if (hasTenantId) {
            updateLinkStatment.setString(5, conn.getTenantId().getString());
        }
        updateLinkStatment.execute();
        Object deleteLinkSql = DELETE_LINK;
        if (hasTenantId) {
            deleteLinkSql = (String)deleteLinkSql + " AND TENANT_ID  = ? ";
        }
        PreparedStatement deleteLinkStatment = conn.prepareStatement((String)deleteLinkSql);
        deleteLinkStatment.setString(1, schemaName.getString());
        deleteLinkStatment.setString(2, schemaName.getString());
        deleteLinkStatment.setString(3, tableName.getString());
        deleteLinkStatment.setString(4, srcTableName);
        if (hasTenantId) {
            deleteLinkStatment.setString(5, conn.getTenantId().getString());
        }
        deleteLinkStatment.execute();
    }

    private static void mapChildViewsToNamespace(String connUrl, Properties props, List<TableInfo> viewInfoList) throws SQLException, IllegalArgumentException, IOException, InterruptedException {
        String prevTenantId = null;
        PhoenixConnection conn = null;
        for (TableInfo viewInfo : viewInfoList) {
            String tenantId = viewInfo.getTenantId() != null ? Bytes.toString((byte[])viewInfo.getTenantId()) : null;
            String viewName = SchemaUtil.getTableName(viewInfo.getSchemaName(), viewInfo.getTableName());
            if (!java.util.Objects.equals(prevTenantId, tenantId)) {
                if (tenantId != null) {
                    props.setProperty("TenantId", tenantId);
                } else {
                    props.remove("TenantId");
                }
                if (conn != null) {
                    conn.close();
                }
                conn = DriverManager.getConnection(connUrl, props).unwrap(PhoenixConnection.class);
            }
            LOGGER.info(String.format("Upgrading view %s for tenantId %s..", viewName, tenantId));
            if (conn != null) {
                try {
                    UpgradeUtil.upgradeTable(conn, viewName);
                }
                catch (TableNotFoundException e) {
                    LOGGER.error("Error getting PTable for view: " + viewInfo, (Throwable)e);
                }
            }
            prevTenantId = tenantId;
        }
    }

    public static void mergeViewIndexIdSequences(PhoenixConnection olderMetaConnection) throws SQLException {
        HashMap sequenceTableMap = new HashMap();
        try (PhoenixConnection metaConnection = new PhoenixConnection(olderMetaConnection, Long.MAX_VALUE);){
            DatabaseMetaData metaData = metaConnection.getMetaData();
            ConnectionQueryServices cqs = metaConnection.getQueryServices();
            try (ResultSet sequenceRS = metaData.getTables(null, null, "%_ID_%", new String[]{"SEQUENCE"});){
                while (sequenceRS.next()) {
                    String tenantId = sequenceRS.getString("TABLE_CAT");
                    String schemaName = sequenceRS.getString("TABLE_SCHEM");
                    String sequenceName = sequenceRS.getString("TABLE_NAME");
                    int numBuckets = sequenceRS.getInt("SALT_BUCKETS");
                    SequenceKey key = new SequenceKey(tenantId, schemaName, sequenceName, numBuckets);
                    String baseTableName = schemaName != null && schemaName.contains("_SEQ_") ? schemaName.replace("_SEQ_", "") : SchemaUtil.getTableName(schemaName, sequenceName.replace("_ID_", ""));
                    if (!sequenceTableMap.containsKey(baseTableName)) {
                        sequenceTableMap.put(baseTableName, new ArrayList());
                    }
                    ((List)sequenceTableMap.get(baseTableName)).add(key);
                }
            }
            for (String baseTableName : sequenceTableMap.keySet()) {
                HashMap<SequenceKey, Long> currentSequenceValues = new HashMap<SequenceKey, Long>();
                long maxViewIndexId = Long.MIN_VALUE;
                PName name = PNameFactory.newName(baseTableName);
                boolean hasNamespaceMapping = SchemaUtil.isNamespaceMappingEnabled(null, cqs.getConfiguration()) || cqs.getProps().getBoolean("phoenix.schema.isNamespaceMappingEnabled", false);
                List existingSequenceKeys = (List)sequenceTableMap.get(baseTableName);
                for (SequenceKey sequenceKey : existingSequenceKeys) {
                    long[] currentValueArray = new long[1];
                    SQLException[] sqlExceptions = new SQLException[1];
                    cqs.incrementSequences(Lists.newArrayList((Object[])new SequenceAllocation[]{new SequenceAllocation(sequenceKey, 1L)}), EnvironmentEdgeManager.currentTimeMillis(), currentValueArray, new SQLException[1]);
                    if (sqlExceptions[0] != null) {
                        LOGGER.error("Unable to convert view index sequence because of error. It will need to be converted manually,  or there's a risk that two view indexes of the same base table will have colliding view index ids.", (Throwable)sqlExceptions[0]);
                        continue;
                    }
                    if (currentValueArray[0] > maxViewIndexId) {
                        maxViewIndexId = currentValueArray[0];
                    }
                    currentSequenceValues.put(sequenceKey, currentValueArray[0]);
                }
                maxViewIndexId += 100L;
                try {
                    SequenceKey newSequenceKey = new SequenceKey(null, MetaDataUtil.getViewIndexSequenceSchemaName(name, hasNamespaceMapping), MetaDataUtil.getViewIndexSequenceName(name, null, hasNamespaceMapping), cqs.getSequenceSaltBuckets());
                    if (currentSequenceValues.containsKey(newSequenceKey)) {
                        long incrementValue = maxViewIndexId - (Long)currentSequenceValues.get(newSequenceKey);
                        SQLException[] incrementExceptions = new SQLException[1];
                        ArrayList incrementAllocations = Lists.newArrayList((Object[])new SequenceAllocation[]{new SequenceAllocation(newSequenceKey, incrementValue)});
                        cqs.incrementSequences(incrementAllocations, EnvironmentEdgeManager.currentTimeMillis(), new long[1], incrementExceptions);
                        if (incrementExceptions[0] == null) continue;
                        throw incrementExceptions[0];
                    }
                    cqs.createSequence(null, newSequenceKey.getSchemaName(), newSequenceKey.getSequenceName(), maxViewIndexId, 1L, 1L, Long.MIN_VALUE, Long.MAX_VALUE, false, EnvironmentEdgeManager.currentTimeMillis());
                }
                catch (SequenceAlreadyExistsException sae) {
                    LOGGER.info("Tried to create view index sequence " + SchemaUtil.getTableName(sae.getSchemaName(), sae.getSequenceName()) + " during upgrade but it already existed. This is probably fine.");
                }
            }
        }
    }

    public static String getSysTableSnapshotName(long currentSystemTableTimestamp, String tableName) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMddHHmmss");
        String date = formatter.format((Object)new Date(EnvironmentEdgeManager.currentTimeMillis()));
        String upgradingFrom = MetaDataProtocol.getVersion(currentSystemTableTimestamp);
        return String.format("SNAPSHOT_%s_%s_TO_%s_%s", tableName, upgradingFrom, "5.3.0", date);
    }

    public static boolean isNoUpgradeSet(Properties props) {
        return Boolean.compare(true, Boolean.valueOf(props.getProperty(DO_NOT_UPGRADE))) == 0;
    }

    public static void doNotUpgradeOnFirstConnection(Properties props) {
        props.setProperty(DO_NOT_UPGRADE, String.valueOf(true));
    }

    public static boolean isUpdateViewIndexIdColumnDataTypeFromShortToLongNeeded(PhoenixConnection metaConnection, byte[] rowKey, byte[] syscatBytes) {
        boolean bl;
        block8: {
            Table sysTable = metaConnection.getQueryServices().getTable(syscatBytes);
            try {
                Scan s = new Scan();
                s.setRowPrefixFilter(rowKey);
                s.addColumn(PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, PhoenixDatabaseMetaData.DATA_TYPE_BYTES);
                ResultScanner scanner = sysTable.getScanner(s);
                Result result = scanner.next();
                Cell cell = result.getColumnLatestCell(PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, PhoenixDatabaseMetaData.DATA_TYPE_BYTES);
                boolean bl2 = bl = Bytes.compareTo((byte[])CellUtil.cloneValue((Cell)cell), (byte[])PInteger.INSTANCE.toBytes(5)) == 0;
                if (sysTable == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (sysTable != null) {
                        try {
                            sysTable.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    LOGGER.error(String.format("Checking VIEW_INDEX_ID data type for upgrade failed: %s. ", e.getMessage()));
                    return false;
                }
            }
            sysTable.close();
        }
        return bl;
    }

    public static void updateViewIndexIdColumnDataTypeFromShortToLong(PhoenixConnection metaConnection, byte[] rowKey, byte[] syscatBytes) {
        try (Table sysTable = metaConnection.getQueryServices().getTable(syscatBytes);){
            KeyValue viewIndexIdKV = new KeyValue(rowKey, PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, PhoenixDatabaseMetaData.DATA_TYPE_BYTES, 42L, PInteger.INSTANCE.toBytes(-5));
            Put viewIndexIdPut = new Put(rowKey);
            viewIndexIdPut.add((Cell)viewIndexIdKV);
            sysTable.put(viewIndexIdPut);
            LOGGER.info("Updated VIEW_INDEX_ID data type from SMALLINT TO BIGINT.");
        }
        catch (Exception e) {
            LOGGER.error(String.format("Upgrade/change VIEW_INDEX_ID data type failed: %s. ", e.getMessage()));
        }
    }

    public static void bootstrapLastDDLTimestampForTablesAndViews(java.sql.Connection metaConnection) throws SQLException {
        UpgradeUtil.bootstrapLastDDLTimestamp(metaConnection, new String[]{PTableType.TABLE.getSerializedValue(), PTableType.VIEW.getSerializedValue()});
    }

    public static void bootstrapLastDDLTimestampForIndexes(java.sql.Connection metaConnection) throws SQLException {
        UpgradeUtil.bootstrapLastDDLTimestamp(metaConnection, new String[]{PTableType.INDEX.getSerializedValue()});
    }

    private static void bootstrapLastDDLTimestamp(java.sql.Connection metaConnection, String[] tableTypes) throws SQLException {
        String tableTypesString = Stream.of(tableTypes).collect(Collectors.joining("','", "'", "'")).toString();
        String pkCols = "TENANT_ID, TABLE_SCHEM, TABLE_NAME, COLUMN_NAME, COLUMN_FAMILY";
        String upsertSql = "UPSERT INTO " + PhoenixDatabaseMetaData.SYSTEM_CATALOG_NAME + " (" + pkCols + ", LAST_DDL_TIMESTAMP) SELECT " + pkCols + ", PHOENIX_ROW_TIMESTAMP() FROM " + PhoenixDatabaseMetaData.SYSTEM_CATALOG_NAME + " WHERE TABLE_TYPE  in (" + tableTypesString + ")";
        LOGGER.info("Setting DDL timestamps for table_type={} to row timestamps", (Object)tableTypesString);
        try (PreparedStatement stmt = metaConnection.prepareStatement(upsertSql);){
            stmt.execute();
            metaConnection.commit();
        }
        LOGGER.info("Setting DDL timestamps for table_type={} is complete", (Object)tableTypesString);
    }

    public static boolean tableHasKeepDeleted(PhoenixConnection conn, String pTableName) throws SQLException, org.apache.hadoop.hbase.TableNotFoundException, IOException {
        ConnectionQueryServices cqs = conn.getQueryServices();
        Admin admin = cqs.getAdmin();
        PTable table = conn.getTable(pTableName);
        TableDescriptor tableDesc = admin.getDescriptor(SchemaUtil.getPhysicalTableName(pTableName, cqs.getProps()));
        return KeepDeletedCells.TRUE.equals((Object)tableDesc.getColumnFamily(SchemaUtil.getEmptyColumnFamily(table)).getKeepDeletedCells());
    }

    public static boolean tableHasMaxVersions(PhoenixConnection conn, String pTableName) throws SQLException, org.apache.hadoop.hbase.TableNotFoundException, IOException {
        ConnectionQueryServices cqs = conn.getQueryServices();
        Admin admin = cqs.getAdmin();
        PTable table = conn.getTable(pTableName);
        TableDescriptor tableDesc = admin.getDescriptor(SchemaUtil.getPhysicalTableName(pTableName, cqs.getProps()));
        return tableDesc.getColumnFamily(SchemaUtil.getEmptyColumnFamily(table)).getMaxVersions() > 1;
    }

    private static class ViewKey {
        @Nullable
        private final String tenantId;
        @Nullable
        private final String schema;
        @Nonnull
        private final String name;

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.tenantId == null ? 0 : this.tenantId.hashCode());
            result = 31 * result + this.name.hashCode();
            result = 31 * result + (this.schema == null ? 0 : this.schema.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ViewKey other = (ViewKey)obj;
            if (this.tenantId == null ? other.tenantId != null : !this.tenantId.equals(other.tenantId)) {
                return false;
            }
            if (!this.name.equals(other.name)) {
                return false;
            }
            return !(this.schema == null ? other.schema != null : !this.schema.equals(other.schema));
        }

        private ViewKey(String tenantId, String schema, String viewName) {
            this.tenantId = tenantId;
            this.schema = schema;
            this.name = viewName;
        }
    }

    private static class ColumnDetails {
        @Nullable
        private final String columnFamily;
        @Nonnull
        private final String columnName;
        private final int ordinalValue;
        private final int dataType;
        private final int maxLength;
        private final int scale;
        private final int sortOrder;
        private final int arraySize;

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.columnName.hashCode();
            result = 31 * result + (this.columnFamily == null ? 0 : this.columnFamily.hashCode());
            result = 31 * result + this.arraySize;
            result = 31 * result + this.dataType;
            result = 31 * result + this.maxLength;
            result = 31 * result + this.ordinalValue;
            result = 31 * result + this.scale;
            result = 31 * result + this.sortOrder;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ColumnDetails other = (ColumnDetails)obj;
            if (!this.columnName.equals(other.columnName)) {
                return false;
            }
            if (this.columnFamily == null ? other.columnFamily != null : !this.columnFamily.equals(other.columnFamily)) {
                return false;
            }
            if (this.arraySize != other.arraySize) {
                return false;
            }
            if (this.dataType != other.dataType) {
                return false;
            }
            if (this.maxLength != other.maxLength) {
                return false;
            }
            if (this.ordinalValue != other.ordinalValue) {
                return false;
            }
            if (this.scale != other.scale) {
                return false;
            }
            return this.sortOrder == other.sortOrder;
        }

        ColumnDetails(String columnFamily, String columnName, int ordinalValue, int dataType, int maxLength, int scale, int sortOrder, int arraySize) {
            Preconditions.checkNotNull((Object)columnName);
            Preconditions.checkNotNull((Object)ordinalValue);
            Preconditions.checkNotNull((Object)dataType);
            this.columnFamily = columnFamily;
            this.columnName = columnName;
            this.ordinalValue = ordinalValue;
            this.dataType = dataType;
            this.maxLength = maxLength;
            this.scale = scale;
            this.sortOrder = sortOrder;
            this.arraySize = arraySize;
        }
    }
}

