/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.util;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.DataOutput;
import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.WritableUtils;
import org.apache.phoenix.execute.TupleProjector;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.hbase.index.util.ImmutableBytesPtr;
import org.apache.phoenix.jdbc.PhoenixPrefetchedResultSet;
import org.apache.phoenix.jdbc.PhoenixResultSet;
import org.apache.phoenix.parse.TableName;
import org.apache.phoenix.query.QueryConstants;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.tuple.ResultTuple;
import org.apache.phoenix.schema.tuple.Tuple;
import org.apache.phoenix.schema.types.PInteger;
import org.apache.phoenix.schema.types.PVarbinaryEncoded;
import org.apache.phoenix.util.ByteUtil;
import org.apache.phoenix.util.PhoenixKeyValueUtil;
import org.apache.phoenix.util.SchemaUtil;
import org.apache.phoenix.util.TrustedByteArrayOutputStream;

public class TupleUtil {
    private TupleUtil() {
    }

    public static boolean equals(Tuple t1, Tuple t2, ImmutableBytesWritable ptr) {
        t1.getKey(ptr);
        byte[] buf = ptr.get();
        int offset = ptr.getOffset();
        int length = ptr.getLength();
        t2.getKey(ptr);
        return Bytes.compareTo((byte[])buf, (int)offset, (int)length, (byte[])ptr.get(), (int)ptr.getOffset(), (int)ptr.getLength()) == 0;
    }

    public static int compare(Tuple t1, Tuple t2, ImmutableBytesWritable ptr) {
        return TupleUtil.compare(t1, t2, ptr, 0);
    }

    public static int compare(Tuple t1, Tuple t2, ImmutableBytesWritable ptr, int keyOffset) {
        t1.getKey(ptr);
        byte[] buf = ptr.get();
        int offset = ptr.getOffset() + keyOffset;
        int length = ptr.getLength() - keyOffset;
        t2.getKey(ptr);
        return Bytes.compareTo((byte[])buf, (int)offset, (int)length, (byte[])ptr.get(), (int)(ptr.getOffset() + keyOffset), (int)(ptr.getLength() - keyOffset));
    }

    public static void getAggregateValue(Tuple r, ImmutableBytesWritable ptr) {
        Cell kv;
        if (r.size() == 1 && Bytes.compareTo((byte[])QueryConstants.SINGLE_COLUMN_FAMILY, (int)0, (int)QueryConstants.SINGLE_COLUMN_FAMILY.length, (byte[])(kv = r.getValue(0)).getFamilyArray(), (int)kv.getFamilyOffset(), (int)kv.getFamilyLength()) == 0 && Bytes.compareTo((byte[])QueryConstants.SINGLE_COLUMN, (int)0, (int)QueryConstants.SINGLE_COLUMN.length, (byte[])kv.getQualifierArray(), (int)kv.getQualifierOffset(), (int)kv.getQualifierLength()) == 0) {
            ptr.set(kv.getValueArray(), kv.getValueOffset(), kv.getValueLength());
            return;
        }
        throw new IllegalStateException("Expected single, aggregated KeyValue from coprocessor, but instead received " + r + ". Ensure aggregating coprocessors are loaded correctly on server");
    }

    public static Tuple getAggregateGroupTuple(Tuple tuple) {
        Cell kv;
        if (tuple == null) {
            return null;
        }
        if (tuple.size() == 1 && Bytes.compareTo((byte[])QueryConstants.GROUPED_AGGREGATOR_VALUE_BYTES, (int)0, (int)QueryConstants.GROUPED_AGGREGATOR_VALUE_BYTES.length, (byte[])(kv = tuple.getValue(0)).getFamilyArray(), (int)kv.getFamilyOffset(), (int)kv.getFamilyLength()) == 0 && Bytes.compareTo((byte[])QueryConstants.GROUPED_AGGREGATOR_VALUE_BYTES, (int)0, (int)QueryConstants.GROUPED_AGGREGATOR_VALUE_BYTES.length, (byte[])kv.getQualifierArray(), (int)kv.getQualifierOffset(), (int)kv.getQualifierLength()) == 0) {
            byte[] kvValue = new byte[kv.getValueLength()];
            System.arraycopy(kv.getValueArray(), kv.getValueOffset(), kvValue, 0, kvValue.length);
            int sizeOfAggregateGroupValue = PInteger.INSTANCE.getCodec().decodeInt(kvValue, 0, SortOrder.ASC);
            Cell result = PhoenixKeyValueUtil.newKeyValue(kvValue, 4, sizeOfAggregateGroupValue, QueryConstants.SINGLE_COLUMN_FAMILY, QueryConstants.SINGLE_COLUMN, Long.MAX_VALUE, kvValue, 4 + sizeOfAggregateGroupValue, kvValue.length - 4 - sizeOfAggregateGroupValue);
            return new ResultTuple(Result.create(Collections.singletonList(result)));
        }
        return tuple;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ImmutableBytesPtr getConcatenatedValue(Tuple result, List<Expression> expressions) throws IOException {
        ImmutableBytesPtr value = new ImmutableBytesPtr(ByteUtil.EMPTY_BYTE_ARRAY);
        Expression expression = expressions.get(0);
        boolean evaluated = expression.evaluate(result, value);
        if (expressions.size() == 1) {
            if (!evaluated) {
                value.set(ByteUtil.EMPTY_BYTE_ARRAY);
            }
            return value;
        }
        try (TrustedByteArrayOutputStream output = new TrustedByteArrayOutputStream(value.getLength() * expressions.size());){
            if (evaluated) {
                output.write(value.get(), value.getOffset(), value.getLength());
            }
            for (int i = 1; i < expressions.size(); ++i) {
                if (!expression.getDataType().isFixedWidth()) {
                    output.write(SchemaUtil.getSeparatorBytes(expression.getDataType(), true, value.getLength() == 0, expression.getSortOrder()));
                }
                if ((expression = expressions.get(i)).evaluate(result, value)) {
                    output.write(value.get(), value.getOffset(), value.getLength());
                    continue;
                }
                if (i >= expressions.size() - 1 || !expression.getDataType().isFixedWidth()) continue;
                throw new DoNotRetryIOException("Non terminating null value found for fixed width expression (" + expression + ") in row: " + result);
            }
            if (!expression.getDataType().isFixedWidth()) {
                if (expression.getDataType() != PVarbinaryEncoded.INSTANCE) {
                    if (SchemaUtil.getSeparatorByte(true, value.getLength() == 0, expression) == QueryConstants.DESC_SEPARATOR_BYTE) {
                        output.write(QueryConstants.DESC_SEPARATOR_BYTE);
                    }
                } else {
                    byte[] sepBytes = SchemaUtil.getSeparatorBytesForVarBinaryEncoded(true, value.getLength() == 0, expression.getSortOrder());
                    if (sepBytes == QueryConstants.DESC_VARBINARY_ENCODED_SEPARATOR_BYTES) {
                        output.write(QueryConstants.DESC_VARBINARY_ENCODED_SEPARATOR_BYTES);
                    }
                }
            }
            byte[] outputBytes = output.getBuffer();
            value.set(outputBytes, 0, output.size());
            ImmutableBytesPtr immutableBytesPtr = value;
            return immutableBytesPtr;
        }
    }

    public static int write(Tuple result, DataOutput out) throws IOException {
        KeyValue kv;
        int i;
        int size = 0;
        for (i = 0; i < result.size(); ++i) {
            kv = PhoenixKeyValueUtil.maybeCopyCell(result.getValue(i));
            size += kv.getLength();
            size += 4;
        }
        WritableUtils.writeVInt((DataOutput)out, (int)size);
        for (i = 0; i < result.size(); ++i) {
            kv = PhoenixKeyValueUtil.maybeCopyCell(result.getValue(i));
            out.writeInt(kv.getLength());
            out.write(kv.getBuffer(), kv.getOffset(), kv.getLength());
        }
        return size;
    }

    @SuppressWarnings(value={"OBL_UNSATISFIED_OBLIGATION_EXCEPTION_EDGE"}, justification="Tge statement object needs to be kept open for the returned RS to be valid, however this is acceptable as not callingPhoenixStatement.close() causes no resource leak")
    public static ResultSet getResultSet(Tuple toProject, TableName tableName, Connection conn, boolean withPrefetch) throws SQLException {
        if (tableName == null) {
            return null;
        }
        try (PhoenixResultSet resultSet = (PhoenixResultSet)conn.createStatement().executeQuery("SELECT * FROM " + tableName);){
            PTable pTable = resultSet.getStatement().getQueryPlan().getContext().getResolver().getTables().get(0).getTable();
            TupleProjector tupleProjector = new TupleProjector(pTable);
            Cell firstCell = null;
            ArrayList<Cell> cells = new ArrayList<Cell>(toProject.size());
            for (int i = 0; i < toProject.size(); ++i) {
                Cell cell = toProject.getValue(i);
                if (firstCell == null) {
                    firstCell = cell;
                } else if (!CellUtil.matchingRows((Cell)firstCell, (short)firstCell.getRowLength(), (Cell)cell, (short)cell.getRowLength())) continue;
                cells.add(cell);
            }
            toProject = new ResultTuple(Result.create(cells));
            TupleProjector.ProjectedValueTuple tuple = tupleProjector.projectResults(toProject, true);
            Cell newCell = tuple.getValue(QueryConstants.VALUE_COLUMN_FAMILY, QueryConstants.VALUE_COLUMN_QUALIFIER);
            PhoenixPrefetchedResultSet newResultSet = new PhoenixPrefetchedResultSet(resultSet.getRowProjector(), resultSet.getContext(), Collections.singletonList(new ResultTuple(Result.create(Collections.singletonList(newCell)))));
            if (withPrefetch) {
                newResultSet.next();
            }
            PhoenixPrefetchedResultSet phoenixPrefetchedResultSet = newResultSet;
            return phoenixPrefetchedResultSet;
        }
    }
}

